/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile.report;

import java.io.IOException;
import java.net.URISyntaxException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import jrm.fx.ui.misc.Settings;
import jrm.fx.ui.profile.report.ReportLiteController;
import jrm.locale.Messages;
import jrm.profile.report.Report;
import jrm.security.Session;
import jrm.security.Sessions;

public class ReportLite
extends Stage {
    private ReportLiteController controller;
    private Session session = Sessions.getSingleSession();

    public ReportLite(Stage parent, Report report) throws IOException, URISyntaxException {
        this.initOwner((Window)parent);
        this.initModality(Modality.NONE);
        this.getIcons().add((Object)((Image)parent.getIcons().get(0)));
        this.setOnShowing(e -> Settings.fromJson(this.session.getUser().getSettings().getProperty("ReportLite.Bounds", null), this));
        this.setOnCloseRequest(e -> {
            this.session.getUser().getSettings().setProperty("ReportLite.Bounds", Settings.toJson(this));
            this.hide();
        });
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ReportLite.fxml").toURI().toURL(), Messages.getBundle());
        BorderPane root = (BorderPane)loader.load();
        this.controller = (ReportLiteController)loader.getController();
        this.setScene(new Scene((Parent)root));
        this.controller.viewController.setReport(report);
        this.show();
    }
}

