/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jrm.ui.basic.JFileDrop;
import jrm.ui.basic.JFileDropMode;

public class JFileDropTextField
extends JTextField
implements FocusListener,
JFileDrop {
    private final Color color;
    private final transient SetCallBack callback;
    private JFileDropMode mode = JFileDropMode.FILE;
    private transient FilenameFilter filter = null;

    public JFileDropTextField(SetCallBack callback) throws HeadlessException {
        this(null, "", 0, callback);
    }

    public JFileDropTextField(String text, SetCallBack callback) throws HeadlessException {
        this(null, text, 0, callback);
    }

    public JFileDropTextField(int columns, SetCallBack callback) throws HeadlessException {
        this(null, "", columns, callback);
    }

    public JFileDropTextField(String text, int columns, SetCallBack callback) throws HeadlessException {
        this(null, "", columns, callback);
    }

    public JFileDropTextField(Document doc, String text, int columns, SetCallBack callback) {
        super(doc, text, columns);
        this.callback = callback;
        this.color = this.getBackground();
        this.addFocusListener(this);
        new DropTarget(this, this);
    }

    public void setMode(JFileDropMode mode) {
        this.mode = mode;
    }

    public void setFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.callback != null) {
            this.callback.call(this.getText());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (this.isFlavorSupported(transferable)) {
            this.setBackground(Color.decode("#DDFFDD"));
            dtde.acceptDrag(1);
        } else {
            this.setBackground(Color.decode("#FFDDDD"));
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setBackground(this.color);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.setBackground(this.color);
        this.drop(dtde, files -> {
            this.setText(((File)files.get(0)).getAbsolutePath());
            this.callback.call(this.getText());
        });
    }

    @Override
    public boolean checkValid(List<File> files) {
        return files.size() == 1;
    }

    @Override
    public boolean isFlavorSupported(Transferable transferable) {
        return this.isEnabled() && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public JFileDropMode getMode() {
        return this.mode;
    }

    @Override
    public FilenameFilter getFilter() {
        return this.filter;
    }

    @FunctionalInterface
    public static interface SetCallBack {
        public void call(String var1);
    }
}

