/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jrm.aui.basic.SrcDstResult;
import jrm.locale.Messages;
import jrm.ui.basic.JTableButton;
import jrm.ui.basic.SDRTableModel;
import jrm.ui.batch.FileCellRenderer;
import jrm.ui.batch.StatusCellRenderer;

public class BatchTableModel
extends SDRTableModel {
    private final String[] headers;
    private final String[] headersTT;
    private final Class<?>[] types = new Class[]{File.class, File.class, String.class, String.class, Boolean.class};
    private final int[] widths = new int[]{0, 0, 0, -70, -22};
    private JTableButton buttons = new JTableButton();
    private final TableCellRenderer[] cellRenderers = new TableCellRenderer[]{new FileCellRenderer(), new FCellRenderer(), new StatusCellRenderer(), this.buttons, null};
    private final TableCellEditor[] cellEditors = new TableCellEditor[]{null, null, null, this.buttons, null};

    public BatchTableModel() {
        this.headers = new String[]{Messages.getString((String)"BatchTableModel.SrcDats"), Messages.getString((String)"BatchTableModel.DstDirs"), Messages.getString((String)"BatchTableModel.Result"), "Details", "Selected"};
        this.headersTT = this.headers;
    }

    public BatchTableModel(String[] headers) {
        this.headers = headers;
        this.headersTT = headers;
    }

    public void setButtonHandler(JTableButton.TableButtonPressedHandler buttonHandler) {
        this.buttons.addHandler(buttonHandler);
    }

    @Override
    public int getRowCount() {
        return this.getData().size();
    }

    @Override
    public int getColumnCount() {
        return this.cellRenderers.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.headers[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex >= 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((SrcDstResult)this.getData().get(rowIndex)).getSrc();
            }
            case 1: {
                return ((SrcDstResult)this.getData().get(rowIndex)).getDst();
            }
            case 2: {
                return ((SrcDstResult)this.getData().get(rowIndex)).getResult();
            }
            case 3: {
                return "Detail";
            }
            case 4: {
                return ((SrcDstResult)this.getData().get(rowIndex)).isSelected();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                ((SrcDstResult)this.getData().get(rowIndex)).setSrc(((File)aValue).getPath());
                break;
            }
            case 1: {
                ((SrcDstResult)this.getData().get(rowIndex)).setDst(((File)aValue).getPath());
                break;
            }
            case 2: {
                ((SrcDstResult)this.getData().get(rowIndex)).setResult((String)aValue);
                break;
            }
            case 3: {
                return;
            }
            case 4: {
                ((SrcDstResult)this.getData().get(rowIndex)).setSelected(((Boolean)aValue).booleanValue());
                break;
            }
        }
        this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return this.cellRenderers;
    }

    @Override
    public TableCellEditor[] getCellEditors() {
        return this.cellEditors;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return this.widths[columnIndex];
    }

    @Override
    public String getColumnTT(int columnIndex) {
        return this.headersTT[columnIndex];
    }

    private final class FCellRenderer
    extends FileCellRenderer {
        private FCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == BatchTableModel.this.getCurrentRow() && column == BatchTableModel.this.getCurrentCol()) {
                this.setBackground(Color.decode("#DDFFDD"));
            } else {
                this.setBackground(Color.white);
            }
            if (value instanceof File) {
                File f = (File)value;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(FCellRenderer.trimmedStringCalculator(f.getPath(), table, this, table.getColumnModel().getColumn(column).getWidth() - 10));
                return this;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

