/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.manager;

import java.io.File;
import java.io.IOException;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import jrm.misc.Log;
import jrm.profile.manager.Dir;
import jrm.ui.profile.manager.DirNode;
import org.apache.commons.io.FileUtils;

public class DirTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    public DirTreeModel(DirNode root) {
        super(root);
        this.addTreeModelListener(this);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        DirNode node = (DirNode)e.getTreePath().getLastPathComponent();
        try {
            int index = e.getChildIndices()[0];
            DirNode childNode = (DirNode)node.getChildAt(index);
            if (childNode.getUserObject() instanceof String) {
                File newdir = new File(node.getDir().getFile(), childNode.getUserObject().toString());
                File olddir = childNode.getDir().getFile();
                if (olddir.renameTo(newdir)) {
                    childNode.setDir(new Dir(newdir));
                }
                childNode.setUserObject(childNode.getDir());
            }
        }
        catch (NullPointerException exc) {
            Log.err((String)exc.getMessage(), (Throwable)exc);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        try {
            int index = e.getChildIndices()[0];
            Object[] children = e.getChildren();
            DirNode child = (DirNode)children[index];
            FileUtils.deleteDirectory((File)child.getDir().getFile());
        }
        catch (IOException | NullPointerException exc) {
            Log.err((String)exc.getMessage(), (Throwable)exc);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }
}

