/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.manager;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jrm.aui.status.StatusRendererFactory;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.profile.manager.Dir;
import jrm.profile.manager.ProfileNFO;
import jrm.security.Session;
import lombok.Generated;

public class FileTableModel
extends AbstractTableModel
implements StatusRendererFactory {
    private transient Dir currDir = null;
    private final String[] columns = new String[]{Messages.getString((String)"FileTableModel.Profile"), Messages.getString((String)"FileTableModel.Version"), Messages.getString((String)"FileTableModel.HaveSets"), Messages.getString((String)"FileTableModel.HaveRoms"), Messages.getString((String)"FileTableModel.HaveDisks"), Messages.getString((String)"FileTableModel.Created"), Messages.getString((String)"FileTableModel.Scanned"), Messages.getString((String)"FileTableModel.Fixed")};
    private final Class<?>[] columnsClass = new Class[]{Object.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    protected static final int[] columnsWidths = new int[]{100, 50, -14, -14, -9, -19, -19, -19};
    private transient List<ProfileNFO> rows;
    private transient Session session;

    public FileTableModel(Session session, Dir dir) {
        this.populate(session, dir);
    }

    public FileTableModel() {
    }

    public void populate(Session session) {
        this.populate(session, this.currDir);
    }

    public void populate(Session session, Dir dir) {
        this.session = session;
        this.currDir = dir;
        this.rows = ProfileNFO.list((Session)session, (File)dir.getFile());
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public File getFileAt(int row) {
        return this.getNfoAt(row).getFile();
    }

    public ProfileNFO getNfoAt(int row) {
        return this.rows.get(row);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(this.rows.get(rowIndex), columnIndex);
    }

    public Object getValueAt(ProfileNFO pnfo, int columnIndex) {
        return FileTableModel.internalGetValueAt(pnfo, columnIndex);
    }

    private static Object internalGetValueAt(ProfileNFO pnfo, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return pnfo.getName();
            }
            case 1: {
                return pnfo.getHTMLVersion();
            }
            case 2: {
                return pnfo.getHTMLHaveSets();
            }
            case 3: {
                return pnfo.getHTMLHaveRoms();
            }
            case 4: {
                return pnfo.getHTMLHaveDisks();
            }
            case 5: {
                return pnfo.getHTMLCreated();
            }
            case 6: {
                return pnfo.getHTMLScanned();
            }
            case 7: {
                return pnfo.getHTMLFixed();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            ProfileNFO pnfo = this.rows.get(rowIndex);
            Arrays.asList("", ".properties", ".cache").forEach(ext -> {
                File newfile;
                File oldfile = new File(this.currDir.getFile(), pnfo.getName() + ext);
                if (oldfile.renameTo(newfile = new File(this.currDir.getFile(), String.valueOf(aValue) + ext))) {
                    Log.warn(() -> "Can't rename " + oldfile.getName() + " to " + newfile.getName());
                }
            });
            File newNfoFile = new File(this.currDir.getFile(), aValue.toString());
            if (this.session.getCurrProfile() != null && this.session.getCurrProfile().getNfo().getFile().equals(pnfo.getFile())) {
                this.session.getCurrProfile().getNfo().relocate(this.session, newNfoFile);
            }
            pnfo.relocate(this.session, newNfoFile);
            this.fireTableCellUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnsClass[columnIndex];
    }

    @Generated
    public Dir getCurrDir() {
        return this.currDir;
    }

    @Generated
    public static int[] getColumnsWidths() {
        return columnsWidths;
    }
}

