/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import jrm.misc.Log;
import jrm.profile.report.Report;
import jrm.security.Session;
import jrm.ui.profile.report.ReportView;

public class ReportLite
extends JDialog {
    private Window parentWindow;

    public ReportLite(final Session session, Window parent, final File reportFile) {
        super(parent);
        this.parentWindow = parent;
        parent.setEnabled(false);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 600);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
        this.getContentPane().setLayout(new BorderLayout());
        final JLabel wait = new JLabel("Loading...");
        wait.setFont(this.getFont().deriveFont(14.0f));
        wait.setHorizontalAlignment(0);
        wait.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)wait, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        buttonPane.add(okButton);
        okButton.addActionListener(e -> this.dispose());
        this.getRootPane().setDefaultButton(okButton);
        new SwingWorker<Report, Void>(){

            @Override
            protected Report doInBackground() throws Exception {
                try {
                    return Report.load((Session)session, (File)reportFile);
                }
                catch (Exception e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    ReportLite.this.getContentPane().remove(wait);
                    ReportLite.this.getContentPane().add(new ReportView((Report)this.get()), "Center", 0);
                    ReportLite.this.validate();
                }
                catch (InterruptedException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
            }
        }.execute();
    }

    @Override
    public void dispose() {
        this.parentWindow.setEnabled(true);
        super.dispose();
    }
}

