/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jrm.aui.profile.report.ReportTreeHandler;
import jrm.profile.report.FilterOptions;
import jrm.profile.report.ReportIntf;
import jrm.ui.profile.report.ReportNode;
import jrm.ui.profile.report.ReportNodeGeneric;

public abstract class ReportTreeModelGeneric<T extends ReportIntf<T>>
extends DefaultTreeModel
implements ReportTreeHandler<T> {
    protected transient T orgRoot;
    protected transient Set<FilterOptions> filterOptions = new HashSet<FilterOptions>();

    protected ReportTreeModelGeneric(TreeNode root) {
        super(root);
    }

    public void initClone() {
        this.setRoot(this.getNodeInstance((ReportIntf)this.orgRoot.clone(this.filterOptions)));
    }

    public abstract ReportNodeGeneric<T> getNodeInstance(T var1);

    public T getOriginalReport() {
        return this.orgRoot;
    }

    public EnumSet<FilterOptions> getFilterOptions() {
        if (this.filterOptions.isEmpty()) {
            return EnumSet.noneOf(FilterOptions.class);
        }
        return EnumSet.copyOf(this.filterOptions);
    }

    public void filter(FilterOptions ... filterOptions) {
        this.filter(Set.of(filterOptions));
    }

    public void filter(Set<FilterOptions> filterOptions) {
        this.filterOptions = filterOptions;
        this.setRoot(this.getNodeInstance((ReportIntf)this.orgRoot.clone(filterOptions)));
    }

    public T getFilteredReport() {
        return ((ReportNodeGeneric)this.getRoot()).getReport();
    }

    public boolean hasListeners() {
        return this.getTreeModelListeners().length > 0;
    }

    public void notifyInsertion(int[] childIndices, Object[] children) {
        if (this.getTreeModelListeners().length > 0) {
            TreeModelEvent event = new TreeModelEvent((Object)this, this.getPathToRoot((ReportNode)this.getRoot()), childIndices, children);
            for (TreeModelListener l : this.getTreeModelListeners()) {
                l.treeNodesInserted(event);
            }
        }
    }
}

