/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.progress;

import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import jrm.aui.progress.ProgressHandler;
import jrm.aui.progress.ProgressInputStream;
import jrm.misc.OffsetProvider;
import jrm.ui.progress.Progress;
import lombok.Generated;

public abstract class SwingWorkerProgress<T, V>
extends SwingWorker<T, V>
implements ProgressHandler {
    private static final String SET_PROGRESS_3 = "setProgress3";
    private static final String SET_PROGRESS_2 = "setProgress2";
    private static final String SET_PROGRESS = "setProgress";
    private final Progress progress;
    private final List<String> errors = new ArrayList<String>();
    private int threadCnt;
    private Boolean multipleSubInfos = null;
    private OffsetProvider offsetProvider = null;

    protected SwingWorkerProgress(Window owner) {
        this.progress = new Progress(owner);
        this.addPropertyChangeListener(e -> this.propertyChange(owner, e));
        this.progress.setVisible(true);
    }

    private void propertyChange(Window owner, PropertyChangeEvent e) throws HeadlessException {
        switch (e.getPropertyName()) {
            case "setProgress": {
                Object object = e.getNewValue();
                if (!(object instanceof SetProgress)) break;
                SetProgress props = (SetProgress)object;
                this.progress.setProgress(props.offset, props.msg, props.val, props.max, props.submsg);
                break;
            }
            case "setProgress2": {
                Object object = e.getNewValue();
                if (!(object instanceof SetProgress2)) break;
                SetProgress2 props = (SetProgress2)object;
                this.progress.setProgress2(props.msg, props.val, props.max);
                break;
            }
            case "setProgress3": {
                Object object = e.getNewValue();
                if (!(object instanceof SetProgress3)) break;
                SetProgress3 props = (SetProgress3)object;
                this.progress.setProgress3(props.msg, props.val, props.max);
                break;
            }
            case "setInfos": {
                Object object = e.getNewValue();
                if (!(object instanceof SetInfos)) break;
                SetInfos props = (SetInfos)object;
                this.progress.setInfos(props.threadCnt, props.multipleSubInfos);
                break;
            }
            case "extendInfos": {
                Object object = e.getNewValue();
                if (!(object instanceof ExtendInfos)) break;
                ExtendInfos props = (ExtendInfos)object;
                this.progress.extendInfos(props.threadCnt, props.multipleSubInfos);
                break;
            }
            case "clearInfos": {
                this.progress.clearInfos();
                break;
            }
            case "canCancel": {
                this.progress.canCancel((Boolean)e.getNewValue());
                break;
            }
            case "cancel": {
                this.progress.cancel();
                break;
            }
            case "close": {
                this.progress.close();
                if (this.errors.isEmpty()) break;
                JOptionPane.showMessageDialog(owner, this.errors.stream().collect(Collectors.joining("\n")), "Error", 0);
                break;
            }
        }
    }

    public void setInfos(int threadCnt, Boolean multipleSubInfos) {
        this.threadCnt = threadCnt <= 0 ? Runtime.getRuntime().availableProcessors() : threadCnt;
        this.multipleSubInfos = multipleSubInfos;
        this.firePropertyChange("setInfos", null, new SetInfos(this.threadCnt, this.multipleSubInfos));
    }

    public void extendInfos(int threadCnt) {
        this.threadCnt = threadCnt;
        this.firePropertyChange("extendInfos", null, new ExtendInfos(this.threadCnt, this.multipleSubInfos));
    }

    public void clearInfos() {
        this.firePropertyChange("clearInfos", false, true);
    }

    private void cleanup() {
        if (this.offsetProvider != null) {
            for (int offset : this.offsetProvider.freeOffsets()) {
                if (offset >= this.threadCnt) continue;
                this.firePropertyChange(SET_PROGRESS, null, new SetProgress(offset, "", null, null, this.multipleSubInfos != null && this.multipleSubInfos != false ? "" : null));
            }
        }
    }

    public void setProgress(String msg, Integer val, Integer max, String submsg) {
        int offset = this.getOffset();
        this.cleanup();
        this.firePropertyChange(SET_PROGRESS, null, new SetProgress(offset, msg, val, max, submsg));
    }

    private int getOffset() {
        if (this.offsetProvider != null) {
            int offset = this.offsetProvider.getOffset();
            if (offset < 0) {
                return 0;
            }
            if (offset >= this.threadCnt) {
                this.extendInfos(offset + 1);
            }
            return offset;
        }
        return 0;
    }

    public void setProgress2(String msg, Integer val, Integer max) {
        this.firePropertyChange(SET_PROGRESS_2, null, new SetProgress2(msg, val, max));
    }

    public void setProgress3(String msg, Integer val, Integer max) {
        this.firePropertyChange(SET_PROGRESS_3, null, new SetProgress3(msg, val, max));
    }

    public int getCurrent() {
        return this.progress.getValue();
    }

    public int getCurrent2() {
        return this.progress.getValue2();
    }

    public int getCurrent3() {
        return this.progress.getValue3();
    }

    public boolean isCancel() {
        return this.progress.isCancel();
    }

    public void doCancel() {
        this.firePropertyChange("cancel", false, true);
    }

    public void canCancel(boolean canCancel) {
        this.firePropertyChange("canCancel", this.canCancel(), canCancel);
    }

    public boolean canCancel() {
        return this.progress.canCancel();
    }

    public InputStream getInputStream(InputStream in, Integer len) {
        return new ProgressInputStream(in, len, (ProgressHandler)this);
    }

    public void close() {
        this.firePropertyChange("close", false, true);
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public void setOptions(ProgressHandler.Option first, ProgressHandler.Option ... rest) {
    }

    public void setOffsetProvider(OffsetProvider offsetProvider) {
        this.offsetProvider = offsetProvider;
    }

    private static class SetProgress {
        private final int offset;
        private final String msg;
        private final Integer val;
        private final Integer max;
        private final String submsg;

        @Generated
        public SetProgress(int offset, String msg, Integer val, Integer max, String submsg) {
            this.offset = offset;
            this.msg = msg;
            this.val = val;
            this.max = max;
            this.submsg = submsg;
        }
    }

    private static class SetProgress2 {
        private final String msg;
        private final Integer val;
        private final Integer max;

        @Generated
        public SetProgress2(String msg, Integer val, Integer max) {
            this.msg = msg;
            this.val = val;
            this.max = max;
        }
    }

    private static class SetProgress3 {
        private final String msg;
        private final Integer val;
        private final Integer max;

        @Generated
        public SetProgress3(String msg, Integer val, Integer max) {
            this.msg = msg;
            this.val = val;
            this.max = max;
        }
    }

    private static class SetInfos {
        private final int threadCnt;
        private final Boolean multipleSubInfos;

        @Generated
        public SetInfos(int threadCnt, Boolean multipleSubInfos) {
            this.threadCnt = threadCnt;
            this.multipleSubInfos = multipleSubInfos;
        }
    }

    private static class ExtendInfos {
        private final int threadCnt;
        private final Boolean multipleSubInfos;

        @Generated
        public ExtendInfos(int threadCnt, Boolean multipleSubInfos) {
            this.threadCnt = threadCnt;
            this.multipleSubInfos = multipleSubInfos;
        }
    }
}

