#include "../LunarSNES.hpp"
Settings settings;

Settings::Settings() {
  Markup::Node::operator=(BML::unserialize(string::read(locate("settings.bml"))));

  auto set = [&](const string& name, const string& value) {
    //create node and set to default value only if it does not already exist
    if(!operator[](name)) operator()(name).setValue(value);
  };

  set("UserInterface/ShowStatusBar", true);

  set("Path/ROM", Path::program());
  set("Path/Save", {Path::program(), "Saves/"});
  set("Path/State", {Path::program(), "States/"});
  set("Path/Cheat", {Path::program(), "Cheats/"});

  set("Video/Driver", ruby::Video::safestDriver());
  set("Video/Synchronize", false);
  set("Video/Shader", "None");
  set("Video/BlurEmulation", false);
  set("Video/ColorEmulation", false);
  set("Video/ScanlineEmulation", false);

  set("Video/Saturation", 100);
  set("Video/Gamma", 100);
  set("Video/Luminance", 100);

  set("Video/Overscan/Horizontal", 0);
  set("Video/Overscan/Vertical", 0);

  set("Video/Windowed/AspectCorrection", false);
  set("Video/Windowed/IntegralScaling", true);
  set("Video/Windowed/Scale", "Small");
  set("Video/Windowed/Scale/Small", "640x480");
  set("Video/Windowed/Scale/Medium", "960x720");
  set("Video/Windowed/Scale/Large", "1280x960");

  set("Video/Fullscreen/AspectCorrection", false);
  set("Video/Fullscreen/IntegralScaling", true);
  set("Video/Fullscreen/Exclusive", false);

  set("Audio/Driver", ruby::Audio::safestDriver());
  set("Audio/Device", "");
  set("Audio/Frequency", 48000);
  set("Audio/Latency", 0);
  set("Audio/Exclusive", false);
  set("Audio/Synchronize", true);
  set("Audio/Mute", false);
  set("Audio/Volume", 100);
  set("Audio/Balance", 50);
  set("Audio/Reverb/Enable", false);

  set("Input/Driver", ruby::Input::safestDriver());
  set("Input/Frequency", 5);
  set("Input/FocusLoss/Pause", false);
  set("Input/FocusLoss/AllowInput", false);

  set("Emulation/AutoSaveMemory/Enable", true);
  set("Emulation/AutoSaveMemory/Interval", 30);

  set("UI/Effect", "None");

  set("Crashed", false);

  set("SuperFamicom/ControllerPort1", "Gamepad");
  set("SuperFamicom/ControllerPort2", "Gamepad");
}

auto Settings::save() -> void {
  file::write(locate("settings.bml"), BML::serialize(*this));
}
