auto Presentation::updateSnow(uint32_t* output) -> void {
  static bool initialized = false;
  if(!initialized) {
    const uint16_t positions[200][2] = {
      {161, 251}, {115, 211}, {249,  87}, {128, 101}, {232, 176},
      { 51, 180}, {108, 193}, {224, 112}, {254, 159}, {102, 238},
      {223, 123}, {218,  42}, {173, 160}, {143, 170}, { 64,   1},
      {174,  29}, { 34, 187}, {194, 199}, { 40,  89}, {232,  32},
      {  7, 195}, {141,  67}, {216,  48}, {234,   1}, {243, 116},
      {164, 182}, {146, 136}, { 66,  70}, { 36,  43}, { 98, 208},
      { 63, 240}, {216, 253}, {147,  36}, { 33, 253}, { 98,  80},
      {228, 156}, { 73,  82}, { 85,   1}, { 97,  72}, {187, 239},
      { 18, 196}, {127, 182}, { 22,  22}, {101,  25}, {124, 145},
      {240, 213}, {186,  22}, {  7, 161}, { 30,  98}, { 90, 197},
      { 22, 205}, { 32, 150}, { 59, 133}, { 49, 140}, { 10, 128},
      {142, 185}, {176, 142}, {220, 195}, {100, 102}, {105, 194},
      { 43, 139}, {184, 153}, {  1,  95}, {176, 169}, {192, 201},
      {233, 243}, { 73,  65}, {188,  14}, {194,  39}, {251, 140},
      {239, 181}, {142, 160}, {242, 248}, { 82,  49}, {  9, 157},
      {233, 162}, {254, 121}, {112,   6}, {118,  24}, { 56, 121},
      { 74, 209}, {  1, 223}, {145,   6}, { 75,  73}, { 18, 168},
      {194, 168}, { 58,  39}, {222, 170}, {214,  75}, { 45, 218},
      { 39, 197}, {242,  98}, { 22,  90}, {255,   5}, {144, 244},
      {252,  55}, { 98,  18}, {135, 101}, { 27,  85}, {215, 207},
      {183,  28}, {201, 142}, { 45, 122}, {145, 159}, { 41, 243},
      {109,  29}, {117, 203}, {  7, 234}, {231, 214}, {131, 133},
      {217,   8}, { 74, 207}, {130,  77}, { 21, 229}, {167,  78},
      {218, 109}, {142,  58}, {134, 238}, { 29, 182}, {178,  14},
      {144, 129}, {196, 219}, { 60, 128}, { 30, 105}, { 57,  53},
      { 76, 122}, {242, 208}, {101, 241}, {246,  99}, {248,  67},
      {137, 244}, { 70,  51}, {202,  94}, {164, 125}, {115,  72},
      { 61,  72}, {129, 169}, {155, 122}, { 91, 154}, {160,  83},
      { 41, 102}, {223, 218}, {140,  40}, {132,  16}, {223,  92},
      { 50, 230}, {168,  47}, {126, 117}, {242, 136}, {  1, 245},
      {171,   0}, { 36,  98}, { 73,  69}, { 14, 229}, { 66, 177},
      {108,  92}, { 39, 250}, {243, 161}, {111,  85}, {211,  99},
      { 52,  98}, {121, 188}, {128, 201}, { 90, 205}, {223,  92},
      {177,  19}, { 87,  18}, { 75,  54}, {  6,  81}, {235, 137},
      {247,  66}, {211, 129}, {247,  39}, {119, 206}, {116, 250},
      {113, 231}, {190, 196}, { 53,  51}, { 34, 114}, { 39,  22},
      {192,  33}, {249, 151}, { 26,  22}, {139,  97}, {171, 238},
      {182,  88}, { 22, 176}, {157, 255}, {178, 199}, {138,  98},
      {140,  36}, {112,  90}, { 25, 245}, {134,  64}, { 48, 190},
      {165, 113}, { 24, 195}, { 84,  70}, {175,   9}, {179,  69},
    };
    const uint8_t velocities[200][2] = {
      { 57,  92}, {100,  19}, {100, 184}, {238, 225}, { 55, 240},
      {255, 221}, {215, 105}, {226, 153}, {164,  41}, { 22,  93},
      {176, 203}, {155, 199}, {244,  52}, {233, 219}, {110, 227},
      {229, 227}, {152, 240}, { 83, 248}, {226,  31}, {163,  22},
      { 28, 156}, { 18,  10}, {248,  67}, {123, 167}, { 25, 138},
      { 90,  10}, { 79, 107}, {208, 229}, {248, 233}, {185,  10},
      {167,  21}, { 19, 178}, {132, 154}, { 81,  70}, { 20,  71},
      { 95, 147}, { 72,  27}, { 91, 189}, { 13, 189}, {102,  84},
      {195, 123}, {251,  93}, { 68,  36}, {178,  59}, {107,  99},
      {104, 191}, { 76, 110}, { 44, 206}, {123,  46}, { 98, 112},
      { 26,  50}, {  1,  35}, {150,  17}, {242, 208}, { 69,  23},
      {202, 197}, { 59,  80}, {136, 124}, { 40,  89}, { 11,  40},
      {  1, 136}, { 90,  72}, {198,  83}, {  2, 174}, {174,   4},
      { 28, 205}, {135,  35}, {194,  54}, { 22,  40}, {  4, 132},
      {191,  88}, {163,  66}, {204, 230}, { 35, 111}, {  9, 177},
      {254, 174}, {163,  68}, {  5,  88}, {111, 235}, { 58, 236},
      {  4, 248}, {172, 154}, {101, 164}, { 43, 223}, { 10,  13},
      {210, 125}, {146,  73}, {192,  57}, {117, 152}, {128,  36},
      {106,  21}, {253, 113}, {110, 133}, {244,   4}, {150,  32},
      { 76,  71}, { 22, 106}, {210, 244}, { 46, 128}, { 27, 215},
      {231, 112}, {177, 196}, {198, 120}, {196,  57}, {234,  74},
      {235, 108}, { 64, 181}, {209, 188}, {177,  63}, {197, 200},
      {126, 164}, {136, 163}, { 48,  62}, {225, 223}, {212, 201},
      {195, 121}, { 90,   7}, { 10, 196}, { 88,  53}, { 39, 249},
      {147,  98}, { 65, 253}, {246,   3}, {152, 125}, {242, 105},
      { 44, 129}, { 94, 232}, { 13,   4}, { 86, 220}, {194,  67},
      {186, 210}, {171, 197}, { 64, 138}, { 89,  78}, { 58, 150},
      { 52,  79}, {138, 201}, {244, 111}, {106, 181}, {192,  69},
      {234, 253}, {239, 113}, { 98,  37}, {209, 151}, { 60,  47},
      {241, 235}, {185,  52}, {173,  94}, {172, 182}, { 47, 150},
      { 80, 118}, { 10,  58}, {161, 237}, { 10,  64}, {238, 198},
      { 14,  74}, {132, 250}, {234,  63}, {169,  86}, {158, 170},
      { 76, 168}, {124, 133}, { 28, 203}, {246, 140}, {228,  77},
      { 50,  53}, {115, 113}, {157, 218}, { 90, 192}, { 28, 209},
      { 72, 117}, {156, 101}, {226,  99}, { 11, 245}, { 69,  59},
      { 17, 175}, {164,  59}, {  8, 166}, {163, 185}, { 10,  60},
      {100,  19}, { 26,  38}, {114, 232}, {180, 115}, {238, 184},
      { 88, 103}, {178,  67}, {212,  21}, { 87,  64}, { 85,   1},
      { 62,  87}, {155,  62}, { 21,  96}, {205, 195}, {131,  97},
      {191, 252}, {218, 209}, {179, 201}, { 12,   2}, {234, 110},
    };
    for(uint id : range(200)) {
      snowParticles[id].posX = positions[id][0] << 8;
      snowParticles[id].posY = positions[id][1] << 8;
      snowParticles[id].velX = velocities[id][0];
      snowParticles[id].velY = velocities[id][1];
    }
    initialized = true;
  }

  uint32_t color;
  for(auto& particle : snowParticles) {
    particle.posX += particle.velX + (100 - settings["Audio/Volume"].natural()) * 2;
    particle.posY += particle.velY + 256;
    switch(particle.velX & 3) {
    case 0: color = 0xffb0b4c8; break;
    case 1: color = 0xffa0a0b0; break;
    case 2: color = 0xff888ca0; break;
    case 3: color = 0xff787888; break;
    }
    if(particle.posY >= 240 << 8) continue;
    *(output + (particle.posY >> 8) * 1024 + (particle.posX >> 8) * 2 +   0) = color;
    *(output + (particle.posY >> 8) * 1024 + (particle.posX >> 8) * 2 +   1) = color;
    *(output + (particle.posY >> 8) * 1024 + (particle.posX >> 8) * 2 + 512) = color;
    *(output + (particle.posY >> 8) * 1024 + (particle.posX >> 8) * 2 + 513) = color;
  }
}
