/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.cpu.asm;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.input.Position;
import scala.util.parsing.input.Reader;
import ucesoft.cbm.Version$;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.cpu.asm.AsmBytecodeEmitter;
import ucesoft.cbm.cpu.asm.AsmCompiler;
import ucesoft.cbm.cpu.asm.AsmEncoding;
import ucesoft.cbm.cpu.asm.AsmEvaluator$Evaluator$;
import ucesoft.cbm.cpu.asm.AsmParser;
import ucesoft.cbm.cpu.asm.AsmParser$Patch$;
import ucesoft.cbm.cpu.asm.AsmParser$Virtual$;
import ucesoft.cbm.cpu.asm.Assembler;
import ucesoft.cbm.cpu.asm.AssemblerPanel;
import ucesoft.cbm.cpu.asm.ByteCodeBlock;
import ucesoft.cbm.cpu.asm.CompilerException;
import ucesoft.cbm.cpu.asm.Preprocessor;
import ucesoft.cbm.misc.Preferences;
import ucesoft.cbm.misc.Preferences$BooleanPreferenceConv$;
import ucesoft.cbm.misc.Preferences$StringPreferenceConv$;
import ucesoft.cbm.trace.Tracer;

public final class Assembler$ {
    public static final Assembler$ MODULE$ = new Assembler$();
    private static final LinkedHashMap<String, String> symbolTable = new LinkedHashMap();
    private static String importDir = System.getProperty("user.dir");
    private static final int FORMAT_BINARY = 0;
    private static final int FORMAT_PRG = 1;

    public LinkedHashMap<String, String> symbolTable() {
        return symbolTable;
    }

    public String importDir() {
        return importDir;
    }

    public void importDir_$eq(String x$1) {
        importDir = x$1;
    }

    public int FORMAT_BINARY() {
        return FORMAT_BINARY;
    }

    public int FORMAT_PRG() {
        return FORMAT_PRG;
    }

    public JDialog getAssemblerDialog(JFrame parent, Memory mem, Tracer tracer) {
        AssemblerPanel assembler = new AssemblerPanel(mem, tracer);
        JDialog dialog = new JDialog(parent, assembler){
            private final AssemblerPanel assembler$1;

            public void setVisible(boolean b) {
                super.setVisible(b);
                if (b) {
                    this.assembler$1.reqFocus();
                    return;
                }
            }
            {
                this.assembler$1 = assembler$1;
                super((Frame)parent$1, "Assembler");
            }
        };
        assembler.setParent(dialog);
        dialog.getContentPane().add("Center", assembler);
        dialog.setJMenuBar(assembler.getMenuBar());
        dialog.pack();
        dialog.addWindowListener(new WindowAdapter(assembler){
            private final AssemblerPanel assembler$1;

            public void windowClosing(WindowEvent e) {
                this.assembler$1.close();
            }
            {
                this.assembler$1 = assembler$1;
            }
        });
        return dialog;
    }

    private List<AsmParser.Statement> compileAutoImport(Function1<String, BoxedUnit> log, Function1<String, BoxedUnit> error) {
        Some some;
        Tuple2 tuple2;
        InputStream in;
        File file = new File(new File(this.importDir()), "autoimport.asm");
        Object in2 = file.exists() ? new Some((Object)new Tuple2((Object)new FileInputStream(file), (Object)file.getParent())) : ((in = ClassLoader.getSystemClassLoader().getResourceAsStream("resources/autoimport.asm")) != null ? new Some((Object)new Tuple2((Object)in, (Object)"jar library")) : None$.MODULE$);
        Some some2 = in2;
        if (some2 instanceof Some && (tuple2 = (Tuple2)(some = some2).value()) != null) {
            List list;
            block7: {
                InputStream in3 = (InputStream)tuple2._1();
                String from = (String)tuple2._2();
                BufferedSource src = Source$.MODULE$.fromInputStream(in3, Codec$.MODULE$.fallbackSystemCodec());
                StringReader sw = new StringReader(src.getLines().mkString("\n"));
                log.apply((Object)new StringBuilder(33).append("Loading autoimport.asm from ").append(from).append(" ...\n").toString());
                AsmParser parser = new AsmParser("autoimport.asm");
                try {
                    Option option;
                    Parsers.ParseResult<List<AsmParser.Statement>> parseResult = parser.parseAll(parser.topStatements(), sw);
                    if (parseResult instanceof Parsers.Success) {
                        List parsed;
                        Parsers.Success success = (Parsers.Success)parseResult;
                        list = parsed = (List)success.result();
                        break block7;
                    }
                    if (parseResult != null && !(option = parser.NoSuccess().unapply(parseResult)).isEmpty()) {
                        String err = (String)((Tuple2)option.get())._1();
                        Reader input = (Reader)((Tuple2)option.get())._2();
                        error.apply((Object)new StringBuilder(5).append(err).append(" at ").append(input.pos()).append("\n").toString());
                        list = Nil$.MODULE$;
                        break block7;
                    }
                    throw new MatchError(parseResult);
                }
                finally {
                    src.close();
                }
            }
            return list;
        }
        if (None$.MODULE$.equals(some2)) {
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)some2);
    }

    public Option<Assembler.CompilationResult> compileSource(String src, Option<String> currentFileName, LinkedHashMap<String, String> symbolTable, Function1<String, BoxedUnit> log, Function1<String, BoxedUnit> error) {
        Right right;
        Preprocessor.Result result;
        Preprocessor prep = new Preprocessor();
        log.apply((Object)"Preprocessing text ...\n");
        Either<String, Preprocessor.Result> either = prep.analyze(src, (Map<String, String>)symbolTable.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            error.apply((Object)new StringBuilder(20).append("Preprocessor error: ").append(err).toString());
            return None$.MODULE$;
        }
        if (either instanceof Right && (result = (Preprocessor.Result)(right = (Right)either).value()) != null) {
            None$ none$;
            block12: {
                String prepSource = result.text();
                Map<String, String> newSet = result.symbols();
                symbolTable.clear();
                symbolTable.addAll(newSet);
                AsmParser parser = new AsmParser((String)currentFileName.getOrElse((Function0 & Serializable)() -> "noname.asm"));
                StringReader in = new StringReader(prepSource);
                try {
                    Option option;
                    List<AsmParser.Statement> autoImportStatements = this.compileAutoImport(log, error);
                    Parsers.ParseResult<List<AsmParser.Statement>> parseResult = parser.parseAll(parser.topStatements(), in);
                    if (parseResult instanceof Parsers.Success) {
                        Parsers.Success success = (Parsers.Success)parseResult;
                        List parsed = (List)success.result();
                        try {
                            StringWriter sw = new StringWriter();
                            log.apply((Object)"Start compiling ...\n");
                            AsmEvaluator$Evaluator$.MODULE$.importDir_$eq(this.importDir());
                            AsmCompiler cc = new AsmCompiler(new PrintWriter(sw), this.importDir());
                            List<ByteCodeBlock> lastByteCodeBlocks = cc.compile((List<AsmParser.Statement>)((List)autoImportStatements.$plus$plus((IterableOnce)parsed)));
                            log.apply((Object)"Code blocks found:\n");
                            log.apply((Object)new StringBuilder(1).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("="), 50)).append("\n").toString());
                            ((IterableOps)lastByteCodeBlocks.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Assembler$.$anonfun$compileSource$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                                Assembler$.$anonfun$compileSource$3(log, x$1);
                                return BoxedUnit.UNIT;
                            });
                            AsmBytecodeEmitter emitter = new AsmBytecodeEmitter(new PrintWriter(sw), lastByteCodeBlocks);
                            AsmEncoding asmEncoding = emitter.encode();
                            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])sw.toString().split("\n")), (Function1 & Serializable)l -> {
                                log.apply((Object)new StringBuilder(1).append(l).append("\n").toString());
                                return BoxedUnit.UNIT;
                            });
                            log.apply((Object)"Compilation terminated\n");
                            none$ = new Some((Object)new Assembler.CompilationResult(lastByteCodeBlocks, asmEncoding));
                        }
                        catch (CompilerException ce) {
                            Option<AsmParser.Statement> option2 = ce.statement();
                            if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                AsmParser.Statement s = (AsmParser.Statement)some.value();
                                BoxedUnit cfr_ignored_0 = (BoxedUnit)error.apply((Object)new StringBuilder(21).append("Parsing error at ").append(Assembler$.rowCol$1(s.pos())).append(": ").append(ce.msg()).append("\n").append(s.pos().longString()).append("\n").toString());
                            } else if (None$.MODULE$.equals(option2)) {
                                BoxedUnit cfr_ignored_1 = (BoxedUnit)error.apply((Object)new StringBuilder(16).append("Parsing error: ").append(ce.msg()).append("\n").toString());
                            } else {
                                throw new MatchError(option2);
                            }
                            none$ = None$.MODULE$;
                        }
                        break block12;
                    }
                    if (parseResult != null && !(option = parser.NoSuccess().unapply(parseResult)).isEmpty()) {
                        String _err = (String)((Tuple2)option.get())._1();
                        Reader input = (Reader)((Tuple2)option.get())._2();
                        String err = _err.startsWith("end of input") ? "Syntax error" : _err;
                        error.apply((Object)new StringBuilder(6).append(err).append(" at ").append(Assembler$.rowCol$1(input.pos())).append("\n").append(input.pos().longString()).append("\n").toString());
                        none$ = None$.MODULE$;
                        break block12;
                    }
                    throw new MatchError(parseResult);
                }
                catch (IllegalArgumentException i) {
                    error.apply((Object)i.getMessage());
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }
        throw new MatchError(either);
    }

    public Function1<String, BoxedUnit> compileSource$default$4(String src, Option<String> currentFileName, LinkedHashMap<String, String> symbolTable) {
        return (Function1 & Serializable)s -> {
            Predef$.MODULE$.print((Object)s);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<String, BoxedUnit> compileSource$default$5(String src, Option<String> currentFileName, LinkedHashMap<String, String> symbolTable) {
        return (Function1 & Serializable)s -> {
            Predef$.MODULE$.print((Object)s);
            return BoxedUnit.UNIT;
        };
    }

    public void saveAs(AsmEncoding asmEncoding, String fileName, int format) {
        FileOutputStream out = new FileOutputStream(fileName);
        if (format == this.FORMAT_PRG()) {
            out.write(asmEncoding.org() & 0xFF);
            out.write(asmEncoding.org() >> 8);
        }
        out.write(asmEncoding.mem());
        out.close();
    }

    public void main(String[] args) {
        Some some;
        Assembler.CompilationResult compilationResult;
        Preferences settings = new Preferences();
        this.importDir_$eq("./");
        LinkedHashMap symbols = new LinkedHashMap();
        ObjectRef log = ObjectRef.create((Function1 & Serializable)s -> {
            Predef$.MODULE$.print((Object)s);
            return BoxedUnit.UNIT;
        });
        ObjectRef out = ObjectRef.create((Object)None$.MODULE$);
        InputStream in = System.in;
        None$ fileName = None$.MODULE$;
        IntRef outFormat = IntRef.create((int)this.FORMAT_BINARY());
        settings.add("include-dir", "Sets the directory where the include files will be searched in", "", settings.add$default$4(), settings.add$default$5(), (Function1 & Serializable)x$2 -> {
            Assembler$.MODULE$.importDir_$eq(x$2);
            return BoxedUnit.UNIT;
        }, Preferences$StringPreferenceConv$.MODULE$);
        settings.add("silent", "Log errors only", BoxesRunTime.boxToBoolean((boolean)false), settings.add$default$4(), settings.add$default$5(), (Function1 & Serializable)sil -> {
            Assembler$.$anonfun$main$3(log, BoxesRunTime.unboxToBoolean((Object)sil));
            return BoxedUnit.UNIT;
        }, Preferences$BooleanPreferenceConv$.MODULE$);
        settings.add("prg", "Writes to the given PRG file", "", settings.add$default$4(), settings.add$default$5(), (Function1 & Serializable)prg -> {
            Assembler$.$anonfun$main$5(out, outFormat, prg);
            return BoxedUnit.UNIT;
        }, Preferences$StringPreferenceConv$.MODULE$);
        settings.add("bin", "Writes to the given raw file", "", settings.add$default$4(), settings.add$default$5(), (Function1 & Serializable)bin -> {
            Assembler$.$anonfun$main$6(out, outFormat, bin);
            return BoxedUnit.UNIT;
        }, Preferences$StringPreferenceConv$.MODULE$);
        settings.add("D", "Defines a symbol. If followed by =<value> defines a string or int symbol, otherwise a boolean symbol", "", settings.add$default$4(), settings.add$default$5(), (Function1 & Serializable)sym -> {
            Assembler$.$anonfun$main$7(symbols, sym);
            return BoxedUnit.UNIT;
        }, Preferences$StringPreferenceConv$.MODULE$);
        if (settings.checkForHelp(args) || args.length == 0) {
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("K64Assembler ver. ").append(Version$.MODULE$.VERSION()).append(" (").append(Version$.MODULE$.BUILD_DATE()).append(")").toString());
            settings.printUsage("file to compile");
            throw package$.MODULE$.exit(0);
        }
        Option<String> option = settings.parseAndLoad(args, new Properties());
        if (option instanceof Some) {
            Some some2 = (Some)option;
            String src = (String)some2.value();
            File f = new File(src);
            if (!f.exists() || !f.isFile()) {
                Predef$.MODULE$.println((Object)new StringBuilder(22).append("Source file ").append(src).append(" not found").toString());
                throw package$.MODULE$.exit(1);
            }
            in = new FileInputStream(f);
            fileName = new Some((Object)src);
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        String source = Source$.MODULE$.fromInputStream(in, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n");
        Option<Assembler.CompilationResult> option2 = this.compileSource(source, (Option<String>)fileName, (LinkedHashMap<String, String>)symbols, (Function1<String, BoxedUnit>)((Function1)log.elem), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            Predef$.MODULE$.println((Object)s);
            return BoxedUnit.UNIT;
        });
        if (option2 instanceof Some && (compilationResult = (Assembler.CompilationResult)(some = (Some)option2).value()) != null) {
            AsmEncoding enc = compilationResult.asmEncoding();
            Option option3 = (Option)out.elem;
            if (option3 instanceof Some) {
                Some some3 = (Some)option3;
                String target = (String)some3.value();
                this.saveAs(enc, target, outFormat.elem);
                BoxedUnit cfr_ignored_0 = (BoxedUnit)((Function1)log.elem).apply((Object)new StringBuilder(17).append("Output binary to ").append(target).toString());
            } else if (None$.MODULE$.equals(option3)) {
            } else {
                throw new MatchError((Object)option3);
            }
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            return;
        }
        throw new MatchError(option2);
    }

    private static final String rowCol$1(Position p) {
        return new StringBuilder(14).append("line ").append(p.line()).append(", column ").append(p.column()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$compileSource$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$compileSource$3(Function1 log$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String string;
            ByteCodeBlock b = (ByteCodeBlock)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Object[] objectArray = new Object[5];
            objectArray[0] = BoxesRunTime.boxToInteger((int)i);
            objectArray[1] = b.name().getOrElse((Function0 & Serializable)() -> "Unnamed");
            objectArray[2] = BoxesRunTime.boxToInteger((int)b.getOrg());
            objectArray[3] = BoxesRunTime.boxToInteger((int)(b.getOrg() + b.size() - 1));
            AsmParser.ORGType oRGType = b.orgType();
            AsmParser$Virtual$ asmParser$Virtual$ = AsmParser$Virtual$.MODULE$;
            if (!(oRGType != null ? !oRGType.equals(asmParser$Virtual$) : asmParser$Virtual$ != null)) {
                string = " virtual";
            } else {
                AsmParser.ORGType oRGType2 = b.orgType();
                AsmParser$Patch$ asmParser$Patch$ = AsmParser$Patch$.MODULE$;
                string = !(oRGType2 != null ? !oRGType2.equals(asmParser$Patch$) : asmParser$Patch$ != null) ? " patch" : "";
            }
            objectArray[4] = string;
            BoxedUnit cfr_ignored_0 = (BoxedUnit)log$1.apply((Object)StringOps$.MODULE$.format$extension("#%03d %30s %04X %04X%s\n", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$4(String x$3) {
    }

    public static final /* synthetic */ void $anonfun$main$3(ObjectRef log$2, boolean sil) {
        if (sil) {
            log$2.elem = (Function1 & Serializable)x$3 -> {
                Assembler$.$anonfun$main$4(x$3);
                return BoxedUnit.UNIT;
            };
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$main$5(ObjectRef out$1, IntRef outFormat$1, String prg) {
        out$1.elem = new Some((Object)prg);
        outFormat$1.elem = MODULE$.FORMAT_PRG();
    }

    public static final /* synthetic */ void $anonfun$main$6(ObjectRef out$1, IntRef outFormat$1, String bin) {
        out$1.elem = new Some((Object)bin);
        outFormat$1.elem = MODULE$.FORMAT_BINARY();
    }

    public static final /* synthetic */ void $anonfun$main$7(LinkedHashMap symbols$1, String sym) {
        Object object;
        Object object2;
        String[] stringArray = sym.split("=");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
            String symbol = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
            String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
            symbols$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)value));
            return;
        }
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
            String symbol = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            symbols$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)""));
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(23).append("Invalid symbol's value ").append(sym).toString());
    }

    private Assembler$() {
    }
}

