/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.expansion;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.net.telnet.TelnetClient;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.CBMComponentType$;
import ucesoft.cbm.ChipID$;
import ucesoft.cbm.Clock;
import ucesoft.cbm.Clock$;
import ucesoft.cbm.ClockEvent;
import ucesoft.cbm.ClockEvent$;
import ucesoft.cbm.Log$;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.expansion.ExpansionPort;
import ucesoft.cbm.expansion.ExpansionPort$;
import ucesoft.cbm.expansion.ExpansionPortType$;
import ucesoft.cbm.expansion.SwiftLink$;
import ucesoft.cbm.peripheral.rs232.HayesResultCode$;
import ucesoft.cbm.peripheral.rs232.Modem;
import ucesoft.cbm.peripheral.rs232.ModemCommandListener;
import ucesoft.cbm.peripheral.rs232.RS232;
import ucesoft.cbm.peripheral.rs232.RS232StatusListener;

@ScalaSignature(bytes="\u0006\u0005\r\u0015u!\u00022d\u0011\u0003Qg!\u00027d\u0011\u0003i\u0007\"\u0002;\u0002\t\u0003)\b\"\u0002<\u0002\t\u00039h!\u00027d\t\u00055\u0002BDA\u001b\t\u0011\u0005\tQ!B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u0003K!!\u0011!Q\u0001\n\u0005\u001d\u0002B\u0002;\u0005\t\u0003\t9\u0004C\u0005\u0002@\u0011\u0011\r\u0011\"\u0001\u0002B!A\u00111\u000b\u0003!\u0002\u0013\t\u0019\u0005C\u0005\u0002V\u0011\u0011\r\u0011\"\u0011\u0002X!A\u0011\u0011\u000e\u0003!\u0002\u0013\tI\u0006C\u0005\u0002l\u0011\u0011\r\u0011\"\u0011\u0002X!A\u0011Q\u000e\u0003!\u0002\u0013\tI\u0006C\u0005\u0002p\u0011\u0011\r\u0011\"\u0011\u0002r!A\u0011Q\u0010\u0003!\u0002\u0013\t\u0019\b\u0003\u0005\u0002\u0000\u0011\u0001\u000bQBAA\u0011!\t9\t\u0002Q\u0001\u000e\u0005%\u0005\u0002CAH\t\u0001\u0006i!!%\t\u0011\u0005UE\u0001)A\u0007\u0003/C\u0001\"a'\u0005A\u00035\u0011Q\u0014\u0005\t\u0003C#\u0001\u0015!\u0004\u0002$\"A\u0011q\u0015\u0003!\u0002\u001b\t9\n\u0003\u0005\u0002*\u0012\u0001\u000bQBAV\u0011!\ty\u000b\u0002Q\u0001\u000e\u0005E\u0006\u0002CA[\t\u0001\u0006i!a.\t\u0011\u0005mF\u0001)A\u0007\u0003GC\u0001\"!0\u0005A\u00035\u0011\u0011\u0017\u0005\t\u0003\u007f#\u0001\u0015!\u0004\u0002B\"A\u0011Q\u0019\u0003!\u0002\u001b\t9\r\u0003\u0005\u0002L\u0012\u0001\u000bQBAg\u0011!\t\t\u000e\u0002Q\u0001\u000e\u0005M\u0007\u0002CAm\t\u0001\u0006i!a5\t\u0011\u0005mG\u0001)A\u0007\u0003'D\u0001\"!8\u0005A\u00035\u00111\u001b\u0005\t\u0003?$\u0001\u0015)\u0003\u0002T\"q\u0011\u0011\u001d\u0003\u0005\u0002\u0003\u0015\t\u0011!Q!\n\u0005M\u0007\u0002CAr\t\u0001\u0006K!a5\t\u0011\u0005\u0015H\u0001)Q\u0005\u0003'D\u0001\"a:\u0005A\u0003&\u00111\u001b\u0005\t\u0003S$\u0001\u0015)\u0003\u0002T\"A\u00111\u001e\u0003!B\u0013\t\u0019\u000e\u0003\b\u0002n\u0012!\t\u0011!B\u0001\u0002\u0003\u0006K!a5\t\u0011\u0005=H\u0001)Q\u0005\u0003'D\u0001\"!=\u0005A\u0003&\u00111\u001f\u0005\t\u0003s$\u0001\u0015!\u0003\u0002|\"A!\u0011\u0001\u0003!\u0002\u0013\u0011\u0019\u0001\u0003\u0005\u0003 \u0011\u0001\u000b\u0015BA-\u0011!\u0011\t\u0003\u0002Q!\n\u0005M\u0007\u0002\u0003B\u0012\t\u0001\u0006KA!\n\t\u0011\t-B\u0001)A\u0005\u0005[A1Ba\r\u0005\u0001\u0004\u0005\t\u0015)\u0003\u00036!A!1\b\u0003!B\u0013\tI\u0006\u0003\u0005\u0003>\u0011\u0001\u000bQ\u0002B \u0011%\u0011)\u0005\u0002b\u0001\n\u0003\u00119\u0005\u0003\u0005\u0003J\u0011\u0001\u000b\u0011BA\f\u0011%\u0011Y\u0005\u0002b\u0001\n\u0003\u00119\u0005\u0003\u0005\u0003N\u0011\u0001\u000b\u0011BA\f\u0011%\u0011y\u0005\u0002b\u0001\n\u0003\u0011\t\u0006\u0003\u0005\u0003`\u0011\u0001\u000b\u0011\u0002B*\u0011%\u0011\t\u0007\u0002b\u0001\n\u0003\u0011\t\u0006\u0003\u0005\u0003d\u0011\u0001\u000b\u0011\u0002B*\u0011\u001d\u0011)\u0007\u0002C\u0001\u0005OBqA!\u001b\u0005\t\u0003\u0011Y\u0007C\u0004\u0003r\u0011!\tAa\u001d\t\u000f\t5E\u0001\"\u0001\u0003\u0010\"9!Q\u0013\u0003\u0005\u0002\t]\u0005b\u0002BO\t\u0011\u0005!q\u0014\u0005\b\u0005C#A\u0011\u0001BR\u0011\u001d\u0011I\u000b\u0002C\u0001\u0005?CqAa+\u0005\t\u0003\u0011i\u000bC\u0004\u00034\u0012!\tA!.\t\u000f\t]F\u0001\"\u0001\u00036\"9!\u0011\u0018\u0003\u0005\u0002\t\u001d\u0003b\u0002B^\t\u0011\u0005!Q\u0018\u0005\b\u0005\u0007$A\u0011\u0002B4\u0011\u001d\u0011)\r\u0002C\u0005\u0005OBqAa2\u0005\t\u0003\u0011I\rC\u0004\u0003V\u0012!\t!a\u0016\t\u000f\t]G\u0001\"\u0001\u0003Z\"9!Q\u001c\u0003\u0005B\t}\u0007b\u0002Bq\t\u0011\u0005#q\r\u0005\b\u0005G$A\u0011\tB4\u0011\u001d\u0011)\u000f\u0002C\u0005\u0005\u000fBqAa<\u0005\t\u0013\u00119\u0005C\u0004\u0003t\u0012!IAa\u0012\t\u000f\t]H\u0001\"\u0003\u0003H!9!1 \u0003\u0005\n\t\u001d\u0004b\u0002B\u0000\t\u0011%1\u0011\u0001\u0005\b\u0007\u000f!A\u0011BB\u0005\u0011\u001d\u0019\t\u0003\u0002C!\u0007GA\u0011ba\u000f\u0005#\u0003%\ta!\u0010\t\u000f\rMC\u0001\"\u0011\u0004V!I1Q\f\u0003\u0012\u0002\u0013\u00051Q\b\u0005\b\u0007?\"A\u0011\u0002B4\u0011\u001d\u0019\t\u0007\u0002C)\u0007GBqa!\u001e\u0005\t#\u001a9\bC\u0004\u0004\u0004\u0012!\tFa\u0012\u0002\u0013M;\u0018N\u001a;MS:\\'B\u00013f\u0003%)\u0007\u0010]1og&|gN\u0003\u0002gO\u0006\u00191MY7\u000b\u0003!\fq!^2fg>4Go\u0001\u0001\u0011\u0005-\fQ\"A2\u0003\u0013M;\u0018N\u001a;MS:\\7CA\u0001o!\ty'/D\u0001q\u0015\u0005\t\u0018!B:dC2\f\u0017BA:q\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A[\u0001\u0006O\u0016$8\u000b\u0014\u000b\u0006q\u00065\u00111\u0005\n\u0004snth\u0001\u0002>\u0002\u0001a\u0014A\u0002\u0010:fM&tW-\\3oiz\u0002\"a\u001b?\n\u0005u\u001c'!D#ya\u0006t7/[8o!>\u0014H\u000fE\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0006eN\u00144G\r\u0006\u0004\u0003\u000f)\u0017A\u00039fe&\u0004\b.\u001a:bY&!\u00111BA\u0001\u0005\u0015\u00116KM\u001a3\u0011\u001d\tya\u0001a\u0001\u0003#\t!B\\7j\u0011\u0006tG\r\\3s!\u001dy\u00171CA\f\u0003;I1!!\u0006q\u0005%1UO\\2uS>t\u0017\u0007E\u0002p\u00033I1!a\u0007q\u0005\u001d\u0011un\u001c7fC:\u00042a\\A\u0010\u0013\r\t\t\u0003\u001d\u0002\u0005+:LG\u000fC\u0004\u0002&\r\u0001\r!a\n\u0002\u0007I,W\u000f\u0005\u0003p\u0003SY\u0018bAA\u0016a\n1q\n\u001d;j_:\u001cR\u0001B>\u007f\u0003_\u00012a`A\u0019\u0013\u0011\t\u0019$!\u0001\u0003)5{G-Z7D_6l\u0017M\u001c3MSN$XM\\3s\u0003-*8-Z:pMR$3MY7%Kb\u0004\u0018M\\:j_:$3k^5gi2Kgn\u001b\u0013%]6L\u0007*\u00198eY\u0016\u0014HCBA\u001d\u0003w\ti\u0004\u0005\u0002l\t!9\u0011qB\u0004A\u0002\u0005E\u0001bBA\u0013\u000f\u0001\u0007\u0011qE\u0001\u0005)f\u0003V)\u0006\u0002\u0002DA!\u0011QIA&\u001d\rY\u0017qI\u0005\u0004\u0003\u0013\u001a\u0017!E#ya\u0006t7/[8o!>\u0014H\u000fV=qK&!\u0011QJA(\u0005\u00151\u0016\r\\;f\u0013\r\t\t\u0006\u001d\u0002\f\u000b:,X.\u001a:bi&|g.A\u0003U3B+\u0005%\u0001\u0003oC6,WCAA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\nA\u0001\\1oO*\u0011\u00111M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002h\u0005u#AB*ue&tw-A\u0003oC6,\u0007%A\u0006d_6\u0004xN\\3oi&#\u0015\u0001D2p[B|g.\u001a8u\u0013\u0012\u0003\u0013!D2p[B|g.\u001a8u)f\u0004X-\u0006\u0002\u0002tA!\u0011QOA&\u001d\u0011\t9(!\u001f\u000e\u0003\u0015L1!a\u001ff\u0003A\u0019%)T\"p[B|g.\u001a8u)f\u0004X-\u0001\bd_6\u0004xN\\3oiRK\b/\u001a\u0011\u0002\u0011ICv,\u0012,F\u001dR{!!a!\"\u0005\u0005\u0015\u0015aC*M?JCv,\u0012,F\u001dR\u000b\u0001\u0002\u0016-`\u000bZ+e\nV\b\u0003\u0003\u0017\u000b#!!$\u0002\u0017Mcu\f\u0016-`\u000bZ+e\nV\u0001\u0014\t\u0006#\u0016i\u0018+F%6Ke*\u0011'`%\u0016\u000bE)W\b\u0003\u0003'k\u0012!A\u0001\u001b%\u0016\u001bU)\u0013,F%~Ke\nV#S%V\u0003FkX#O\u0003\ncU\tR\b\u0003\u00033k\u0012AA\u0001\u001e)J\u000bejU'J)R+%kX%O)\u0016\u0013&+\u0016)U?\u000e{e\n\u0016*P\u0019>\u0011\u0011qT\u000f\u0002\u0019\u0005IQi\u0011%P?6{E)R\b\u0003\u0003Kk\u0012\u0001E\u0001\b\u001fZ+%KU+O\u0003\u001d!5\tR0E'J{!!!,\u001e\u0003\u0001\fADU#D\u000b&3VIU0E\u0003R\u000buLU#H\u0013N#VIU0F\u001bB#\u0016l\u0004\u0002\u00024v\t\u0001!A\u000eS\u000b\u000e+\u0015JV#S?\u0012\u000bE+Q0S\u000b\u001eK5\u000bV#S?\u001a+F\nT\b\u0003\u0003sk\u0012\u0001C\u0001 )J\u000bejU'J)R+%k\u0018#B)\u0006{&+R$J'R+%kX#N!RK\u0016A\b+S\u0003:\u001bV*\u0013+U\u000bJ{F)\u0011+B?J+u)S*U\u000bJ{f)\u0016'M\u0003U!\u0015\tV!`\u0007\u0006\u0013&+S#S?\u0012+E+R\"U\u000b\u0012{!!a1\u001e\u0003\u0001\na\u0002R!U\u0003~\u001bV\tV0S\u000b\u0006#\u0015l\u0004\u0002\u0002Jv\t\u0001)A\u0002J%F{!!a4\u001e\u0005\u0001\u0001\u0019\u0001\u0002#B)\u0006\u00032a\\Ak\u0013\r\t9\u000e\u001d\u0002\u0004\u0013:$\u0018AB*U\u0003R+6+A\u0002D\u001b\u0012\u000bAa\u0011+S\u0019\u000611\u000f^1ukN\fA%^2fg>4G\u000fJ2c[\u0012*\u0007\u0010]1og&|g\u000eJ*xS\u001a$H*\u001b8lI\u0011\u001aW\u000eZ\u0001\u0005GR\u0014H.A\u0005d_:tWm\u0019;fI\u00069qN^3seVt\u0017\u0001\u0006:fG\u0016Lg/\u001a:ECR\f'+Z4jgR,'/A\fue\u0006t7/\\5ui\u0016\u0014H)\u0019;b%\u0016<\u0017n\u001d;fe\u0006!SoY3t_\u001a$He\u00192nI\u0015D\b/\u00198tS>tGeU<jMRd\u0015N\\6%I%\u0014\u0018/\u0001\u0007csR,'+Z2fSZ,G-\u0001\u0006dY>\u001c7\u000eV5dWN\u00042a\\A{\u0013\r\t9\u0010\u001d\u0002\u0005\u0019>tw-A\u0002dY.\u0004B!a\u001e\u0002~&\u0019\u0011q`3\u0003\u000b\rcwnY6\u0002\u0019Q,GN\\3u\u00072LWM\u001c;\u0011\t\t\u0015!1D\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u00051A/\u001a7oKRTAA!\u0004\u0003\u0010\u0005\u0019a.\u001a;\u000b\t\tE!1C\u0001\bG>lWn\u001c8t\u0015\u0011\u0011)Ba\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011I\"A\u0002pe\u001eLAA!\b\u0003\b\taA+\u001a7oKR\u001cE.[3oi\u0006!\u0001n\\:u\u0003\u0011\u0001xN\u001d;\u0002\u00111\f7\u000f\u001e\"bk\u0012\u00042a\u001cB\u0014\u0013\r\u0011I\u0003\u001d\u0002\u0007\t>,(\r\\3\u0002\u000b5|G-Z7\u0011\u0007}\u0014y#\u0003\u0003\u00032\u0005\u0005!!B'pI\u0016l\u0017AD:uCR,8\u000fT5ti\u0016tWM\u001d\t\u0004\u007f\n]\u0012\u0002\u0002B\u001d\u0003\u0003\u00111CU*3gI\u001aF/\u0019;vg2K7\u000f^3oKJ\f1\u0002[8ti\u0006sGmQ8oM\u000611\u000bU#F\tN\u0003Ra\u001cB!\u0005KI1Aa\u0011q\u0005\u0015\t%O]1z\u0003\u0015)\u0005LU(N+\t\t9\"\u0001\u0004F1J{U\nI\u0001\u0005\u000f\u0006kU)A\u0003H\u00036+\u0005%\u0001\u0003S\u001f6cUC\u0001B*!\u0011\u0011)Fa\u0017\u000e\u0005\t]#b\u0001B-K\u0006\u00191\r];\n\t\tu#q\u000b\u0002\u0007\u001b\u0016lwN]=\u0002\u000bI{U\n\u0014\u0011\u0002\tI{U\nS\u0001\u0006%>k\u0005\nI\u0001\u0007Q\u0006tw-\u00169\u0015\u0005\u0005u\u0011aC2p[6\fg\u000eZ'pI\u0016$B!!\b\u0003n!9!qN A\u0002\u0005]\u0011AA8o\u0003%\u0019wN\u001c8fGR$v\u000e\u0006\u0003\u0002\u001e\tU\u0004b\u0002B<\u0001\u0002\u0007!\u0011P\u0001\bC\u0012$'/Z:t!\u0011\u0011YH!#\u000f\t\tu$Q\u0011\t\u0004\u0005\u007f\u0002XB\u0001BA\u0015\r\u0011\u0019)[\u0001\u0007yI|w\u000e\u001e \n\u0007\t\u001d\u0005/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\u0012YIC\u0002\u0003\bB\fAA]5oOR!\u0011Q\u0004BI\u0011\u001d\u0011\u0019*\u0011a\u0001\u0003/\tqA]5oO&tw-\u0001\u0004tKR$\u0006\f\u0012\u000b\u0005\u0003;\u0011I\nC\u0004\u0003\u001c\n\u0003\r!a5\u0002\t!Lw\r[\u0001\u0007O\u0016$H\u000b\u0017#\u0016\u0005\u0005M\u0017!C:fi>#\b.\u001a:t)\u0011\tiB!*\t\u000f\t\u001dF\t1\u0001\u0002T\u0006)a/\u00197vK\u0006Iq-\u001a;Pi\",'o]\u0001\u0011g\u0016$8i\u001c8gS\u001e,(/\u0019;j_:$B!!\b\u00030\"9!\u0011\u0017$A\u0002\te\u0014\u0001B2p]\u001a\fabY8o]\u0016\u001cG/[8o\u0013:4w.\u0006\u0002\u0003z\u0005\u0001r-\u001a;D_:4\u0017nZ;sCRLwN\\\u0001\nSN,e.\u00192mK\u0012\f!b]3u\u000b:\f'\r\\3e)\u0011\tiBa0\t\u000f\t\u0005'\n1\u0001\u0002\u0018\u00059QM\\1cY\u0016$\u0017aB2p]:,7\r^\u0001\u000bI&\u001c8m\u001c8oK\u000e$\u0018AF:fi\nKGOU3dK&4X\r\u001a'jgR,g.\u001a:\u0015\t\u0005u!1\u001a\u0005\b\u0005\u001bl\u0005\u0019\u0001Bh\u0003\u0005a\u0007#B8\u0003R\u0006u\u0011b\u0001Bja\nIa)\u001e8di&|g\u000eM\u0001\u000fO\u0016$H)Z:de&\u0004H/[8o\u0003A\u0019X\r\u001e*TeM\u0012D*[:uK:,'\u000f\u0006\u0003\u0002\u001e\tm\u0007b\u0002Bg\u001f\u0002\u0007!QG\u0001\ti>\u001cFO]5oOR\u0011!\u0011P\u0001\u0006e\u0016\u001cX\r^\u0001\u0006K*,7\r^\u0001\u0006SN\u0014Fk\u0015\u0015\u0004'\n%\bcA8\u0003l&\u0019!Q\u001e9\u0003\r%tG.\u001b8f\u0003MI7\u000fR1uCR+'/\\5oC2\u0014V-\u00193zQ\r!&\u0011^\u0001\u001bSN\u0014VmY3jm\u0016\u0014\u0018J\u001c;feJ,\b\u000f^#oC\ndW\r\u001a\u0015\u0004+\n%\u0018!H5t)J\fgn]7jiR,'/\u00138uKJ\u0014X\u000f\u001d;F]\u0006\u0014G.\u001a3)\u0007Y\u0013I/A\u0002o[&D3a\u0016Bu\u0003%\u0011X-\u00193Ds\u000edW\r\u0006\u0003\u0002\u001e\r\r\u0001bBB\u00031\u0002\u0007\u00111_\u0001\u0007Gf\u001cG.Z:\u0002\u0017M|7m[3u\u000bJ\u0014xN\u001d\u000b\u0005\u0003;\u0019Y\u0001C\u0004\u0004\u000ee\u0003\raa\u0004\u0002\u0003Q\u0004Ba!\u0005\u0004\u001c9!11CB\f\u001d\u0011\u0011yh!\u0006\n\u0003EL1a!\u0007q\u0003\u001d\u0001\u0018mY6bO\u0016LAa!\b\u0004 \tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u00073\u0001\u0018\u0001\u0002:fC\u0012$b!a5\u0004&\r%\u0002bBB\u00145\u0002\u0007\u00111[\u0001\t?\u0006$GM]3tg\"I11\u0006.\u0011\u0002\u0003\u00071QF\u0001\u0007G\"L\u0007/\u0013#\u0011\t\r=2Q\u0007\b\u0005\u0003o\u001a\t$C\u0002\u00044\u0015\faa\u00115ja&#\u0015\u0002BB\u001c\u0007s\u0011!!\u0013#\u000b\u0007\rMR-\u0001\bsK\u0006$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r}\"\u0006BB\u0017\u0007\u0003Z#aa\u0011\u0011\t\r\u00153qJ\u0007\u0003\u0007\u000fRAa!\u0013\u0004L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u001b\u0002\u0018AC1o]>$\u0018\r^5p]&!1\u0011KB$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0006oJLG/\u001a\u000b\t\u0003;\u00199f!\u0017\u0004\\!91q\u0005/A\u0002\u0005M\u0007b\u0002BT9\u0002\u0007\u00111\u001b\u0005\n\u0007Wa\u0006\u0013!a\u0001\u0007[\tqb\u001e:ji\u0016$C-\u001a4bk2$HeM\u0001\u0011kB$\u0017\r^3DY>\u001c7\u000eV5dWN\f\u0011b]1wKN#\u0018\r^3\u0015\t\u0005u1Q\r\u0005\b\u0007Oz\u0006\u0019AB5\u0003\ryW\u000f\u001e\t\u0005\u0007W\u001a\t(\u0004\u0002\u0004n)!1qNA1\u0003\tIw.\u0003\u0003\u0004t\r5$AE(cU\u0016\u001cGoT;uaV$8\u000b\u001e:fC6\f\u0011\u0002\\8bIN#\u0018\r^3\u0015\t\u0005u1\u0011\u0010\u0005\b\u0007w\u0002\u0007\u0019AB?\u0003\tIg\u000e\u0005\u0003\u0004l\r}\u0014\u0002BBA\u0007[\u0012\u0011c\u00142kK\u000e$\u0018J\u001c9viN#(/Z1n\u0003Q\tG\u000e\\8xgN#\u0018\r^3SKN$xN]5oO\u0002")
public class SwiftLink
extends ExpansionPort
implements RS232,
ModemCommandListener {
    public final Function1<Object, BoxedUnit> ucesoft$cbm$expansion$SwiftLink$$nmiHandler;
    private final Option<ExpansionPort> reu;
    private final Enumeration.Value TYPE;
    private final String name;
    private final String componentID;
    private final Enumeration.Value componentType;
    private final int DATA;
    private final int STATUS;
    private final int CMD;
    private final int CTRL;
    private int status;
    public int ucesoft$cbm$expansion$SwiftLink$$cmd;
    private int ctrl;
    private int connected;
    private int overrun;
    private int receiverDataRegister;
    private int transmitterDataRegister;
    public int ucesoft$cbm$expansion$SwiftLink$$irq;
    private int byteReceived;
    private long clockTicks;
    private final Clock clk;
    private final TelnetClient telnetClient;
    private String host;
    private int port;
    private double lastBaud;
    private final Modem modem;
    private RS232StatusListener statusListener;
    private String hostAndConf;
    private final double[] SPEEDS;
    private final boolean EXROM;
    private final boolean GAME;
    private final Memory ROML;
    private final Memory ROMH;
    private boolean ucesoft$cbm$peripheral$rs232$RS232$$flowControl;

    public static ExpansionPort getSL(Function1<Object, BoxedUnit> nmiHandler, Option<ExpansionPort> reu) {
        return SwiftLink$.MODULE$.getSL(nmiHandler, reu);
    }

    @Override
    public boolean flowControlEnabled() {
        return RS232.flowControlEnabled$(this);
    }

    @Override
    public void setFlowControlEnabled(boolean enabled) {
        RS232.setFlowControlEnabled$(this, enabled);
    }

    @Override
    public boolean ucesoft$cbm$peripheral$rs232$RS232$$flowControl() {
        return this.ucesoft$cbm$peripheral$rs232$RS232$$flowControl;
    }

    @Override
    public void ucesoft$cbm$peripheral$rs232$RS232$$flowControl_$eq(boolean x$1) {
        this.ucesoft$cbm$peripheral$rs232$RS232$$flowControl = x$1;
    }

    @Override
    public void ucesoft$cbm$peripheral$rs232$RS232$_setter_$componentType_$eq(Enumeration.Value x$1) {
    }

    @Override
    public Enumeration.Value TYPE() {
        return this.TYPE;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public Enumeration.Value componentType() {
        return this.componentType;
    }

    @Override
    public boolean EXROM() {
        return this.EXROM;
    }

    @Override
    public boolean GAME() {
        return this.GAME;
    }

    @Override
    public Memory ROML() {
        return this.ROML;
    }

    @Override
    public Memory ROMH() {
        return this.ROMH;
    }

    @Override
    public void hangUp() {
        Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> "SwiftLink hanged up");
        this.connected = 64;
        this.disconnect();
        this.nmi();
    }

    @Override
    public void commandMode(boolean on) {
    }

    @Override
    public void connectTo(String address) {
        Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("SwiftLink - Connecting to ").append(address).toString());
        this.setConfiguration(address);
        this.setEnabled(true);
    }

    @Override
    public void ring(boolean ringing) {
    }

    @Override
    public void setTXD(int high) {
    }

    @Override
    public int getTXD() {
        return 0;
    }

    @Override
    public void setOthers(int value) {
    }

    @Override
    public int getOthers() {
        return 0;
    }

    @Override
    public void setConfiguration(String conf) {
        String string = conf;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.hostAndConf = conf;
            String[] pars = conf.split(":");
            if (pars.length != 2) {
                throw new IllegalArgumentException("Bad configuration string, expected host:port");
            }
            this.host = pars[0];
            this.port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(pars[1]));
            return;
        }
        this.host = "";
    }

    @Override
    public String connectionInfo() {
        return this.hostAndConf;
    }

    @Override
    public String getConfiguration() {
        return new StringBuilder(1).append(this.host).append(":").append(this.port).toString();
    }

    @Override
    public boolean isEnabled() {
        return this.connected == 0;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.eject();
        if (enabled) {
            String string = this.host;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.connect();
            }
            this.connected = 0;
            this.clk.pause();
            this.clk.schedule(new ClockEvent("SL_RX_EVENT", this.clk.currentCycles() + this.clockTicks, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.readCycle(cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
            this.clk.play();
            this.nmi();
            ExpansionPort$.MODULE$.setExpansionPort(this);
            return;
        }
    }

    private void connect() {
        try {
            this.telnetClient.connect(this.host, this.port);
            this.modem.setStreams(this.telnetClient.getInputStream(), this.telnetClient.getOutputStream());
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("SwiftLink connected to ").append($this.host).append(":").append($this.port).toString());
            this.statusListener.setRS232Enabled(true);
            this.statusListener.connectedTo(new StringBuilder(1).append(this.host).append(":").append(this.port).toString());
        }
        catch (IOException io) {
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("SwiftLink connection error: ").append(io).toString());
            this.disconnect();
        }
    }

    private void disconnect() {
        try {
            try {
                this.connected = 64;
                if (this.telnetClient != null) {
                    this.telnetClient.disconnect();
                }
                this.modem.setStreams(null, null);
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("SwiftLink disconnected from ").append($this.host).append(":").append($this.port).toString());
                this.modem.commandModeMessage(HayesResultCode$.MODULE$.NO_CARRIER());
            }
            catch (Throwable throwable) {}
        }
        finally {
            this.statusListener.setRS232Enabled(false);
            this.statusListener.connectedTo("");
        }
    }

    @Override
    public void setBitReceivedListener(Function0<BoxedUnit> l) {
    }

    @Override
    public String getDescription() {
        return "<html>SwiftLink TCP/IP cartridge.<br>Connection string: <i>host:port</i> or leave empty to connect later via <i>atdt host:port</i> modem command</html>";
    }

    @Override
    public void setRS232Listener(RS232StatusListener l) {
        this.statusListener = l;
    }

    @Override
    public String toString() {
        return new StringBuilder(0).append(this.componentID()).append((Object)(this.isEnabled() ? "(enabled)" : "")).append((Object)(this.reu.isDefined() ? " $DE00 + REU" : " $DF00")).toString();
    }

    @Override
    public void reset() {
        this.disconnect();
        this.ctrl = 8;
        this.ucesoft$cbm$expansion$SwiftLink$$cmd = 224;
        this.status = 16;
        this.ucesoft$cbm$expansion$SwiftLink$$nmiHandler.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.clk.cancel("SL_RX_EVENT");
        this.clk.cancel("SL_TX_EVENT");
        Option<ExpansionPort> option = this.reu;
        if (option instanceof Some) {
            Some some = (Some)option;
            ExpansionPort r = (ExpansionPort)some.value();
            r.reset();
            return;
        }
    }

    @Override
    public void eject() {
        this.disconnect();
        this.clk.cancel("SL_RX_EVENT");
        this.clk.cancel("SL_TX_EVENT");
        ExpansionPort$.MODULE$.setExpansionPort(ExpansionPort$.MODULE$.emptyExpansionPort());
    }

    private boolean isRTS() {
        return (this.ucesoft$cbm$expansion$SwiftLink$$cmd >> 2 & 3) != 0;
    }

    private boolean isDataTerminalReady() {
        return (this.ucesoft$cbm$expansion$SwiftLink$$cmd & 1) > 0;
    }

    private boolean isReceiverInterruptEnabled() {
        return (this.ucesoft$cbm$expansion$SwiftLink$$cmd & 2) == 0;
    }

    private boolean isTransmitterInterruptEnabled() {
        return (this.ucesoft$cbm$expansion$SwiftLink$$cmd & 0xC) == 4;
    }

    private void nmi() {
        this.ucesoft$cbm$expansion$SwiftLink$$nmiHandler.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.ucesoft$cbm$expansion$SwiftLink$$nmiHandler.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.ucesoft$cbm$expansion$SwiftLink$$irq = 128;
    }

    private void readCycle(long cycles2) {
        try {
            if (this.isRTS() && this.isDataTerminalReady() && this.modem.inputStream() != null && this.modem.inputStream().available() > 0) {
                this.statusListener.update(1, 1);
                this.byteReceived = this.modem.inputStream().read();
                this.overrun = this.receiverDataRegister == 8 ? 2 : 0;
                this.receiverDataRegister = 8;
                if (this.isReceiverInterruptEnabled()) {
                    this.nmi();
                }
            } else {
                this.statusListener.update(1, 0);
            }
        }
        catch (Throwable t) {
            this.socketError(t);
        }
        this.clk.schedule(new ClockEvent("SL_RX_EVENT", cycles2 + this.clockTicks, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.readCycle(cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
    }

    private void socketError(Throwable t) {
        Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Error while reading/writing byte from/to SwiftLink: ").append(t).toString());
        t.printStackTrace();
        this.hangUp();
    }

    @Override
    public int read(int _address, Enumeration.Value chipID) {
        int address = _address & 0xFF00 | _address & 3;
        int n = address;
        if (this.STATUS == n) {
            int status = this.overrun | this.receiverDataRegister | this.transmitterDataRegister | this.connected | this.ucesoft$cbm$expansion$SwiftLink$$irq;
            this.ucesoft$cbm$expansion$SwiftLink$$irq = 0;
            return status;
        }
        if (this.CTRL == n) {
            return this.ctrl;
        }
        if (this.CMD == n) {
            return this.ucesoft$cbm$expansion$SwiftLink$$cmd;
        }
        if (this.DATA == n) {
            this.receiverDataRegister = 0;
            return this.byteReceived;
        }
        Option<ExpansionPort> option = this.reu;
        if (option instanceof Some) {
            Some some = (Some)option;
            ExpansionPort r = (ExpansionPort)some.value();
            return r.read(_address, chipID);
        }
        return 0;
    }

    @Override
    public Enumeration.Value read$default$2() {
        return ChipID$.MODULE$.CPU();
    }

    @Override
    public void write(int _address, int value, Enumeration.Value chipID) {
        block5: {
            int address = _address & 0xFF00 | _address & 3;
            int n = address;
            if (this.STATUS == n) {
                this.reset();
                return;
            }
            if (this.CTRL == n) {
                this.ctrl = value;
                this.updateClockTicks();
                return;
            }
            if (this.CMD == n) {
                this.ucesoft$cbm$expansion$SwiftLink$$cmd = value;
                this.statusListener.update(4, this.isDataTerminalReady() ? 1 : 0);
                this.statusListener.update(2, (this.ucesoft$cbm$expansion$SwiftLink$$cmd >> 2 & 3) != 0 ? 1 : 0);
                this.updateClockTicks();
                return;
            }
            if (this.DATA == n) {
                this.statusListener.update(2, value & 0xC);
                if (this.transmitterDataRegister == 16) {
                    this.statusListener.update(256, 1);
                    this.transmitterDataRegister = 0;
                    this.clk.schedule(new ClockEvent("SL_RX_EVENT", this.clk.currentCycles() + this.clockTicks, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> {
                        $this.statusListener.update(256, 0);
                        try {
                            try {
                                if ($this.modem.outputStream() != null) {
                                    $this.modem.outputStream().write(value);
                                    $this.modem.outputStream().flush();
                                }
                            }
                            catch (Throwable t) {
                                this.socketError(t);
                            }
                        }
                        finally {
                            $this.transmitterDataRegister = 16;
                            if (this.isTransmitterInterruptEnabled()) {
                                this.nmi();
                            }
                        }
                    }, ClockEvent$.MODULE$.$lessinit$greater$default$4()));
                    return;
                }
                return;
            }
            Option<ExpansionPort> option = this.reu;
            if (!(option instanceof Some)) break block5;
            Some some = (Some)option;
            ExpansionPort r = (ExpansionPort)some.value();
            r.write(_address, value, chipID);
        }
    }

    @Override
    public Enumeration.Value write$default$3() {
        return ChipID$.MODULE$.CPU();
    }

    private void updateClockTicks() {
        int stopBits = 1 + ((this.ctrl & 0x80) >> 7);
        int wordLength = 8 - ((this.ctrl & 0x60) >> 5);
        int parityBit = (this.ucesoft$cbm$expansion$SwiftLink$$cmd & 0x20) >> 5;
        double baud = this.SPEEDS[this.ctrl & 0xF];
        this.modem.setBaud((int)baud);
        this.clockTicks = (int)package$.MODULE$.round(this.clk.getClockHz() / baud * (double)(1 + stopBits + wordLength + parityBit));
        if (baud != this.lastBaud) {
            this.lastBaud = baud;
            this.clk.cancel("SL_RX_EVENT");
            this.clk.schedule(new ClockEvent("SL_RX_EVENT", this.clk.currentCycles() + this.clockTicks, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.readCycle(cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("SwiftLink clockTicks=").append($this.clockTicks).append(" stopBits=").append(stopBits).append(" wordLength=").append(wordLength).append(" parityBit=").append(parityBit).append(" baud=").append(baud).toString());
            return;
        }
    }

    @Override
    public void saveState(ObjectOutputStream out) {
    }

    @Override
    public void loadState(ObjectInputStream in) {
    }

    @Override
    public boolean allowsStateRestoring() {
        this.showError("State error", "Storing SwiftLink's state is not supported.");
        return false;
    }

    public SwiftLink(Function1<Object, BoxedUnit> nmiHandler, Option<ExpansionPort> reu) {
        this.ucesoft$cbm$expansion$SwiftLink$$nmiHandler = nmiHandler;
        this.reu = reu;
        RS232.$init$(this);
        this.TYPE = ExpansionPortType$.MODULE$.SWIFTLINK();
        this.name = "SwiftLink";
        this.componentID = "SwiftLink";
        this.componentType = CBMComponentType$.MODULE$.MEMORY();
        this.DATA = reu.isDefined() ? 56832 : 57088;
        this.STATUS = reu.isDefined() ? 56833 : 57089;
        this.CMD = reu.isDefined() ? 56834 : 57090;
        this.CTRL = reu.isDefined() ? 56835 : 57091;
        this.status = 0;
        this.ucesoft$cbm$expansion$SwiftLink$$cmd = 0;
        this.ctrl = 8;
        this.connected = 96;
        this.overrun = 0;
        this.receiverDataRegister = 0;
        this.transmitterDataRegister = 16;
        this.ucesoft$cbm$expansion$SwiftLink$$irq = 0;
        this.byteReceived = 0;
        this.clockTicks = 1000000L;
        this.clk = Clock$.MODULE$.systemClock();
        this.telnetClient = new TelnetClient();
        this.host = "";
        this.port = 0;
        this.lastBaud = 0.0;
        this.modem = new Modem(this, new StringBuilder(95).append("WELCOME ON KERNAL64'S SWIFTLINK IMPL.").append('\r').append("TYPE 'ATDT <HOST>:<PORT> TO CONNECT ").append('\r').toString());
        this.hostAndConf = "";
        this.SPEEDS = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(new double[]{10.0, 50.0, 75.0, 109.92, 134.58, 150.0, 300.0, 600.0, 1200.0, 1800.0, 2400.0, 3600.0, 4800.0, 7200.0, 9600.0, 19200.0}), (Function1)(JFunction1.mcDD.sp & Serializable)x$2 -> x$2 * (double)2, (ClassTag)ClassTag$.MODULE$.Double());
        this.EXROM = true;
        this.GAME = true;
        this.ROML = null;
        this.ROMH = null;
    }
}

