/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.file.Files;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.formats.Cartridge$;
import ucesoft.cbm.formats.Cartridge$CBMType$;

@ScalaSignature(bytes="\u0006\u0005\t=r!\u0002!B\u0011\u0003Ae!\u0002&B\u0011\u0003Y\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0003)\u0006\"B5\u0002\t\u0003Qw!\u0002@\u0002\u0011\u0003yhaBA\u0002\u0003!\u0005\u0011Q\u0001\u0005\u0007%\u001a!\t!!\u0004\t\u0013\u0005=aA1A\u0005\u0002\u0005E\u0001\u0002CA\u000e\r\u0001\u0006I!a\u0005\t\u0013\u0005uaA1A\u0005\u0002\u0005E\u0001\u0002CA\u0010\r\u0001\u0006I!a\u0005\t\u0013\u0005\u0005bA1A\u0005\u0002\u0005E\u0001\u0002CA\u0012\r\u0001\u0006I!a\u0005\t\u0013\u0005\u0015bA1A\u0005\u0002\u0005E\u0001\u0002CA\u0014\r\u0001\u0006I!a\u0005\t\u0013\u0005%b!!A\u0005\n\u0005-\u0002\"CA\u001d\u0003E\u0005I\u0011AA\u001e\r\u0015Q\u0015\tAA)\u0011)\t\u0019F\u0005BC\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003/\u0012\"\u0011!Q\u0001\nMD\u0011\"!\u0017\u0013\u0005\u0003\u0005\u000b\u0011B1\t\rI\u0013B\u0011AA.\r\u0019\t\u0019G\u0005\u0001\u0002f!1!k\u0006C\u0001\u0003OB\u0011\"!\u001c\u0018\u0001\u0004%\t!a\u001c\t\u0013\u0005]t\u00031A\u0005\u0002\u0005e\u0004\u0002CA@/\u0001\u0006K!!\u001d\t\u0013\u0005\u0005u\u00031A\u0005\u0002\u0005=\u0004\"CAB/\u0001\u0007I\u0011AAC\u0011!\tIi\u0006Q!\n\u0005E\u0004\"CAF/\u0001\u0007I\u0011AA8\u0011%\tii\u0006a\u0001\n\u0003\ty\t\u0003\u0005\u0002\u0014^\u0001\u000b\u0015BA9\u0011%\t)j\u0006a\u0001\n\u0003\t9\nC\u0005\u0002\u001c^\u0001\r\u0011\"\u0001\u0002\u001e\"A\u0011\u0011U\f!B\u0013\tI\nC\u0004\u0002$^!\t!!*\t\u000f\u0005=v\u0003\"\u0011\u00022\"I\u0011q\u0017\nA\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003w\u0013\u0002\u0019!C\u0001\u0003{C\u0001\"!1\u0013A\u0003&\u00111\u0017\u0005\n\u0003\u0007\u0014\u0002\u0019!C\u0001\u0003_B\u0011\"!2\u0013\u0001\u0004%\t!a2\t\u0011\u0005-'\u0003)Q\u0005\u0003cB1\"!4\u0013\u0001\u0004\u0005\r\u0011\"\u0001\u0002P\"Y\u0011q\u001b\nA\u0002\u0003\u0007I\u0011AAm\u0011-\tiN\u0005a\u0001\u0002\u0003\u0006K!!5\t\u0013\u0005}'\u00031A\u0005\u0002\u0005\u0005\b\"CAr%\u0001\u0007I\u0011AAs\u0011\u001d\tIO\u0005Q!\n\u0005D\u0011\"a;\u0013\u0001\u0004%\t!!9\t\u0013\u00055(\u00031A\u0005\u0002\u0005=\bbBAz%\u0001\u0006K!\u0019\u0005\n\u0003k\u0014\u0002\u0019!C\u0001\u0003oD\u0011\"a?\u0013\u0001\u0004%\t!!@\t\u0011\t\u0005!\u0003)Q\u0005\u0003sD!Ba\u0001\u0013\u0011\u000b\u0007I\u0011AA8\u0011\u001d\u0011)A\u0005C\u0005\u0005\u000fA\u0011Ba\u0006\u0013#\u0003%IA!\u0007\t\u000f\tu!\u0003\"\u0001\u0003 !9!1\u0006\n\u0005\n\t5\u0002bBAR%\u0011%!Q\u0006\u0005\b\u0003_\u0013B\u0011IAY\u0003%\u0019\u0015M\u001d;sS\u0012<WM\u0003\u0002C\u0007\u00069am\u001c:nCR\u001c(B\u0001#F\u0003\r\u0019'-\u001c\u0006\u0002\r\u00069QoY3t_\u001a$8\u0001\u0001\t\u0003\u0013\u0006i\u0011!\u0011\u0002\n\u0007\u0006\u0014HO]5eO\u0016\u001c\"!\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001*\u0001\fde\u0016\fG/Z\"S)\u001aKG.\u001a$s_6\u001cF/\u0019;f)\t1F\r\u0005\u0003N/f\u000b\u0017B\u0001-O\u0005\u0019!V\u000f\u001d7feA\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0003S>T\u0011AX\u0001\u0005U\u00064\u0018-\u0003\u0002a7\n!a)\u001b7f!\ti%-\u0003\u0002d\u001d\n9!i\\8mK\u0006t\u0007\"B3\u0004\u0001\u00041\u0017AA5o!\tQv-\u0003\u0002i7\n\trJ\u00196fGRLe\u000e];u'R\u0014X-Y7\u0002\t5\f\u0017N\u001c\u000b\u0003W:\u0004\"!\u00147\n\u00055t%\u0001B+oSRDQa\u001c\u0003A\u0002A\fA!\u0019:hgB\u0019Q*]:\n\u0005It%!B!se\u0006L\bC\u0001;|\u001d\t)\u0018\u0010\u0005\u0002w\u001d6\tqO\u0003\u0002y\u000f\u00061AH]8pizJ!A\u001f(\u0002\rA\u0013X\rZ3g\u0013\taXP\u0001\u0004TiJLgn\u001a\u0006\u0003u:\u000bqa\u0011\"N)f\u0004X\rE\u0002\u0002\u0002\u0019i\u0011!\u0001\u0002\b\u0007\nkE+\u001f9f'\r1\u0011q\u0001\t\u0004\u001b\u0006%\u0011bAA\u0006\u001d\nYQI\\;nKJ\fG/[8o)\u0005y\u0018aA\"7iU\u0011\u00111\u0003\t\u0005\u0003+\t9\"D\u0001\u0007\u0013\u0011\tI\"!\u0003\u0003\u000bY\u000bG.^3\u0002\t\r3D\u0007I\u0001\u0005\u0007F\u0012\u0004(A\u0003DcIB\u0004%A\u0003W\u0013\u000e\u0013\u0004'\u0001\u0004W\u0013\u000e\u0013\u0004\u0007I\u0001\u0006\u0007\nk\u0015*S\u0001\u0007\u0007\nk\u0015*\u0013\u0011\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005MR,\u0001\u0003mC:<\u0017\u0002BA\u001c\u0003c\u0011aa\u00142kK\u000e$\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002>)\u001a\u0011-a\u0010,\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0013O\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\n)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u001c\"A\u0005'\u0002\t\u0019LG.Z\u000b\u0002g\u0006)a-\u001b7fA\u0005\u0019!/Y<\u0015\r\u0005u\u0013qLA1!\tI%\u0003\u0003\u0004\u0002TY\u0001\ra\u001d\u0005\t\u000332\u0002\u0013!a\u0001C\n!1\t[5q'\t9B\n\u0006\u0002\u0002jA\u0019\u00111N\f\u000e\u0003I\t!BY1oW:+XNY3s+\t\t\t\bE\u0002N\u0003gJ1!!\u001eO\u0005\rIe\u000e^\u0001\u000fE\u0006t7NT;nE\u0016\u0014x\fJ3r)\rY\u00171\u0010\u0005\n\u0003{R\u0012\u0011!a\u0001\u0003c\n1\u0001\u001f\u00132\u0003-\u0011\u0017M\\6Ok6\u0014WM\u001d\u0011\u0002'M$\u0018M\u001d;j]\u001edu.\u00193BI\u0012\u0014Xm]:\u0002/M$\u0018M\u001d;j]\u001edu.\u00193BI\u0012\u0014Xm]:`I\u0015\fHcA6\u0002\b\"I\u0011QP\u000f\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0015gR\f'\u000f^5oO2{\u0017\rZ!eIJ,7o\u001d\u0011\u0002\u000fI|WnU5{K\u0006Y!o\\7TSj,w\fJ3r)\rY\u0017\u0011\u0013\u0005\n\u0003{\u0002\u0013\u0011!a\u0001\u0003c\n\u0001B]8n'&TX\rI\u0001\be>lG)\u0019;b+\t\tI\n\u0005\u0003Nc\u0006E\u0014a\u0003:p[\u0012\u000bG/Y0%KF$2a[AP\u0011%\tihIA\u0001\u0002\u0004\tI*\u0001\u0005s_6$\u0015\r^1!\u0003\u0011aw.\u00193\u0015\u0007-\f9\u000b\u0003\u0004fK\u0001\u0007\u0011\u0011\u0016\t\u00045\u0006-\u0016bAAW7\n\u0001\"+\u00198e_6\f5mY3tg\u001aKG.Z\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0017\t\u0005\u0003_\t),C\u0002}\u0003c\tAA\\1nKV\u0011\u00111W\u0001\t]\u0006lWm\u0018\u0013fcR\u00191.a0\t\u0013\u0005u\u0004&!AA\u0002\u0005M\u0016!\u00028b[\u0016\u0004\u0013aB2ueRK\b/Z\u0001\fGR\u0014H+\u001f9f?\u0012*\u0017\u000fF\u0002l\u0003\u0013D\u0011\"! ,\u0003\u0003\u0005\r!!\u001d\u0002\u0011\r$(\u000fV=qK\u0002\nqa\u00192n)f\u0004X-\u0006\u0002\u0002RB!\u00111[A\f\u001d\r\t).\u0002\b\u0003\u0013\u0002\t1b\u00192n)f\u0004Xm\u0018\u0013fcR\u00191.a7\t\u0013\u0005ud&!AA\u0002\u0005E\u0017\u0001C2c[RK\b/\u001a\u0011\u0002\u000b\u0015C&kT'\u0016\u0003\u0005\f\u0011\"\u0012-S\u001f6{F%Z9\u0015\u0007-\f9\u000f\u0003\u0005\u0002~E\n\t\u00111\u0001b\u0003\u0019)\u0005LU(NA\u0005!q)Q'F\u0003!9\u0015)T#`I\u0015\fHcA6\u0002r\"A\u0011Q\u0010\u001b\u0002\u0002\u0003\u0007\u0011-A\u0003H\u00036+\u0005%A\u0003dQ&\u00048/\u0006\u0002\u0002zB!Q*]A5\u0003%\u0019\u0007.\u001b9t?\u0012*\u0017\u000fF\u0002l\u0003\u007fD\u0011\"! 8\u0003\u0003\u0005\r!!?\u0002\r\rD\u0017\u000e]:!\u0003\u0019Y'mU5{K\u00069\u0011\r\u001a3DQ&\u0004H#C6\u0003\n\t5!q\u0002B\n\u0011\u001d\u0011YA\u000fa\u0001\u0003c\n!B]8n\u0003\u0012$'/Z:t\u0011\u001d\tYI\u000fa\u0001\u0003cBqA!\u0005;\u0001\u0004\tI*A\u0002s_6D\u0011B!\u0006;!\u0003\u0005\r!!\u001d\u0002\t\t\fgn[\u0001\u0012C\u0012$7\t[5qI\u0011,g-Y;mi\u0012\"TC\u0001B\u000eU\u0011\t\t(a\u0010\u0002\u0013M\fg/Z*uCR,GcA6\u0003\"!9!1\u0005\u001fA\u0002\t\u0015\u0012aA8viB\u0019!La\n\n\u0007\t%2L\u0001\nPE*,7\r^(viB,Ho\u0015;sK\u0006l\u0017a\u00027pC\u0012\u0014\u0016m\u001e\u000b\u0002W\u0002")
public class Cartridge {
    private int kbSize;
    private final String file;
    private final boolean raw;
    private String name;
    private int ctrType;
    private Enumeration.Value cbmType;
    private boolean EXROM;
    private boolean GAME;
    private Chip[] chips;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Cartridge$.MODULE$.$lessinit$greater$default$2();
    }

    public static void main(String[] args) {
        Cartridge$.MODULE$.main(args);
    }

    public static Tuple2<File, Object> createCRTFileFromState(ObjectInputStream in) {
        return Cartridge$.MODULE$.createCRTFileFromState(in);
    }

    public String file() {
        return this.file;
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public int ctrType() {
        return this.ctrType;
    }

    public void ctrType_$eq(int x$1) {
        this.ctrType = x$1;
    }

    public Enumeration.Value cbmType() {
        return this.cbmType;
    }

    public void cbmType_$eq(Enumeration.Value x$1) {
        this.cbmType = x$1;
    }

    public boolean EXROM() {
        return this.EXROM;
    }

    public void EXROM_$eq(boolean x$1) {
        this.EXROM = x$1;
    }

    public boolean GAME() {
        return this.GAME;
    }

    public void GAME_$eq(boolean x$1) {
        this.GAME = x$1;
    }

    public Chip[] chips() {
        return this.chips;
    }

    public void chips_$eq(Chip[] x$1) {
        this.chips = x$1;
    }

    private int kbSize$lzycompute() {
        Cartridge cartridge = this;
        synchronized (cartridge) {
            if (!this.bitmap$0) {
                this.kbSize = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.chips()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.romSize()), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 1024;
                this.bitmap$0 = true;
            }
        }
        return this.kbSize;
    }

    public int kbSize() {
        if (!this.bitmap$0) {
            return this.kbSize$lzycompute();
        }
        return this.kbSize;
    }

    private void addChip(int romAddress, int romSize, int[] rom, int bank) {
        Chip chip = new Chip();
        chip.bankNumber_$eq(bank);
        chip.startingLoadAddress_$eq(romAddress);
        chip.romSize_$eq(romSize);
        chip.romData_$eq(rom);
        if (this.chips() == null) {
            this.chips_$eq((Chip[])((Object[])new Chip[]{chip}));
            return;
        }
        this.chips_$eq((Chip[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.chips()), (Object)new Chip[]{chip}, ClassTag$.MODULE$.apply(Chip.class)));
    }

    private int addChip$default$4() {
        return 0;
    }

    public void saveState(ObjectOutputStream out) {
        File f = new File(this.file());
        out.writeBoolean(this.raw);
        out.writeInt((int)f.length());
        Files.copy(f.toPath(), out);
    }

    private void loadRaw() {
        File f = new File(this.file());
        byte[] buffer = Files.readAllBytes(f.toPath());
        int address = (buffer[1] << 8 | buffer[0]) & 0xFFFF;
        int[] rom = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.byteArrayOps(buffer), 2)), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Cartridge.$anonfun$loadRaw$1(BoxesRunTime.unboxToByte((Object)x$3))), (ClassTag)ClassTag$.MODULE$.Int());
        this.addChip(address, buffer.length - 2, rom, this.addChip$default$4());
        this.name_$eq(f.getName());
    }

    private void load() {
        try (RandomAccessFile in = new RandomAccessFile(this.file(), "r");){
            byte[] nameBuffer = (byte[])Array$.MODULE$.ofDim(16, (ClassTag)ClassTag$.MODULE$.Byte());
            in.readFully(nameBuffer);
            String signature = new String(nameBuffer);
            try {
                this.cbmType_$eq(Cartridge$CBMType$.MODULE$.withName(signature));
            }
            catch (Exception exception) {
                throw new IOException(new StringBuilder(30).append("Cart signature not supported: ").append(signature).toString());
            }
            in.seek(22L);
            this.ctrType_$eq(in.readByte() * 256 + in.readByte());
            this.EXROM_$eq(in.readByte() == 1);
            this.GAME_$eq(in.readByte() == 1);
            in.seek(32L);
            scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
            boolean zeroFound = false;
            for (int i = 0; i < 32 && !zeroFound; ++i) {
                BoxedUnit boxedUnit;
                byte c = in.readByte();
                if (c == 0) {
                    zeroFound = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = sb.append((char)c);
            }
            this.name_$eq(sb.toString());
            in.seek(64L);
            Nil$ tmp = Nil$.MODULE$;
            while (in.getFilePointer() < in.length()) {
                Chip chip = new Chip();
                chip.load(in);
                Chip chip2 = chip;
                tmp = tmp.$colon$colon((Object)chip2);
            }
            this.chips_$eq((Chip[])tmp.reverse().toArray(ClassTag$.MODULE$.apply(Chip.class)));
        }
    }

    public String toString() {
        return new StringBuilder(38).append("Cartridge[").append(this.cbmType()).append("] ").append(this.name()).append(" type=").append(this.ctrType()).append(" EXROM=").append(this.EXROM()).append(" GAME=").append(this.GAME()).append(" CHIPS=").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.chips()), (Function1 & Serializable)x$4 -> x$4.toString(), ClassTag$.MODULE$.apply(String.class))).mkString("[", ",", "]")).toString();
    }

    public static final /* synthetic */ int $anonfun$loadRaw$1(byte x$3) {
        return x$3 & 0xFF;
    }

    public Cartridge(String file, boolean raw) {
        this.file = file;
        this.raw = raw;
        this.name = "";
        this.ctrType = 0;
        this.EXROM = false;
        this.GAME = false;
        this.chips = null;
        if (raw) {
            this.loadRaw();
        } else {
            this.load();
        }
    }

    public class Chip {
        private int bankNumber;
        private int startingLoadAddress;
        private int romSize;
        private int[] romData;

        public int bankNumber() {
            return this.bankNumber;
        }

        public void bankNumber_$eq(int x$1) {
            this.bankNumber = x$1;
        }

        public int startingLoadAddress() {
            return this.startingLoadAddress;
        }

        public void startingLoadAddress_$eq(int x$1) {
            this.startingLoadAddress = x$1;
        }

        public int romSize() {
            return this.romSize;
        }

        public void romSize_$eq(int x$1) {
            this.romSize = x$1;
        }

        public int[] romData() {
            return this.romData;
        }

        public void romData_$eq(int[] x$1) {
            this.romData = x$1;
        }

        public void load(RandomAccessFile in) {
            if (in.readByte() != 67 || in.readByte() != 72 || in.readByte() != 73 || in.readByte() != 80) {
                throw new IOException("CHIP signature not found");
            }
            in.skipBytes(6);
            this.bankNumber_$eq((Chip.nextByte$1(in) << 8) + Chip.nextByte$1(in));
            this.startingLoadAddress_$eq((Chip.nextByte$1(in) << 8) + Chip.nextByte$1(in) & 0xFFFF);
            this.romSize_$eq((Chip.nextByte$1(in) << 8) + Chip.nextByte$1(in) & 0xFFFF);
            byte[] buffer = (byte[])Array$.MODULE$.ofDim(this.romSize(), (ClassTag)ClassTag$.MODULE$.Byte());
            in.read(buffer);
            this.romData_$eq((int[])Array$.MODULE$.ofDim(this.romSize(), (ClassTag)ClassTag$.MODULE$.Int()));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.romSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                $this.romData()[i] = buffer[i] & 0xFF;
            });
        }

        public String toString() {
            return new StringBuilder(32).append("CHIP bank=").append(this.bankNumber()).append(" loadAddress=").append(Integer.toHexString(this.startingLoadAddress())).append(" romSize=").append(this.romSize()).toString();
        }

        public /* synthetic */ Cartridge ucesoft$cbm$formats$Cartridge$Chip$$$outer() {
            return Cartridge.this;
        }

        private static final int nextByte$1(RandomAccessFile in$1) {
            return in$1.readByte() & 0xFF;
        }

        public Chip() {
            if (Cartridge.this == null) {
                throw null;
            }
            this.bankNumber = 0;
            this.startingLoadAddress = 0;
            this.romSize = 0;
            this.romData = null;
        }
    }
}

