/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.util.Properties;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.expansion.ExpansionPort;
import ucesoft.cbm.formats.Cartridge;
import ucesoft.cbm.formats.Cartridge$;
import ucesoft.cbm.formats.Cartridge$CBMType$;
import ucesoft.cbm.formats.ExpansionPortFactory;
import ucesoft.cbm.formats.cart.ActionReplay;
import ucesoft.cbm.formats.cart.Comal80;
import ucesoft.cbm.formats.cart.Dinamic;
import ucesoft.cbm.formats.cart.EasyFlash;
import ucesoft.cbm.formats.cart.EpyxFastload;
import ucesoft.cbm.formats.cart.FinalCartridgeI;
import ucesoft.cbm.formats.cart.FinalCartridgeIII;
import ucesoft.cbm.formats.cart.FunPlay;
import ucesoft.cbm.formats.cart.GMOD2;
import ucesoft.cbm.formats.cart.GMOD3;
import ucesoft.cbm.formats.cart.GameSystem;
import ucesoft.cbm.formats.cart.KCS;
import ucesoft.cbm.formats.cart.Mach5;
import ucesoft.cbm.formats.cart.MagicDesk;
import ucesoft.cbm.formats.cart.MagicDesk16K;
import ucesoft.cbm.formats.cart.Ocean;
import ucesoft.cbm.formats.cart.PageFox;
import ucesoft.cbm.formats.cart.SimonsBasic;
import ucesoft.cbm.formats.cart.SuperExplode;
import ucesoft.cbm.formats.cart.SuperGames;
import ucesoft.cbm.formats.cart.SuperSnapshot5;
import ucesoft.cbm.formats.cart.WarpSpeed;
import ucesoft.cbm.formats.cart.Zaxxon;

public final class ExpansionPortFactory$ {
    public static final ExpansionPortFactory$ MODULE$ = new ExpansionPortFactory$();

    public ExpansionPort loadExpansionPort(String crtName, Function1<Object, BoxedUnit> irqAction, Function1<Object, BoxedUnit> nmiAction, Memory ram, Memory forwardRam, Function0<BoxedUnit> reset, Properties config) {
        Cartridge crt = new Cartridge(crtName, Cartridge$.MODULE$.$lessinit$greater$default$2());
        Enumeration.Value value = crt.cbmType();
        Enumeration.Value value2 = Cartridge$CBMType$.MODULE$.C64();
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Unsupported cartridge signature '").append(crt.cbmType()).append("'").toString());
        }
        int n = crt.ctrType();
        switch (n) {
            case 1: {
                return new ActionReplay(crt, nmiAction, ram);
            }
            case 2: {
                return new KCS(crt, ram, nmiAction);
            }
            case 3: {
                return new FinalCartridgeIII(crt, nmiAction, ram);
            }
            case 0: {
                return new ExpansionPortFactory.CartridgeExpansionPort(crt, ram);
            }
            case 4: {
                return new SimonsBasic(crt, ram);
            }
            case 21: {
                return new Comal80(crt, ram);
            }
            case 19: {
                return new MagicDesk(crt, ram);
            }
            case 17: {
                return new Dinamic(crt, ram);
            }
            case 15: {
                return new GameSystem(crt, ram);
            }
            case 16: {
                return new WarpSpeed(crt, ram);
            }
            case 32: {
                return new EasyFlash(crt, ram);
            }
            case 5: {
                return new Ocean(crt, ram);
            }
            case 7: {
                return new FunPlay(crt, ram);
            }
            case 8: {
                return new SuperGames(crt, ram);
            }
            case 10: {
                return new EpyxFastload(crt, ram);
            }
            case 13: {
                return new FinalCartridgeI(crt, ram);
            }
            case 20: {
                return new SuperSnapshot5(crt, nmiAction, ram);
            }
            case 60: {
                return new GMOD2(crt, ram, config);
            }
            case 62: {
                return new GMOD3(crt, ram, forwardRam);
            }
            case 18: {
                return new Zaxxon(crt, ram);
            }
            case 51: {
                return new Mach5(crt, ram);
            }
            case 53: {
                return new PageFox(crt, ram);
            }
            case 48: {
                return new SuperExplode(crt, ram, reset);
            }
            case 85: {
                return new MagicDesk16K(crt, ram);
            }
        }
        throw new IllegalArgumentException(new StringBuilder(32).append("Unsupported cartridge type ").append(crt.ctrType()).append(" for ").append(crt.name()).toString());
    }

    public void main(String[] args) {
        Cartridge crt = new Cartridge(args[0], Cartridge$.MODULE$.$lessinit$greater$default$2());
        Predef$.MODULE$.println((Object)new StringBuilder(4).append(crt.ctrType()).append(" -> ").append(new ExpansionPortFactory.CartridgeExpansionPort(crt, null)).toString());
    }

    private ExpansionPortFactory$() {
    }
}

