/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats.cart;

import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import ucesoft.cbm.ChipID$;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.formats.Cartridge;
import ucesoft.cbm.formats.CartridgeBuilder;
import ucesoft.cbm.formats.ExpansionPortFactory;
import ucesoft.cbm.formats.cart.GMOD3$FlashROM$;
import ucesoft.cbm.formats.cart.GMOD3$IRQHackVectorRAM$;
import ucesoft.cbm.misc.EN25QH128A;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u00192\u0001iB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"Aq\u000b\u0001B\u0001B\u0003%\u0011\u000bC\u0003Y\u0001\u0011\u0005\u0011\f\u0003\u0004`\u0001\u0001\u0006K\u0001\u0019\u0005\u0007M\u0002\u0001\u000b\u0015B4\t\r)\u0004\u0001\u0015)\u0003a\u0011\u0019Y\u0007\u0001)A\u0005Y\"1q\u000e\u0001Q\u0001\nA<QA\u001e\u0001\t\n]4Q!\u001f\u0001\t\niDQ\u0001W\u0006\u0005\u0002yD\u0001b`\u0006C\u0002\u0013\u0005\u0013\u0011\u0001\u0005\b\u0003\u0007Y\u0001\u0015!\u0003a\u0011%\t)a\u0003b\u0001\n\u0003\n9\u0001C\u0004\u0002\n-\u0001\u000b\u0011B4\t\u0013\u0005-1B1A\u0005B\u0005\u001d\u0001bBA\u0007\u0017\u0001\u0006Ia\u001a\u0005\n\u0003\u001fY!\u0019!C!\u0003#A\u0001\"a\t\fA\u0003%\u00111\u0003\u0005\b\u0003KYA\u0011IA\u0014\u0011\u001d\tyc\u0003C!\u0003\u0003Aq!!\r\f\t\u0003\n\u0019\u0004C\u0004\u0002L-!\t%!\u0014\b\u000f\u0005]\u0003\u0001#\u0003\u0002Z\u00199\u00111\f\u0001\t\n\u0005u\u0003B\u0002-\u001b\t\u0003\ty\u0006\u0003\u0005\u00005\t\u0007I\u0011IA\u0001\u0011\u001d\t\u0019A\u0007Q\u0001\n\u0001D\u0011\"!\u0002\u001b\u0005\u0004%\t%a\u0002\t\u000f\u0005%!\u0004)A\u0005O\"I\u00111\u0002\u000eC\u0002\u0013\u0005\u0013q\u0001\u0005\b\u0003\u001bQ\u0002\u0015!\u0003h\u0011%\tyA\u0007b\u0001\n\u0003\n\t\u0002\u0003\u0005\u0002$i\u0001\u000b\u0011BA\n\u0011\u001d\t)C\u0007C!\u0003OAq!a\f\u001b\t\u0003\n\t\u0001C\u0004\u00022i!\t%!\u0019\t\u000f\u0005-#\u0004\"\u0011\u0002h!9\u0011\u0011\u0007\u0001\u0005B\u0005=\u0004\"CA>\u0001E\u0005I\u0011AA?\u0011\u001d\tY\u0005\u0001C!\u0003'C\u0011\"a'\u0001#\u0003%\t!! \t\u000f\u0005u\u0005\u0001\"\u0011\u0002(!9\u0011q\u0014\u0001\u0005B\u0005\u001d\u0002bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003C\u0003A\u0011AA\u0014\u0005\u00159Uj\u0014#4\u0015\t\u00114'\u0001\u0003dCJ$(B\u0001\u001b6\u0003\u001d1wN]7biNT!AN\u001c\u0002\u0007\r\u0014WNC\u00019\u0003\u001d)8-Z:pMR\u001c\u0001a\u0005\u0002\u0001wA\u0011A\b\u0013\b\u0003{\u0019s!AP#\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\":\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u00027o%\u0011A'N\u0005\u0003\u000fN\nA#\u0012=qC:\u001c\u0018n\u001c8Q_J$h)Y2u_JL\u0018BA%K\u0005Y\u0019\u0015M\u001d;sS\u0012<W-\u0012=qC:\u001c\u0018n\u001c8Q_J$(BA$4\u0003\r\u0019'\u000f\u001e\t\u0003\u001b:k\u0011aM\u0005\u0003\u001fN\u0012\u0011bQ1siJLGmZ3\u0002\u0007I\fW\u000e\u0005\u0002S+6\t1K\u0003\u0002Uk\u0005\u00191\r];\n\u0005Y\u001b&AB'f[>\u0014\u00180\u0001\u0006g_J<\u0018M\u001d3SC6\fa\u0001P5oSRtD\u0003\u0002.];z\u0003\"a\u0017\u0001\u000e\u0003EBQa\u0013\u0003A\u00021CQ\u0001\u0015\u0003A\u0002ECQa\u0016\u0003A\u0002E\u000b1BY5u\u0005\u0006tw-T8eKB\u0011\u0011\rZ\u0007\u0002E*\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\n9!i\\8mK\u0006t\u0017A\u00032b].\u001cuN\u001c4jOB\u0011\u0011\r[\u0005\u0003S\n\u00141!\u00138u\u0003%I'/\u001d,fGR|'/\u0001\u0003J%F\u001b\u0006cA1nO&\u0011aN\u0019\u0002\u0006\u0003J\u0014\u0018-_\u0001\tgBLg\t\\1tQB\u0011\u0011\u000f^\u0007\u0002e*\u00111/N\u0001\u0005[&\u001c8-\u0003\u0002ve\nQQI\u0014\u001a6#\"\u000b$\u0007O!\u0002\u0011\u0019c\u0017m\u001d5S\u001f6\u0003\"\u0001_\u0006\u000e\u0003\u0001\u0011\u0001B\u00127bg\"\u0014v*T\n\u0004\u0017m\f\u0006CA1}\u0013\ti(M\u0001\u0004B]f\u0014VM\u001a\u000b\u0002o\u0006)\u0011n\u001d*p[V\t\u0001-\u0001\u0004jgJ{W\u000eI\u0001\u0007Y\u0016tw\r\u001e5\u0016\u0003\u001d\fq\u0001\\3oORD\u0007%\u0001\u0007ti\u0006\u0014H/\u00113ee\u0016\u001c8/A\u0007ti\u0006\u0014H/\u00113ee\u0016\u001c8\u000fI\u0001\u0005]\u0006lW-\u0006\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u00027b]\u001eT!!!\b\u0002\t)\fg/Y\u0005\u0005\u0003C\t9B\u0001\u0004TiJLgnZ\u0001\u0006]\u0006lW\rI\u0001\u0005S:LG\u000f\u0006\u0002\u0002*A\u0019\u0011-a\u000b\n\u0007\u00055\"M\u0001\u0003V]&$\u0018\u0001C5t\u0003\u000e$\u0018N^3\u0002\tI,\u0017\r\u001a\u000b\u0006O\u0006U\u0012\u0011\b\u0005\u0007\u0003o9\u0002\u0019A4\u0002\u000f\u0005$GM]3tg\"I\u00111H\f\u0011\u0002\u0003\u0007\u0011QH\u0001\u0007G\"L\u0007/\u0013#\u0011\t\u0005}\u0012Q\t\b\u0004}\u0005\u0005\u0013bAA\"k\u000511\t[5q\u0013\u0012KA!a\u0012\u0002J\t\u0011\u0011\n\u0012\u0006\u0004\u0003\u0007*\u0014!B<sSR,G\u0003CA\u0015\u0003\u001f\n\t&!\u0016\t\r\u0005]\u0002\u00041\u0001h\u0011\u0019\t\u0019\u0006\u0007a\u0001O\u0006)a/\u00197vK\"I\u00111\b\r\u0011\u0002\u0003\u0007\u0011QH\u0001\u0011\u0013J\u000b\u0006*Y2l-\u0016\u001cGo\u001c:S\u00036\u0003\"\u0001\u001f\u000e\u0003!%\u0013\u0016\u000bS1dWZ+7\r^8s%\u0006k5c\u0001\u000e|#R\u0011\u0011\u0011\f\u000b\u0006O\u0006\r\u0014Q\r\u0005\u0007\u0003o1\u0003\u0019A4\t\u0013\u0005mb\u0005%AA\u0002\u0005uB\u0003CA\u0015\u0003S\nY'!\u001c\t\r\u0005]r\u00051\u0001h\u0011\u0019\t\u0019f\na\u0001O\"I\u00111H\u0014\u0011\u0002\u0003\u0007\u0011Q\b\u000b\u0006O\u0006E\u00141\u000f\u0005\u0007\u0003oA\u0003\u0019A4\t\u0013\u0005m\u0002\u0006%AA\u0002\u0005U\u0004\u0003BA<\u0003\u000brA!!\u001f\u0002B5\tQ'\u0001\bsK\u0006$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}$\u0006BA;\u0003\u0003[#!a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\u0013\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011SAD\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\t\u0003S\t)*a&\u0002\u001a\"1\u0011q\u0007\u0016A\u0002\u001dDa!a\u0015+\u0001\u00049\u0007\"CA\u001eUA\u0005\t\u0019AA;\u0003=9(/\u001b;fI\u0011,g-Y;mi\u0012\u001a\u0014!\u0002:fg\u0016$\u0018!B3kK\u000e$\u0018!C2sK\u0006$Xm\u0011*U\u0001")
public class GMOD3
extends ExpansionPortFactory.CartridgeExpansionPort {
    private volatile GMOD3$FlashROM$ FlashROM$module;
    private volatile GMOD3$IRQHackVectorRAM$ IRQHackVectorRAM$module;
    private final Cartridge crt;
    private final Memory ram;
    private final Memory forwardRam;
    private boolean bitBangMode;
    private int bankConfig;
    public boolean ucesoft$cbm$formats$cart$GMOD3$$irqVector;
    public final int[] ucesoft$cbm$formats$cart$GMOD3$$IRQS;
    private final EN25QH128A spiFlash;

    private GMOD3$FlashROM$ FlashROM() {
        if (this.FlashROM$module == null) {
            this.FlashROM$lzycompute$1();
        }
        return this.FlashROM$module;
    }

    private GMOD3$IRQHackVectorRAM$ IRQHackVectorRAM() {
        if (this.IRQHackVectorRAM$module == null) {
            this.IRQHackVectorRAM$lzycompute$1();
        }
        return this.IRQHackVectorRAM$module;
    }

    @Override
    public int read(int address, Enumeration.Value chipID) {
        if (address >= 57088) {
            return super.read(address, chipID);
        }
        if (this.bitBangMode) {
            return this.spiFlash.out() << 7;
        }
        if (address < 56840) {
            return this.bankConfig & 0xFF;
        }
        if (address >= 56840 && address < 56848) {
            return this.bankConfig >> 8;
        }
        return super.read(address, chipID);
    }

    @Override
    public Enumeration.Value read$default$2() {
        return ChipID$.MODULE$.CPU();
    }

    @Override
    public void write(int address, int value, Enumeration.Value chipID) {
        if (address < 56840) {
            if (this.bitBangMode) {
                boolean cs = (value & 0x40) == 0;
                int clk = (value & 0x20) >> 5;
                int din = (value & 0x10) >> 4;
                this.spiFlash.clock(cs, clk, din);
                return;
            }
            this.bankConfig = (address & 7) << 8 | value;
            this.romlBankIndex_$eq(this.bankConfig);
            return;
        }
        if (address == 56840) {
            this.bitBangMode = (value & 0x80) > 0;
            this.exrom_$eq((value & 0x40) > 0);
            this.ucesoft$cbm$formats$cart$GMOD3$$irqVector = (value & 0x20) > 0;
            this.notifyMemoryConfigurationChange();
            return;
        }
    }

    @Override
    public Enumeration.Value write$default$3() {
        return ChipID$.MODULE$.CPU();
    }

    @Override
    public void reset() {
        this.romlBankIndex_$eq(0);
        this.romhBankIndex_$eq(0);
        this.bankConfig = 0;
        this.game_$eq(true);
        this.exrom_$eq(false);
        this.ucesoft$cbm$formats$cart$GMOD3$$irqVector = false;
        this.bitBangMode = false;
        this.notifyMemoryConfigurationChange();
    }

    @Override
    public void eject() {
        this.ram.setForwardReadTo((Option<Memory>)None$.MODULE$);
    }

    @Override
    public void init() {
        this.forwardRam.setForwardReadTo((Option<Memory>)new Some((Object)this.IRQHackVectorRAM()));
    }

    public void createCRT() {
        CartridgeBuilder builder = new CartridgeBuilder(this.crt.file(), "KERNAL64 GMOD3", 62, false, true);
        this.romlBanks().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GMOD3.$anonfun$createCRT$1(this, check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            GMOD3.$anonfun$createCRT$2(this, builder, x$1);
            return BoxedUnit.UNIT;
        });
        builder.finish();
    }

    private final void FlashROM$lzycompute$1() {
        GMOD3 gMOD3 = this;
        synchronized (gMOD3) {
            if (this.FlashROM$module == null) {
                this.FlashROM$module = new GMOD3$FlashROM$(this);
            }
        }
    }

    private final void IRQHackVectorRAM$lzycompute$1() {
        GMOD3 gMOD3 = this;
        synchronized (gMOD3) {
            if (this.IRQHackVectorRAM$module == null) {
                this.IRQHackVectorRAM$module = new GMOD3$IRQHackVectorRAM$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$createCRT$1(GMOD3 $this, Tuple2 check$ifrefutable$1) {
        Memory rom;
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null && (rom = (Memory)tuple2._2()) instanceof ExpansionPortFactory.CartridgeExpansionPort.ROM && ((ExpansionPortFactory.CartridgeExpansionPort.ROM)rom).ucesoft$cbm$formats$ExpansionPortFactory$CartridgeExpansionPort$ROM$$$outer() == $this;
    }

    public static final /* synthetic */ void $anonfun$createCRT$2(GMOD3 $this, CartridgeBuilder builder$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int b = tuple2._1$mcI$sp();
            Memory rom = (Memory)tuple2._2();
            if (rom instanceof ExpansionPortFactory.CartridgeExpansionPort.ROM && ((ExpansionPortFactory.CartridgeExpansionPort.ROM)rom).ucesoft$cbm$formats$ExpansionPortFactory$CartridgeExpansionPort$ROM$$$outer() == $this) {
                ExpansionPortFactory.CartridgeExpansionPort.ROM rOM = (ExpansionPortFactory.CartridgeExpansionPort.ROM)rom;
                builder$1.addChip(32768, 2, b, rOM.data());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public GMOD3(Cartridge crt, Memory ram, Memory forwardRam) {
        this.crt = crt;
        this.ram = ram;
        this.forwardRam = forwardRam;
        super(crt, ram);
        this.bitBangMode = false;
        this.bankConfig = 0;
        this.ucesoft$cbm$formats$cart$GMOD3$$irqVector = false;
        this.ucesoft$cbm$formats$cart$GMOD3$$IRQS = new int[]{8, 0, 8, 0, 12, 128, 12, 0};
        if (crt.kbSize() != 2048 && crt.kbSize() != 4096 && crt.kbSize() != 8192 && crt.kbSize() != 16384) {
            throw new IllegalArgumentException(new StringBuilder(19).append("GMOD3: bad size: ").append(crt.kbSize()).append("KB").toString());
        }
        this.spiFlash = new EN25QH128A(crt.kbSize() * 1024, this.FlashROM());
    }
}

