/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.misc;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class AnimatedGIFWriter {
    private int codeLen;
    private int codeIndex;
    private int clearCode;
    private int endOfImage;
    private int bufIndex;
    private int empty_bits = 8;
    private int bitsPerPixel = 8;
    private byte[] bytes_buf = new byte[256];
    private int[] colorPalette;
    private boolean isApplyDither;
    int[] child = new int[4097];
    int[] siblings = new int[4097];
    int[] suffix = new int[4097];
    private int logicalScreenWidth;
    private int logicalScreenHeight;
    private boolean animated;
    private int loopCount;
    private boolean firstFrame = true;
    public static final byte IMAGE_SEPARATOR = 44;
    public static final byte IMAGE_TRAILER = 59;
    public static final byte EXTENSION_INTRODUCER = 33;
    public static final byte GRAPHIC_CONTROL_LABEL = -7;
    public static final byte APPLICATION_EXTENSION_LABEL = -1;
    public static final byte COMMENT_EXTENSION_LABEL = -2;
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    private static Dimension getLogicalScreenSize(BufferedImage[] bufferedImageArray) {
        int n = 0;
        int n2 = 0;
        for (BufferedImage bufferedImage : bufferedImageArray) {
            if (bufferedImage.getWidth() > n) {
                n = bufferedImage.getWidth();
            }
            if (bufferedImage.getHeight() <= n2) continue;
            n2 = bufferedImage.getHeight();
        }
        return new Dimension(n, n2);
    }

    private static Dimension getLogicalScreenSize(GIFFrame[] gIFFrameArray) {
        int n = 0;
        int n2 = 0;
        for (GIFFrame gIFFrame : gIFFrameArray) {
            int n3 = gIFFrame.getFrameWidth() + gIFFrame.getLeftPosition();
            int n4 = gIFFrame.getFrameHeight() + gIFFrame.getTopPosition();
            if (n3 > n) {
                n = n3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return new Dimension(n, n2);
    }

    public AnimatedGIFWriter() {
        this(false);
    }

    public AnimatedGIFWriter(boolean bl) {
        this.isApplyDither = bl;
    }

    public void write(BufferedImage bufferedImage, OutputStream outputStream) throws Exception {
        if (bufferedImage == null) {
            throw new NullPointerException("Input image is null");
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.write(AnimatedGIFWriter.getRGB(bufferedImage), n, n2, outputStream);
    }

    private void encode(byte[] byArray, OutputStream outputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = byArray.length;
        this.bitsPerPixel = this.bitsPerPixel == 1 ? 2 : this.bitsPerPixel;
        outputStream.write(this.bitsPerPixel);
        this.init_encoder(this.bitsPerPixel);
        this.send_code_to_buffer(this.clearCode, outputStream);
        n = byArray[n5++] & 0xFF;
        block0: while (n5 < n6) {
            n4 = byArray[n5++] & 0xFF;
            n2 = this.child[n];
            if (n2 > 0) {
                if (this.suffix[n2] == n4) {
                    n = n2;
                    continue;
                }
                n3 = n2;
                while (this.siblings[n3] > 0) {
                    if (this.suffix[n3 = this.siblings[n3]] != n4) continue;
                    n = n3;
                    continue block0;
                }
                this.siblings[n3] = this.codeIndex;
                this.suffix[this.codeIndex] = n4;
                this.send_code_to_buffer(n, outputStream);
                n = n4;
                ++this.codeIndex;
                if (this.codeIndex <= 1 << this.codeLen) continue;
                if (this.codeLen == 12) {
                    this.send_code_to_buffer(this.clearCode, outputStream);
                    this.init_encoder(this.bitsPerPixel);
                    continue;
                }
                ++this.codeLen;
                continue;
            }
            this.child[n] = this.codeIndex;
            this.suffix[this.codeIndex] = n4;
            this.send_code_to_buffer(n, outputStream);
            n = n4;
            ++this.codeIndex;
            if (this.codeIndex <= 1 << this.codeLen) continue;
            if (this.codeLen == 12) {
                this.send_code_to_buffer(this.clearCode, outputStream);
                this.init_encoder(this.bitsPerPixel);
                continue;
            }
            ++this.codeLen;
        }
        this.send_code_to_buffer(n, outputStream);
        this.send_code_to_buffer(this.endOfImage, outputStream);
        this.flush_buf(outputStream, this.bufIndex + 1);
    }

    public void finishWrite(OutputStream outputStream) throws Exception {
        outputStream.write(59);
        outputStream.close();
    }

    private void flush_buf(OutputStream outputStream, int n) throws Exception {
        outputStream.write(n);
        outputStream.write(this.bytes_buf, 0, n);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, 255, (byte)0);
    }

    private static int[] getRGB(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = writableRaster.getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        int n2 = writableRaster.getTransferType();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n3 * n4;
        int[] nArray = new int[n5];
        switch (n2) {
            case 3: {
                nArray = (int[])object;
                if (n == 3) {
                    for (int i = 0; i < n5; ++i) {
                        float f = 255.0f / (float)(nArray[i] >> 24 & 0xFF);
                        byte by = (byte)((float)(nArray[i] >> 16 & 0xFF) * f);
                        byte by2 = (byte)((float)(nArray[i] >> 8 & 0xFF) * f);
                        byte by3 = (byte)((float)(nArray[i] & 0xFF) * f);
                        nArray[i] = nArray[i] & 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
                    }
                } else if (n == 4) {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n6 = nArray[i] >> 16 & 0xFF;
                        int n7 = nArray[i] >> 8 & 0xFF;
                        int n8 = nArray[i] & 0xFF;
                        nArray[i] = 0xFF000000 | n8 << 16 | n7 << 8 | n6;
                    }
                } else if (n == 1) {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = 0xFF000000 | nArray[i];
                    }
                } else if (n != 2) {
                    return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
                }
                return nArray;
            }
            case 0: {
                byte[] byArray = (byte[])object;
                if (n == 13 || n == 12) {
                    int n9;
                    IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
                    int n10 = indexColorModel.getMapSize();
                    byte[] byArray2 = new byte[n10];
                    byte[] byArray3 = new byte[n10];
                    byte[] byArray4 = new byte[n10];
                    byte[] byArray5 = new byte[n10];
                    int[] nArray2 = new int[n10];
                    indexColorModel.getReds(byArray2);
                    indexColorModel.getGreens(byArray3);
                    indexColorModel.getBlues(byArray4);
                    indexColorModel.getAlphas(byArray5);
                    for (n9 = 0; n9 < n10; ++n9) {
                        nArray2[n9] = (byArray5[n9] & 0xFF) << 24 | (byArray2[n9] & 0xFF) << 16 | (byArray3[n9] & 0xFF) << 8 | byArray4[n9] & 0xFF;
                    }
                    for (n9 = 0; n9 < n5; ++n9) {
                        nArray[n9] = nArray2[byArray[n9] & 0xFF];
                    }
                } else if (n == 6) {
                    int n11 = 0;
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = (byArray[n11++] & 0xFF) << 16 | (byArray[n11++] & 0xFF) << 8 | byArray[n11++] & 0xFF | (byArray[n11++] & 0xFF) << 24;
                    }
                } else if (n == 5) {
                    int n12 = 0;
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = 0xFF000000 | (byArray[n12++] & 0xFF) << 16 | (byArray[n12++] & 0xFF) << 8 | byArray[n12++] & 0xFF;
                    }
                } else if (n == 7) {
                    int n13 = 0;
                    int n14 = 0;
                    while (n13 < n5) {
                        float f = 255.0f * (float)(byArray[n14 + 3] & 0xFF);
                        byte by = (byte)((float)(byArray[n14 + 2] & 0xFF) * f);
                        byte by4 = (byte)((float)(byArray[n14 + 1] & 0xFF) * f);
                        byte by5 = (byte)((float)(byArray[n14] & 0xFF) * f);
                        nArray[n13] = byArray[n14 + 3] & 0xFF000000 | (by5 & 0xFF) << 16 | (by4 & 0xFF) << 8 | by & 0xFF;
                        ++n13;
                        n14 += 4;
                    }
                } else if (n == 10) {
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray[i] & 0xFF) << 8 | byArray[i] & 0xFF;
                    }
                } else {
                    return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
                }
                return nArray;
            }
            case 1: {
                short[] sArray = (short[])object;
                if (n == 11) {
                    for (int i = 0; i < n5; ++i) {
                        int n15 = sArray[i] >> 8 & 0xFF;
                        nArray[i] = 0xFF000000 | n15 << 16 | n15 << 8 | n15;
                    }
                } else if (n == 8) {
                    for (int i = 0; i < n5; ++i) {
                        int n16 = sArray[i] >> 11 & 0x1F;
                        int n17 = sArray[i] >> 5 & 0x3F;
                        int n18 = sArray[i] & 0x1F;
                        nArray[i] = 0xFF000000 | n16 << 19 | n17 << 10 | n18 << 3;
                    }
                } else if (n == 9) {
                    for (int i = 0; i < n5; ++i) {
                        int n19 = sArray[i] >>> 10 & 0x1F;
                        int n20 = sArray[i] >>> 5 & 0x1F;
                        int n21 = sArray[i] & 0x1F;
                        nArray[i] = 0xFF000000 | n19 << 19 | n20 << 11 | n21 << 3;
                    }
                } else {
                    return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
                }
                return nArray;
            }
        }
        return bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
    }

    private void init_encoder(int n) {
        this.clearCode = 1 << n;
        this.endOfImage = this.clearCode + 1;
        this.codeLen = n + 1;
        this.codeIndex = this.endOfImage + 1;
        Arrays.fill(this.child, 0);
        Arrays.fill(this.siblings, 0);
        Arrays.fill(this.suffix, 0);
    }

    public void prepareForWrite(OutputStream outputStream, int n, int n2) throws Exception {
        this.writeHeader(outputStream, true);
        this.logicalScreenWidth = n;
        this.logicalScreenHeight = n2;
        this.animated = true;
    }

    private void send_code_to_buffer(int n, OutputStream outputStream) throws Exception {
        int n2 = this.codeLen;
        int n3 = this.bufIndex;
        this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | (n & MASK[this.empty_bits]) << 8 - this.empty_bits);
        n >>= this.empty_bits;
        n2 -= this.empty_bits;
        while (n2 > 0) {
            if (++this.bufIndex >= 255) {
                this.flush_buf(outputStream, 255);
            }
            int n4 = this.bufIndex;
            this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | n & 0xFF);
            n >>= 8;
            n2 -= 8;
        }
        this.empty_bits = -n2;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    private void write(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        this.writeHeader(outputStream, true);
        this.logicalScreenWidth = n;
        this.logicalScreenHeight = n2;
        this.firstFrame = true;
        this.animated = false;
        this.writeFrame(nArray, n, n2, 0, 0, 0, outputStream);
        outputStream.write(59);
        outputStream.close();
    }

    public void writeAnimatedGIF(BufferedImage[] bufferedImageArray, int[] nArray, OutputStream outputStream) throws Exception {
        this.writeHeader(outputStream, true);
        Dimension dimension = AnimatedGIFWriter.getLogicalScreenSize(bufferedImageArray);
        this.logicalScreenWidth = dimension.width;
        this.logicalScreenHeight = dimension.height;
        this.animated = true;
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            int n = bufferedImageArray[i].getWidth();
            int n2 = bufferedImageArray[i].getHeight();
            this.writeFrame(AnimatedGIFWriter.getRGB(bufferedImageArray[i]), n, n2, 0, 0, nArray[i], outputStream);
        }
        outputStream.write(59);
        outputStream.close();
    }

    public void writeAnimatedGIF(GIFFrame[] gIFFrameArray, OutputStream outputStream) throws Exception {
        this.writeHeader(outputStream, true);
        Dimension dimension = AnimatedGIFWriter.getLogicalScreenSize(gIFFrameArray);
        this.logicalScreenWidth = dimension.width;
        this.logicalScreenHeight = dimension.height;
        this.animated = true;
        for (int i = 0; i < gIFFrameArray.length; ++i) {
            int n = gIFFrameArray[i].getFrameWidth();
            int n2 = gIFFrameArray[i].getFrameHeight();
            int[] nArray = AnimatedGIFWriter.getRGB(gIFFrameArray[i].getFrame());
            if (gIFFrameArray[i].getTransparencyFlag() == 1 && gIFFrameArray[i].getTransparentColor() != -1) {
                int n3 = gIFFrameArray[i].getTransparentColor() & 0xFFFFFF;
                for (int j = nArray.length - 1; j > 0; --j) {
                    int n4 = nArray[j] & 0xFFFFFF;
                    if (n4 != n3) continue;
                    nArray[j] = n4;
                }
            }
            this.writeFrame(nArray, n, n2, gIFFrameArray[i].getLeftPosition(), gIFFrameArray[i].getTopPosition(), gIFFrameArray[i].getDelay(), gIFFrameArray[i].getDisposalMethod(), gIFFrameArray[i].getUserInputFlag(), outputStream);
        }
        outputStream.write(59);
        outputStream.close();
    }

    public void writeAnimatedGIF(List<GIFFrame> list, OutputStream outputStream) throws Exception {
        this.writeAnimatedGIF(list.toArray(new GIFFrame[0]), outputStream);
    }

    private void writeComment(OutputStream outputStream, String string) throws Exception {
        outputStream.write(33);
        outputStream.write(-2);
        byte[] byArray = string.getBytes();
        int n = byArray.length / 255;
        int n2 = byArray.length % 255;
        int n3 = 0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                outputStream.write(255);
                outputStream.write(byArray, n3, 255);
                n3 += 255;
            }
        }
        if (n2 > 0) {
            outputStream.write(n2);
            outputStream.write(byArray, n3, n2);
        }
        outputStream.write(0);
    }

    public void writeFrame(OutputStream outputStream, GIFFrame gIFFrame) throws Exception {
        BufferedImage bufferedImage = gIFFrame.getFrame();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = gIFFrame.getLeftPosition();
        int n4 = gIFFrame.getTopPosition();
        if (this.firstFrame) {
            if (this.logicalScreenWidth <= 0) {
                this.logicalScreenWidth = n;
            }
            if (this.logicalScreenHeight <= 0) {
                this.logicalScreenHeight = n2;
            }
        }
        if (n3 >= this.logicalScreenWidth || n4 >= this.logicalScreenHeight) {
            return;
        }
        if (n3 + n > this.logicalScreenWidth) {
            n = this.logicalScreenWidth - n3;
        }
        if (n4 + n2 > this.logicalScreenHeight) {
            n2 = this.logicalScreenHeight - n4;
        }
        int[] nArray = AnimatedGIFWriter.getRGB(bufferedImage.getSubimage(0, 0, n, n2));
        if (gIFFrame.getTransparencyFlag() == 1 && gIFFrame.getTransparentColor() != -1) {
            int n5 = gIFFrame.getTransparentColor() & 0xFFFFFF;
            for (int i = nArray.length - 1; i > 0; --i) {
                int n6 = nArray[i] & 0xFFFFFF;
                if (n6 != n5) continue;
                nArray[i] = n6;
            }
        }
        this.writeFrame(nArray, n, n2, gIFFrame.getLeftPosition(), gIFFrame.getTopPosition(), gIFFrame.getDelay(), gIFFrame.getDisposalMethod(), gIFFrame.getUserInputFlag(), outputStream);
    }

    public void writeFrame(OutputStream outputStream, BufferedImage bufferedImage) throws Exception {
        this.writeFrame(outputStream, bufferedImage, 100);
    }

    public void writeFrame(OutputStream outputStream, BufferedImage bufferedImage, int n) throws Exception {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (this.firstFrame) {
            if (this.logicalScreenWidth <= 0) {
                this.logicalScreenWidth = n2;
            }
            if (this.logicalScreenHeight <= 0) {
                this.logicalScreenHeight = n3;
            }
        }
        if (n <= 0) {
            n = 100;
        }
        if (n2 > this.logicalScreenWidth) {
            n2 = this.logicalScreenWidth;
        }
        if (n3 > this.logicalScreenHeight) {
            n3 = this.logicalScreenHeight;
        }
        this.writeFrame(AnimatedGIFWriter.getRGB(bufferedImage.getSubimage(0, 0, n2, n3)), n2, n3, 0, 0, n, outputStream);
    }

    private void writeFrame(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, OutputStream outputStream) throws Exception {
        this.empty_bits = 8;
        int n8 = -1;
        byte[] byArray = new byte[n * n2];
        this.colorPalette = new int[256];
        int[] nArray2 = AnimatedGIFWriter.checkColorDepth(nArray, byArray, this.colorPalette);
        if (nArray2[0] > 8) {
            this.bitsPerPixel = 8;
            nArray2 = this.isApplyDither ? AnimatedGIFWriter.reduceColorsDiffusionDither(nArray, n, n2, this.bitsPerPixel, byArray, this.colorPalette) : AnimatedGIFWriter.reduceColors(nArray, this.bitsPerPixel, byArray, this.colorPalette);
        }
        this.bitsPerPixel = nArray2[0];
        n8 = nArray2[1];
        int n9 = 1 << this.bitsPerPixel;
        if (this.firstFrame) {
            int n10 = -120;
            byte by = 0;
            byte by2 = 0;
            int n11 = 7;
            n10 = (byte)(n10 | (n11 << 4 | this.bitsPerPixel - 1));
            if (n8 >= 0) {
                by = (byte)n8;
            }
            this.writeLSD(outputStream, (short)this.logicalScreenWidth, (short)this.logicalScreenHeight, (short)n10, by, by2);
            this.writePalette(outputStream, n9);
            this.writeComment(outputStream, "Created by ICAFE - https://github.com/dragon66/icafe");
            if (this.animated) {
                this.writeNetscapeApplicationBlock(outputStream, this.loopCount);
            }
        }
        this.writeGraphicControlBlock(outputStream, n5, n8, n6, n7);
        if (this.firstFrame) {
            this.writeImageDescriptor(outputStream, n, n2, n3, n4, -1);
            this.firstFrame = false;
        } else {
            this.writeImageDescriptor(outputStream, n, n2, n3, n4, this.bitsPerPixel - 1);
            this.writePalette(outputStream, n9);
        }
        this.encode(byArray, outputStream);
        outputStream.write(0);
    }

    private void writeFrame(int[] nArray, int n, int n2, int n3, int n4, int n5, OutputStream outputStream) throws Exception {
        this.writeFrame(nArray, n, n2, n3, n4, n5, 2, 0, outputStream);
    }

    private void writeGraphicControlBlock(OutputStream outputStream, int n, int n2, int n3, int n4) throws Exception {
        byte[] byArray;
        n = Math.round((float)n / 10.0f);
        byArray = new byte[]{33, -7, 4, (byte)(byArray[3] | ((n3 & 7) << 2 | (n4 & 1) << 1)), (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)n2, 0};
        if (n2 >= 0) {
            byArray[3] = (byte)(byArray[3] | 1);
        }
        outputStream.write(byArray, 0, 8);
    }

    private void writeHeader(OutputStream outputStream, boolean bl) throws IOException {
        if (bl) {
            outputStream.write("GIF89a".getBytes());
        } else {
            outputStream.write("GIF87a".getBytes());
        }
    }

    private void writeImageDescriptor(OutputStream outputStream, int n, int n2, int n3, int n4, int n5) throws Exception {
        byte[] byArray = new byte[]{44, (byte)(n3 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n4 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), 32};
        if (n5 >= 0) {
            byArray[9] = (byte)(byArray[9] | (0x80 | n5));
        }
        outputStream.write(byArray, 0, 10);
    }

    private void writeLSD(OutputStream outputStream, short s, short s2, short s3, byte by, byte by2) throws IOException {
        byte[] byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF), (byte)(s2 & 0xFF), (byte)(s2 >> 8 & 0xFF), (byte)(s3 & 0xFF), by, by2};
        outputStream.write(byArray);
    }

    private void writeNetscapeApplicationBlock(OutputStream outputStream, int n) throws Exception {
        byte[] byArray = new byte[]{33, -1, 11, 78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48, 3, 1, (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), 0};
        outputStream.write(byArray);
    }

    private void writePalette(OutputStream outputStream, int n) throws Exception {
        int n2 = 0;
        byte[] byArray = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            byArray[n2++] = (byte)(this.colorPalette[i] >> 16 & 0xFF);
            byArray[n2++] = (byte)(this.colorPalette[i] >> 8 & 0xFF);
            byArray[n2++] = (byte)(this.colorPalette[i] & 0xFF);
        }
        outputStream.write(byArray, 0, n * 3);
    }

    private static int[] checkColorDepth(int[] nArray, byte[] byArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = -1;
        int n5 = -1;
        int[] nArray3 = new int[2];
        IntHashtable<Integer> intHashtable = new IntHashtable<Integer>(1023);
        for (int i = 0; i < nArray.length; ++i) {
            Integer n6;
            n2 = nArray[i] & 0xFFFFFF;
            if (nArray[i] >>> 24 < 128) {
                if (n4 < 0) {
                    n4 = n;
                    n5 = n2;
                }
                n2 = Integer.MAX_VALUE;
            }
            if ((n6 = (Integer)intHashtable.get(n2)) != null) {
                byArray[i] = n6.byteValue();
                continue;
            }
            if (n > 255) {
                nArray3[0] = 24;
                return nArray3;
            }
            intHashtable.put(n2, n);
            byArray[i] = (byte)n;
            nArray2[n++] = 0xFF000000 | n2;
        }
        if (n4 >= 0) {
            nArray2[n4] = n5;
        }
        while (1 << n3 < n) {
            ++n3;
        }
        nArray3[0] = n3;
        nArray3[1] = n4;
        return nArray3;
    }

    private static int[] reduceColorsDiffusionDither(int[] nArray, int n, int n2, int n3, byte[] byArray, int[] nArray2) {
        if (n3 > 8 || n3 < 1) {
            throw new IllegalArgumentException("Invalid color depth " + n3);
        }
        int[] nArray3 = new int[2];
        int n4 = 0;
        n4 = new WuQuant(nArray, 1 << n3).quantize(nArray2, nArray3);
        AnimatedGIFWriter.dither_FloydSteinberg(nArray, n, n2, byArray, n4, nArray2, nArray3[1]);
        return nArray3;
    }

    private static int[] reduceColors(int[] nArray, int n, byte[] byArray, int[] nArray2) {
        int[] nArray3 = new int[2];
        new WuQuant(nArray, 1 << n).quantize(byArray, nArray2, nArray3);
        return nArray3;
    }

    private static void dither_FloydSteinberg(int[] nArray, int n, int n2, byte[] byArray, int n3, int[] nArray2, int n4) {
        int n5 = 0;
        int n6 = 0;
        int[] nArray3 = new int[n + 2];
        int[] nArray4 = new int[n + 2];
        int[] nArray5 = new int[n + 2];
        int[] nArray6 = new int[n + 2];
        int[] nArray7 = new int[n + 2];
        int[] nArray8 = new int[n + 2];
        InverseColorMap inverseColorMap = new InverseColorMap();
        inverseColorMap.createInverseMap(n3, nArray2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (nArray[n6] >>> 24 < 128) {
                    byArray[n6] = (byte)n4;
                } else {
                    int n7 = ((nArray[n6] & 0xFF0000) >>> 16) + nArray3[j + 1];
                    if (n7 > 255) {
                        n7 = 255;
                    } else if (n7 < 0) {
                        n7 = 0;
                    }
                    int n8 = ((nArray[n6] & 0xFF00) >>> 8) + nArray4[j + 1];
                    if (n8 > 255) {
                        n8 = 255;
                    } else if (n8 < 0) {
                        n8 = 0;
                    }
                    int n9 = (nArray[n6] & 0xFF) + nArray5[j + 1];
                    if (n9 > 255) {
                        n9 = 255;
                    } else if (n9 < 0) {
                        n9 = 0;
                    }
                    n5 = inverseColorMap.getNearestColorIndex(n7, n8, n9);
                    byArray[n6] = (byte)n5;
                    int n10 = n7 - (nArray2[n5] >> 16 & 0xFF);
                    int n11 = n8 - (nArray2[n5] >> 8 & 0xFF);
                    int n12 = n9 - (nArray2[n5] & 0xFF);
                    int n13 = j + 2;
                    nArray3[n13] = nArray3[n13] + n10 * 7 / 16;
                    int n14 = j;
                    nArray6[n14] = nArray6[n14] + n10 * 3 / 16;
                    int n15 = j + 1;
                    nArray6[n15] = nArray6[n15] + n10 * 5 / 16;
                    int n16 = j + 2;
                    nArray6[n16] = nArray6[n16] + n10 / 16;
                    int n17 = j + 2;
                    nArray4[n17] = nArray4[n17] + n11 * 7 / 16;
                    int n18 = j;
                    nArray7[n18] = nArray7[n18] + n11 * 3 / 16;
                    int n19 = j + 1;
                    nArray7[n19] = nArray7[n19] + n11 * 5 / 16;
                    int n20 = j + 2;
                    nArray7[n20] = nArray7[n20] + n11 / 16;
                    int n21 = j + 2;
                    nArray5[n21] = nArray5[n21] + n12 * 7 / 16;
                    int n22 = j;
                    nArray8[n22] = nArray8[n22] + n12 * 3 / 16;
                    int n23 = j + 1;
                    nArray8[n23] = nArray8[n23] + n12 * 5 / 16;
                    int n24 = j + 2;
                    nArray8[n24] = nArray8[n24] + n12 / 16;
                }
                ++n6;
            }
            int[] nArray9 = nArray3;
            nArray3 = nArray6;
            nArray6 = nArray9;
            nArray9 = nArray4;
            nArray4 = nArray7;
            nArray7 = nArray9;
            nArray9 = nArray5;
            nArray5 = nArray8;
            nArray8 = nArray9;
            Arrays.fill(nArray6, 0);
            Arrays.fill(nArray7, 0);
            Arrays.fill(nArray8, 0);
        }
    }

    public static class GIFFrame {
        private BufferedImage frame;
        private int leftPosition;
        private int topPosition;
        private int frameWidth;
        private int frameHeight;
        private int delay;
        private int disposalMethod = 0;
        private int userInputFlag = 0;
        private int transparencyFlag = 0;
        private int transparentColor = -1;
        public static final int DISPOSAL_UNSPECIFIED = 0;
        public static final int DISPOSAL_LEAVE_AS_IS = 1;
        public static final int DISPOSAL_RESTORE_TO_BACKGROUND = 2;
        public static final int DISPOSAL_RESTORE_TO_PREVIOUS = 3;
        public static final int DISPOSAL_TO_BE_DEFINED = 7;
        public static final int USER_INPUT_NONE = 0;
        public static final int USER_INPUT_EXPECTED = 1;
        public static final int TRANSPARENCY_INDEX_NONE = 0;
        public static final int TRANSPARENCY_INDEX_SET = 1;
        public static final int TRANSPARENCY_COLOR_NONE = -1;

        public GIFFrame(BufferedImage bufferedImage) {
            this(bufferedImage, 0, 0, 0, 0);
        }

        public GIFFrame(BufferedImage bufferedImage, int n) {
            this(bufferedImage, 0, 0, n, 0);
        }

        public GIFFrame(BufferedImage bufferedImage, int n, int n2) {
            this(bufferedImage, 0, 0, n, n2);
        }

        public GIFFrame(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
            this(bufferedImage, n, n2, n3, n4, 0, 0, -1);
        }

        public GIFFrame(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            if (bufferedImage == null) {
                throw new IllegalArgumentException("Null input image");
            }
            if (n4 < 0 || n4 > 7) {
                throw new IllegalArgumentException("Invalid disposal method: " + n4);
            }
            if (n5 < 0 || n5 > 1) {
                throw new IllegalArgumentException("Invalid user input flag: " + n5);
            }
            if (n6 < 0 || n6 > 1) {
                throw new IllegalArgumentException("Invalid transparency flag: " + n6);
            }
            if (n < 0 || n2 < 0) {
                throw new IllegalArgumentException("Negative coordinates for frame top-left position");
            }
            if (n3 < 0) {
                n3 = 0;
            }
            this.frame = bufferedImage;
            this.leftPosition = n;
            this.topPosition = n2;
            this.delay = n3;
            this.disposalMethod = n4;
            this.userInputFlag = n5;
            this.transparencyFlag = n6;
            this.frameWidth = bufferedImage.getWidth();
            this.frameHeight = bufferedImage.getHeight();
            this.transparentColor = n7;
        }

        public int getDelay() {
            return this.delay;
        }

        public int getDisposalMethod() {
            return this.disposalMethod;
        }

        public BufferedImage getFrame() {
            return this.frame;
        }

        public int getFrameHeight() {
            return this.frameHeight;
        }

        public int getFrameWidth() {
            return this.frameWidth;
        }

        public int getLeftPosition() {
            return this.leftPosition;
        }

        public int getTopPosition() {
            return this.topPosition;
        }

        public int getTransparentColor() {
            return this.transparentColor;
        }

        public int getTransparencyFlag() {
            return this.transparencyFlag;
        }

        public int getUserInputFlag() {
            return this.userInputFlag;
        }
    }

    private static class IntHashtable<E> {
        private HashEntry<E>[] array;
        private int currentSize;

        public IntHashtable(int n) {
            this.array = new HashEntry[n];
            this.makeEmpty();
        }

        public void put(int n, E e) {
            int n2 = this.locate(n);
            if (this.isActive(n2)) {
                return;
            }
            this.array[n2] = new HashEntry<E>(n, e, true);
            if (++this.currentSize > this.array.length / 2) {
                this.rehash();
            }
        }

        private void rehash() {
            HashEntry<E>[] hashEntryArray = this.array;
            this.array = new HashEntry[IntHashtable.nextPrime(2 * hashEntryArray.length)];
            this.currentSize = 0;
            for (int i = 0; i < hashEntryArray.length; ++i) {
                if (hashEntryArray[i] == null || !hashEntryArray[i].isActive) continue;
                this.put(hashEntryArray[i].key, hashEntryArray[i].value);
            }
        }

        private int locate(int n) {
            int n2 = 0;
            int n3 = (n & Integer.MAX_VALUE) % this.array.length;
            while (this.array[n3] != null && this.array[n3].key != n) {
                if ((n3 += 2 * ++n2 - 1) < this.array.length) continue;
                n3 -= this.array.length;
            }
            return n3;
        }

        public E get(int n) {
            int n2 = this.locate(n);
            return this.isActive(n2) ? (E)this.array[n2].value : null;
        }

        private boolean isActive(int n) {
            return this.array[n] != null && this.array[n].isActive;
        }

        public void makeEmpty() {
            this.currentSize = 0;
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = null;
            }
        }

        private static int nextPrime(int n) {
            if (n % 2 == 0) {
                ++n;
            }
            while (!IntHashtable.isPrime(n)) {
                n += 2;
            }
            return n;
        }

        private static boolean isPrime(int n) {
            if (n == 2 || n == 3) {
                return true;
            }
            if (n == 1 || n % 2 == 0) {
                return false;
            }
            int n2 = 3;
            while (n2 * n2 <= n) {
                if (n % n2 == 0) {
                    return false;
                }
                n2 += 2;
            }
            return true;
        }

        private static class HashEntry<V> {
            int key;
            V value;
            boolean isActive;

            HashEntry(int n, V v) {
                this(n, v, true);
            }

            HashEntry(int n, V v, boolean bl) {
                this.key = n;
                this.value = v;
                this.isActive = bl;
            }
        }
    }

    private static class WuQuant {
        private static final int MAXCOLOR = 256;
        private static final int RED = 2;
        private static final int GREEN = 1;
        private static final int BLUE = 0;
        private static int QUANT_SIZE = 33;
        private int size;
        private int lut_size;
        private int[] qadd;
        private int[] pixels;
        private int transparent_color = -1;
        private float[][][] m2 = new float[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
        private long[][][] wt = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
        private long[][][] mr = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
        private long[][][] mg = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
        private long[][][] mb = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];

        public WuQuant(int[] nArray, int n) {
            this.pixels = nArray;
            this.size = nArray.length;
            this.lut_size = n;
        }

        public int quantize(byte[] byArray, int[] nArray, int[] nArray2) {
            int n;
            int n2;
            Box[] boxArray = new Box[256];
            int[] nArray3 = new int[QUANT_SIZE * QUANT_SIZE * QUANT_SIZE];
            float[] fArray = new float[256];
            this.Hist3d(this.wt, this.mr, this.mg, this.mb, this.m2);
            this.M3d(this.wt, this.mr, this.mg, this.mb, this.m2);
            for (n2 = 0; n2 < 256; ++n2) {
                boxArray[n2] = new Box();
            }
            boxArray[0].b0 = 0;
            boxArray[0].g0 = 0;
            boxArray[0].r0 = 0;
            boxArray[0].g1 = boxArray[0].b1 = QUANT_SIZE - 1;
            boxArray[0].r1 = boxArray[0].b1;
            int n3 = 0;
            if (this.transparent_color >= 0) {
                --this.lut_size;
            }
            for (n2 = 1; n2 < this.lut_size; ++n2) {
                if (this.Cut(boxArray[n3], boxArray[n2])) {
                    fArray[n3] = boxArray[n3].vol > 1 ? this.Var(boxArray[n3]) : 0.0f;
                    fArray[n2] = boxArray[n2].vol > 1 ? this.Var(boxArray[n2]) : 0.0f;
                } else {
                    fArray[n3] = 0.0f;
                    --n2;
                }
                n3 = 0;
                float f = fArray[0];
                for (n = 1; n <= n2; ++n) {
                    if (!(fArray[n] > f)) continue;
                    f = fArray[n];
                    n3 = n;
                }
                if (!(f <= 0.0f)) continue;
                n = n2 + 1;
                break;
            }
            for (n = 0; n < this.lut_size; ++n) {
                this.Mark(boxArray[n], n, nArray3);
                long l = this.Vol(boxArray[n], this.wt);
                if (l > 0L) {
                    int n4 = (int)(this.Vol(boxArray[n], this.mr) / l);
                    int n5 = (int)(this.Vol(boxArray[n], this.mg) / l);
                    int n6 = (int)(this.Vol(boxArray[n], this.mb) / l);
                    nArray[n] = 0xFF000000 | n4 << 16 | n5 << 8 | n6;
                    continue;
                }
                nArray[n] = 0;
            }
            for (n2 = 0; n2 < this.size; ++n2) {
                byArray[n2] = this.pixels[n2] >>> 24 < 128 ? (byte)this.lut_size : (byte)nArray3[this.qadd[n2]];
            }
            int n7 = 0;
            while (1 << n7 < this.lut_size) {
                ++n7;
            }
            nArray2[0] = n7;
            nArray2[1] = -1;
            if (this.transparent_color >= 0) {
                nArray[this.lut_size] = this.transparent_color;
                nArray2[1] = this.lut_size;
            }
            return this.lut_size;
        }

        public int quantize(int[] nArray, int[] nArray2) {
            int n;
            int n2;
            Box[] boxArray = new Box[256];
            float[] fArray = new float[256];
            this.Hist3d(this.wt, this.mr, this.mg, this.mb, this.m2);
            this.M3d(this.wt, this.mr, this.mg, this.mb, this.m2);
            for (n2 = 0; n2 < 256; ++n2) {
                boxArray[n2] = new Box();
            }
            boxArray[0].b0 = 0;
            boxArray[0].g0 = 0;
            boxArray[0].r0 = 0;
            boxArray[0].g1 = boxArray[0].b1 = QUANT_SIZE - 1;
            boxArray[0].r1 = boxArray[0].b1;
            int n3 = 0;
            if (this.transparent_color >= 0) {
                --this.lut_size;
            }
            for (n2 = 1; n2 < this.lut_size; ++n2) {
                if (this.Cut(boxArray[n3], boxArray[n2])) {
                    fArray[n3] = boxArray[n3].vol > 1 ? this.Var(boxArray[n3]) : 0.0f;
                    fArray[n2] = boxArray[n2].vol > 1 ? this.Var(boxArray[n2]) : 0.0f;
                } else {
                    fArray[n3] = 0.0f;
                    --n2;
                }
                n3 = 0;
                float f = fArray[0];
                for (n = 1; n <= n2; ++n) {
                    if (!(fArray[n] > f)) continue;
                    f = fArray[n];
                    n3 = n;
                }
                if (!(f <= 0.0f)) continue;
                n = n2 + 1;
                break;
            }
            for (n = 0; n < this.lut_size; ++n) {
                long l = this.Vol(boxArray[n], this.wt);
                if (l > 0L) {
                    int n4 = (int)(this.Vol(boxArray[n], this.mr) / l);
                    int n5 = (int)(this.Vol(boxArray[n], this.mg) / l);
                    int n6 = (int)(this.Vol(boxArray[n], this.mb) / l);
                    nArray[n] = 0xFF000000 | n4 << 16 | n5 << 8 | n6;
                    continue;
                }
                nArray[n] = 0;
            }
            int n7 = 0;
            while (1 << n7 < this.lut_size) {
                ++n7;
            }
            nArray2[0] = n7;
            nArray2[1] = -1;
            if (this.transparent_color >= 0) {
                nArray[this.lut_size] = this.transparent_color;
                nArray2[1] = this.lut_size;
            }
            return this.lut_size;
        }

        private void Hist3d(long[][][] lArray, long[][][] lArray2, long[][][] lArray3, long[][][] lArray4, float[][][] fArray) {
            int n;
            int[] nArray = new int[256];
            for (n = 0; n < 256; ++n) {
                nArray[n] = n * n;
            }
            this.qadd = new int[this.size];
            for (n = 0; n < this.size; ++n) {
                int n2 = this.pixels[n];
                if (n2 >>> 24 < 128 && this.transparent_color < 0) {
                    this.transparent_color = n2;
                }
                int n3 = n2 >> 16 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 & 0xFF;
                int n6 = (n3 >> 3) + 1;
                int n7 = (n4 >> 3) + 1;
                int n8 = (n5 >> 3) + 1;
                this.qadd[n] = (n6 << 10) + (n6 << 6) + n6 + (n7 << 5) + n7 + n8;
                long[] lArray5 = lArray[n6][n7];
                int n9 = n8;
                lArray5[n9] = lArray5[n9] + 1L;
                long[] lArray6 = lArray2[n6][n7];
                int n10 = n8;
                lArray6[n10] = lArray6[n10] + (long)n3;
                long[] lArray7 = lArray3[n6][n7];
                int n11 = n8;
                lArray7[n11] = lArray7[n11] + (long)n4;
                long[] lArray8 = lArray4[n6][n7];
                int n12 = n8;
                lArray8[n12] = lArray8[n12] + (long)n5;
                float[] fArray2 = fArray[n6][n7];
                int n13 = n8;
                fArray2[n13] = fArray2[n13] + (float)(nArray[n3] + nArray[n4] + nArray[n5]);
            }
        }

        private void M3d(long[][][] lArray, long[][][] lArray2, long[][][] lArray3, long[][][] lArray4, float[][][] fArray) {
            int[] nArray = new int[QUANT_SIZE];
            int[] nArray2 = new int[QUANT_SIZE];
            int[] nArray3 = new int[QUANT_SIZE];
            int[] nArray4 = new int[QUANT_SIZE];
            float[] fArray2 = new float[QUANT_SIZE];
            for (int i = 1; i < QUANT_SIZE; ++i) {
                for (int j = 0; j < QUANT_SIZE; ++j) {
                    nArray4[j] = 0;
                    nArray3[j] = 0;
                    nArray2[j] = 0;
                    nArray[j] = 0;
                    fArray2[j] = 0;
                }
                for (int j = 1; j < QUANT_SIZE; ++j) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    float f = 0;
                    for (int k = 1; k < QUANT_SIZE; ++k) {
                        n4 = (int)((long)n4 + lArray[i][j][k]);
                        n3 = (int)((long)n3 + lArray2[i][j][k]);
                        n2 = (int)((long)n2 + lArray3[i][j][k]);
                        n = (int)((long)n + lArray4[i][j][k]);
                        f += fArray[i][j][k];
                        int n5 = k;
                        nArray[n5] = nArray[n5] + n4;
                        int n6 = k;
                        nArray2[n6] = nArray2[n6] + n3;
                        int n7 = k;
                        nArray3[n7] = nArray3[n7] + n2;
                        int n8 = k;
                        nArray4[n8] = nArray4[n8] + n;
                        int n9 = k;
                        fArray2[n9] = fArray2[n9] + f;
                        lArray[i][j][k] = lArray[i - 1][j][k] + (long)nArray[k];
                        lArray2[i][j][k] = lArray2[i - 1][j][k] + (long)nArray2[k];
                        lArray3[i][j][k] = lArray3[i - 1][j][k] + (long)nArray3[k];
                        lArray4[i][j][k] = lArray4[i - 1][j][k] + (long)nArray4[k];
                        fArray[i][j][k] = fArray[i - 1][j][k] + fArray2[k];
                    }
                }
            }
        }

        private long Vol(Box box, long[][][] lArray) {
            return lArray[box.r1][box.g1][box.b1] - lArray[box.r1][box.g1][box.b0] - lArray[box.r1][box.g0][box.b1] + lArray[box.r1][box.g0][box.b0] - lArray[box.r0][box.g1][box.b1] + lArray[box.r0][box.g1][box.b0] + lArray[box.r0][box.g0][box.b1] - lArray[box.r0][box.g0][box.b0];
        }

        private long Bottom(Box box, int n, long[][][] lArray) {
            switch (n) {
                case 2: {
                    return -lArray[box.r0][box.g1][box.b1] + lArray[box.r0][box.g1][box.b0] + lArray[box.r0][box.g0][box.b1] - lArray[box.r0][box.g0][box.b0];
                }
                case 1: {
                    return -lArray[box.r1][box.g0][box.b1] + lArray[box.r1][box.g0][box.b0] + lArray[box.r0][box.g0][box.b1] - lArray[box.r0][box.g0][box.b0];
                }
                case 0: {
                    return -lArray[box.r1][box.g1][box.b0] + lArray[box.r1][box.g0][box.b0] + lArray[box.r0][box.g1][box.b0] - lArray[box.r0][box.g0][box.b0];
                }
            }
            return 0L;
        }

        private long Top(Box box, int n, int n2, long[][][] lArray) {
            switch (n) {
                case 2: {
                    return lArray[n2][box.g1][box.b1] - lArray[n2][box.g1][box.b0] - lArray[n2][box.g0][box.b1] + lArray[n2][box.g0][box.b0];
                }
                case 1: {
                    return lArray[box.r1][n2][box.b1] - lArray[box.r1][n2][box.b0] - lArray[box.r0][n2][box.b1] + lArray[box.r0][n2][box.b0];
                }
                case 0: {
                    return lArray[box.r1][box.g1][n2] - lArray[box.r1][box.g0][n2] - lArray[box.r0][box.g1][n2] + lArray[box.r0][box.g0][n2];
                }
            }
            return 0L;
        }

        private float Var(Box box) {
            float f = this.Vol(box, this.mr);
            float f2 = this.Vol(box, this.mg);
            float f3 = this.Vol(box, this.mb);
            float f4 = this.m2[box.r1][box.g1][box.b1] - this.m2[box.r1][box.g1][box.b0] - this.m2[box.r1][box.g0][box.b1] + this.m2[box.r1][box.g0][box.b0] - this.m2[box.r0][box.g1][box.b1] + this.m2[box.r0][box.g1][box.b0] + this.m2[box.r0][box.g0][box.b1] - this.m2[box.r0][box.g0][box.b0];
            return f4 - (f * f + f2 * f2 + f3 * f3) / (float)this.Vol(box, this.wt);
        }

        private float Maximize(Box box, int n, int n2, int n3, int[] nArray, long l, long l2, long l3, long l4) {
            long l5 = this.Bottom(box, n, this.mr);
            long l6 = this.Bottom(box, n, this.mg);
            long l7 = this.Bottom(box, n, this.mb);
            long l8 = this.Bottom(box, n, this.wt);
            float f = 0.0f;
            nArray[0] = -1;
            for (int i = n2; i < n3; ++i) {
                long l9 = l5 + this.Top(box, n, i, this.mr);
                long l10 = l6 + this.Top(box, n, i, this.mg);
                long l11 = l7 + this.Top(box, n, i, this.mb);
                long l12 = l8 + this.Top(box, n, i, this.wt);
                if (l12 == 0L) continue;
                float f2 = (float)(l9 * l9 + l10 * l10 + l11 * l11) / (float)l12;
                l9 = l - l9;
                l10 = l2 - l10;
                l11 = l3 - l11;
                if ((l12 = l4 - l12) == 0L || !((f2 += (float)(l9 * l9 + l10 * l10 + l11 * l11) / (float)l12) > f)) continue;
                f = f2;
                nArray[0] = i;
            }
            return f;
        }

        private boolean Cut(Box box, Box box2) {
            int n;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            long l = this.Vol(box, this.mr);
            long l2 = this.Vol(box, this.mg);
            long l3 = this.Vol(box, this.mb);
            long l4 = this.Vol(box, this.wt);
            float f = this.Maximize(box, 2, box.r0 + 1, box.r1, nArray, l, l2, l3, l4);
            float f2 = this.Maximize(box, 1, box.g0 + 1, box.g1, nArray2, l, l2, l3, l4);
            float f3 = this.Maximize(box, 0, box.b0 + 1, box.b1, nArray3, l, l2, l3, l4);
            if (f >= f2 && f >= f3) {
                n = 2;
                if (nArray[0] < 0) {
                    return false;
                }
            } else {
                n = f2 >= f && f2 >= f3 ? 1 : 0;
            }
            box2.r1 = box.r1;
            box2.g1 = box.g1;
            box2.b1 = box.b1;
            switch (n) {
                case 2: {
                    box2.r0 = box.r1 = nArray[0];
                    box2.g0 = box.g0;
                    box2.b0 = box.b0;
                    break;
                }
                case 1: {
                    box2.g0 = box.g1 = nArray2[0];
                    box2.r0 = box.r0;
                    box2.b0 = box.b0;
                    break;
                }
                case 0: {
                    box2.b0 = box.b1 = nArray3[0];
                    box2.r0 = box.r0;
                    box2.g0 = box.g0;
                }
            }
            box.vol = (box.r1 - box.r0) * (box.g1 - box.g0) * (box.b1 - box.b0);
            box2.vol = (box2.r1 - box2.r0) * (box2.g1 - box2.g0) * (box2.b1 - box2.b0);
            return true;
        }

        private void Mark(Box box, int n, int[] nArray) {
            for (int i = box.r0 + 1; i <= box.r1; ++i) {
                for (int j = box.g0 + 1; j <= box.g1; ++j) {
                    for (int k = box.b0 + 1; k <= box.b1; ++k) {
                        nArray[(i << 10) + (i << 6) + i + (j << 5) + j + k] = n;
                    }
                }
            }
        }

        private static final class Box {
            int r0;
            int r1;
            int g0;
            int g1;
            int b0;
            int b1;
            int vol;

            private Box() {
            }
        }
    }

    private static class InverseColorMap {
        private int bitsReserved;
        private int bitsDiscarded;
        private int maxColorVal;
        private int invMapLen;
        private byte[] invColorMap;

        public InverseColorMap() {
            this(5);
        }

        public InverseColorMap(int n) {
            this.bitsReserved = n;
            this.bitsDiscarded = 8 - this.bitsReserved;
            this.maxColorVal = 1 << this.bitsReserved;
            this.invMapLen = this.maxColorVal * this.maxColorVal * this.maxColorVal;
            this.invColorMap = new byte[this.invMapLen];
        }

        public int getNearestColorIndex(int n, int n2, int n3) {
            return this.invColorMap[n >> this.bitsDiscarded << (this.bitsReserved << 1) | n2 >> this.bitsDiscarded << this.bitsReserved | n3 >> this.bitsDiscarded] & 0xFF;
        }

        public void createInverseMap(int n, int[] nArray) {
            int n2 = 1 << this.bitsDiscarded;
            int n3 = 1 << this.bitsDiscarded + this.bitsDiscarded;
            int n4 = n3 + n3;
            int[] nArray2 = new int[this.invMapLen];
            int n5 = this.invMapLen;
            while (--n5 >= 0) {
                nArray2[n5] = Integer.MAX_VALUE;
            }
            for (n5 = 0; n5 < n; ++n5) {
                int n6 = nArray[n5] >> 16 & 0xFF;
                int n7 = nArray[n5] >> 8 & 0xFF;
                int n8 = nArray[n5] & 0xFF;
                int n9 = (n2 >> 1) - n6;
                int n10 = (n2 >> 1) - n7;
                int n11 = (n2 >> 1) - n8;
                int n12 = n9 * n9 + n10 * n10 + n11 * n11;
                int n13 = n4 - (n6 << this.bitsDiscarded + 1);
                int n14 = n4 - (n7 << this.bitsDiscarded + 1);
                int n15 = n4 - (n8 << this.bitsDiscarded + 1);
                int n16 = 0;
                n9 = n12;
                for (int i = 0; i < this.maxColorVal; ++i) {
                    n10 = n9;
                    for (int j = 0; j < this.maxColorVal; ++j) {
                        n11 = n10;
                        for (int k = 0; k < this.maxColorVal; ++k) {
                            if (n11 < nArray2[n16]) {
                                nArray2[n16] = n11;
                                this.invColorMap[n16] = (byte)n5;
                            }
                            n11 += n15;
                            n15 += n4;
                            ++n16;
                        }
                        n10 += n14;
                        n14 += n4;
                    }
                    n9 += n13;
                    n13 += n4;
                }
            }
        }
    }
}

