/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.misc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import ucesoft.cbm.misc.RS232StatusPanel;
import ucesoft.cbm.peripheral.rs232.BridgeRS232$;
import ucesoft.cbm.peripheral.rs232.RS232;

public final class RS232ConfigPanel$ {
    public static final RS232ConfigPanel$ MODULE$ = new RS232ConfigPanel$();
    private static RS232[] AVAILABLE_RS232;
    private static Option<RS232> activeRs232;
    private static JDialog configPanel;
    private static Option<RS232> selectingRs232;
    private static final JLabel ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel;
    private static final RS232StatusPanel RS232StatusPanel;

    static {
        activeRs232 = None$.MODULE$;
        selectingRs232 = None$.MODULE$;
        ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel = new JLabel();
        RS232StatusPanel = new RS232StatusPanel(){

            public void connectedTo(String address) {
                super.connectedTo(address);
                RS232ConfigPanel$.MODULE$.ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel().setText(address);
            }

            public void disconnected() {
                super.disconnected();
                RS232ConfigPanel$.MODULE$.ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel().setText("");
            }
        };
    }

    private RS232[] AVAILABLE_RS232() {
        return AVAILABLE_RS232;
    }

    private void AVAILABLE_RS232_$eq(RS232[] x$1) {
        AVAILABLE_RS232 = x$1;
    }

    private Option<RS232> activeRs232() {
        return activeRs232;
    }

    private void activeRs232_$eq(Option<RS232> x$1) {
        activeRs232 = x$1;
    }

    private JDialog configPanel() {
        return configPanel;
    }

    private void configPanel_$eq(JDialog x$1) {
        configPanel = x$1;
    }

    private Option<RS232> selectingRs232() {
        return selectingRs232;
    }

    private void selectingRs232_$eq(Option<RS232> x$1) {
        selectingRs232 = x$1;
    }

    public JLabel ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel() {
        return ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel;
    }

    private RS232StatusPanel RS232StatusPanel() {
        return RS232StatusPanel;
    }

    public JDialog RS232ConfigDialog() {
        return this.configPanel();
    }

    public void registerAvailableRS232Drivers(JFrame parent, RS232[] rs232Drivers) {
        this.AVAILABLE_RS232_$eq(rs232Drivers);
        this.configPanel_$eq(this.initConfigPanel(parent));
        BridgeRS232$.MODULE$.setRS232Listener(this.RS232StatusPanel());
    }

    private JDialog initConfigPanel(JFrame parent) {
        JDialog dialog = new JDialog((Frame)parent, "RS232 Configuration panel");
        dialog.setIconImage(new ImageIcon(this.getClass().getResource("/resources/commodore.png")).getImage());
        Container pane = dialog.getContentPane();
        ButtonGroup group = new ButtonGroup();
        JTextField conf = new JTextField(30);
        JButton applyButton = new JButton("Apply");
        conf.addActionListener(x$3 -> MODULE$.applySelected(dialog, conf.getText()));
        applyButton.addActionListener(x$4 -> MODULE$.applySelected(dialog, conf.getText()));
        conf.setEnabled(false);
        JRadioButton[] radios = (JRadioButton[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.AVAILABLE_RS232()), (Function1 & Serializable)r -> {
            JRadioButton radio = new JRadioButton(r.toString());
            group.add(radio);
            radio.addActionListener(x$5 -> {
                if (radio.isSelected()) {
                    MODULE$.selectingRs232_$eq((Option<RS232>)new Some(r));
                    conf.setToolTipText(r.getDescription());
                    conf.setEnabled(true);
                    return;
                }
            });
            radio.setAlignmentX(0.0f);
            return radio;
        }, ClassTag$.MODULE$.apply(JRadioButton.class));
        JPanel radioPanel = new JPanel();
        radioPanel.setBorder(BorderFactory.createTitledBorder("RS-232 drivers"));
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        JRadioButton noneRadio = new JRadioButton("None");
        noneRadio.setSelected(true);
        group.add(noneRadio);
        noneRadio.addActionListener(x$6 -> {
            conf.setToolTipText("");
            conf.setEnabled(false);
            MODULE$.selectingRs232_$eq((Option<RS232>)None$.MODULE$);
        });
        radioPanel.add(noneRadio);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])radios), (Function1 & Serializable)r -> radioPanel.add((Component)r));
        JPanel confPanel = new JPanel();
        confPanel.add(new JLabel("Connection string:"));
        confPanel.add(conf);
        confPanel.add(applyButton);
        JPanel connPanel = new JPanel(new FlowLayout(0));
        this.ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel().setForeground(Color.BLUE);
        connPanel.add(new JLabel("Connected to:"));
        connPanel.add(this.ucesoft$cbm$misc$RS232ConfigPanel$$connectedToLabel());
        connPanel.setAlignmentX(0.0f);
        confPanel.setAlignmentX(0.0f);
        radioPanel.add(confPanel);
        radioPanel.add(connPanel);
        pane.add("Center", radioPanel);
        pane.add("South", this.RS232StatusPanel());
        this.RS232StatusPanel().setVisible(true);
        JPanel handshakePanel = new JPanel(new FlowLayout(0));
        handshakePanel.setBorder(BorderFactory.createTitledBorder("RS-232 handshacking"));
        JCheckBox hscb = new JCheckBox("RS-232 flow control enabled");
        hscb.addActionListener(x$7 -> BridgeRS232$.MODULE$.setFlowControlEnabled(hscb.isSelected()));
        handshakePanel.add(hscb);
        pane.add("North", handshakePanel);
        dialog.pack();
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(1);
        return dialog;
    }

    private void applySelected(JDialog parent, String conf) {
        Option<RS232> option = this.selectingRs232();
        if (None$.MODULE$.equals(option)) {
            Option<RS232> option2 = this.activeRs232();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                RS232 ars232 = (RS232)some.value();
                ars232.setEnabled(false);
                this.activeRs232_$eq((Option<RS232>)None$.MODULE$);
                BridgeRS232$.MODULE$.unsetRS232();
                JOptionPane.showMessageDialog(parent, "RS-232 disabled", "RS-232 configuration", 1);
            } else if (None$.MODULE$.equals(option2)) {
            } else {
                throw new MatchError(option2);
            }
            return;
        }
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            RS232 ars232 = (RS232)some.value();
            try {
                ars232.setConfiguration(conf);
                this.activeRs232().foreach((Function1 & Serializable)x$8 -> {
                    x$8.setEnabled(false);
                    return BoxedUnit.UNIT;
                });
                this.activeRs232_$eq((Option<RS232>)new Some((Object)ars232));
                BridgeRS232$.MODULE$.setRS232(ars232);
                BridgeRS232$.MODULE$.setEnabled(true);
                JOptionPane.showMessageDialog(parent, "RS-232 enabled with new configuration", "RS-232 configuration", 1);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(parent, t.toString(), "RS-232 configuration error", 0);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private RS232ConfigPanel$() {
    }
}

