/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.cia;

import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import ucesoft.cbm.peripheral.Connector;
import ucesoft.cbm.peripheral.controlport.ControlPort;
import ucesoft.cbm.peripheral.keyboard.HomeKeyboard;

@ScalaSignature(bytes="\u0006\u00051<Q!\u0006\f\t\u0002}1Q!\t\f\t\u0002\tBQ!K\u0001\u0005\u0002)2AaK\u0001\u0001Y!A\u0011g\u0001B\u0001B\u0003%!\u0007\u0003\u00059\u0007\t\u0005\t\u0015!\u0003:\u0011\u0015I3\u0001\"\u0001@\u0011\u001d!5A1A\u0005\u0002\u0015CaAT\u0002!\u0002\u00131\u0005\"B(\u0004\t\u000b\u0001\u0006\"\u0002+\u0004\t+)f\u0001B.\u0002\u0001qC\u0001\"M\u0006\u0003\u0002\u0003\u0006IA\r\u0005\tq-\u0011\t\u0011)A\u0005s!AQl\u0003B\u0001B\u0003%a\fC\u0003*\u0017\u0011\u0005\u0011\rC\u0004E\u0017\t\u0007I\u0011A#\t\r9[\u0001\u0015!\u0003G\u0011\u001917\u0002)Q\u0005O\")qj\u0003C\u0003!\")Ak\u0003C\u000bU\u0006q1)S!2\u0007>tg.Z2u_J\u001c(BA\f\u0019\u0003\r\u0019\u0017.\u0019\u0006\u00033i\t!\u0002]3sSBDWM]1m\u0015\tYB$A\u0002dE6T\u0011!H\u0001\bk\u000e,7o\u001c4u\u0007\u0001\u0001\"\u0001I\u0001\u000e\u0003Y\u0011abQ%Bc\r{gN\\3di>\u00148o\u0005\u0002\u0002GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0010\u0003\u001dA{'\u000f^!D_:tWm\u0019;peN\u00111!\f\t\u0003]=j\u0011\u0001G\u0005\u0003aa\u0011\u0011bQ8o]\u0016\u001cGo\u001c:\u0002\u0005-\u0014\u0007CA\u001a7\u001b\u0005!$BA\u001b\u0019\u0003!YW-\u001f2pCJ$\u0017BA\u001c5\u00051Au.\\3LKf\u0014w.\u0019:e\u0003!\u0019GO\u001d7Q_J$\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0019\u0003-\u0019wN\u001c;s_2\u0004xN\u001d;\n\u0005yZ$aC\"p]R\u0014x\u000e\u001c)peR$2\u0001\u0011\"D!\t\t5!D\u0001\u0002\u0011\u0015\td\u00011\u00013\u0011\u0015Ad\u00011\u0001:\u0003-\u0019w.\u001c9p]\u0016tG/\u0013#\u0016\u0003\u0019\u0003\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\t1\fgn\u001a\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\ti\u0005J\u0001\u0004TiJLgnZ\u0001\rG>l\u0007o\u001c8f]RLE\tI\u0001\u0005e\u0016\fG-F\u0001R!\t!#+\u0003\u0002TK\t\u0019\u0011J\u001c;\u0002\u0019A,'OZ8s[^\u0013\u0018\u000e^3\u0015\u0005YK\u0006C\u0001\u0013X\u0013\tAVE\u0001\u0003V]&$\b\"\u0002.\u000b\u0001\u0004\t\u0016\u0001\u00023bi\u0006\u0014a\u0002U8si\n\u001buN\u001c8fGR|'o\u0005\u0002\f[\u00051B.[4iiB+g\u000e\u0016:jO\u001e,'\u000fS1oI2,'\u000fE\u0002%?ZK!\u0001Y\u0013\u0003\u0013\u0019+hn\u0019;j_:\u0004D\u0003\u00022dI\u0016\u0004\"!Q\u0006\t\u000bEz\u0001\u0019\u0001\u001a\t\u000baz\u0001\u0019A\u001d\t\u000bu{\u0001\u0019\u00010\u0002\u00111\f7\u000f\u001e'Q\u001f:\u0004\"\u0001\n5\n\u0005%,#a\u0002\"p_2,\u0017M\u001c\u000b\u0003-.DQA\u0017\u000bA\u0002E\u0003")
public final class CIA1Connectors {

    public static class PortAConnector
    extends Connector {
        private final HomeKeyboard kb;
        private final ControlPort ctrlPort;
        private final String componentID;

        @Override
        public String componentID() {
            return this.componentID;
        }

        @Override
        public final int read() {
            int port = this.ctrlPort.readPort();
            return this.kb.readRow() & (this.latch() | ~this.ddr()) & port;
        }

        @Override
        public final void performWrite(int data) {
            int port = this.ctrlPort.readPort();
            this.kb.selectRow((data | ~this.ddr()) & port & 0xFF);
        }

        public PortAConnector(HomeKeyboard kb, ControlPort ctrlPort) {
            this.kb = kb;
            this.ctrlPort = ctrlPort;
            this.componentID = "CIA1 Port A Connector";
        }
    }

    public static class PortBConnector
    extends Connector {
        private final HomeKeyboard kb;
        private final ControlPort ctrlPort;
        private final Function0<BoxedUnit> lightPenTriggerHandler;
        private final String componentID;
        private boolean lastLPOn;

        @Override
        public String componentID() {
            return this.componentID;
        }

        @Override
        public final int read() {
            int port = this.ctrlPort.readPort();
            int reg = this.kb.readCol() & (this.latch() | ~this.ddr()) & port;
            return reg;
        }

        @Override
        public final void performWrite(int data) {
            boolean lpPressed;
            int port = this.ctrlPort.readPort();
            boolean bl = lpPressed = (data & this.ddr() & 0x10) > 0;
            if (this.lastLPOn && !lpPressed) {
                this.lightPenTriggerHandler.apply$mcV$sp();
            }
            this.lastLPOn = lpPressed;
            this.kb.selectCol((data | ~this.ddr()) & port & 0xFF);
        }

        public PortBConnector(HomeKeyboard kb, ControlPort ctrlPort, Function0<BoxedUnit> lightPenTriggerHandler) {
            this.kb = kb;
            this.ctrlPort = ctrlPort;
            this.lightPenTriggerHandler = lightPenTriggerHandler;
            this.componentID = "CIA1 Port B Connector";
            this.lastLPOn = false;
        }
    }
}

