/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.drive;

import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import ucesoft.cbm.CBMComponent;
import ucesoft.cbm.ClockEvent;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.formats.Diskette;
import ucesoft.cbm.peripheral.bus.BusDataIterator;
import ucesoft.cbm.peripheral.bus.IECBus;
import ucesoft.cbm.peripheral.bus.IECBusDevice;
import ucesoft.cbm.peripheral.drive.C1541Emu$;
import ucesoft.cbm.peripheral.drive.C1541Emu$Job$;
import ucesoft.cbm.peripheral.drive.Drive;
import ucesoft.cbm.peripheral.drive.DriveLedListener;
import ucesoft.cbm.peripheral.drive.DriveType$;
import ucesoft.cbm.peripheral.drive.EmptyFloppy$;
import ucesoft.cbm.peripheral.drive.Floppy;

@ScalaSignature(bytes="\u0006\u0005\tUx!B+W\u0011\u0003yf!B1W\u0011\u0003\u0011\u0007\"B5\u0002\t\u0003Q\u0007bB6\u0002\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0006\u0001\u000b\u0011B7\t\u000fE\f!\u0019!C\u0005e\"1a/\u0001Q\u0001\nM<Qa^\u0001\t\na4QA_\u0001\t\nmDQ!\u001b\u0005\u0005\u0002}D\u0011\"!\u0001\t\u0005\u0004%\t!a\u0001\t\u0011\u00055\u0001\u0002)A\u0005\u0003\u000bA\u0011\"a\u0004\t\u0005\u0004%\t!a\u0001\t\u0011\u0005E\u0001\u0002)A\u0005\u0003\u000bA\u0011\"a\u0005\t\u0005\u0004%\t!a\u0001\t\u0011\u0005U\u0001\u0002)A\u0005\u0003\u000bA\u0011\"a\u0006\t\u0005\u0004%\t!a\u0001\t\u0011\u0005e\u0001\u0002)A\u0005\u0003\u000bA\u0011\"a\u0007\t\u0005\u0004%\t!a\u0001\t\u0011\u0005u\u0001\u0002)A\u0005\u0003\u000bA\u0011\"a\b\t\u0003\u0003%I!!\t\t\u0011\u0005M\u0012A1A\u0005\n1Dq!!\u000e\u0002A\u0003%Q\u000e\u0003\u0005\u00028\u0005\u0011\r\u0011\"\u0003m\u0011\u001d\tI$\u0001Q\u0001\n5D\u0001\"a\u000f\u0002\u0005\u0004%I\u0001\u001c\u0005\b\u0003{\t\u0001\u0015!\u0003n\u0011!\ty$\u0001b\u0001\n\u0013a\u0007bBA!\u0003\u0001\u0006I!\u001c\u0005\t\u0003\u0007\n!\u0019!C\u0005Y\"9\u0011QI\u0001!\u0002\u0013i\u0007\u0002CA$\u0003\t\u0007I\u0011\u00027\t\u000f\u0005%\u0013\u0001)A\u0005[\"I\u00111J\u0001C\u0002\u0013%\u0011Q\n\u0005\t\u0003K\n\u0001\u0015!\u0003\u0002P!I\u0011qM\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0004\u0006CZ\u0003\u0011q\u0010\u0005\u000b\u0003\u000f##\u0011!Q\u0001\n\u0005M\u0005BCAMI\t\u0005\t\u0015!\u0003\u0002\u001c\"I\u0011\u0011\u0015\u0013\u0003\u0002\u0003\u0006I!\u001c\u0005\u0007S\u0012\"\t!a)\t\u0013\u00055FE1A\u0005\u0002\u0005=\u0006\u0002CA]I\u0001\u0006I!!-\t\u0013\u0005mFE1A\u0005\u0002\u0005u\u0006\u0002CA`I\u0001\u0006I!a\u0018\t\u0013\u0005\u0005GE1A\u0005\u0002\u0005\r\u0007\u0002CAvI\u0001\u0006I!!2\t\u0013\u00055HE1A\u0005B\u0005=\b\u0002CAyI\u0001\u0006I!!8\t\u0011\u0005MH\u0005)Q\u0005\u0003kD\u0001Ba\u0002%A\u0003&!\u0011\u0002\u0005\b\u0005\u001f!\u0003\u0015)\u0003n\u0011!\u0011\t\u0002\nQ!\n\tM\u0001B\u0002B\rI\u0011E#\u000fC\u0004\u0003\u001c\u0011\"\tF!\b\t\u000f\t-B\u0005\"\u0011\u0003.!9!1\b\u0013\u0005\u0002\tu\u0002b\u0002B#I\u0011\u0005!q\t\u0005\b\u0005\u001f\"C\u0011\u0001B)\u0011\u001d\u0011I\u0006\nC\u0005\u00057BqA!\u0019%\t#\u0012\u0019\u0007C\u0004\u0003z\u0011\"\tEa\u001f\t\u000f\t}D\u0005\"\u0001\u0003>!9!\u0011\u0011\u0013\u0005B\tu\u0002b\u0002BBI\u0011\u0005#Q\b\u0005\b\u0005\u000b#C\u0011\tB\u001f\u0011\u001d\u00119\t\nC)\u0005{AqA!#%\t\u0003\u0012i\u0004C\u0004\u0003\f\u0012\"\tE!\u0010\t\u000f\t5E\u0005\"\u0011\u0003>!9!q\u0012\u0013\u0005B\tE\u0005b\u0002BLI\u0011E#\u0011\u0014\u0005\b\u0005;#C\u0011\u0002B\u001f\u0011\u001d\u0011y\n\nC\u0005\u0005{AqA!)%\t\u0013\u0011\u0019\u000bC\u0004\u0003*\u0012\"IAa+\t\u000f\tEF\u0005\"\u0003\u00034\"9!q\u0017\u0013\u0005\n\te\u0006b\u0002B_I\u0011%!q\u0018\u0005\b\u0005\u0007$C\u0011\u0002B\u001f\u0011\u001d\u0011)\r\nC\u0005\u0005\u000fDqAa3%\t\u0013\u0011i\rC\u0004\u0003R\u0012\"\tBa5\t\u000f\t\u0015H\u0005\"\u0005\u0003h\"1!1\u001f\u0013\u0005\u0012I\f\u0001bQ\u00196iE*U.\u001e\u0006\u0003/b\u000bQ\u0001\u001a:jm\u0016T!!\u0017.\u0002\u0015A,'/\u001b9iKJ\fGN\u0003\u0002\\9\u0006\u00191MY7\u000b\u0003u\u000bq!^2fg>4Go\u0001\u0001\u0011\u0005\u0001\fQ\"\u0001,\u0003\u0011\r\u000bT\u0007N\u0019F[V\u001c\"!A2\u0011\u0005\u0011<W\"A3\u000b\u0003\u0019\fQa]2bY\u0006L!\u0001[3\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq,A\u0007C\u0019&s5j\u0018+J\u001b\u0016{U\u000bV\u000b\u0002[B\u0011AM\\\u0005\u0003_\u0016\u00141!\u00138u\u00039\u0011E*\u0013(L?RKU*R(V)\u0002\nQ\u0001R#C+\u001e+\u0012a\u001d\t\u0003IRL!!^3\u0003\u000f\t{w\u000e\\3b]\u00061A)\u0012\"V\u000f\u0002\n1AS8c!\tI\b\"D\u0001\u0002\u0005\rQuNY\n\u0003\u0011q\u0004\"\u0001Z?\n\u0005y,'aC#ok6,'/\u0019;j_:$\u0012\u0001_\u0001\n\u0019>\u000bEi\u0018$J\u0019\u0016+\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011\u0002\b\u0003s\u001eI1!a\u0003~\u0005\u00151\u0016\r\\;f\u0003)au*\u0011#`\r&cU\tI\u0001\n'\u00063Vi\u0018$J\u0019\u0016\u000b!bU!W\u000b~3\u0015\nT#!\u00031au*\u0011#`\u0007\"\u000beJT#M\u00035au*\u0011#`\u0007\"\u000beJT#MA\u0005a1+\u0011,F?\u000eC\u0015I\u0014(F\u0019\u0006i1+\u0011,F?\u000eC\u0015I\u0014(F\u0019\u0002\nQ!R'Q)f\u000ba!R'Q)f\u0003\u0013\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tA\u0001\\1oO*\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005\u001d\"AB(cU\u0016\u001cG/A\u0005T)\u0006#VkU0P\u0017\u0006Q1\u000bV!U+N{vj\u0013\u0011\u0002'M#\u0016\tV+T?NKf\nV!Y?\u0016\u0013&k\u0014*\u0002)M#\u0016\tV+T?NKf\nV!Y?\u0016\u0013&k\u0014*!\u0003U\u0019F+\u0011+V'~3\u0015\nT#`\u001d>#vLR(V\u001d\u0012\u000bac\u0015+B)V\u001bvLR%M\u000b~su\nV0G\u001fVsE\tI\u0001\u0012'R\u000bE+V*`\u001d>{6\tS!O\u001d\u0016c\u0015AE*U\u0003R+6k\u0018(P?\u000eC\u0015I\u0014(F\u0019\u0002\nab\u0015+B)V\u001bvlV#M\u0007>kU)A\bT)\u0006#VkU0X\u000b2\u001bu*T#!\u0003Y\u0019F+\u0011+V'~#%+\u0013,F?:{Ek\u0018*F\u0003\u0012K\u0016aF*U\u0003R+6k\u0018#S\u0013Z+uLT(U?J+\u0015\tR-!\u0003-)%KU(S?\u000e{E)R*\u0016\u0005\u0005=\u0003cBA)\u00037j\u0017qL\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u00033*\u0017AC2pY2,7\r^5p]&!\u0011QLA*\u0005\ri\u0015\r\u001d\t\u0005\u0003K\t\t'\u0003\u0003\u0002d\u0005\u001d\"AB*ue&tw-\u0001\u0007F%J{%kX\"P\t\u0016\u001b\u0006%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003WR3!\\A7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=K\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7#\u0002\u0013\u0002\u0002\u00065\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001d\u0005,A\u0002ckNLA!a#\u0002\u0006\na\u0011*R\"CkN$UM^5dKB\u0019\u0001-a$\n\u0007\u0005EeKA\u0003Ee&4X\r\u0005\u0003\u0002\u0004\u0006U\u0015\u0002BAL\u0003\u000b\u0013a!S#D\u0005V\u001c\u0018a\u00037fI2K7\u000f^3oKJ\u00042\u0001YAO\u0013\r\tyJ\u0016\u0002\u0011\tJLg/\u001a'fI2K7\u000f^3oKJ\fa\u0001Z3wS\u000e,G\u0003CAS\u0003O\u000bI+a+\u0011\u0005\u0001$\u0003bBADQ\u0001\u0007\u00111\u0013\u0005\b\u00033C\u0003\u0019AAN\u0011!\t\t\u000b\u000bI\u0001\u0002\u0004i\u0017!\u00033sSZ,G+\u001f9f+\t\t\t\f\u0005\u0003\u00024\u0006%ab\u00011\u00026&\u0019\u0011q\u0017,\u0002\u0013\u0011\u0013\u0018N^3UsB,\u0017A\u00033sSZ,G+\u001f9fA\u0005Y1m\\7q_:,g\u000e^%E+\t\ty&\u0001\u0007d_6\u0004xN\\3oi&#\u0005%A\u0007g_Jl\u0017\r^#yi2K7\u000f^\u000b\u0003\u0003\u000b\u0004b!a2\u0002X\u0006ug\u0002BAe\u0003'tA!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001ft\u0016A\u0002\u001fs_>$h(C\u0001g\u0013\r\t).Z\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI.a7\u0003\t1K7\u000f\u001e\u0006\u0004\u0003+,\u0007\u0003BAp\u0003OtA!!9\u0002dB\u0019\u00111Z3\n\u0007\u0005\u0015X-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\nIOC\u0002\u0002f\u0016\faBZ8s[\u0006$X\t\u001f;MSN$\b%A\u0003ckNLG-\u0006\u0002\u0002^\u00061!-^:jI\u0002\n1\u0002\u001a:jm\u0016\u0014V-\u00193feB)A-a>\u0002|&\u0019\u0011\u0011`3\u0003\r=\u0003H/[8o!\u0011\tiPa\u0001\u000e\u0005\u0005}(b\u0001B\u00015\u00069am\u001c:nCR\u001c\u0018\u0002\u0002B\u0003\u0003\u007f\u0014\u0001\u0002R5tW\u0016$H/Z\u0001\u0004U>\u0014\u0007\u0003\u0002B\u0006\u0003\u0013q1A!\u0004\b\u001d\t\u0001\u0007!\u0001\u0004ti\u0006$Xo]\u0001\rKJ\u0014xN\u001d+j[\u0016|W\u000f\u001e\t\u0004I\nU\u0011b\u0001B\fK\n!Aj\u001c8h\u00035I7\u000fR3wS\u000e,'+Z1es\u0006AAn\\1e\t\u0006$\u0018\r\u0006\u0003\u0003 \t\u001d\u0002#\u00023\u0002x\n\u0005\u0002\u0003BAB\u0005GIAA!\n\u0002\u0006\ny!)^:ECR\f\u0017\n^3sCR|'\u000fC\u0004\u0003*Y\u0002\r!!8\u0002\u0011\u0019LG.\u001a(b[\u0016\fQbZ3u!J|\u0007/\u001a:uS\u0016\u001cXC\u0001B\u0018!\u0011\u0011\tDa\u000e\u000e\u0005\tM\"\u0002\u0002B\u001b\u0003W\tA!\u001e;jY&!!\u0011\bB\u001a\u0005)\u0001&o\u001c9feRLWm]\u0001\u0005S:LG\u000f\u0006\u0002\u0003@A\u0019AM!\u0011\n\u0007\t\rSM\u0001\u0003V]&$\u0018!C4fi\u001acw\u000e\u001d9z)\t\u0011I\u0005E\u0002a\u0005\u0017J1A!\u0014W\u0005\u00191En\u001c9qs\u0006q1/\u001a;Ee&4XMU3bI\u0016\u0014HC\u0002B \u0005'\u0012)\u0006C\u0004\u0002tj\u0002\rA!\u0013\t\r\t]#\b1\u0001t\u0003A)W.\u001e7bi\u0016Len]3si&tw-\u0001\u0005cY&t7\u000eT3e)\u0011\u0011yD!\u0018\t\u000f\t}3\b1\u0001\u0003\u0014\u000511-_2mKN\fqa]3u\u001b>$W\r\u0006\u0003\u0003@\t\u0015\u0004b\u0002B4y\u0001\u0007!\u0011N\u0001\b]\u0016<Xj\u001c3f!\u0011\u0011Y'!\u0003\u000f\t\t5$1\u000f\b\u0005\u0003\u0007\u0013y'\u0003\u0003\u0003r\u0005\u0015\u0015\u0001D%F\u0007\n+8\u000fR3wS\u000e,\u0017\u0002\u0002B;\u0005o\nA!T8eK*!!\u0011OAC\u0003\u001d\u0019Gn\\2lK\u0012$BAa\u0010\u0003~!9!qL\u001fA\u0002\tM\u0011!\u0002:fg\u0016$\u0018\u0001C;oY&\u001cH/\u001a8\u0002\t=\u0004XM\\\u0001\r_B,gnX2iC:tW\r\\\u0001\u0007k:$\u0018\r\\6\u0002\u000b\rdwn]3\u0002!\u0019LG.\u001a(b[\u0016\u0014VmY3jm\u0016$\u0017\u0001\u00043bi\u0006tu\u000e\u001e$pk:$\u0017a\u00042zi\u0016TUo\u001d;Xe&$H/\u001a8\u0015\t\t}\"1\u0013\u0005\u0007\u0005+3\u0005\u0019A:\u0002\r%\u001cH*Y:u\u0003\u0011aw.\u00193\u0015\t\t}\"1\u0014\u0005\b\u0005S9\u0005\u0019AAo\u0003=A\u0017M\u001c3mK\u000eC\u0017M\u001c8fYF*\u0014AC:f]\u0012\u001cF/\u0019;vg\u0006I1/\u001a;Ti\u0006$Xo\u001d\u000b\u0005\u0005\u007f\u0011)\u000b\u0003\u0004\u0003(*\u0003\r!\\\u0001\u0005G>$W-\u0001\bfq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3\u0015\t\t}\"Q\u0016\u0005\b\u0005_[\u0005\u0019AAo\u0003\r\u0019W\u000eZ\u0001\u0004[~+G\u0003\u0002B \u0005kCqAa,M\u0001\u0004\ti.A\u0002n?^$BAa\u0010\u0003<\"9!qV'A\u0002\u0005u\u0017aA7`eR!!q\bBa\u0011\u001d\u0011yK\u0014a\u0001\u0003;\f!\"\u001b8ji&\fG.\u001b>f\u00035\u0011WO\u001a4feB{\u0017N\u001c;feR!!q\bBe\u0011\u001d\u0011y\u000b\u0015a\u0001\u0003;\f!\"\\3n_JL(+Z1e)\u0011\u0011yDa4\t\u000f\t=\u0016\u000b1\u0001\u0002^\u0006I1/\u0019<f'R\fG/\u001a\u000b\u0005\u0005\u007f\u0011)\u000eC\u0004\u0003XJ\u0003\rA!7\u0002\u0007=,H\u000f\u0005\u0003\u0003\\\n\u0005XB\u0001Bo\u0015\u0011\u0011y.a\u000b\u0002\u0005%|\u0017\u0002\u0002Br\u0005;\u0014!c\u00142kK\u000e$x*\u001e;qkR\u001cFO]3b[\u0006IAn\\1e'R\fG/\u001a\u000b\u0005\u0005\u007f\u0011I\u000fC\u0004\u0003lN\u0003\rA!<\u0002\u0005%t\u0007\u0003\u0002Bn\u0005_LAA!=\u0003^\n\trJ\u00196fGRLe\u000e];u'R\u0014X-Y7\u0002)\u0005dGn\\<t'R\fG/\u001a*fgR|'/\u001b8h\u0001")
public class C1541Emu
extends IECBusDevice
implements Drive {
    private final DriveLedListener ledListener;
    private final Enumeration.Value driveType;
    private final String componentID;
    private final List<String> formatExtList;
    private final String busid;
    private Option<Diskette> driveReader;
    private Enumeration.Value job;
    private int status;
    private long errorTimeout;
    private Enumeration.Value componentType;
    private Function1<Object, BoxedUnit> runningListener;
    private int MIN_SPEED_HZ;
    private int MAX_SPEED_HZ;
    private Properties properties;
    private ListBuffer<CBMComponent> ucesoft$cbm$CBMComponent$$_components;

    public static int $lessinit$greater$default$3() {
        return C1541Emu$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public void disconnect() {
        Drive.disconnect$(this);
    }

    @Override
    public void setActive(boolean active) {
        Drive.setActive$(this, active);
    }

    @Override
    public boolean isRunning() {
        return Drive.isRunning$(this);
    }

    @Override
    public void setCanSleep(boolean canSleep) {
        Drive.setCanSleep$(this, canSleep);
    }

    @Override
    public boolean canGoSleeping() {
        return Drive.canGoSleeping$(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        Drive.setReadOnly$(this, readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return Drive.isReadOnly$(this);
    }

    @Override
    public Memory getMem() {
        return Drive.getMem$(this);
    }

    @Override
    public int getSpeedHz() {
        return Drive.getSpeedHz$(this);
    }

    @Override
    public void setSpeedHz(int speed) {
        Drive.setSpeedHz$(this, speed);
    }

    @Override
    public final void add(CBMComponent c) {
        CBMComponent.add$(this, c);
    }

    @Override
    public void shutdown() {
        CBMComponent.shutdown$(this);
    }

    @Override
    public void hardReset() {
        CBMComponent.hardReset$(this);
    }

    @Override
    public final void change(CBMComponent oldComponent, CBMComponent newComponent) {
        CBMComponent.change$(this, oldComponent, newComponent);
    }

    @Override
    public final void remove(CBMComponent c) {
        CBMComponent.remove$(this, c);
    }

    @Override
    public void afterInitHook() {
        CBMComponent.afterInitHook$(this);
    }

    @Override
    public final void shutdownComponent() {
        CBMComponent.shutdownComponent$(this);
    }

    @Override
    public final void resetComponent() {
        CBMComponent.resetComponent$(this);
    }

    @Override
    public final void hardResetComponent() {
        CBMComponent.hardResetComponent$(this);
    }

    @Override
    public void initComponent() {
        CBMComponent.initComponent$(this);
    }

    @Override
    public final List<CBMComponent> components() {
        return CBMComponent.components$(this);
    }

    @Override
    public final void printComponentsTree() {
        CBMComponent.printComponentsTree$(this);
    }

    @Override
    public void save(ObjectOutputStream out) {
        CBMComponent.save$(this, out);
    }

    @Override
    public void load(ObjectInputStream in) {
        CBMComponent.load$(this, in);
    }

    @Override
    public void componentIDMismatchHandling(String id) {
        CBMComponent.componentIDMismatchHandling$(this, id);
    }

    @Override
    public final boolean allowsState() {
        return CBMComponent.allowsState$(this);
    }

    @Override
    public void saveClockEvents(ObjectOutputStream out) {
        CBMComponent.saveClockEvents$(this, out);
    }

    @Override
    public void loadClockEvents(ObjectInputStream in, Function2<Object, Object, ClockEvent> f) {
        CBMComponent.loadClockEvents$(this, in, f);
    }

    @Override
    public <T> void loadMemory(Object mem, ObjectInputStream in) {
        CBMComponent.loadMemory$(this, mem, in);
    }

    @Override
    public Option<Frame> getActiveFrame() {
        return CBMComponent.getActiveFrame$(this);
    }

    @Override
    public void showError(String title, String error) {
        CBMComponent.showError$(this, title, error);
    }

    @Override
    public boolean isHeadless() {
        return CBMComponent.isHeadless$(this);
    }

    @Override
    public Enumeration.Value componentType() {
        return this.componentType;
    }

    @Override
    public Function1<Object, BoxedUnit> runningListener() {
        return this.runningListener;
    }

    @Override
    public void runningListener_$eq(Function1<Object, BoxedUnit> x$1) {
        this.runningListener = x$1;
    }

    @Override
    public int MIN_SPEED_HZ() {
        return this.MIN_SPEED_HZ;
    }

    @Override
    public int MAX_SPEED_HZ() {
        return this.MAX_SPEED_HZ;
    }

    @Override
    public void ucesoft$cbm$peripheral$drive$Drive$_setter_$componentType_$eq(Enumeration.Value x$1) {
        this.componentType = x$1;
    }

    @Override
    public void ucesoft$cbm$peripheral$drive$Drive$_setter_$MIN_SPEED_HZ_$eq(int x$1) {
        this.MIN_SPEED_HZ = x$1;
    }

    @Override
    public void ucesoft$cbm$peripheral$drive$Drive$_setter_$MAX_SPEED_HZ_$eq(int x$1) {
        this.MAX_SPEED_HZ = x$1;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public ListBuffer<CBMComponent> ucesoft$cbm$CBMComponent$$_components() {
        return this.ucesoft$cbm$CBMComponent$$_components;
    }

    @Override
    public void ucesoft$cbm$CBMComponent$_setter_$properties_$eq(Properties x$1) {
        this.properties = x$1;
    }

    @Override
    public final void ucesoft$cbm$CBMComponent$_setter_$ucesoft$cbm$CBMComponent$$_components_$eq(ListBuffer<CBMComponent> x$1) {
        this.ucesoft$cbm$CBMComponent$$_components = x$1;
    }

    @Override
    public Enumeration.Value driveType() {
        return this.driveType;
    }

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public List<String> formatExtList() {
        return this.formatExtList;
    }

    @Override
    public String busid() {
        return this.busid;
    }

    @Override
    public boolean isDeviceReady() {
        return this.driveReader.isDefined();
    }

    @Override
    public Option<BusDataIterator> loadData(String fileName) {
        None$ none$;
        try {
            if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
                Predef$.MODULE$.println((Object)new StringBuilder(8).append("Loading ").append(fileName).toString());
            }
            Diskette qual$1 = (Diskette)this.driveReader.get();
            String x$1 = fileName;
            Enumeration.Value x$2 = qual$1.load$default$2();
            Some some = new Some((Object)qual$1.load(x$1, x$2).iterator());
            none$ = some;
        }
        catch (FileNotFoundException e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Properties getProperties() {
        this.properties().setProperty("Status", Integer.toString(this.status));
        return this.properties();
    }

    @Override
    public void init() {
    }

    @Override
    public Floppy getFloppy() {
        return (Floppy)this.driveReader.getOrElse((Function0 & Serializable)() -> EmptyFloppy$.MODULE$);
    }

    @Override
    public void setDriveReader(Floppy driveReader, boolean emulateInserting) {
        this.driveReader = new Some((Object)((Diskette)driveReader));
    }

    private void blinkLed(long cycles) {
        if (this.errorTimeout == 0L) {
            this.ledListener.turnOn();
            this.errorTimeout = cycles + (long)C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$BLINK_TIMEOUT();
            return;
        }
        if (this.errorTimeout < cycles) {
            if (this.ledListener.isOn()) {
                this.ledListener.turnOff();
            } else {
                this.ledListener.turnOn();
            }
            this.errorTimeout = cycles + (long)C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$BLINK_TIMEOUT();
            return;
        }
    }

    @Override
    public void setMode(Enumeration.Value newMode) {
        super.setMode(newMode);
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.channels()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isOpened()))) {
            this.ledListener.turnOn();
            return;
        }
        this.ledListener.turnOff();
    }

    @Override
    public void clocked(long cycles) {
        super.clocked(cycles);
        if (this.status != C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_OK() && this.status != C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_WELCOME()) {
            this.blinkLed(cycles);
            return;
        }
    }

    @Override
    public void reset() {
        this.job = C1541Emu$Job$.MODULE$.EMPTY();
    }

    @Override
    public void unlisten() {
        super.unlisten();
        if (this.channel() == 15) {
            this.handleChannel15();
        }
        this.resetSignals();
    }

    @Override
    public void open() {
        super.open();
        int n = this.channel();
        switch (n) {
            case 0: {
                this.job = C1541Emu$Job$.MODULE$.LOAD_FILE();
                this.channels()[this.channel()].readDirection_$eq(true);
                return;
            }
            case 1: {
                this.job = C1541Emu$Job$.MODULE$.SAVE_FILE();
                this.channels()[this.channel()].readDirection_$eq(false);
                return;
            }
            case 15: {
                if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
                    Predef$.MODULE$.println((Object)"Channel 15!!!");
                    return;
                }
                return;
            }
        }
        if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("Using logical channel ").append(this.channel()).toString());
        }
        this.channels()[this.channel()].readDirection_$eq(true);
        this.job = C1541Emu$Job$.MODULE$.LOAD_CHANNEL();
    }

    @Override
    public void open_channel() {
        super.open_channel();
        if (!this.channels()[this.channel()].isOpened()) {
            this.channels()[this.channel()].open();
            int n = this.channel();
            switch (n) {
                case 15: {
                    this.handleChannel15();
                    return;
                }
            }
            this.load(this.channels()[this.channel()].fileName().toString());
            return;
        }
    }

    @Override
    public void untalk() {
        this.resetSignals();
    }

    @Override
    public void close() {
        super.close();
        Enumeration.Value value = this.job;
        Enumeration.Value value2 = C1541Emu$Job$.MODULE$.SAVE_FILE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
                Predef$.MODULE$.println((Object)new StringBuilder(13).append("Saving file ").append((CharSequence)this.channels()[this.channel()].fileName()).append(" ").append(this.channels()[this.channel()].buffer().length()).toString());
            }
        }
        this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_OK());
    }

    @Override
    public void fileNameReceived() {
        super.fileNameReceived();
        if (this.channels()[this.channel()].fileName().toString().startsWith("#")) {
            this.channels()[this.channel()].open();
        }
        if (this.channel() == 15 && this.channels()[this.channel()].fileName().length() > 0) {
            this.handleChannel15();
            return;
        }
    }

    @Override
    public void dataNotFound() {
        super.dataNotFound();
        this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_FILE_NOT_FOUND());
    }

    @Override
    public void byteJustWritten(boolean isLast) {
        super.byteJustWritten(isLast);
    }

    @Override
    public void load(String fileName) {
        String string = fileName;
        String string2 = "#";
        if (string == null ? string2 != null : !string.equals(string2)) {
            super.load(fileName);
            return;
        }
        if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
            Predef$.MODULE$.println((Object)"Loading from #");
            return;
        }
    }

    private void handleChannel15() {
        String cmd;
        String string = cmd = this.channels()[this.channel()].fileName().length() > 0 ? this.channels()[this.channel()].fileName().toString() : this.channels()[this.channel()].bufferToString();
        if (cmd.length() > 0) {
            this.executeCommand(cmd);
            this.channels()[this.channel()].buffer().clear();
        }
        this.sendStatus();
    }

    private void sendStatus() {
        this.channels()[this.channel()].dataToSend_$eq((Option<BusDataIterator>)new Some((Object)new BusDataIterator.StringDataIterator(new StringBuilder(11).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02d,%s,00,00"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.status), C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$ERROR_CODES().apply((Object)BoxesRunTime.boxToInteger((int)this.status))}))).append('\r').toString())));
    }

    private void setStatus(int code) {
        this.status = code;
    }

    private void executeCommand(String cmd) {
        String command = cmd.charAt(cmd.length() - 1) == '\r' ? cmd.substring(0, cmd.length() - 1) : cmd;
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Executing command ").append(command).toString());
        try {
            char c = command.charAt(0);
            switch (c) {
                case 'I': {
                    this.initialize();
                    break;
                }
                case 'U': {
                    if (command.startsWith("U1:")) {
                        this.memoryRead(command.substring(3));
                        break;
                    }
                    if (command.startsWith("U1")) {
                        this.memoryRead(command.substring(2));
                        break;
                    }
                    this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
                    break;
                }
                case 'B': {
                    if (command.startsWith("B-P:")) {
                        this.bufferPointer(command.substring(4));
                        break;
                    }
                    if (command.startsWith("B-P")) {
                        this.bufferPointer(command.substring(3));
                        break;
                    }
                    this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
                    break;
                }
                case 'M': {
                    if (command.startsWith("M-R:")) {
                        this.m_r(command.substring(4));
                        break;
                    }
                    if (command.startsWith("M-R")) {
                        this.m_r(command.substring(3));
                        break;
                    }
                    if (command.startsWith("M-W:")) {
                        this.m_w(command.substring(4));
                        break;
                    }
                    if (command.startsWith("M-W")) {
                        this.m_w(command.substring(3));
                        break;
                    }
                    if (command.startsWith("M-E:")) {
                        this.m_e(command.substring(4));
                        break;
                    }
                    if (command.startsWith("M-E")) {
                        this.m_e(command.substring(3));
                    }
                    break;
                }
                default: {
                    this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
        }
    }

    private void m_e(String cmd) {
        char lo = cmd.charAt(0);
        char hi = cmd.charAt(1);
        int address = hi * 256 + lo;
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("M-E from ").append(Integer.toHexString(address)).toString());
    }

    private void m_w(String cmd) {
        char lo = cmd.charAt(0);
        char hi = cmd.charAt(1);
        char len = cmd.charAt(2);
        int address = hi * 256 + lo;
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("M-W to ").append(Integer.toHexString(address)).append(" len=").append((int)len).toString());
    }

    private void m_r(String cmd) {
        if (cmd.length() == 2 || cmd.length() == 3) {
            char lo = cmd.charAt(0);
            char hi = cmd.charAt(1);
            char len = cmd.length() == 3 ? cmd.charAt(2) : (char)'\u0001';
            int address = hi * 256 + lo;
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("M-R from ").append(Integer.toHexString(address)).append(" len=").append((int)len).toString());
            return;
        }
        this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
    }

    private void initialize() {
        this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_OK());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.channels()), (Function1 & Serializable)c -> {
            C1541Emu.$anonfun$initialize$1(c);
            return BoxedUnit.UNIT;
        });
        if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
            Predef$.MODULE$.println((Object)"Initialized!!");
            return;
        }
    }

    private void bufferPointer(String cmd) {
        StringTokenizer st = new StringTokenizer(cmd.trim(), " ,");
        if (st.countTokens() == 2) {
            try {
                int channel = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(st.nextToken()));
                int pos = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(st.nextToken()));
                if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(31).append("Buffer pointer on channel=").append(channel).append(" pos=").append(pos).toString());
                }
                if (channel > 15 || !this.channels()[channel].isOpened()) {
                    this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_NO_CHANNEL());
                } else {
                    ((BusDataIterator)this.channels()[channel].dataToSend().get()).goto(pos);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
            }
            return;
        }
        this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
    }

    private void memoryRead(String cmd) {
        StringTokenizer st = new StringTokenizer(cmd.trim(), " ,");
        if (st.countTokens() == 4) {
            try {
                int channel = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(st.nextToken()));
                int drive = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(st.nextToken()));
                int track = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(st.nextToken()));
                int sector = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(st.nextToken()));
                if (C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$DEBUG()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(45).append("Memory read on channel=").append(channel).append(" drive=").append(drive).append(" track=").append(track).append(" sector=").append(sector).toString());
                }
                if (channel > 15 || !this.channels()[channel].isOpened()) {
                    this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_NO_CHANNEL());
                } else if (drive != 0) {
                    this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_DRIVE_NOT_READY());
                } else {
                    this.channels()[channel].dataToSend_$eq((Option<BusDataIterator>)new Some((Object)new BusDataIterator.ArrayDataIterator(((Diskette)this.driveReader.get()).readBlock(track, sector), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)256)))));
                    Predef$.MODULE$.println((Object)Predef$.MODULE$.wrapByteArray(((Diskette)this.driveReader.get()).readBlock(track, sector)).mkString(","));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
            }
            return;
        }
        this.setStatus(C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_SYNTAX_ERROR());
    }

    @Override
    public void saveState(ObjectOutputStream out) {
    }

    @Override
    public void loadState(ObjectInputStream in) {
    }

    @Override
    public boolean allowsStateRestoring() {
        Option<Diskette> option = this.driveReader;
        if (option instanceof Some) {
            Some some = (Some)option;
            Diskette d64 = (Diskette)some.value();
            this.showError("State warning", new StringBuilder(75).append("Warning: 1541 emulation is active with ").append(d64).append(". The disk will not be saved/loaded.").toString());
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$initialize$1(IECBusDevice.Channel c) {
        c.close();
        c.dataToSend_$eq((Option<BusDataIterator>)None$.MODULE$);
    }

    public C1541Emu(IECBus bus, DriveLedListener ledListener, int device) {
        this.ledListener = ledListener;
        super(bus, device);
        CBMComponent.$init$(this);
        Drive.$init$(this);
        this.driveType = DriveType$.MODULE$.OTHER();
        this.componentID = "C1541 Emu";
        this.formatExtList = new .colon.colon((Object)"D64", (List)Nil$.MODULE$);
        this.busid = new StringBuilder(9).append("C1541Emu_").append(device).toString();
        bus.registerListener(this);
        this.driveReader = None$.MODULE$;
        this.job = C1541Emu$Job$.MODULE$.EMPTY();
        this.status = C1541Emu$.MODULE$.ucesoft$cbm$peripheral$drive$C1541Emu$$STATUS_WELCOME();
        this.errorTimeout = 0L;
        Statics.releaseFence();
    }
}

