/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.mos653x;

import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import ucesoft.cbm.peripheral.mos653x.MOS653X;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\u001c8\u0001\u0001C\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t)\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003X\u0011!\u0001\u0007A!b\u0001\n\u00031\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\bk\u0002\u0011\r\u0011\"\u0005w\u0011\u0019i\b\u0001)A\u0005o\"9a\u0010\u0001b\u0001\n#1\bBB@\u0001A\u0003%q\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0005\u0002\u0004!I\u0011Q\u0001\u0001A\u0002\u0013E\u0011q\u0001\u0005\b\u0003\u001b\u0001\u0001\u0015)\u0003{\u0011%\ty\u0001\u0001a\u0001\n#\t\t\u0002C\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0005\u0002\u0016!9\u0011\u0011\u0004\u0001!B\u00139\u0007\"CA\u000e\u0001\u0001\u0007I\u0011CA\t\u0011%\ti\u0002\u0001a\u0001\n#\ty\u0002C\u0004\u0002$\u0001\u0001\u000b\u0015B4\t\u0013\u0005\u0015\u0002\u00011A\u0005\u0012\u0005E\u0001\"CA\u0014\u0001\u0001\u0007I\u0011CA\u0015\u0011\u001d\ti\u0003\u0001Q!\n\u001dD\u0011\"a\f\u0001\u0001\u0004%\t\"!\u0005\t\u0013\u0005E\u0002\u00011A\u0005\u0012\u0005M\u0002bBA\u001c\u0001\u0001\u0006Ka\u001a\u0005\n\u0003s\u0001\u0001\u0019!C\t\u0003#A\u0011\"a\u000f\u0001\u0001\u0004%\t\"!\u0010\t\u000f\u0005\u0005\u0003\u0001)Q\u0005O\"I\u00111\t\u0001A\u0002\u0013E\u0011\u0011\u0003\u0005\n\u0003\u000b\u0002\u0001\u0019!C\t\u0003\u000fBq!a\u0013\u0001A\u0003&q\rC\u0005\u0002N\u0001\u0001\r\u0011\"\u0005\u0002\u0004!I\u0011q\n\u0001A\u0002\u0013E\u0011\u0011\u000b\u0005\b\u0003+\u0002\u0001\u0015)\u0003{\u0011%\t9\u0006\u0001a\u0001\n#\t\u0019\u0001C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0005\u0002\\!9\u0011q\f\u0001!B\u0013Q\bbBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0000\u0001!\t\"!!\t\u000f\u0005\u001d\u0005\u0001\"\u0005\u0002\n\"9\u0011q\u0012\u0001\u0005\u0012\u0005E\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u00037\u0003A\u0011AA2\u0011\u001d\ti\n\u0001C\t\u0003GBq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002&\u0002!\t\"a\u0019\t\u000f\u0005\u001d\u0006\u0001\"\u0005\u0002*\n9QjT*7kM\u0012$B\u0001\u001d:\u0003\u001diwn\u001d\u001c6gaT!AO\u001e\u0002\u0015A,'/\u001b9iKJ\fGN\u0003\u0002={\u0005\u00191MY7\u000b\u0003y\nq!^2fg>4Go\u0001\u0001\u0014\u0005\u0001\t\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g-\u0001\u0003oC6,W#A%\u0011\u0005)\u000bfBA&P!\ta5)D\u0001N\u0015\tqu(\u0001\u0004=e>|GOP\u0005\u0003!\u000e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001kQ\u0001\u0006]\u0006lW\rI\u0001\u0006a>\u0014H/Q\u000b\u0002/B\u0011\u0001\f\u0018\b\u00033jk\u0011aN\u0005\u00037^\nq!T(TmU\u001a\u0004,\u0003\u0002^=\n!\u0001k\u001c:u\u0015\tYv'\u0001\u0004q_J$\u0018\tI\u0001\u0006a>\u0014HOQ\u0001\u0007a>\u0014HO\u0011\u0011\u0002\r%\u0014\u0018\u000fT8x+\u0005!\u0007\u0003\u0002\"fO*L!AZ\"\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\"i\u0013\tI7IA\u0004C_>dW-\u00198\u0011\u0005\t[\u0017B\u00017D\u0005\u0011)f.\u001b;\u0002\u000f%\u0014\u0018\u000fT8xA\u00051A(\u001b8jiz\"R\u0001]9sgR\u0004\"!\u0017\u0001\t\u000b\u001dK\u0001\u0019A%\t\u000bUK\u0001\u0019A,\t\u000b\u0001L\u0001\u0019A,\t\u000b\tL\u0001\u0019\u00013\u0002\u0007I\fW.F\u0001x!\r\u0011\u0005P_\u0005\u0003s\u000e\u0013Q!\u0011:sCf\u0004\"AQ>\n\u0005q\u001c%aA%oi\u0006!!/Y7!\u0003\u0011\u0011XmZ:\u0002\u000bI,wm\u001d\u0011\u0002\u000bQLW.\u001a:\u0016\u0003i\f\u0011\u0002^5nKJ|F%Z9\u0015\u0007)\fI\u0001\u0003\u0005\u0002\f=\t\t\u00111\u0001{\u0003\rAH%M\u0001\u0007i&lWM\u001d\u0011\u0002\u00191\f7\u000f\u001e)BoY\u000bG.^3\u0016\u0003\u001d\f\u0001\u0003\\1tiB\u000buGV1mk\u0016|F%Z9\u0015\u0007)\f9\u0002\u0003\u0005\u0002\fI\t\t\u00111\u0001h\u00035a\u0017m\u001d;Q\u0003^2\u0016\r\\;fA\u0005\u0019\u0002/Y\u001cOK\u001e\fG/\u001b<f\u000b\u0012<W-T8eK\u00069\u0002/Y\u001cOK\u001e\fG/\u001b<f\u000b\u0012<W-T8eK~#S-\u001d\u000b\u0004U\u0006\u0005\u0002\u0002CA\u0006+\u0005\u0005\t\u0019A4\u0002)A\fwGT3hCRLg/Z#eO\u0016lu\u000eZ3!\u0003\u0019\u0001\u0018mN%S#\u0006Q\u0001/Y\u001cJ%F{F%Z9\u0015\u0007)\fY\u0003\u0003\u0005\u0002\fa\t\t\u00111\u0001h\u0003\u001d\u0001\u0018mN%S#\u0002\nQ\u0002]18\u0013J\u000bVI\\1cY\u0016$\u0017!\u00059bo%\u0013\u0016+\u00128bE2,Gm\u0018\u0013fcR\u0019!.!\u000e\t\u0011\u0005-1$!AA\u0002\u001d\fa\u0002]18\u0013J\u000bVI\\1cY\u0016$\u0007%\u0001\u0005uS6,'/\u0013*R\u00031!\u0018.\\3s\u0013J\u000bv\fJ3r)\rQ\u0017q\b\u0005\t\u0003\u0017q\u0012\u0011!a\u0001O\u0006IA/[7fe&\u0013\u0016\u000bI\u0001\u0010i&lWM]%S#\u0016s\u0017M\u00197fI\u0006\u0019B/[7fe&\u0013\u0016+\u00128bE2,Gm\u0018\u0013fcR\u0019!.!\u0013\t\u0011\u0005-\u0011%!AA\u0002\u001d\f\u0001\u0003^5nKJL%+U#oC\ndW\r\u001a\u0011\u0002\u001fQLW.\u001a:Nk2$\u0018\u000e\u001d7jKJ\f1\u0003^5nKJlU\u000f\u001c;ja2LWM]0%KF$2A[A*\u0011!\tY\u0001JA\u0001\u0002\u0004Q\u0018\u0001\u0005;j[\u0016\u0014X*\u001e7uSBd\u0017.\u001a:!\u0003Y!\u0018.\\3s\u001bVdG/\u001b9mS\u0016\u00148i\\;oi\u0016\u0014\u0018A\u0007;j[\u0016\u0014X*\u001e7uSBd\u0017.\u001a:D_VtG/\u001a:`I\u0015\fHc\u00016\u0002^!A\u00111B\u0014\u0002\u0002\u0003\u0007!0A\fuS6,'/T;mi&\u0004H.[3s\u0007>,h\u000e^3sA\u0005)!/Z:fiR\t!.\u0001\u0005xe&$XMU!N)\u0015Q\u0017\u0011NA7\u0011\u0019\tYG\u000ba\u0001u\u00069\u0011\r\u001a3sKN\u001c\bBBA8U\u0001\u0007!0A\u0003wC2,X-A\u0004sK\u0006$'+Q'\u0015\u0007i\f)\b\u0003\u0004\u0002l-\u0002\rA_\u0001\u0006oJLG/\u001a\u000b\u0006U\u0006m\u0014Q\u0010\u0005\u0007\u0003Wb\u0003\u0019\u0001>\t\r\u0005=D\u00061\u0001{\u0003u9(/\u001b;f)&lWM](s\u000b\u0012<W\rR3uK\u000e$8i\u001c8ue>dG#\u00026\u0002\u0004\u0006\u0015\u0005BBA6[\u0001\u0007!\u0010\u0003\u0004\u0002p5\u0002\rA_\u0001\u000boJLG/\u001a+j[\u0016\u0014H#\u00026\u0002\f\u00065\u0005BBA6]\u0001\u0007!\u0010\u0003\u0004\u0002p9\u0002\rA_\u0001\u0017oJLG/Z#eO\u0016$U\r^3di\u000e{g\u000e\u001e:pYR\u0019!.a%\t\r\u0005-t\u00061\u0001{\u0003\r\u0001\u0018m\u000e\u000b\u0004U\u0006e\u0005BBA8a\u0001\u0007q-A\u0003dY>\u001c7.\u0001\tuS6,'/\u0013*R\u001f\u000e\u001cWO\u001d:fI\u0006!!/Z1e)\rQ\u00181\u0015\u0005\u0007\u0003W\u001a\u0004\u0019\u0001>\u0002\u0011\rDWmY6J%F\u000b\u0011C]3bI&sG/\u001a:skB$h\t\\1h)\u0005Q\b")
public class MOS6532 {
    private final String name;
    private final MOS653X.Port portA;
    private final MOS653X.Port portB;
    private final Function1<Object, BoxedUnit> irqLow;
    private final int[] ram;
    private final int[] regs;
    private int timer;
    private boolean lastPA7Value;
    private boolean pa7NegativeEdgeMode;
    private boolean pa7IRQ;
    private boolean pa7IRQEnabled;
    private boolean timerIRQ;
    private boolean timerIRQEnabled;
    private int timerMultiplier;
    private int timerMultiplierCounter;

    public String name() {
        return this.name;
    }

    public MOS653X.Port portA() {
        return this.portA;
    }

    public MOS653X.Port portB() {
        return this.portB;
    }

    public Function1<Object, BoxedUnit> irqLow() {
        return this.irqLow;
    }

    public int[] ram() {
        return this.ram;
    }

    public int[] regs() {
        return this.regs;
    }

    public int timer() {
        return this.timer;
    }

    public void timer_$eq(int x$1) {
        this.timer = x$1;
    }

    public boolean lastPA7Value() {
        return this.lastPA7Value;
    }

    public void lastPA7Value_$eq(boolean x$1) {
        this.lastPA7Value = x$1;
    }

    public boolean pa7NegativeEdgeMode() {
        return this.pa7NegativeEdgeMode;
    }

    public void pa7NegativeEdgeMode_$eq(boolean x$1) {
        this.pa7NegativeEdgeMode = x$1;
    }

    public boolean pa7IRQ() {
        return this.pa7IRQ;
    }

    public void pa7IRQ_$eq(boolean x$1) {
        this.pa7IRQ = x$1;
    }

    public boolean pa7IRQEnabled() {
        return this.pa7IRQEnabled;
    }

    public void pa7IRQEnabled_$eq(boolean x$1) {
        this.pa7IRQEnabled = x$1;
    }

    public boolean timerIRQ() {
        return this.timerIRQ;
    }

    public void timerIRQ_$eq(boolean x$1) {
        this.timerIRQ = x$1;
    }

    public boolean timerIRQEnabled() {
        return this.timerIRQEnabled;
    }

    public void timerIRQEnabled_$eq(boolean x$1) {
        this.timerIRQEnabled = x$1;
    }

    public int timerMultiplier() {
        return this.timerMultiplier;
    }

    public void timerMultiplier_$eq(int x$1) {
        this.timerMultiplier = x$1;
    }

    public int timerMultiplierCounter() {
        return this.timerMultiplierCounter;
    }

    public void timerMultiplierCounter_$eq(int x$1) {
        this.timerMultiplierCounter = x$1;
    }

    public void reset() {
        Arrays.fill(this.ram(), 0);
        Arrays.fill(this.regs(), 0);
        this.timer_$eq(0);
        this.lastPA7Value_$eq(true);
        this.pa7NegativeEdgeMode_$eq(true);
        this.pa7IRQ_$eq(false);
        this.pa7IRQEnabled_$eq(false);
        this.timerIRQ_$eq(false);
        this.timerIRQEnabled_$eq(false);
        this.timerMultiplier_$eq(1);
        this.timerMultiplierCounter_$eq(1);
    }

    public void writeRAM(int address, int value) {
        this.ram()[address & this.ram().length - 1] = value;
    }

    public int readRAM(int address) {
        return this.ram()[address & this.ram().length - 1];
    }

    public void write(int address, int value) {
        int n = address & 7;
        switch (n) {
            case 0: 
            case 1: {
                Predef$.MODULE$.println((Object)new StringBuilder(17).append("[6532 ").append(this.name()).append("] write ").append((Object)(n == 0 ? "PRA" : "DDRA")).append(" = ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(value))).toString());
                this.regs()[n] = value;
                int n2 = (this.regs()[0] | ~this.regs()[1]) & 0xFF;
                this.portA().write(n2);
                return;
            }
            case 2: 
            case 3: {
                Predef$.MODULE$.println((Object)new StringBuilder(17).append("[6532 ").append(this.name()).append("] write ").append((Object)(n == 2 ? "PRB" : "DDRB")).append(" = ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(value))).toString());
                this.regs()[n] = value;
                int n3 = (this.regs()[2] | ~this.regs()[3]) & 0xFF;
                this.portB().write(n3);
                return;
            }
        }
        this.writeTimerOrEdgeDetectControl(address, value);
    }

    public void writeTimerOrEdgeDetectControl(int address, int value) {
        if ((address & 0x10) > 0) {
            this.writeTimer(address, value);
            return;
        }
        this.writeEdgeDetectControl(address);
    }

    public void writeTimer(int address, int value) {
        int n;
        this.timerIRQEnabled_$eq((address & 8) > 0);
        int n2 = address & 3;
        switch (n2) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 64;
                break;
            }
            case 3: {
                n = 1024;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
        }
        this.timerMultiplier_$eq(n);
        this.timer_$eq(value);
        this.timerMultiplierCounter_$eq(this.timerMultiplier());
        this.timerIRQ_$eq(false);
        Predef$.MODULE$.println((Object)new StringBuilder(38).append("[6532 ").append(this.name()).append("] setting timer = ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(value))).append(" multiplier = ").append(this.timerMultiplier()).toString());
        this.checkIRQ();
    }

    public void writeEdgeDetectControl(int address) {
        this.pa7IRQEnabled_$eq((address & 2) > 0);
        this.pa7NegativeEdgeMode_$eq((address & 1) == 0);
        Predef$.MODULE$.println((Object)new StringBuilder(59).append("[6532 ").append(this.name()).append("] write PA7 mode: pa7IRQEnabled=").append(this.pa7IRQEnabled()).append(" pa7NegativeEdgeMode=").append(this.pa7NegativeEdgeMode()).toString());
    }

    public void pa7(boolean value) {
        if (this.pa7NegativeEdgeMode()) {
            this.pa7IRQ_$eq(this.lastPA7Value() && !value);
        } else {
            this.pa7IRQ_$eq(!this.lastPA7Value() && value);
        }
        this.checkIRQ();
        this.lastPA7Value_$eq(value);
    }

    public void clock() {
        if (this.timer() > -255) {
            this.timerMultiplierCounter_$eq(this.timerMultiplierCounter() - 1);
            if (this.timerMultiplierCounter() == 0) {
                this.timerMultiplierCounter_$eq(this.timerMultiplier());
                this.timer_$eq(this.timer() - 1);
                if (this.timer() == -1) {
                    this.timerIRQOccurred();
                    return;
                }
                return;
            }
            return;
        }
    }

    public void timerIRQOccurred() {
        this.timerIRQ_$eq(true);
        this.checkIRQ();
    }

    public int read(int address) {
        int n = address & 7;
        switch (n) {
            case 0: {
                int n2 = this.portA().read();
                return n2 & ~this.regs()[1] | this.regs()[0] & this.regs()[1];
            }
            case 1: {
                return this.regs()[1];
            }
            case 2: {
                int n3 = this.portB().read();
                return n3 & ~this.regs()[3] | this.regs()[2] & this.regs()[3];
            }
            case 3: {
                return this.regs()[3];
            }
            case 4: 
            case 6: {
                this.timerIRQEnabled_$eq((address & 8) > 0);
                this.timerIRQ_$eq(false);
                this.checkIRQ();
                return this.timer() & 0xFF;
            }
            case 5: 
            case 7: {
                return this.readInterruptFlag();
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public void checkIRQ() {
        this.irqLow().apply((Object)BoxesRunTime.boxToBoolean((boolean)(this.pa7IRQEnabled() & this.pa7IRQ() | this.timerIRQEnabled() & this.timerIRQ())));
    }

    public int readInterruptFlag() {
        int st = (this.timerIRQ() ? 128 : 0) | (this.pa7IRQ() ? 64 : 0);
        this.pa7IRQ_$eq(false);
        this.checkIRQ();
        return st;
    }

    public MOS6532(String name, MOS653X.Port portA, MOS653X.Port portB, Function1<Object, BoxedUnit> irqLow) {
        this.name = name;
        this.portA = portA;
        this.portB = portB;
        this.irqLow = irqLow;
        this.ram = (int[])Array$.MODULE$.ofDim(128, (ClassTag)ClassTag$.MODULE$.Int());
        this.regs = (int[])Array$.MODULE$.ofDim(4, (ClassTag)ClassTag$.MODULE$.Int());
        this.timer = 0;
        this.lastPA7Value = true;
        this.pa7NegativeEdgeMode = true;
        this.pa7IRQ = false;
        this.pa7IRQEnabled = false;
        this.timerIRQ = false;
        this.timerIRQEnabled = false;
        this.timerMultiplier = 1;
        this.timerMultiplierCounter = 1;
    }
}

