/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.rs232;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import ucesoft.cbm.Log$;
import ucesoft.cbm.peripheral.rs232.StreamRS232;

@ScalaSignature(bytes="\u0006\u0005y;Q\u0001E\t\t\u0002i1Q\u0001H\t\t\u0002uAQaI\u0001\u0005\u0002u3A\u0001H\t\u0001?!)1e\u0001C\u0001I!9Qe\u0001b\u0001\n\u00031\u0003BB\u0018\u0004A\u0003%q\u0005\u0003\u00041\u0007\u0001\u0006Ka\n\u0005\u0007c\r\u0001\u000b\u0015\u0002\u001a\t\u0013a\u001a\u0001\u0019!A!B\u0013I\u0004BB \u0004A\u0003&q\u0005C\u0003A\u0007\u0011\u0005a\u0005C\u0003B\u0007\u0011\u0005#\tC\u0003N\u0007\u0011\u0005c\nC\u0003U\u0007\u0011\u0005S\u000bC\u0003\\\u0007\u0011\u0005C,\u0001\u0005U\u0007B\u00136KM\u001a3\u0015\t\u00112#A\u0003sgJ\u001a$G\u0003\u0002\u0015+\u0005Q\u0001/\u001a:ja\",'/\u00197\u000b\u0005Y9\u0012aA2c[*\t\u0001$A\u0004vG\u0016\u001cxN\u001a;\u0004\u0001A\u00111$A\u0007\u0002#\tAAk\u0011)S'J\u001a$g\u0005\u0002\u0002=A\u00111dA\n\u0003\u0007\u0001\u0002\"aG\u0011\n\u0005\t\n\"aC*ue\u0016\fWNU*3gI\na\u0001P5oSRtD#\u0001\u0010\u0002\u0017\r|W\u000e]8oK:$\u0018\nR\u000b\u0002OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0005Y\u0006twMC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#AB*ue&tw-\u0001\u0007d_6\u0004xN\\3oi&#\u0005%\u0001\u0003i_N$\u0018\u0001\u00029peR\u0004\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u00121!\u00138u\u0003\u0019\u0019xnY6fiB\u0011!(P\u0007\u0002w)\u0011AhK\u0001\u0004]\u0016$\u0018B\u0001 <\u0005\u0019\u0019vnY6fi\u0006Y\u0001n\\:u\u0003:$7i\u001c8g\u000399W\r\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:\fabY8o]\u0016\u001cG/[8o\u0013:4w.F\u0001D!\t!5J\u0004\u0002F\u0013B\u0011a\tN\u0007\u0002\u000f*\u0011\u0001*G\u0001\u0007yI|w\u000e\u001e \n\u0005)#\u0014A\u0002)sK\u0012,g-\u0003\u0002/\u0019*\u0011!\nN\u0001\u0011g\u0016$8i\u001c8gS\u001e,(/\u0019;j_:$\"a\u0014*\u0011\u0005M\u0002\u0016BA)5\u0005\u0011)f.\u001b;\t\u000bMk\u0001\u0019A\"\u0002\t\r|gNZ\u0001\u000bg\u0016$XI\\1cY\u0016$GCA(W\u0011\u00159f\u00021\u0001Y\u0003\u001d)g.\u00192mK\u0012\u0004\"aM-\n\u0005i#$a\u0002\"p_2,\u0017M\\\u0001\ti>\u001cFO]5oOR\t1\tF\u0001\u001b\u0001")
public class TCPRS232
extends StreamRS232 {
    private final String componentID;
    private String host = "";
    private int port = 0;
    private Socket socket;
    private String hostAndConf = "";

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public String getDescription() {
        return "<html><b>Connects to a TCP server</b>.<br>Connection String syntax: <i>host:port,baud,bits,parity,stops</i> to connect or<br><i>baud,bits,parity,stops</i> to use 'at' modem commands</html>";
    }

    @Override
    public String connectionInfo() {
        return this.hostAndConf;
    }

    @Override
    public void setConfiguration(String conf) {
        String string;
        this.hostAndConf = conf;
        String[] parts = conf.split(",");
        int n = parts.length;
        switch (n) {
            case 4: {
                string = conf;
                break;
            }
            case 5: {
                string = conf.substring(conf.indexOf(",") + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad Telnet RS-232 configuration string. Expected [<host>:<port>,<baud>,]<bits>,<parity>,<stops>");
            }
        }
        String confString = string;
        super.setConfiguration(confString);
        if (parts.length == 5) {
            String[] pars = parts[0].split(":");
            if (pars.length != 2) {
                throw new IllegalArgumentException("Bad Telnet RS-232 configuration string. Bad host:port parameter");
            }
            this.host = pars[0];
            this.port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(pars[1]));
            return;
        }
        this.host = "";
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() || !enabled) {
            String string = this.host;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Disconnecting from ").append($this.host).append("...").toString());
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Throwable throwable) {}
                this.disconnect();
                super.setEnabled(false);
            }
        }
        if (enabled) {
            String string = this.host;
            String string3 = "";
            if (string == null ? string3 != null : !string.equals(string3)) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Connecting to ").append($this.host).append(":").append($this.port).append(" ...").toString());
                try {
                    this.socket = new Socket(this.host, this.port);
                    this.setStreams(this.socket.getInputStream(), this.socket.getOutputStream(), new StringBuilder(1).append(this.host).append(":").append(this.port).toString());
                    super.setEnabled(enabled);
                }
                catch (IOException io) {
                    Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Cannot connect to ").append($this.host).append(":").append($this.port).append(". ").append(io).toString());
                    this.disconnect();
                }
                return;
            }
        }
    }

    public String toString() {
        return new StringBuilder(0).append(this.componentID()).append((Object)(this.isEnabled() ? "(enabled)" : "")).toString();
    }

    public TCPRS232() {
        this.componentID = "TCP RS-232";
    }
}

