/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

public class DAC {
    static int[] build_dac_table(int n, double d, boolean bl) {
        int n2;
        double[] dArray = new double[n];
        int[] nArray = new int[1 << n];
        for (n2 = 0; n2 < n; ++n2) {
            int n3;
            double d2 = 1.0;
            double d3 = d * 1.0;
            double d4 = bl ? d3 : Double.POSITIVE_INFINITY;
            for (n3 = 0; n3 < n2; ++n3) {
                d4 = d4 == Double.POSITIVE_INFINITY ? 1.0 + d3 : 1.0 + d3 * d4 / (d3 + d4);
            }
            if (d4 == Double.POSITIVE_INFINITY) {
                d4 = d3;
            } else {
                d4 = d3 * d4 / (d3 + d4);
                d2 = d2 * d4 / d3;
            }
            ++n3;
            while (n3 < n) {
                double d5 = d2 / (d4 += 1.0);
                d4 = d3 * d4 / (d3 + d4);
                d2 = d4 * d5;
                ++n3;
            }
            dArray[n2] = d2;
        }
        for (n2 = 0; n2 < 1 << n; ++n2) {
            int n4 = n2;
            double d6 = 0.0;
            for (int i = 0; i < n; ++i) {
                d6 += (double)(n4 & 1) * dArray[i];
                n4 >>= 1;
            }
            nArray[n2] = (int)((double)((1 << n) - 1) * d6 + 0.5) & 0xFFFF;
        }
        return nArray;
    }

    private static void cubic_coefficients(double d, double d2, double d3, double d4, double d5, double d6, Coefficients coefficients) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        coefficients.a = (d5 + d6 - 2.0 * d8 / d7) / (d7 * d7);
        coefficients.b = ((d6 - d5) / d7 - 3.0 * (d + d3) * coefficients.a) / 2.0;
        coefficients.c = d5 - (3.0 * d * coefficients.a + 2.0 * coefficients.b) * d;
        coefficients.d = d2 - ((d * coefficients.a + coefficients.b) * d + coefficients.c) * d;
    }

    private static void interpolate_forward_difference(double d, double d2, double d3, double d4, double d5, double d6, PointPlotter pointPlotter, double d7) {
        Coefficients coefficients = new Coefficients();
        DAC.cubic_coefficients(d, d2, d3, d4, d5, d6, coefficients);
        double d8 = ((coefficients.a * d + coefficients.b) * d + coefficients.c) * d + coefficients.d;
        double d9 = (3.0 * coefficients.a * (d + d7) + 2.0 * coefficients.b) * d * d7 + ((coefficients.a * d7 + coefficients.b) * d7 + coefficients.c) * d7;
        double d10 = (6.0 * coefficients.a * (d + d7) + 2.0 * coefficients.b) * d7 * d7;
        double d11 = 6.0 * coefficients.a * d7 * d7 * d7;
        for (double d12 = d; d12 <= d3; d12 += d7) {
            pointPlotter.plot(d12, d8);
            d8 += d9;
            d9 += d10;
            d10 += d11;
        }
    }

    private static double x(int[][] nArray, int n) {
        return nArray[n][0];
    }

    private static double y(int[][] nArray, int n) {
        return nArray[n][1];
    }

    public static void interpolate(int[][] nArray, int n, int n2, int[] nArray2, double d) {
        PointPlotter pointPlotter = new PointPlotter(nArray2);
        int n3 = n;
        int n4 = ++n3;
        int n5 = ++n4;
        ++n5;
        while (n4 != n2) {
            if (DAC.x(nArray, n3) != DAC.x(nArray, n4)) {
                double d2;
                double d3;
                if (DAC.x(nArray, n) == DAC.x(nArray, n3) && DAC.x(nArray, n4) == DAC.x(nArray, n5)) {
                    d2 = d3 = (DAC.y(nArray, n4) - DAC.y(nArray, n3)) / (DAC.x(nArray, n4) - DAC.x(nArray, n3));
                } else if (DAC.x(nArray, n) == DAC.x(nArray, n3)) {
                    d2 = (DAC.y(nArray, n5) - DAC.y(nArray, n3)) / (DAC.x(nArray, n5) - DAC.x(nArray, n3));
                    d3 = (3.0 * (DAC.y(nArray, n4) - DAC.y(nArray, n3)) / (DAC.x(nArray, n4) - DAC.x(nArray, n3)) - d2) / 2.0;
                } else if (DAC.x(nArray, n4) == DAC.x(nArray, n5)) {
                    d3 = (DAC.y(nArray, n4) - DAC.y(nArray, n)) / (DAC.x(nArray, n4) - DAC.x(nArray, n));
                    d2 = (3.0 * (DAC.y(nArray, n4) - DAC.y(nArray, n3)) / (DAC.x(nArray, n4) - DAC.x(nArray, n3)) - d3) / 2.0;
                } else {
                    d3 = (DAC.y(nArray, n4) - DAC.y(nArray, n)) / (DAC.x(nArray, n4) - DAC.x(nArray, n));
                    d2 = (DAC.y(nArray, n5) - DAC.y(nArray, n3)) / (DAC.x(nArray, n5) - DAC.x(nArray, n3));
                }
                DAC.interpolate_forward_difference(DAC.x(nArray, n3), DAC.y(nArray, n3), DAC.x(nArray, n4), DAC.y(nArray, n4), d3, d2, pointPlotter, d);
            }
            ++n;
            ++n3;
            ++n4;
            ++n5;
        }
    }

    private static class Coefficients {
        double a;
        double b;
        double c;
        double d;

        private Coefficients() {
        }
    }

    public static class PointPlotter {
        private final int[] f;

        PointPlotter(int[] nArray) {
            this.f = nArray;
        }

        void plot(double d, double d2) {
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            this.f[(int)d] = (int)(d2 + 0.5);
        }
    }
}

