/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import ucesoft.cbm.Tickable;
import ucesoft.cbm.peripheral.sid.SIDChip;
import ucesoft.cbm.peripheral.sid.resid4.ExternalFilter;
import ucesoft.cbm.peripheral.sid.resid4.SIDModel;
import ucesoft.cbm.peripheral.sid.resid4.SIDfilter;
import ucesoft.cbm.peripheral.sid.resid4.Voice;

public class SID
implements SIDChip {
    private SIDModel current_model;
    public boolean enabled;
    private static final SIDModel MOS_6581 = new SIDModel("6581", 2.2, 896, 522240, false, 0);
    private static final SIDModel MOS_8580 = new SIDModel("8580", 2.0, 2528, 0, true, 1);
    private final Voice[] voices = new Voice[3];
    public final Tickable clock;
    private final int[] register = new int[32];
    private final SIDfilter filter = new SIDfilter();
    private final ExternalFilter extfilt = new ExternalFilter();
    private int bus_value;
    private long bus_clock;
    public int type = 0;

    public SID(Tickable tickable) {
        this.voices[0] = new Voice();
        this.voices[1] = new Voice();
        this.voices[2] = new Voice();
        this.voices[0].setSYNCsource(this.voices[2]);
        this.voices[1].setSYNCsource(this.voices[0]);
        this.voices[2].setSYNCsource(this.voices[1]);
        this.clock = tickable;
        this.setModel(this.type);
    }

    @Override
    public void clock() {
        this.voices[0].envelope.clock();
        this.voices[1].envelope.clock();
        this.voices[2].envelope.clock();
        this.voices[0].wave.clock();
        this.voices[1].wave.clock();
        this.voices[2].wave.clock();
        this.voices[0].wave.synchronize();
        this.voices[1].wave.synchronize();
        this.voices[2].wave.synchronize();
        this.voices[0].wave.set_waveform_output();
        this.voices[1].wave.set_waveform_output();
        this.voices[2].wave.set_waveform_output();
        this.filter.clock(this.voices[0].generate(), this.voices[1].generate(), this.voices[2].generate());
        this.extfilt.clock(this.filter.output());
    }

    @Override
    public final int read(int n) {
        switch (n & 0x1F) {
            case 25: 
            case 26: {
                this.bus_value = 0;
                this.bus_clock = this.clock.currentCycles();
                break;
            }
            case 27: {
                this.bus_value = this.voices[2].wave.readOSC();
                this.bus_clock = this.clock.currentCycles();
                break;
            }
            case 28: {
                this.bus_value = this.voices[2].envelope.readENV();
                this.bus_clock = this.clock.currentCycles();
                break;
            }
            default: {
                this.updateBus();
            }
        }
        return this.bus_value;
    }

    @Override
    public final void write(int n, int n2) {
        this.bus_clock = this.clock.currentCycles();
        int n3 = n2;
        this.register[n &= 0x1F] = n3;
        this.bus_value = n3;
        switch (n) {
            case 0: {
                this.voices[0].wave.writeFREQ_LO(n2);
                break;
            }
            case 1: {
                this.voices[0].wave.writeFREQ_HI(n2);
                break;
            }
            case 2: {
                this.voices[0].wave.writePW_LO(n2);
                break;
            }
            case 3: {
                this.voices[0].wave.writePW_HI(n2);
                break;
            }
            case 4: {
                this.voices[0].envelope.writeCONTROL_REG(n2);
                this.voices[0].wave.writeCONTROL_REG(n2);
                break;
            }
            case 5: {
                this.voices[0].envelope.writeATTACK_DECAY(n2);
                break;
            }
            case 6: {
                this.voices[0].envelope.writeSUSTAIN_RELEASE(n2);
                break;
            }
            case 7: {
                this.voices[1].wave.writeFREQ_LO(n2);
                break;
            }
            case 8: {
                this.voices[1].wave.writeFREQ_HI(n2);
                break;
            }
            case 9: {
                this.voices[1].wave.writePW_LO(n2);
                break;
            }
            case 10: {
                this.voices[1].wave.writePW_HI(n2);
                break;
            }
            case 11: {
                this.voices[1].envelope.writeCONTROL_REG(n2);
                this.voices[1].wave.writeCONTROL_REG(n2);
                break;
            }
            case 12: {
                this.voices[1].envelope.writeATTACK_DECAY(n2);
                break;
            }
            case 13: {
                this.voices[1].envelope.writeSUSTAIN_RELEASE(n2);
                break;
            }
            case 14: {
                this.voices[2].wave.writeFREQ_LO(n2);
                break;
            }
            case 15: {
                this.voices[2].wave.writeFREQ_HI(n2);
                break;
            }
            case 16: {
                this.voices[2].wave.writePW_LO(n2);
                break;
            }
            case 17: {
                this.voices[2].wave.writePW_HI(n2);
                break;
            }
            case 18: {
                this.voices[2].envelope.writeCONTROL_REG(n2);
                this.voices[2].wave.writeCONTROL_REG(n2);
                break;
            }
            case 19: {
                this.voices[2].envelope.writeATTACK_DECAY(n2);
                break;
            }
            case 20: {
                this.voices[2].envelope.writeSUSTAIN_RELEASE(n2);
                break;
            }
            case 21: {
                this.filter.writeFC_LO(n2);
                break;
            }
            case 22: {
                this.filter.writeFC_HI(n2);
                break;
            }
            case 23: {
                this.filter.writeRES_FILT(n2);
                break;
            }
            case 24: {
                this.filter.writeMODE_VOL(n2);
            }
        }
    }

    public void updateBus() {
        if (this.clock.currentCycles() - this.bus_clock > (long)(this.current_model == MOS_8580 ? 663552 : 7424)) {
            this.bus_value = 0;
        }
    }

    @Override
    public void updateBusValue(int n) {
        this.bus_value = n;
    }

    @Override
    public int output() {
        int n = this.extfilt.output() / 11;
        if (n >= 32768) {
            return Short.MAX_VALUE;
        }
        return Math.max(n, Short.MIN_VALUE);
    }

    @Override
    public void setModel(int n) {
        this.type = n;
        if (n == 0) {
            this.current_model = MOS_6581;
        } else if (n == 1) {
            this.current_model = MOS_8580;
        }
        this.voices[0].switch_model(this.current_model);
        this.voices[1].switch_model(this.current_model);
        this.voices[2].switch_model(this.current_model);
        this.filter.set_chip_model(n);
    }

    @Override
    public void reset() {
        this.voices[0].reset();
        this.voices[1].reset();
        this.voices[2].reset();
        this.filter.reset();
        this.extfilt.reset();
        this.bus_value = 0;
    }

    @Override
    public void saveState(ObjectOutputStream objectOutputStream) {
        try {
            this.updateBus();
            objectOutputStream.writeObject(this.register);
            objectOutputStream.writeInt(this.bus_value);
            objectOutputStream.writeLong(this.bus_clock);
            for (Voice voice : this.voices) {
                voice.saveState(objectOutputStream);
            }
            this.filter.saveState(objectOutputStream);
            this.extfilt.saveState(objectOutputStream);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Can't save SID state", throwable);
        }
    }

    @Override
    public void loadState(ObjectInputStream objectInputStream) {
        try {
            int[] nArray = (int[])objectInputStream.readObject();
            for (int i = 0; i < this.register.length; ++i) {
                this.write(i, nArray[i]);
            }
            this.bus_value = objectInputStream.readInt();
            this.bus_clock = objectInputStream.readLong();
            for (Voice voice : this.voices) {
                voice.loadState(objectInputStream);
            }
            this.filter.loadState(objectInputStream);
            this.extfilt.loadState(objectInputStream);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Can't load SID state", throwable);
        }
    }
}

