/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.vic20;

import scala.Enumeration;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import ucesoft.cbm.peripheral.bus.IECBus;
import ucesoft.cbm.peripheral.bus.IECBusLine$;
import ucesoft.cbm.peripheral.bus.IECBusListener;
import ucesoft.cbm.peripheral.c2n.Datassette;
import ucesoft.cbm.peripheral.controlport.ControlPort;
import ucesoft.cbm.peripheral.drive.VIA;
import ucesoft.cbm.peripheral.keyboard.HomeKeyboard;

@ScalaSignature(bytes="\u0006\u0005}4AAD\b\u0001-!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0003A!A!\u0002\u0013i\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011i\u0002!\u0011!Q\u0001\nmB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\t+\u0002A)\u0019!C!-\")q\f\u0001C!A\")\u0001\u000f\u0001C!c\")a\u000f\u0001C\u0001o\")\u0001\u0010\u0001C!s\")A\u0010\u0001C!{\nIa+S\"3aYK\u0017M\r\u0006\u0003!E\tQA^5deAR!AE\n\u0002\u0007\r\u0014WNC\u0001\u0015\u0003\u001d)8-Z:pMR\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0006IJLg/\u001a\u0006\u00039E\t!\u0002]3sSBDWM]1m\u0013\tq\u0012DA\u0002W\u0013\u0006\u000b1AY;t!\t\t3%D\u0001#\u0015\ty2$\u0003\u0002%E\t1\u0011*R\"CkN\f!a\u001b2\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%Z\u0012\u0001C6fs\n|\u0017M\u001d3\n\u0005-B#\u0001\u0004%p[\u0016\\U-\u001f2pCJ$\u0017aC2p]R\u0014x\u000e\u001c)peR\u0004\"AL\u0019\u000e\u0003=R!\u0001M\u000e\u0002\u0017\r|g\u000e\u001e:pYB|'\u000f^\u0005\u0003e=\u00121bQ8oiJ|G\u000eU8si\u0006QA-\u0019;bgN,G\u000f^3\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]Z\u0012aA23]&\u0011\u0011H\u000e\u0002\u000b\t\u0006$\u0018m]:fiR,\u0017!C5sc\u0006\u001bG/[8o!\u0011at(\u0011#\u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005q\u0012\u0015BA\">\u0005\u001d\u0011un\u001c7fC:\u0004\"\u0001P#\n\u0005\u0019k$\u0001B+oSR\f1BY;t\u0019&\u001cH/\u001a8feB\u0011\u0011%S\u0005\u0003\u0015\n\u0012a\"S#D\u0005V\u001cH*[:uK:,'/\u0001\u0004=S:LGO\u0010\u000b\b\u001b>\u0003\u0016KU*U!\tq\u0005!D\u0001\u0010\u0011\u0015yr\u00011\u0001!\u0011\u0015)s\u00011\u0001'\u0011\u0015as\u00011\u0001.\u0011\u0015\u0019t\u00011\u00015\u0011\u0015Qt\u00011\u0001<\u0011\u00159u\u00011\u0001I\u0003-\u0019w.\u001c9p]\u0016tG/\u0013#\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\t1\fgn\u001a\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0016L\u0001\u0004TiJLgnZ\u0001\u0005e\u0016\fG\rF\u0002bI\u001a\u0004\"\u0001\u00102\n\u0005\rl$aA%oi\")Q-\u0003a\u0001C\u00069\u0011\r\u001a3sKN\u001c\bbB4\n!\u0003\u0005\r\u0001[\u0001\u0007G\"L\u0007/\u0013#\u0011\u0005%lgB\u00016l\u001b\u0005\t\u0012B\u00017\u0012\u0003\u0019\u0019\u0005.\u001b9J\t&\u0011an\u001c\u0002\u0003\u0013\u0012S!\u0001\\\t\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0011\u00138/\u001e\u0005\u0006K*\u0001\r!\u0019\u0005\u0006i*\u0001\r!Y\u0001\u0006m\u0006dW/\u001a\u0005\bO*\u0001\n\u00111\u0001i\u0003I!\u0017\r^1tg\u0016$H/\u001a*fC\u0012d\u0015N\\3\u0015\u0003\u0011\u000baaQ!3\u001fV$HC\u0001#{\u0011\u0015YH\u00021\u0001B\u0003\u0015\u0019H/\u0019;f\u0003\u0019\u0019%IM(viR\u0011AI \u0005\u0006w6\u0001\r!\u0011")
public class VIC20Via2
extends VIA {
    private String componentID;
    private final IECBus bus;
    private final HomeKeyboard kb;
    private final ControlPort controlPort;
    private final Datassette datassette;
    private final IECBusListener busListener;
    private volatile boolean bitmap$0;

    private String componentID$lzycompute() {
        VIC20Via2 vIC20Via2 = this;
        synchronized (vIC20Via2) {
            if (!this.bitmap$0) {
                this.componentID = "VIA2 (9120)";
                this.bitmap$0 = true;
            }
        }
        return this.componentID;
    }

    @Override
    public String componentID() {
        if (!this.bitmap$0) {
            return this.componentID$lzycompute();
        }
        return this.componentID;
    }

    @Override
    public int read(int address, Enumeration.Value chipID) {
        int n = address & 0xF;
        switch (n) {
            case 1: 
            case 15: {
                super.read(address, chipID);
                return this.kb.readRow() & (this.regs()[1] | ~this.regs()[3]) & 0xFF;
            }
            case 0: {
                super.read(address, chipID);
                int joy3 = 0x7F | (this.controlPort.readPort() & 8) << 4;
                return this.kb.readCol() & (this.regs()[0] | ~this.regs()[2]) & joy3 & 0xFF;
            }
        }
        return super.read(address, chipID);
    }

    @Override
    public void write(int address, int value, Enumeration.Value chipID) {
        int n = address & 0xF;
        switch (n) {
            case 1: 
            case 15: {
                super.write(address, value, chipID);
                this.kb.selectRow(value);
                return;
            }
            case 0: {
                super.write(address, value, chipID);
                this.kb.selectCol(value);
                this.datassette.setWriteLine((value & 8) > 0);
                return;
            }
        }
        super.write(address, value, chipID);
    }

    public void datassetteReadLine() {
        this.irq_set(2);
    }

    @Override
    public void CA2Out(boolean state) {
        this.bus.setLine(this.busListener, IECBusLine$.MODULE$.CLK(), state ? 1 : 0);
    }

    @Override
    public void CB2Out(boolean state) {
        this.bus.setLine(this.busListener, IECBusLine$.MODULE$.DATA(), state ? 1 : 0);
    }

    public VIC20Via2(IECBus bus, HomeKeyboard kb, ControlPort controlPort, Datassette datassette, Function1<Object, BoxedUnit> irqAction, IECBusListener busListener) {
        this.bus = bus;
        this.kb = kb;
        this.controlPort = controlPort;
        this.datassette = datassette;
        this.busListener = busListener;
        super("VIA_2", 37152, irqAction);
    }
}

