/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.c64;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import ucesoft.cbm.C64Model$;
import ucesoft.cbm.CBMComponent;
import ucesoft.cbm.CBMComponentType$;
import ucesoft.cbm.CBMComputerModel;
import ucesoft.cbm.CBMHomeComputer;
import ucesoft.cbm.Log$;
import ucesoft.cbm.Version$;
import ucesoft.cbm.c64.C64$;
import ucesoft.cbm.c64.C64MMU;
import ucesoft.cbm.c64.C64VICMemory;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.expansion.ExpansionPort$;
import ucesoft.cbm.expansion.WiC64$;
import ucesoft.cbm.formats.ProgramLoader$;
import ucesoft.cbm.misc.DisplayEffectPanel$;
import ucesoft.cbm.misc.GIFPanel$;
import ucesoft.cbm.misc.Preferences$;
import ucesoft.cbm.misc.Preferences$BooleanPreferenceConv$;
import ucesoft.cbm.misc.ROMPanel$;
import ucesoft.cbm.misc.RS232ConfigPanel$;
import ucesoft.cbm.misc.VolumeSettingsPanel;
import ucesoft.cbm.misc.WiC64Panel;
import ucesoft.cbm.peripheral.bus.BusSnoop;
import ucesoft.cbm.peripheral.c2n.Datassette;
import ucesoft.cbm.peripheral.cia.CIA;
import ucesoft.cbm.peripheral.cia.CIA$;
import ucesoft.cbm.peripheral.cia.CIA1Connectors;
import ucesoft.cbm.peripheral.cia.CIA2Connectors;
import ucesoft.cbm.peripheral.controlport.ControlPort$;
import ucesoft.cbm.peripheral.drive.DriveType$;
import ucesoft.cbm.peripheral.drive.ParallelCable$;
import ucesoft.cbm.peripheral.keyboard.HomeKeyboard$;
import ucesoft.cbm.peripheral.vic.Display;
import ucesoft.cbm.peripheral.vic.Display$;
import ucesoft.cbm.peripheral.vic.VICType$;
import ucesoft.cbm.peripheral.vic.VIC_II;
import ucesoft.cbm.peripheral.vic.VIC_II$;
import ucesoft.cbm.peripheral.vic.coprocessor.VICCoprocessor;
import ucesoft.cbm.peripheral.vic.renderer.DriveRenderer;
import ucesoft.cbm.trace.Tracer;

@ScalaSignature(bytes="\u0006\u0005\u0005]x!\u0002\u0017.\u0011\u0003!d!\u0002\u001c.\u0011\u00039\u0004\"B!\u0002\t\u0003\u0011e\u0001\u0002\u001c.\u0001\rCQ!Q\u0002\u0005\u0002!CqAS\u0002C\u0002\u0013E3\n\u0003\u0004P\u0007\u0001\u0006I\u0001\u0014\u0005\b!\u000e\u0011\r\u0011\"\u0001R\u0011\u0019Q6\u0001)A\u0005%\"91l\u0001b\u0001\n\u0003a\u0006BB6\u0004A\u0003%Q\fC\u0004m\u0007\t\u0007I\u0011C)\t\r5\u001c\u0001\u0015!\u0003S\u0011\u001dq7A1A\u0005\u0012ECaa\\\u0002!\u0002\u0013\u0011\u0006b\u00029\u0004\u0005\u0004%\t\"\u0015\u0005\u0007c\u000e\u0001\u000b\u0011\u0002*\t\u000fI\u001c!\u0019!C\tg\"11p\u0001Q\u0001\nQDq\u0001`\u0002C\u0002\u0013EQ\u0010C\u0004\u0002\u000e\r\u0001\u000b\u0011\u0002@\t\u0013\u0005=1\u00011A\u0005\u0012\u0005E\u0001\"CA\r\u0007\u0001\u0007I\u0011CA\u000e\u0011!\t9c\u0001Q!\n\u0005M\u0001\u0002CA\u0015\u0007\u0001\u0006I!a\u000b\t\u000f\u0005E2\u0001\"\u0001\u00024!9\u0011QG\u0002\u0005\u0002\u0005M\u0002bBA\u001c\u0007\u0011E\u0011\u0011\b\u0005\b\u0003\u000b\u001aA\u0011CA$\u0011\u001d\tie\u0001C\u0005\u0003\u001fBq!!\u0016\u0004\t\u0003\n\t\u0002C\u0004\u0002X\r!\t&!\u0017\t\u000f\u000554\u0001\"\u0003\u00024!9\u0011qN\u0002\u0005\u0012\u0005E\u0004bBAD\u0007\u0011%\u00111\u0007\u0005\b\u0003\u0013\u001bA\u0011CAF\u0011\u001d\t\tk\u0001C)\u0003gAq!a)\u0004\t#\t)\u000bC\u0004\u0002,\u000e!\t\"!,\t\u000f\u0005m6\u0001\"\u0005\u0002.\"9\u0011QX\u0002\u0005\u0012\u0005}\u0006bBAf\u0007\u0011E\u0011Q\u001a\u0005\b\u00033\u001cA\u0011CA\t\u0011\u001d\tYn\u0001C\u0001\u0003;\f1a\u0011\u001c5\u0015\tqs&A\u0002dmQR!\u0001M\u0019\u0002\u0007\r\u0014WNC\u00013\u0003\u001d)8-Z:pMR\u001c\u0001\u0001\u0005\u00026\u00035\tQFA\u0002DmQ\u001a2!\u0001\u001d?!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fMB\u0011\u0011hP\u0005\u0003\u0001j\u00121!\u00119q\u0003\u0019a\u0014N\\5u}Q\tAg\u0005\u0002\u0004\tB\u0011QIR\u0007\u0002_%\u0011qi\f\u0002\u0010\u0007\nk\u0005j\\7f\u0007>l\u0007/\u001e;feR\t\u0011\n\u0005\u00026\u0007\u0005A1MY7N_\u0012,G.F\u0001M!\t)U*\u0003\u0002O_\t\u00012IQ'D_6\u0004X\u000f^3s\u001b>$W\r\\\u0001\nG\nlWj\u001c3fY\u0002\n1bY8na>tWM\u001c;J\tV\t!\u000b\u0005\u0002T16\tAK\u0003\u0002V-\u0006!A.\u00198h\u0015\u00059\u0016\u0001\u00026bm\u0006L!!\u0017+\u0003\rM#(/\u001b8h\u00031\u0019w.\u001c9p]\u0016tG/\u0013#!\u00035\u0019w.\u001c9p]\u0016tG\u000fV=qKV\tQ\f\u0005\u0002_Q:\u0011qL\u001a\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!aY\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u0001\u00192\u0013\t9w&\u0001\tD\u00056\u001bu.\u001c9p]\u0016tG\u000fV=qK&\u0011\u0011N\u001b\u0002\u0005)f\u0004XM\u0003\u0002h_\u0005q1m\\7q_:,g\u000e\u001e+za\u0016\u0004\u0013\u0001E!Q!2K5)\u0011+J\u001f:{f*Q'F\u0003E\t\u0005\u000b\u0015'J\u0007\u0006#\u0016j\u0014(`\u001d\u0006kU\tI\u0001\u0017\u0007>se)S$V%\u0006#\u0016j\u0014(`\r&cUIT!N\u000b\u000692i\u0014(G\u0013\u001e+&+\u0011+J\u001f:{f)\u0013'F\u001d\u0006kU\tI\u0001\u001f\t\u00163\u0015)\u0016'U?.+\u0015LQ(B%\u0012{&+R*P+J\u001bUi\u0018(B\u001b\u0016\u000bq\u0004R#G\u0003VcEkX&F3\n{\u0015I\u0015#`%\u0016\u001bv*\u0016*D\u000b~s\u0015)T#!\u0003\riW.^\u000b\u0002iB\u0011Q\u000f\u001f\b\u0003kYL!a^\u0017\u0002\r\r3D'T'V\u0013\tI(PA\u0006N\u0003&su,T#N\u001fJK&BA<.\u0003\u0011iW.\u001e\u0011\u0002\u0015\t,8o\u00158p_B,'/F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005\u0019!-^:\u000b\u0007\u0005\u001dq&\u0001\u0006qKJL\u0007\u000f[3sC2LA!a\u0003\u0002\u0002\tA!)^:T]>|\u0007/A\u0006ckN\u001cfn\\8qKJ\u0004\u0013\u0001\u00052vgNswn\u001c9fe\u0006\u001bG/\u001b<f+\t\t\u0019\u0002E\u0002:\u0003+I1!a\u0006;\u0005\u001d\u0011un\u001c7fC:\fACY;t':|w\u000e]3s\u0003\u000e$\u0018N^3`I\u0015\fH\u0003BA\u000f\u0003G\u00012!OA\u0010\u0013\r\t\tC\u000f\u0002\u0005+:LG\u000fC\u0005\u0002&Y\t\t\u00111\u0001\u0002\u0014\u0005\u0019\u0001\u0010J\u0019\u0002#\t,8o\u00158p_B,'/Q2uSZ,\u0007%A\u0005wS\u000elU-\\8ssB\u0019Q'!\f\n\u0007\u0005=RF\u0001\u0007DmQ2\u0016jQ'f[>\u0014\u00180A\u0003sKN,G\u000f\u0006\u0002\u0002\u001e\u0005!\u0011N\\5u\u0003!i\u0017-\u001b8M_>\u0004H\u0003BA\u000f\u0003wAq!!\u0010\u001c\u0001\u0004\ty$\u0001\u0004ds\u000edWm\u001d\t\u0004s\u0005\u0005\u0013bAA\"u\t!Aj\u001c8h\u0003\u0019\u0019X\r\u001e#N\u0003R!\u0011QDA%\u0011\u001d\tY\u0005\ba\u0001\u0003'\t1\u0001Z7b\u0003\u0015\u0011\u0017\rT8x)\u0011\ti\"!\u0015\t\u000f\u0005MS\u00041\u0001\u0002\u0014\u0005\u0019An\\<\u0002\u0015%\u001c\b*Z1eY\u0016\u001c8/A\u0006f]\u0006\u0014G.\u001a#sSZ,G\u0003CA\u000f\u00037\n)'!\u001b\t\u000f\u0005us\u00041\u0001\u0002`\u0005\u0011\u0011\u000e\u001a\t\u0004s\u0005\u0005\u0014bAA2u\t\u0019\u0011J\u001c;\t\u000f\u0005\u001dt\u00041\u0001\u0002\u0014\u00059QM\\1cY\u0016$\u0007bBA6?\u0001\u0007\u00111C\u0001\fkB$\u0017\r^3Ge\u0006lW-A\u0006bI*,8\u000f\u001e*bi&|\u0017a\u00037pC\u0012\u0004&k\u0012$jY\u0016$b!!\b\u0002t\u0005\r\u0005bBA;C\u0001\u0007\u0011qO\u0001\u0005M&dW\r\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiHV\u0001\u0003S>LA!!!\u0002|\t!a)\u001b7f\u0011\u001d\t))\ta\u0001\u0003'\tq!Y;u_J,h.\u0001\u0007uC.,7K\\1qg\"|G/A\btKR\u001cV\r\u001e;j]\u001e\u001cX*\u001a8v)\u0011\ti\"!$\t\u000f\u0005=5\u00051\u0001\u0002\u0012\u0006Qq\u000e\u001d;j_:lUM\\;\u0011\t\u0005M\u0015QT\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006)1o^5oO*\u0011\u00111T\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003?\u000b)JA\u0003K\u001b\u0016tW/A\u000etKR<En\u001c2bY\u000e{W.\\1oI2Kg.Z(qi&|gn]\u0001\rg\u00064XmU3ui&twm\u001d\u000b\u0005\u0003;\t9\u000bC\u0004\u0002*\u0016\u0002\r!a\u0005\u0002\tM\fg/Z\u0001\u0007O\u0016$(+Q'\u0016\u0005\u0005=\u0006\u0003BAY\u0003ok!!a-\u000b\u0007\u0005Uv&A\u0002daVLA!!/\u00024\n1Q*Z7pef\f!bZ3u\u0007\"\f'OU(N\u0003%\u0019\u0018M^3Ti\u0006$X\r\u0006\u0003\u0002\u001e\u0005\u0005\u0007bBAbQ\u0001\u0007\u0011QY\u0001\u0004_V$\b\u0003BA=\u0003\u000fLA!!3\u0002|\t\u0011rJ\u00196fGR|U\u000f\u001e9viN#(/Z1n\u0003%aw.\u00193Ti\u0006$X\r\u0006\u0003\u0002\u001e\u0005=\u0007bBAiS\u0001\u0007\u00111[\u0001\u0003S:\u0004B!!\u001f\u0002V&!\u0011q[A>\u0005Ey%M[3di&s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0015C2dwn^:Ti\u0006$XMU3ti>\u0014\u0018N\\4\u0002\rQ,(O\\(o)\u0011\ti\"a8\t\u000f\u0005\u00058\u00061\u0001\u0002d\u0006!\u0011M]4t!\u0015I\u0014Q]Au\u0013\r\t9O\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003W\f\u0019P\u0004\u0003\u0002n\u0006=\bCA1;\u0013\r\t\tPO\u0001\u0007!J,G-\u001a4\n\u0007e\u000b)PC\u0002\u0002rj\u0002")
public class C64
extends CBMHomeComputer {
    private final CBMComputerModel cbmModel = C64Model$.MODULE$;
    private final String componentID;
    private final Enumeration.Value componentType = CBMComponentType$.MODULE$.INTERNAL();
    private final String APPLICATION_NAME;
    private final String CONFIGURATION_FILENAME;
    private final String DEFAULT_KEYBOARD_RESOURCE_NAME;
    private final C64MMU.MAIN_MEMORY mmu = new C64MMU.MAIN_MEMORY();
    private final BusSnoop busSnooper = new BusSnoop(this.bus());
    private boolean busSnooperActive = false;
    private final C64VICMemory vicMemory = new C64VICMemory(this.mmu(), this.mmu().CHAR_ROM(), this.cpu());

    public static void main(String[] args) {
        C64$.MODULE$.main(args);
    }

    public static void delayedInit(Function0<BoxedUnit> body2) {
        C64$.MODULE$.delayedInit(body2);
    }

    public static long executionStart() {
        return C64$.MODULE$.executionStart();
    }

    @Override
    public CBMComputerModel cbmModel() {
        return this.cbmModel;
    }

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public Enumeration.Value componentType() {
        return this.componentType;
    }

    @Override
    public String APPLICATION_NAME() {
        return this.APPLICATION_NAME;
    }

    @Override
    public String CONFIGURATION_FILENAME() {
        return this.CONFIGURATION_FILENAME;
    }

    @Override
    public String DEFAULT_KEYBOARD_RESOURCE_NAME() {
        return this.DEFAULT_KEYBOARD_RESOURCE_NAME;
    }

    @Override
    public C64MMU.MAIN_MEMORY mmu() {
        return this.mmu;
    }

    public BusSnoop busSnooper() {
        return this.busSnooper;
    }

    public boolean busSnooperActive() {
        return this.busSnooperActive;
    }

    public void busSnooperActive_$eq(boolean x$1) {
        this.busSnooperActive = x$1;
    }

    @Override
    public void reset() {
        this.dma_$eq(false);
        this.clock().maximumSpeed_$eq(false);
        this.maxSpeedItem().setSelected(false);
        ProgramLoader$.MODULE$.reset();
        this.cia12Running()[0] = true;
        this.cia12Running()[1] = true;
    }

    @Override
    public void init() {
        Log$.MODULE$.setInfo();
        Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> "Building the system ...");
        RS232ConfigPanel$.MODULE$.registerAvailableRS232Drivers(this.displayFrame(), this.AVAILABLE_RS232());
        ExpansionPort$.MODULE$.addConfigurationListener(this.mmu());
        this.initializedDrives(DriveType$.MODULE$._1541());
        ProgramLoader$.MODULE$.cpu_$eq(this.cpu());
        ProgramLoader$.MODULE$.warpModeListener_$eq((Function1<Object, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            this.warpMode(BoxesRunTime.unboxToBoolean((Object)x$1), true);
            return BoxedUnit.UNIT;
        });
        this.add(this.clock());
        this.add(this.mmu());
        this.add((CBMComponent)((Object)this.cpu()));
        this.add(this.keyb());
        this.add(this.controlPortA());
        this.add(this.controlPortB());
        this.add(this.bus());
        this.add(this.expansionPort());
        this.add(this.rs232());
        this.add(this.vicMemory);
        ExpansionPort$.MODULE$.setMemoryForEmptyExpansionPort(this.vicMemory);
        ExpansionPort$.MODULE$.addConfigurationListener(this.vicMemory);
        CIA1Connectors.PortAConnector cia1CP1 = new CIA1Connectors.PortAConnector(this.keyb(), this.controlPortA());
        CIA1Connectors.PortBConnector cia1CP2 = new CIA1Connectors.PortBConnector(this.keyb(), this.controlPortB(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.vicChip().triggerLightPen());
        this.add(cia1CP1);
        this.add(cia1CP2);
        this.add(this.irqSwitcher());
        this.cia1_$eq(new CIA("CIA1", 56320, cia1CP1, cia1CP2, (Function1<Object, BoxedUnit>)(Function1 & Serializable)x$2 -> {
            C64.$anonfun$init$4(this, BoxesRunTime.unboxToBoolean((Object)x$2));
            return BoxedUnit.UNIT;
        }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)idle -> {
            this.cia12Running()[0] = !BoxesRunTime.unboxToBoolean((Object)idle);
            return BoxedUnit.UNIT;
        }, CIA$.MODULE$.$lessinit$greater$default$7()));
        CIA2Connectors.PortAConnector cia2CP1 = new CIA2Connectors.PortAConnector(this.vicMemory, this.bus(), this.rs232());
        CIA2Connectors.PortBConnector cia2CP2 = new CIA2Connectors.PortBConnector(this.rs232());
        this.add(cia2CP1);
        this.add(cia2CP2);
        this.add(this.nmiSwitcher());
        this.cia2_$eq(new CIA("CIA2", 56576, cia2CP1, cia2CP2, (Function1<Object, BoxedUnit>)(Function1 & Serializable)x$3 -> {
            C64.$anonfun$init$6(this, BoxesRunTime.unboxToBoolean((Object)x$3));
            return BoxedUnit.UNIT;
        }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)idle -> {
            this.cia12Running()[1] = !BoxesRunTime.unboxToBoolean((Object)idle);
            return BoxedUnit.UNIT;
        }, CIA$.MODULE$.$lessinit$greater$default$7()));
        CIA cIA = this.cia2();
        WiC64$.MODULE$.flag2Action_$eq((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cIA.setFlagLow());
        this.wic64Panel_$eq(new WiC64Panel(this.displayFrame(), this.preferences()));
        WiC64$.MODULE$.setListener(this.wic64Panel());
        this.add(WiC64$.MODULE$);
        CIA cIA2 = this.cia2();
        this.rs232().setBitReceivedListener((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cIA2.setFlagLow());
        CIA cIA3 = this.cia2();
        ParallelCable$.MODULE$.ca2Callback_$eq((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cIA3.setFlagLow());
        this.add(ParallelCable$.MODULE$);
        this.vicChip_$eq(new VIC_II(this.vicMemory, this.mmu().COLOR_RAM(), (Function1<Object, BoxedUnit>)(Function1 & Serializable)x$4 -> {
            C64.$anonfun$init$11(this, BoxesRunTime.unboxToBoolean((Object)x$4));
            return BoxedUnit.UNIT;
        }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)low -> {
            this.baLow(BoxesRunTime.unboxToBoolean((Object)low));
            return BoxedUnit.UNIT;
        }, VIC_II$.MODULE$.$lessinit$greater$default$5()));
        this.mmu().setLastByteReadMemory(this.vicMemory);
        this.mmu().setIO(this.cia1(), this.cia2(), this.sid(), this.vicChip());
        this.display_$eq(new Display(this.vicChip().SCREEN_WIDTH(), this.vicChip().SCREEN_HEIGHT(), this.displayFrame().getTitle(), this.displayFrame(), Display$.MODULE$.$lessinit$greater$default$5()));
        this.add(this.display());
        this.display().setPreferredSize(new Dimension(this.vicChip().VISIBLE_SCREEN_WIDTH(), this.vicChip().VISIBLE_SCREEN_HEIGHT()));
        this.vicChip().setDisplay(this.display());
        this.displayFrame().getContentPane().add("Center", this.display());
        this.displayFrame().addKeyListener(this);
        this.display().addMouseListener((MouseListener)((Object)this.keypadControlPort()));
        this.display().addMouseListener((MouseListener)((Object)ControlPort$.MODULE$.emptyControlPort()));
        CBMHomeComputer.LightPenButtonListener lightPen = new CBMHomeComputer.LightPenButtonListener();
        this.add(lightPen);
        this.display().addMouseListener(lightPen);
        this.configureJoystick();
        if (this.headless()) {
            Log$.MODULE$.setOutput(null);
        }
        CIA cIA4 = this.cia1();
        this.datassette_$eq(new Datassette((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cIA4.setFlagLow()));
        this.mmu().setDatassette(this.datassette());
        this.add(this.datassette());
        this.add(this.printer());
        this.add(this.flyerIEC());
        this.displayFrame().getContentPane().add("South", this.makeInfoPanel(true));
        this.displayFrame().setTransferHandler(this.DNDHandler());
        this.gifRecorder_$eq(GIFPanel$.MODULE$.createGIFPanel(this.displayFrame(), (Display[])((Object[])new Display[]{this.display()}), (String[])((Object[])new String[]{"VIC"})));
        this.tracer().addDevice(new Tracer.TracedDevice("Main 6510 CPU", this.mmu(), this.cpu(), true));
        this.tracer().setDisplay(new Tracer.TracedDisplay(this){
            private final /* synthetic */ C64 $outer;

            public Tuple2<Object, Object> getRasterLineAndCycle() {
                return new Tuple2.mcII.sp(this.$outer.vicChip().getRasterLine(), this.$outer.vicChip().getRasterCycle());
            }

            public void setDisplayRasterLine(int line) {
                this.$outer.display().setRasterLineAt(line);
            }

            public void enableDisplayRasterLine(boolean enabled) {
                this.$outer.display().setDrawRasterLine(enabled);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void mainLoop(long cycles) {
        this.vicChip().clock();
        if (this.cia12Running()[0]) {
            this.cia1().clock(false);
        }
        if (this.cia12Running()[1]) {
            this.cia2().clock(false);
        }
        for (int d = 0; d < this.TOTAL_DRIVES(); ++d) {
            if (!this.drivesEnabled()[d] || !this.drivesRunning()[d]) continue;
            this.drives()[d].clock(cycles);
        }
        if (this.device12DriveEnabled()) {
            this.device12Drive().clock(cycles);
        }
        if (this.busSnooperActive()) {
            this.busSnooper().clock(cycles);
        }
        if (this.printerEnabled()) {
            this.printer().clock(cycles);
        }
        if (this.isFlyerEnabled()) {
            this.flyerIEC().clock(cycles);
        }
        if (this.cartButtonRequested() && this.cpu().isFetchingInstruction()) {
            this.cartButtonRequested_$eq(false);
            ExpansionPort$.MODULE$.getExpansionPort().freezeButton();
        }
        ProgramLoader$.MODULE$.checkLoadingInWarpMode(this.cbmModel(), true);
        this.cpu().fetchAndExecute(1);
        if (this.sidCycleExact()) {
            this.sid().clock();
            return;
        }
    }

    @Override
    public void setDMA(boolean dma) {
        this.dma_$eq(dma);
        this.cpu().setDMA(dma);
    }

    private void baLow(boolean low) {
        this.cpu().setBaLow(low);
        this.expansionPort().setBaLow(low);
    }

    @Override
    public boolean isHeadless() {
        return this.headless();
    }

    @Override
    public void enableDrive(int id, boolean enabled, boolean updateFrame) {
        super.enableDrive(id, enabled, updateFrame);
        if (updateFrame) {
            this.adjustRatio();
            return;
        }
    }

    private void adjustRatio() {
        Dimension dim = this.display().getSize();
        dim.height = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)dim.width / this.vicChip().SCREEN_ASPECT_RATIO()));
        this.display().setPreferredSize(dim);
        this.displayFrame().pack();
    }

    @Override
    public void loadPRGFile(File file, boolean autorun) {
        Tuple2<Object, Object> tuple2 = ProgramLoader$.MODULE$.loadPRG(this.mmu(), file, true, 8, ProgramLoader$.MODULE$.loadPRG$default$5());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int start = tuple2._1$mcI$sp();
        int end = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(start, end);
        int start2 = sp2._1$mcI$sp();
        int end2 = sp2._2$mcI$sp();
        Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("BASIC program loaded from ").append(start2).append(" to ").append(end2).toString());
        this.configuration().setProperty(this.CONFIGURATION_LASTDISKDIR(), file.getParentFile().toString());
        if (autorun) {
            HomeKeyboard$.MODULE$.insertSmallTextIntoKeyboardBuffer(new StringBuilder(14).append("RUN").append('\r').toString(), this.mmu(), true);
            return;
        }
    }

    private void takeSnapshot() {
        JFileChooser fc = new JFileChooser();
        int n = fc.showSaveDialog(this.displayFrame());
        switch (n) {
            case 0: {
                File file = fc.getSelectedFile().getName().toUpperCase().endsWith(".PNG") ? fc.getSelectedFile() : new File(new StringBuilder(4).append(fc.getSelectedFile().toString()).append(".png").toString());
                this.display().saveSnapshot(file);
                return;
            }
        }
    }

    @Override
    public void setSettingsMenu(JMenu optionMenu) {
        this.setDriveMenu(optionMenu);
        optionMenu.addSeparator();
        JMenuItem keybEditorItem = new JMenuItem("Keyboard settings ...");
        keybEditorItem.addActionListener(x$6 -> this.showKeyboardSettings());
        optionMenu.add(keybEditorItem);
        JMenuItem keybEditor = new JMenuItem("Keyboard editor/virtual keyboard ...");
        optionMenu.add(keybEditor);
        keybEditor.addActionListener(x$7 -> {
            keybEditor.setEnabled(false);
            this.showKeyboardEditor(keybEditor);
        });
        optionMenu.addSeparator();
        this.setVolumeSettings(optionMenu);
        optionMenu.addSeparator();
        this.setWarpModeSettings(optionMenu);
        optionMenu.addSeparator();
        JMenuItem adjustRatioItem = new JMenuItem("Adjust display ratio");
        adjustRatioItem.setAccelerator(KeyStroke.getKeyStroke(65, 512));
        adjustRatioItem.addActionListener(x$8 -> this.adjustRatio());
        optionMenu.add(adjustRatioItem);
        JMenu zoomItem = new JMenu("Zoom");
        ButtonGroup groupZ = new ButtonGroup();
        optionMenu.add(zoomItem);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)z -> {
            int n;
            JRadioButtonMenuItem zoom1Item = new JRadioButtonMenuItem(new StringBuilder(7).append("Zoom x ").append(z).toString());
            zoom1Item.addActionListener(x$9 -> this.vicZoom(z));
            int n2 = z;
            switch (n2) {
                case 1: {
                    n = 49;
                    break;
                }
                case 2: {
                    n = 50;
                    break;
                }
                case 3: {
                    n = 51;
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                }
            }
            int kea = n;
            zoom1Item.setAccelerator(KeyStroke.getKeyStroke(kea, 512));
            zoomItem.add(zoom1Item);
            groupZ.add(zoom1Item);
        });
        JMenu vicItem = new JMenu("VIC");
        optionMenu.add(vicItem);
        this.setRenderingSettings(vicItem, this.setRenderingSettings$default$2());
        JMenuItem vicDisplayEffectsItem = new JMenuItem("VIC's display effects ...");
        vicItem.add(vicDisplayEffectsItem);
        vicDisplayEffectsItem.addActionListener(x$10 -> DisplayEffectPanel$.MODULE$.createDisplayEffectPanel(this.displayFrame(), this.display(), "VIC").setVisible(true));
        this.setVICModel(vicItem);
        this.setVICBorderMode(vicItem);
        this.setFullScreenSettings(optionMenu);
        this.setOneFrameMode(vicItem, (Function0<Display>)(Function0 & Serializable)() -> this.display(), 78, this.setOneFrameMode$default$4());
        optionMenu.addSeparator();
        this.setJoysticsSettings(optionMenu);
        this.setLightPenSettings(optionMenu, this.setLightPenSettings$default$2());
        this.setMouseSettings(optionMenu);
        optionMenu.addSeparator();
        JMenuItem snapshotItem = new JMenuItem("Take a snapshot...");
        snapshotItem.setAccelerator(KeyStroke.getKeyStroke(83, 512));
        snapshotItem.addActionListener(x$11 -> this.takeSnapshot());
        optionMenu.add(snapshotItem);
        JMenuItem gifRecorderItem = new JMenuItem("GIF recorder...");
        gifRecorderItem.setAccelerator(KeyStroke.getKeyStroke(70, 512));
        gifRecorderItem.addActionListener(x$12 -> this.openGIFRecorder());
        optionMenu.add(gifRecorderItem);
        optionMenu.addSeparator();
        this.setPauseSettings(optionMenu);
        optionMenu.addSeparator();
        this.setPrinterSettings(optionMenu);
        optionMenu.addSeparator();
        this.setSIDSettings(optionMenu);
        optionMenu.addSeparator();
        this.setDrivesSettings();
        JCheckBoxMenuItem busSnooperActiveItem = new JCheckBoxMenuItem("Bus snoop active");
        busSnooperActiveItem.setSelected(false);
        busSnooperActiveItem.addActionListener(e -> this.busSnooperActive_$eq(((JCheckBoxMenuItem)e.getSource()).isSelected()));
        optionMenu.add(busSnooperActiveItem);
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> {
            busSnooperActiveItem.setSelected(false);
            this.busSnooperActive_$eq(false);
        };
        this.resetSettingsActions_$eq((List<Function0<BoxedUnit>>)this.resetSettingsActions().$colon$colon((Object)intersect));
        optionMenu.addSeparator();
        this.setRemotingSettings(optionMenu);
        optionMenu.addSeparator();
        JMenu IOItem = new JMenu("I/O");
        optionMenu.add(IOItem);
        optionMenu.addSeparator();
        JMenuItem rs232Item = new JMenuItem("RS-232 ...");
        rs232Item.addActionListener(x$13 -> this.manageRS232());
        IOItem.add(rs232Item);
        IOItem.addSeparator();
        this.setFlyerSettings(IOItem);
        this.setWiC64Settings(IOItem);
        this.setREUSettings(IOItem);
        this.setGEORamSettings(IOItem);
        this.setRAMCartSettings(IOItem);
        this.setIsepicSettings(IOItem);
        this.setBeamRacerSettings(IOItem);
        IOItem.addSeparator();
        this.setDigiMAXSettings(IOItem);
        IOItem.addSeparator();
        this.setGMOD3FlashSettings(IOItem);
        this.setEasyFlashSettings(IOItem);
        IOItem.addSeparator();
        this.setCPMSettings(IOItem);
        IOItem.addSeparator();
        JCheckBoxMenuItem ren = new JCheckBoxMenuItem("FreeSpin cable enabled");
        IOItem.add(ren);
        ren.addActionListener(x$14 -> {
            this.clock().pause();
            DriveRenderer rend = ren.isSelected() ? new DriveRenderer(this.bus(), this.display(), (VolumeSettingsPanel.VolumeSetting)((Object)this.volumeDialog())) : null;
            ((VIC_II)this.vicChip()).setExternalRenderer(rend);
            this.clock().play();
        });
        JMenuItem romItem = new JMenuItem("ROMs ...");
        optionMenu.add(romItem);
        romItem.addActionListener(x$15 -> {
            this.clock().pause();
            ROMPanel$.MODULE$.showROMPanel(this.displayFrame(), this.configuration(), this.cbmModel(), false, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.saveSettings(false);
                this.reset(false, this.reset$default$2());
            });
            this.clock().play();
        });
    }

    @Override
    public void setGlobalCommandLineOptions() {
        super.setGlobalCommandLineOptions();
        this.preferences().add(Preferences$.MODULE$.PREF_CUSTOMGLUELOGIC(), "Set internal glue logic to custom (C64C)", BoxesRunTime.boxToBoolean((boolean)false), this.preferences().add$default$4(), this.preferences().add$default$5(), (Function1 & Serializable)x$16 -> {
            this.vicMemory.setCustomGlueLogic(BoxesRunTime.unboxToBoolean((Object)x$16));
            return BoxedUnit.UNIT;
        }, Preferences$BooleanPreferenceConv$.MODULE$);
        this.preferences().add(Preferences$.MODULE$.PREF_VICIINEW(), "Set VICII new model", BoxesRunTime.boxToBoolean((boolean)false), this.preferences().add$default$4(), this.preferences().add$default$5(), (Function1 & Serializable)x$17 -> {
            C64.$anonfun$setGlobalCommandLineOptions$2(this, BoxesRunTime.unboxToBoolean((Object)x$17));
            return BoxedUnit.UNIT;
        }, Preferences$BooleanPreferenceConv$.MODULE$);
    }

    @Override
    public void saveSettings(boolean save) {
        if (!this.ignoreConfig()) {
            Object object;
            if (!this.zoomOverride()) {
                Dimension dimension = this.display().getSize();
                object = this.configuration().setProperty(this.CONFIGURATION_FRAME_DIM(), new StringBuilder(1).append(dimension.width).append(",").append(dimension.height).toString());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.configuration().setProperty(this.CONFIGURATION_FRAME_XY(), new StringBuilder(1).append(this.displayFrame().getX()).append(",").append(this.displayFrame().getY()).toString());
            if (save) {
                this.preferences().save(this.configuration());
                Predef$.MODULE$.println((Object)"Settings saved");
            }
            this.saveConfigurationFile();
            return;
        }
    }

    @Override
    public Memory getRAM() {
        return this.mmu().getRAM();
    }

    @Override
    public Memory getCharROM() {
        return this.mmu().CHAR_ROM();
    }

    @Override
    public void saveState(ObjectOutputStream out) {
        out.writeBoolean(this.drivesEnabled()[0]);
        out.writeBoolean(this.drivesEnabled()[1]);
        out.writeBoolean(this.printerEnabled());
        out.writeObject(this.vicChip().getVICModel().VIC_TYPE().toString());
        Option<VICCoprocessor> option = this.vicChip().getCoprocessor();
        if (None$.MODULE$.equals(option)) {
            out.writeBoolean(false);
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            VICCoprocessor cop = (VICCoprocessor)some.value();
            out.writeBoolean(true);
            out.writeObject(cop.componentID());
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void loadState(ObjectInputStream in) {
        block3: {
            block4: {
                this.drivesEnabled()[0] = in.readBoolean();
                this.drivesEnabled()[1] = in.readBoolean();
                this.printerEnabled_$eq(in.readBoolean());
                Enumeration.Value vicModel = VICType$.MODULE$.withName(in.readObject().toString());
                this.setVICModel(vicModel, false, false, false);
                if (!in.readBoolean()) break block3;
                String string = in.readObject().toString();
                switch (string == null ? 0 : string.hashCode()) {
                    case 81441819: {
                        if (!"VASYL".equals(string)) break;
                        this.preferences().update(Preferences$.MODULE$.PREF_BEAMRACERENABLED(), BoxesRunTime.boxToBoolean((boolean)true));
                        break block4;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder(20).append("Coprocessor ").append(string).append(" unknown").toString());
            }
            return;
        }
    }

    @Override
    public boolean allowsStateRestoring() {
        return true;
    }

    @Override
    public void turnOn(String[] args) {
        this.swing((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.setMenu());
        if (this.preferences().checkForHelp(args)) {
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("Kernal64, Commodore 64 emulator ver. ").append(Version$.MODULE$.VERSION()).append(" (").append(Version$.MODULE$.BUILD_DATE()).append(")").toString());
            this.preferences().printUsage("file to attach");
            throw package$.MODULE$.exit(0);
        }
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)C64.$anonfun$turnOn$2(x$18)))) {
            this.headless_$eq(true);
        }
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)C64.$anonfun$turnOn$3(x$19)))) {
            this.configuration().clear();
        }
        this.swing((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.initComponent());
        this.swing((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.displayFrame().pack());
        if (this.configuration().getProperty(this.CONFIGURATION_FRAME_DIM()) != null) {
            int[] dim = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.configuration().getProperty(this.CONFIGURATION_FRAME_DIM()).split(",")), (Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$20))), (ClassTag)ClassTag$.MODULE$.Int());
            this.swing((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.updateVICScreenDimension(new Dimension(dim[0], dim[1])));
        } else {
            this.vicZoom(2);
        }
        if (this.configuration().getProperty(this.CONFIGURATION_FRAME_XY()) != null) {
            int[] xy = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.configuration().getProperty(this.CONFIGURATION_FRAME_XY()).split(",")), (Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$21))), (ClassTag)ClassTag$.MODULE$.Int());
            this.swing((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.displayFrame().setLocation(xy[0], xy[1]));
        } else {
            this.displayFrame().setLocationByPlatform(true);
        }
        this.loadSettings(args);
        this.swing((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.displayFrame().setVisible(!this.headless());
            if (this.fullScreenAtBoot()) {
                this.setVicFullScreen();
                return;
            }
        });
        this.clock().play();
        this.swing((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkKeyboardLayout());
    }

    public static final /* synthetic */ void $anonfun$init$4(C64 $this, boolean x$2) {
        $this.irqSwitcher().setLine(2, x$2);
    }

    public static final /* synthetic */ void $anonfun$init$6(C64 $this, boolean x$3) {
        $this.nmiSwitcher().setLine(2, x$3);
    }

    public static final /* synthetic */ void $anonfun$init$11(C64 $this, boolean x$4) {
        $this.irqSwitcher().setLine(1, x$4);
    }

    public static final /* synthetic */ void $anonfun$setGlobalCommandLineOptions$2(C64 $this, boolean x$17) {
        ((VIC_II)$this.vicChip()).setNEWVICModel(x$17);
    }

    public static final /* synthetic */ boolean $anonfun$turnOn$2(String x$18) {
        String string = x$18;
        String string2 = "--headless";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$turnOn$3(String x$19) {
        String string = x$19;
        String string2 = "--ignore-config-file";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public C64() {
        this.componentID = "Commodore 64";
        this.APPLICATION_NAME = "Kernal64";
        this.CONFIGURATION_FILENAME = "C64.config";
        this.DEFAULT_KEYBOARD_RESOURCE_NAME = "/resources/default_keyboard_c64";
    }
}

