/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.expansion.vic20;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import javax.swing.JFrame;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import ucesoft.cbm.expansion.vic20.VIC20ExpansionPort;
import ucesoft.cbm.expansion.vic20.VIC20FE3;
import ucesoft.cbm.misc.Preferences;
import ucesoft.cbm.misc.Preferences$;

public final class VIC20FE3$
implements VIC20ExpansionPort.VIC20ExpansionPortStateHandler {
    public static final VIC20FE3$ MODULE$ = new VIC20FE3$();
    private static boolean ucesoft$cbm$expansion$vic20$VIC20FE3$$imageWriteBack = false;
    private static String ucesoft$cbm$expansion$vic20$VIC20FE3$$lastEnabledROMPath = "";

    public boolean ucesoft$cbm$expansion$vic20$VIC20FE3$$imageWriteBack() {
        return ucesoft$cbm$expansion$vic20$VIC20FE3$$imageWriteBack;
    }

    public void ucesoft$cbm$expansion$vic20$VIC20FE3$$imageWriteBack_$eq(boolean x$1) {
        ucesoft$cbm$expansion$vic20$VIC20FE3$$imageWriteBack = x$1;
    }

    private String lastEnabledROMPath() {
        return ucesoft$cbm$expansion$vic20$VIC20FE3$$lastEnabledROMPath;
    }

    public void ucesoft$cbm$expansion$vic20$VIC20FE3$$lastEnabledROMPath_$eq(String x$1) {
        ucesoft$cbm$expansion$vic20$VIC20FE3$$lastEnabledROMPath = x$1;
    }

    public Either<Throwable, VIC20FE3> make(String romPath, VIC20ExpansionPort.Signals signals) {
        Left left;
        try {
            File f = new File(romPath);
            if (f.length() > 524288L) {
                throw new IllegalArgumentException("FE3 ROM length maximum size is 512K");
            }
            int[] tmpRom = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(Files.readAllBytes(f.toPath())), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)VIC20FE3$.$anonfun$make$1(BoxesRunTime.unboxToByte((Object)x$1))), (ClassTag)ClassTag$.MODULE$.Int());
            int[] rom = (int[])Array$.MODULE$.fill(524288, (Function0)(JFunction0.mcI.sp & Serializable)() -> 255, (ClassTag)ClassTag$.MODULE$.Int());
            int offset = 0;
            if (f.length() < 32768L) {
                int tsize = (int)f.length() + 4095 & 0xFFFFF000;
                offset = 32768 - tsize;
            }
            int ROMSIZE = 524288;
            System.arraycopy(tmpRom, 0, rom, offset, f.length() > (long)ROMSIZE ? ROMSIZE : tmpRom.length);
            left = new Right((Object)new VIC20FE3(rom, signals));
        }
        catch (Throwable io) {
            left = new Left((Object)io);
        }
        return left;
    }

    @Override
    public VIC20ExpansionPort load(ObjectInputStream in, VIC20ExpansionPort.Signals signals) {
        int[] rom = (int[])in.readObject();
        this.ucesoft$cbm$expansion$vic20$VIC20FE3$$imageWriteBack_$eq(in.readBoolean());
        File tmpFile = File.createTempFile("fe3", "");
        tmpFile.deleteOnExit();
        byte[] romBytes = (byte[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(rom), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)VIC20FE3$.$anonfun$load$1(BoxesRunTime.unboxToInt((Object)x$2))), (ClassTag)ClassTag$.MODULE$.Byte());
        FileOutputStream out = new FileOutputStream(tmpFile);
        out.write(romBytes);
        out.close();
        signals.pref().updateWithoutNotify(Preferences$.MODULE$.PREF_VIC20_FE3(), tmpFile.toString());
        return new VIC20FE3(rom, signals);
    }

    @Override
    public void save(VIC20ExpansionPort cart, ObjectOutputStream out) {
        out.writeObject(((VIC20FE3)cart).rom());
        out.writeBoolean(this.ucesoft$cbm$expansion$vic20$VIC20FE3$$imageWriteBack());
        cart.save(out);
    }

    public void ucesoft$cbm$expansion$vic20$VIC20FE3$$saveRomBackOnImage(int[] rom) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.lastEnabledROMPath()));
            for (int i = 0; i < rom.length; ++i) {
                out.write(rom[i]);
            }
            out.close();
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(33).append("FE3: Cannot write back to image: ").append(e).toString());
        }
    }

    public void showConfPanel(JFrame parent, Preferences pref, Function2<Object, String, BoxedUnit> enableHandler) {
        VIC20FE3.VIC20FE3Panel panel = new VIC20FE3.VIC20FE3Panel(parent, pref, enableHandler);
        panel.dialog().setVisible(true);
    }

    public static final /* synthetic */ int $anonfun$make$1(byte x$1) {
        return x$1 & 0xFF;
    }

    public static final /* synthetic */ byte $anonfun$load$1(int x$2) {
        return (byte)x$2;
    }

    private VIC20FE3$() {
    }
}

