/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.C128Model$;
import ucesoft.cbm.C64Model$;
import ucesoft.cbm.CBMComputerModel;
import ucesoft.cbm.VIC20Model$;
import ucesoft.cbm.cbm2.CBM2MMU;
import ucesoft.cbm.cpu.CPU65xx;
import ucesoft.cbm.cpu.Memory;

public final class ProgramLoader$ {
    public static final ProgramLoader$ MODULE$ = new ProgramLoader$();
    private static CPU65xx cpu;
    private static boolean loadingWithWarp;
    private static boolean loadingWithWarpEnabled;
    private static Function1<Object, BoxedUnit> warpModeListener;

    static {
        loadingWithWarp = false;
        loadingWithWarpEnabled = false;
    }

    public CPU65xx cpu() {
        return cpu;
    }

    public void cpu_$eq(CPU65xx x$1) {
        cpu = x$1;
    }

    public boolean loadingWithWarpEnabled() {
        return loadingWithWarpEnabled;
    }

    public void loadingWithWarpEnabled_$eq(boolean x$1) {
        loadingWithWarpEnabled = x$1;
    }

    public Function1<Object, BoxedUnit> warpModeListener() {
        return warpModeListener;
    }

    public void warpModeListener_$eq(Function1<Object, BoxedUnit> x$1) {
        warpModeListener = x$1;
    }

    public void checkLoadingInWarpMode(CBMComputerModel model, boolean c64Mode) {
        CBMComputerModel cBMComputerModel = model;
        if (C64Model$.MODULE$.equals(cBMComputerModel) ? true : C128Model$.MODULE$.equals(cBMComputerModel)) {
            if (c64Mode) {
                if (this.loadingWithWarpEnabled()) {
                    int pc = this.cpu().getCurrentInstructionPC();
                    if (pc == 62688 && !loadingWithWarp) {
                        loadingWithWarp = true;
                        if (this.warpModeListener() != null) {
                            BoxedUnit cfr_ignored_0 = (BoxedUnit)this.warpModeListener().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                            return;
                        }
                        return;
                    }
                    if (loadingWithWarp && (pc == 62763 || pc == 63027)) {
                        loadingWithWarp = false;
                        if (this.warpModeListener() != null) {
                            BoxedUnit cfr_ignored_1 = (BoxedUnit)this.warpModeListener().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            return;
                        }
                        return;
                    }
                    return;
                }
                return;
            }
            if (this.loadingWithWarpEnabled()) {
                int pc = this.cpu().getCurrentInstructionPC();
                if (!(pc != 62497 && pc != 62159 || loadingWithWarp)) {
                    loadingWithWarp = true;
                    if (this.warpModeListener() != null) {
                        BoxedUnit cfr_ignored_2 = (BoxedUnit)this.warpModeListener().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        return;
                    }
                    return;
                }
                if (loadingWithWarp && (pc == 62630 || pc == 62616 || pc == 62604 || pc == 62363 || pc == 62243)) {
                    loadingWithWarp = false;
                    if (this.warpModeListener() != null) {
                        BoxedUnit cfr_ignored_3 = (BoxedUnit)this.warpModeListener().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        return;
                    }
                    return;
                }
                return;
            }
            return;
        }
        if (VIC20Model$.MODULE$.equals(cBMComputerModel)) {
            if (this.loadingWithWarpEnabled()) {
                int pc = this.cpu().getCurrentInstructionPC();
                if (pc == 62901 && !loadingWithWarp) {
                    loadingWithWarp = true;
                    if (this.warpModeListener() != null) {
                        BoxedUnit cfr_ignored_4 = (BoxedUnit)this.warpModeListener().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        return;
                    }
                    return;
                }
                if (loadingWithWarp && (pc == 62911 || pc == 62869)) {
                    loadingWithWarp = false;
                    if (this.warpModeListener() != null) {
                        BoxedUnit cfr_ignored_5 = (BoxedUnit)this.warpModeListener().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        return;
                    }
                    return;
                }
                return;
            }
            return;
        }
        throw new MatchError((Object)cBMComputerModel);
    }

    public void reset() {
        loadingWithWarp = false;
    }

    public void updateBASICPointers(Memory mem, int startAddress, int endAddress, boolean c64Mode, int drive, String fileName) {
        if (c64Mode) {
            int endOfBasic = mem.read(55, mem.read$default$2()) | mem.read(56, mem.read$default$2()) << 8;
            mem.write(11, 76, mem.write$default$3());
            mem.write(15, 2, mem.write$default$3());
            mem.write(35, 8, mem.write$default$3());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(45), 50).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)adr -> {
                mem.write(adr, endAddress & 0xFF, mem.write$default$3());
                mem.write(adr + 1, endAddress >> 8, mem.write$default$3());
            });
            mem.write(54, 160, mem.write$default$3());
            mem.write(73, drive, mem.write$default$3());
            mem.write(144, 64, mem.write$default$3());
            mem.write(148, 64, mem.write$default$3());
            mem.write(163, 64, mem.write$default$3());
            mem.write(174, endAddress & 0xFF, mem.write$default$3());
            mem.write(175, endAddress >> 8, mem.write$default$3());
            mem.write(184, 1, mem.write$default$3());
            mem.write(185, 96, mem.write$default$3());
            mem.write(186, drive, mem.write$default$3());
            mem.write(187, endOfBasic & 0xFF, mem.write$default$3());
            mem.write(188, endOfBasic >> 8, mem.write$default$3());
            mem.write(195, 1, mem.write$default$3());
            mem.write(196, 8, mem.write$default$3());
            mem.write(183, 0, mem.write$default$3());
            return;
        }
        mem.write(43, startAddress & 0xFF, mem.write$default$3());
        mem.write(172, startAddress & 0xFF, mem.write$default$3());
        mem.write(44, startAddress >> 8, mem.write$default$3());
        mem.write(173, startAddress >> 8, mem.write$default$3());
        mem.write(4624, endAddress & 0xFF, mem.write$default$3());
        mem.write(4625, endAddress >> 8, mem.write$default$3());
    }

    private int startAddress(Memory mem, boolean c64Mode) {
        if (c64Mode) {
            return mem.read(43, mem.read$default$2()) | mem.read(44, mem.read$default$2()) << 8;
        }
        return mem.read(172, mem.read$default$2()) | mem.read(173, mem.read$default$2()) << 8;
    }

    private int endAddress(Memory mem, boolean c64Mode) {
        if (c64Mode) {
            return mem.read(45, mem.read$default$2()) | mem.read(46, mem.read$default$2()) << 8;
        }
        return mem.read(4624, mem.read$default$2()) | mem.read(4625, mem.read$default$2()) << 8;
    }

    public Tuple2<Object, Object> loadCBMIIPRG(CBM2MMU mem, File file) {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        int size = (int)(file.length() - 2L);
        in.skip(2L);
        IntRef m = IntRef.create((int)3);
        int b = in.read();
        while (b != -1) {
            mem.writeBank(m.elem, b, 1);
            ++m.elem;
            b = in.read();
        }
        in.close();
        mem.writeBank(47, 3 + size & 0xFF, 15);
        mem.writeBank(48, 3 + size >> 8, 15);
        int dotprg = file.getName().lastIndexOf(".");
        String fileName = dotprg != -1 ? file.getName().substring(0, dotprg) : file.getName();
        mem.writeBank(157, fileName.length(), 15);
        m.elem = mem.readBank(144, 15) | mem.readBank(145, 15) << 8;
        int fnBank = mem.readBank(146, 15);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), fileName.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> mem.writeBank(m$1.elem + i, fileName.charAt(i), fnBank));
        return new Tuple2.mcII.sp(3, 3 + size);
    }

    public Tuple2<Object, Object> loadPRG(Memory mem, File file, boolean c64Mode, int drive, Option<Object> startAddress) {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        int start = in.read() | in.read() << 8;
        Option<Object> option = startAddress;
        if (option instanceof Some) {
            int s;
            Some some = (Some)option;
            start = s = BoxesRunTime.unboxToInt((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        int m = start;
        int b = in.read();
        int size = 0;
        while (b != -1) {
            mem.write(m, b, mem.write$default$3());
            ++m;
            ++size;
            b = in.read();
        }
        in.close();
        int end = start + size;
        int dotprg = file.getName().lastIndexOf(".");
        String fileName = dotprg != -1 ? file.getName().substring(0, dotprg) : file.getName();
        this.updateBASICPointers(mem, start, end, c64Mode, drive, fileName);
        return new Tuple2.mcII.sp(start, end);
    }

    public Tuple2<Object, Object> loadPRG(Memory mem, int[] data, Option<Object> startAddress, boolean c64Mode, int drive, String fileName) {
        int start;
        int n;
        Option<Object> option = startAddress;
        if (option instanceof Some) {
            int address;
            Some some = (Some)option;
            n = address = BoxesRunTime.unboxToInt((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            n = this.startAddress(mem, c64Mode);
        } else {
            throw new MatchError(option);
        }
        int memPtr = start = n;
        for (int dataIndex = 0; dataIndex < data.length; ++dataIndex) {
            mem.write(memPtr, data[dataIndex], mem.write$default$3());
            ++memPtr;
        }
        int end = start + data.length & 0xFFFF;
        this.updateBASICPointers(mem, start, end, c64Mode, drive, fileName);
        return new Tuple2.mcII.sp(start, end);
    }

    public Option<Object> loadPRG$default$5() {
        return None$.MODULE$;
    }

    public Tuple2<Object, Object> savePRG(File file, Memory mem, boolean c64Mode) {
        FileOutputStream out = new FileOutputStream(file);
        int start = this.startAddress(mem, c64Mode);
        int end = this.endAddress(mem, c64Mode) - 1;
        out.write(start & 0xF);
        out.write(start >> 8);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)m -> out.write(mem.read(m, mem.read$default$2())));
        out.close();
        return new Tuple2.mcII.sp(start, end);
    }

    private ProgramLoader$() {
    }
}

