/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.formats.ProgramLoader$;
import ucesoft.cbm.formats.T64Entry;

@ScalaSignature(bytes="\u0006\u0005Q4AAD\b\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003*\u0001\u0011\u0005!\u0006\u0003\u0004/\u0001\u0001\u0006Ia\f\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\u001d\t\u000fu\u0002!\u0019!C\u0001}!1Q\t\u0001Q\u0001\n}BQA\u0012\u0001\u0005\u0002\u001dCQa\u0013\u0001\u0005\u00021CQ!\u0014\u0001\u0005\u00029CqA\u0018\u0001\u0012\u0002\u0013\u0005q\fC\u0003k\u0001\u0011%1\u000eC\u0003p\u0001\u0011%\u0001\u000fC\u0003t\u0001\u0011%aHA\u0002UmQR!\u0001E\t\u0002\u000f\u0019|'/\\1ug*\u0011!cE\u0001\u0004G\nl'\"\u0001\u000b\u0002\u000fU\u001cWm]8gi\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006!a-\u001b7f!\tybE\u0004\u0002!IA\u0011\u0011%G\u0007\u0002E)\u00111%F\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015J\u0012A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!J\r\u0002\rqJg.\u001b;?)\tYS\u0006\u0005\u0002-\u00015\tq\u0002C\u0003\u001e\u0005\u0001\u0007a$A\u0002umQ\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u0005%|'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012\u0001CU1oI>l\u0017iY2fgN4\u0015\u000e\\3\u0002\u0013}#\u0018\r]3OC6,\u0007CA\u001d=\u001b\u0005Q$BA\u001e4\u0003\u0011a\u0017M\\4\n\u0005\u001dR\u0014aB3oiJLWm]\u000b\u0002\u007fA\u0019\u0001\u0004\u0011\"\n\u0005\u0005K\"!B!se\u0006L\bC\u0001\u0017D\u0013\t!uB\u0001\u0005UmQ*e\u000e\u001e:z\u0003!)g\u000e\u001e:jKN\u0004\u0013!B2m_N,W#\u0001%\u0011\u0005aI\u0015B\u0001&\u001a\u0005\u0011)f.\u001b;\u0002\u0011Q\f\u0007/\u001a(b[\u0016,\u0012AH\u0001\rY>\fG-\u00138NK6|'/\u001f\u000b\u0005\u0011>;\u0016\fC\u0003Q\u0013\u0001\u0007\u0011+A\u0002nK6\u0004\"AU+\u000e\u0003MS!\u0001V\t\u0002\u0007\r\u0004X/\u0003\u0002W'\n1Q*Z7pefDQ\u0001W\u0005A\u0002\t\u000bQ!\u001a8uefDqAW\u0005\u0011\u0002\u0003\u00071,A\u0004dmQju\u000eZ3\u0011\u0005aa\u0016BA/\u001a\u0005\u001d\u0011un\u001c7fC:\fa\u0003\\8bI&sW*Z7pef$C-\u001a4bk2$HeM\u000b\u0002A*\u00121,Y\u0016\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\nk:\u001c\u0007.Z2lK\u0012T!aZ\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002jI\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\tI,\u0017\rZ\u000b\u0002YB\u0011\u0001$\\\u0005\u0003]f\u00111!\u00138u\u0003!\u0011X-\u00193OC6,GC\u0001\u001dr\u0011\u0015\u0011H\u00021\u0001m\u0003\raWM\\\u0001\fY>\fG-\u00128ue&,7\u000f")
public class T64 {
    private final RandomAccessFile t64;
    private String _tapeName;
    private final T64Entry[] entries;

    public T64Entry[] entries() {
        return this.entries;
    }

    public void close() {
        this.t64.close();
    }

    public String tapeName() {
        return this._tapeName;
    }

    public void loadInMemory(Memory mem, T64Entry entry, boolean c64Mode) {
        this.t64.seek(entry.offset());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(entry.startAddress()), entry.startAddress() + entry.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)m -> mem.write(m, this.read(), mem.write$default$3()));
        int endAddress = entry.startAddress() + entry.length();
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(17).append("Loaded ").append(entry.fileName()).append(" from ").append(entry.startAddress()).append(" to ").append(endAddress).toString());
        ProgramLoader$.MODULE$.updateBASICPointers(mem, entry.startAddress(), endAddress, c64Mode, 1, entry.fileName());
    }

    public boolean loadInMemory$default$3() {
        return true;
    }

    private int read() {
        return this.t64.read() & 0xFF;
    }

    private String readName(int len) {
        StringBuilder sb = new StringBuilder();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), len).foreach((Function1 & Serializable)i -> sb.append((char)this.read()));
        return sb.toString().trim();
    }

    private T64Entry[] loadEntries() {
        if (this.read() != 67 || this.read() != 54 || this.read() != 52) {
            throw new IOException("T64 Bad format");
        }
        this.t64.seek(36L);
        int totalEntries = this.read() | this.read() << 8;
        this.t64.seek(40L);
        this._tapeName = this.readName(24);
        IntRef offset = IntRef.create((int)64);
        IndexedSeq entries = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), totalEntries).map((Function1 & Serializable)e -> T64.$anonfun$loadEntries$1(this, offset, BoxesRunTime.unboxToInt((Object)e)));
        return (T64Entry[])((IterableOnceOps)entries.flatten(Predef$.MODULE$.$conforms())).toArray(ClassTag$.MODULE$.apply(T64Entry.class));
    }

    public static final /* synthetic */ Option $anonfun$loadEntries$1(T64 $this, IntRef offset$1, int e) {
        $this.t64.seek(offset$1.elem);
        offset$1.elem += 32;
        if ($this.read() == 0 || $this.read() == 0) {
            return None$.MODULE$;
        }
        int startAddress = $this.read() | $this.read() << 8;
        int length = ($this.read() | $this.read() << 8) - startAddress;
        $this.t64.skipBytes(2);
        int off = $this.read() | $this.read() << 8 | ($this.read() | $this.read() << 8) << 16;
        $this.t64.skipBytes(4);
        String fileName = $this.readName(16);
        return new Some((Object)new T64Entry(fileName, startAddress, off, length, length / 256));
    }

    public T64(String file) {
        this.t64 = new RandomAccessFile(file, "r");
        this._tapeName = "";
        this.entries = this.loadEntries();
    }
}

