/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import ucesoft.cbm.formats.TAP;

public final class TAP$ {
    public static final TAP$ MODULE$ = new TAP$();
    private static final int ucesoft$cbm$formats$TAP$$UNDEFINED_GAP = 20000;
    private static final int Z = 48;
    private static final int O = 66;
    private static final int N = 86;
    private static final int ZERO = MODULE$.Z() << 8 | MODULE$.O();
    private static final int ONE = MODULE$.O() << 8 | MODULE$.Z();
    private static final int NEW_DATA = MODULE$.N() << 8 | MODULE$.O();
    private static final int END_DATA = MODULE$.N() << 8 | MODULE$.Z();
    private static final int TOL = 5;

    public int ucesoft$cbm$formats$TAP$$UNDEFINED_GAP() {
        return ucesoft$cbm$formats$TAP$$UNDEFINED_GAP;
    }

    private int Z() {
        return Z;
    }

    private int O() {
        return O;
    }

    private int N() {
        return N;
    }

    private int ZERO() {
        return ZERO;
    }

    private int ONE() {
        return ONE;
    }

    private int NEW_DATA() {
        return NEW_DATA;
    }

    private int END_DATA() {
        return END_DATA;
    }

    private int TOL() {
        return TOL;
    }

    public double COUNTER_PERIOD() {
        return 2945891.52;
    }

    public long FAST_FORWARD_PERIOD() {
        return package$.MODULE$.round(this.COUNTER_PERIOD() / 12.0);
    }

    private boolean isSync(long sync, int n) {
        return sync == -8536424081845353598L && n == 129;
    }

    public TAP.TAPInfo anaylize(File tapFile) {
        int lastTwo = 0;
        ListBuffer files = new ListBuffer();
        byte[] tapBuffer = Files.readAllBytes(tapFile.toPath());
        HashMap counterMap = new HashMap();
        byte version = tapBuffer[12];
        boolean inData = false;
        int n = 0;
        int pulses = 0;
        long sync = 0L;
        boolean header = false;
        int headerCounter = 0;
        int fileType = 0;
        long tapOffset = 0L;
        StringBuilder fileName = new StringBuilder();
        int i = 20;
        int cycles = 0;
        int syncCounter = 0;
        while (i < tapBuffer.length) {
            int n2;
            int read = tapBuffer[i];
            int pos = i++;
            if (read == 0) {
                if (version == 0) {
                    n2 = this.ucesoft$cbm$formats$TAP$$UNDEFINED_GAP();
                } else if (i + 2 < tapBuffer.length) {
                    int newGap = tapBuffer[i] | tapBuffer[i + 1] << 8 | tapBuffer[i + 2] << 16;
                    i += 2;
                    n2 = newGap != 0 ? newGap : this.ucesoft$cbm$formats$TAP$$UNDEFINED_GAP();
                } else {
                    n2 = this.ucesoft$cbm$formats$TAP$$UNDEFINED_GAP();
                }
            } else {
                n2 = read << 3;
            }
            int gap = n2;
            int counter = (int)package$.MODULE$.round((double)(cycles += gap) / this.COUNTER_PERIOD());
            counterMap.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)counter), (Function0)(JFunction0.mcI.sp & Serializable)() -> pos);
            if (read >= this.Z() - this.TOL() && read <= this.Z() + this.TOL()) {
                read = this.Z();
            } else if (read >= this.O() - this.TOL() && read <= this.O() + this.TOL()) {
                read = this.O();
            } else if (read >= this.N() - this.TOL() && read <= this.N() + this.TOL()) {
                read = this.N();
            }
            lastTwo = (lastTwo << 8 | read) & 0xFFFF;
            if (inData) {
                BoxedUnit boxedUnit;
                int bit;
                int n3 = bit = lastTwo == this.ONE() ? 1 : 0;
                if (--pulses % 2 == 0) {
                    n = bit << 15 | n >> 1;
                }
                if (pulses != 0) continue;
                inData = false;
                n = n >> 7 & 0xFF;
                if (header) {
                    if (++headerCounter == 1) {
                        tapOffset = i;
                        fileType = n;
                        if (fileType != 1 && fileType != 3 && fileType != 4) {
                            header = false;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (headerCounter >= 6 && headerCounter <= 22) {
                        fileName.append((char)n);
                        if (headerCounter == 22) {
                            String string;
                            int n4 = fileType;
                            switch (n4) {
                                case 1: 
                                case 3: {
                                    string = "PRG";
                                    break;
                                }
                                case 4: {
                                    string = "SEQ";
                                    break;
                                }
                                default: {
                                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n4));
                                }
                            }
                            String fileTypeName = string;
                            boxedUnit = files.$plus$eq((Object)new TAP.TAPHeader(fileTypeName, fileName.toString(), tapOffset > 27136L ? tapOffset - 27136L : 0L, syncCounter > 1 ? syncCounter - 2 : syncCounter));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (this.isSync(sync, n)) {
                    syncCounter = counter;
                    header = true;
                    headerCounter = 0;
                    fileName.clear();
                    continue;
                }
                sync = sync << 8 | (long)n;
                continue;
            }
            if (lastTwo == this.NEW_DATA()) {
                inData = true;
                pulses = 18;
                n = 0;
                continue;
            }
            if (lastTwo != this.END_DATA()) continue;
            inData = false;
        }
        return new TAP.TAPInfo((List<TAP.TAPHeader>)files.toList(), new TAP.TapCounterMap((Map<Object, Object>)counterMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private TAP$() {
    }
}

