/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;
import ucesoft.cbm.Log$;
import ucesoft.cbm.formats.ZIP;

public final class ZIP$ {
    public static final ZIP$ MODULE$ = new ZIP$();
    private static final Set<String> allowedArchiveExtentions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"PRG", "D64", "G64", "CRT", "TAP", "T64", "D71", "G71", "D80"}));

    private Set<String> allowedArchiveExtentions() {
        return allowedArchiveExtentions;
    }

    public Try<List<ZIP.ArchiveEntry>> zipEntries(File file) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ZipFile zip = new ZipFile(file);
            Iterator entries = CollectionConverters$.MODULE$.EnumerationHasAsScala(zip.entries()).asScala();
            Iterator validEntries = entries.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ZIP$.$anonfun$zipEntries$2(e)));
            List list = validEntries.map((Function1 & Serializable)e -> new ZIP.ArchiveEntry(new File(e.getName()).getName(), file, e.getName())).toList();
            zip.close();
            return list;
        });
    }

    public Option<File> extractEntry(ZIP.ArchiveEntry entry, File dir) {
        None$ none$;
        ZipFile zip = new ZipFile(entry.zipFile());
        try {
            try {
                ZipEntry item = zip.getEntry(entry.entry());
                if (item == null) {
                    none$ = None$.MODULE$;
                } else {
                    InputStream in = zip.getInputStream(item);
                    File file = new File(dir, entry.name());
                    if (file.exists()) {
                        none$ = new Some((Object)file);
                    } else {
                        file.deleteOnExit();
                        Files.copy(in, file.toPath(), new CopyOption[0]);
                        none$ = new Some((Object)file);
                    }
                }
            }
            finally {
                zip.close();
            }
        }
        catch (Throwable t) {
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Can't open zip archive: ").append(entry.zipFile()).append(": ").append(t).toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void createZIPWith(File zipArchive, Seq<File> files) {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipArchive));
        files.foreach((Function1 & Serializable)f -> {
            ZIP$.$anonfun$createZIPWith$1(out, f);
            return BoxedUnit.UNIT;
        });
        out.close();
    }

    public static final /* synthetic */ boolean $anonfun$zipEntries$2(ZipEntry e) {
        String name = e.getName();
        int dot = name.lastIndexOf(".");
        return dot != -1 && MODULE$.allowedArchiveExtentions().contains((Object)name.substring(dot + 1).toUpperCase());
    }

    public static final /* synthetic */ void $anonfun$createZIPWith$1(ZipOutputStream out$1, File f) {
        ZipEntry entry = new ZipEntry(f.getName());
        out$1.putNextEntry(entry);
        Files.copy(f.toPath(), out$1);
        out$1.closeEntry();
    }

    private ZIP$() {
    }
}

