/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats.cart;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import ucesoft.cbm.ChipID$;
import ucesoft.cbm.Log$;
import ucesoft.cbm.cpu.Memory;
import ucesoft.cbm.formats.Cartridge;
import ucesoft.cbm.formats.ExpansionPortFactory;
import ucesoft.cbm.misc.M93C86;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\n\u0015\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A!\b\u0001B\u0001B\u0003%1\bC\u0003D\u0001\u0011\u0005A\t\u0003\u0004K\u0001\u0001\u0006Ia\u0013\u0005\u0007#\u0002\u0001\u000b\u0015\u0002*\t\ra\u0003\u0001\u0015!\u0003Z\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u001di\u0007!%A\u0005\u00029DQ!\u001f\u0001\u0005BiD\u0001\"!\u0002\u0001#\u0003%\tA\u001c\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\tY\u0001\u0001C!\u0003\u0013Aq!!\u0004\u0001\t\u0003\nI\u0001C\u0004\u0002\u0010\u0001!\t%!\u0003\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\n!9\u00111\u0003\u0001\u0005B\u0005U\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0002\u0006\u000f6{EI\r\u0006\u0003+Y\tAaY1si*\u0011q\u0003G\u0001\bM>\u0014X.\u0019;t\u0015\tI\"$A\u0002dE6T\u0011aG\u0001\bk\u000e,7o\u001c4u\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}YcB\u0001\u0011*\u001d\t\t\u0003F\u0004\u0002#O9\u00111EJ\u0007\u0002I)\u0011Q\u0005H\u0001\u0007yI|w\u000e\u001e \n\u0003mI!!\u0007\u000e\n\u0005]A\u0012B\u0001\u0016\u0017\u0003Q)\u0005\u0010]1og&|g\u000eU8si\u001a\u000b7\r^8ss&\u0011A&\f\u0002\u0017\u0007\u0006\u0014HO]5eO\u0016,\u0005\u0010]1og&|g\u000eU8si*\u0011!FF\u0001\u0004GJ$\bC\u0001\u00192\u001b\u00051\u0012B\u0001\u001a\u0017\u0005%\u0019\u0015M\u001d;sS\u0012<W-A\u0002sC6\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\r\u0002\u0007\r\u0004X/\u0003\u0002:m\t1Q*Z7pef\faaY8oM&<\u0007C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0011)H/\u001b7\u000b\u0003\u0001\u000bAA[1wC&\u0011!)\u0010\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0003F\u000f\"K\u0005C\u0001$\u0001\u001b\u0005!\u0002\"\u0002\u0018\u0005\u0001\u0004y\u0003\"B\u001a\u0005\u0001\u0004!\u0004\"\u0002\u001e\u0005\u0001\u0004Y\u0014\u0001G\"P\u001d\u001aKu)\u0016*B)&{ejX$N\u001f\u0012\u0013tLR%M\u000bB\u0011AjT\u0007\u0002\u001b*\u0011ajP\u0001\u0005Y\u0006tw-\u0003\u0002Q\u001b\n11\u000b\u001e:j]\u001e\f1A]3h!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\rIe\u000e^\u0001\u0007[f\u001a4\r\u000f\u001c\u0011\u0005ikV\"A.\u000b\u0005qC\u0012\u0001B7jg\u000eL!AX.\u0003\r5K4g\u0011\u001d7\u0003\u0011\u0011X-\u00193\u0015\u0007I\u000b7\rC\u0003c\u0011\u0001\u0007!+A\u0004bI\u0012\u0014Xm]:\t\u000f\u0011D\u0001\u0013!a\u0001K\u000611\r[5q\u0013\u0012\u0003\"A\u001a6\u000f\u0005\u001dDW\"\u0001\r\n\u0005%D\u0012AB\"iSBLE)\u0003\u0002lY\n\u0011\u0011\n\u0012\u0006\u0003Sb\taB]3bI\u0012\"WMZ1vYR$#'F\u0001pU\t)\u0007oK\u0001r!\t\u0011x/D\u0001t\u0015\t!X/A\u0005v]\u000eDWmY6fI*\u0011a\u000fV\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001=t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0006oJLG/\u001a\u000b\u0006wz|\u00181\u0001\t\u0003'rL!! +\u0003\tUs\u0017\u000e\u001e\u0005\u0006E*\u0001\rA\u0015\u0005\u0007\u0003\u0003Q\u0001\u0019\u0001*\u0002\u000bY\fG.^3\t\u000f\u0011T\u0001\u0013!a\u0001K\u0006yqO]5uK\u0012\"WMZ1vYR$3'A\u0003sKN,G\u000fF\u0001|\u0003\u0015)'.Z2u\u0003!\u0019\b.\u001e;e_^t\u0017\u0001B5oSR\f!b]1wK\u0016+\u0007O]8n\u0003%\u0019\u0018M^3Ti\u0006$X\rF\u0002|\u0003/Aq!!\u0007\u0012\u0001\u0004\tY\"A\u0002pkR\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003Cy\u0014AA5p\u0013\u0011\t)#a\b\u0003%=\u0013'.Z2u\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\nY>\fGm\u0015;bi\u0016$2a_A\u0016\u0011\u001d\tiC\u0005a\u0001\u0003_\t!!\u001b8\u0011\t\u0005u\u0011\u0011G\u0005\u0005\u0003g\tyBA\tPE*,7\r^%oaV$8\u000b\u001e:fC6\u0004")
public class GMOD2
extends ExpansionPortFactory.CartridgeExpansionPort {
    private final Properties config;
    private final String CONFIGURATION_GMOD2_FILE;
    private int reg;
    private final M93C86 m93c86;

    @Override
    public int read(int address, Enumeration.Value chipID) {
        if (address == 56832) {
            return this.m93c86.output() << 7;
        }
        return 0;
    }

    @Override
    public Enumeration.Value read$default$2() {
        return ChipID$.MODULE$.CPU();
    }

    @Override
    public void write(int address, int value, Enumeration.Value chipID) {
        if (address == 56832) {
            this.reg = value;
            if ((value & 0x40) == 0) {
                this.m93c86.chipSelect(false);
                int bank = value & 0x3F;
                this.romlBankIndex_$eq(bank);
                this.romhBankIndex_$eq(bank);
                return;
            }
            this.m93c86.chipSelect(true);
            this.m93c86.clock((value & 0x20) > 0);
            this.m93c86.input(value >> 4 & 1);
            return;
        }
    }

    @Override
    public Enumeration.Value write$default$3() {
        return ChipID$.MODULE$.CPU();
    }

    @Override
    public void reset() {
        this.romlBankIndex_$eq(0);
        this.romhBankIndex_$eq(0);
    }

    @Override
    public void eject() {
        this.saveEeprom();
    }

    @Override
    public void shutdown() {
        this.saveEeprom();
    }

    @Override
    public void init() {
        Option option = Option$.MODULE$.apply((Object)this.config.getProperty(this.CONFIGURATION_GMOD2_FILE));
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String eeprom = (String)some.value();
            File file = new File(eeprom);
            if (file.exists()) {
                this.m93c86.load(file);
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("EEPROM loaded from ").append(file).toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private void saveEeprom() {
        Option option = Option$.MODULE$.apply((Object)this.config.getProperty(this.CONFIGURATION_GMOD2_FILE));
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String eeprom = (String)some.value();
            this.m93c86.save(new File(eeprom));
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("EEPROM saved to ").append(eeprom).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void saveState(ObjectOutputStream out) {
        super.saveState(out);
        out.writeInt(this.reg);
        this.m93c86.save(out);
    }

    @Override
    public void loadState(ObjectInputStream in) {
        super.loadState(in);
        this.reg = in.readInt();
        this.m93c86.load(in);
    }

    public GMOD2(Cartridge crt, Memory ram, Properties config) {
        this.config = config;
        super(crt, ram);
        this.CONFIGURATION_GMOD2_FILE = "gmod2.file";
        this.reg = 0;
        this.m93c86 = new M93C86(true);
    }
}

