/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.keyboard;

import java.awt.event.KeyEvent;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.CBMComponentType$;
import ucesoft.cbm.CBMComputerModel;
import ucesoft.cbm.cbm2.CBM2MMU;
import ucesoft.cbm.peripheral.keyboard.BKeyboard$;
import ucesoft.cbm.peripheral.keyboard.CKey$;
import ucesoft.cbm.peripheral.keyboard.Keyboard;
import ucesoft.cbm.peripheral.keyboard.KeyboardMapper;

@ScalaSignature(bytes="\u0006\u0005\u0005uu!B\u0012%\u0011\u0003ic!B\u0018%\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004\"C\u001d\u0002\u0001\u0004\u0005\r\u0011\"\u0003;\u0011%\u0011\u0017\u00011AA\u0002\u0013%1\rC\u0005g\u0003\u0001\u0007\t\u0011)Q\u0005w!9q-\u0001a\u0001\n\u0013A\u0007b\u00027\u0002\u0001\u0004%I!\u001c\u0005\u0007_\u0006\u0001\u000b\u0015B5\u0007\tu\nAA\u0010\u0005\t\u000f&\u0011\t\u0011)A\u0005\u0011\"A1+\u0003B\u0001B\u0003%A\u000bC\u00038\u0013\u0011\u0005!\fC\u0003^\u0013\u0011\u0005c\fC\u0003q\u0003\u0011\u0005\u0011O\u0002\u00030I\u0001!\b\u0002\u0003=\u0010\u0005\u0003\u0005\u000b\u0011B=\t\u0011q|!Q1A\u0005RuD1\"!\u0002\u0010\u0005\u0003\u0005\u000b\u0011\u0002@\u0002\b!1qg\u0004C\u0001\u0003\u0013A\u0011\"!\u0005\u0010\u0005\u0004%\t!a\u0005\t\u0011\u0005eq\u0002)A\u0005\u0003+A\u0011\"a\u0007\u0010\u0005\u0004%\t!!\b\t\u0011\u0005Ur\u0002)A\u0005\u0003?A\u0011\"a\u000e\u0010\u0001\u0004%I!!\u000f\t\u0013\u0005\u0005s\u00021A\u0005\n\u0005\r\u0003\u0002CA$\u001f\u0001\u0006K!a\u000f\t\u000f\u0005%s\u0002\"\u0002\u0002L!9\u0011\u0011K\b\u0005\u0006\u0005M\u0003bBA,\u001f\u0011\u0015\u0011\u0011\f\u0005\b\u00037zAQIA/\u0011\u001d\t\u0019h\u0004C#\u0003kBq!!\u001f\u0010\t#\nY\bC\u0004\u0002\u000e>!\t&a$\t\r\u0005mu\u0002\"\u0015i\u0003%\u00115*Z=c_\u0006\u0014HM\u0003\u0002&M\u0005A1.Z=c_\u0006\u0014HM\u0003\u0002(Q\u0005Q\u0001/\u001a:ja\",'/\u00197\u000b\u0005%R\u0013aA2c[*\t1&A\u0004vG\u0016\u001cxN\u001a;\u0004\u0001A\u0011a&A\u0007\u0002I\tI!iS3zE>\f'\u000fZ\n\u0003\u0003E\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001.\u0003)YW-\u001f2UQJ,\u0017\rZ\u000b\u0002wA\u0011A(C\u0007\u0002\u0003\tq1*Z=c_\u0006\u0014H\r\u00165sK\u0006$7CA\u0005@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003mC:<'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013a\u0001\u00165sK\u0006$\u0017a\u0001;yiB\u0011\u0011\n\u0015\b\u0003\u0015:\u0003\"aS\u001a\u000e\u00031S!!\u0014\u0017\u0002\rq\u0012xn\u001c;?\u0013\ty5'\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(4\u0003\riW-\u001c\t\u0003+bk\u0011A\u0016\u0006\u0003/\"\nAa\u00192ne%\u0011\u0011L\u0016\u0002\b\u0007\nk%'T'V)\rY4\f\u0018\u0005\u0006\u000f2\u0001\r\u0001\u0013\u0005\u0006'2\u0001\r\u0001V\u0001\u0004eVtG#A0\u0011\u0005I\u0002\u0017BA14\u0005\u0011)f.\u001b;\u0002\u001d-,\u0017P\u0019+ie\u0016\fGm\u0018\u0013fcR\u0011q\f\u001a\u0005\bK\u0012\t\t\u00111\u0001<\u0003\rAH%M\u0001\fW\u0016L(\r\u00165sK\u0006$\u0007%A\tlKf\u0014G\u000b\u001b:fC\u0012\u0014VO\u001c8j]\u001e,\u0012!\u001b\t\u0003e)L!a[\u001a\u0003\u000f\t{w\u000e\\3b]\u0006)2.Z=c)\"\u0014X-\u00193Sk:t\u0017N\\4`I\u0015\fHCA0o\u0011\u001d)w!!AA\u0002%\f!c[3zERC'/Z1e%Vtg.\u001b8hA\u0005a\u0012N\\:feR$V\r\u001f;J]R|7*Z=c_\u0006\u0014HMQ;gM\u0016\u0014HcA0sg\")qI\u0004a\u0001\u0011\")1K\u0004a\u0001)N\u0011q\"\u001e\t\u0003]YL!a\u001e\u0013\u0003\u0011-+\u0017PY8be\u0012\f1aX6n!\tq#0\u0003\u0002|I\tq1*Z=c_\u0006\u0014H-T1qa\u0016\u0014\u0018!B7pI\u0016dW#\u0001@\u0011\u0007}\f\t!D\u0001)\u0013\r\t\u0019\u0001\u000b\u0002\u0011\u0007\nk5i\\7qkR,'/T8eK2\fa!\\8eK2\u0004\u0013B\u0001?w)\u0019\tY!!\u0004\u0002\u0010A\u0011af\u0004\u0005\u0006qN\u0001\r!\u001f\u0005\u0006yN\u0001\rA`\u0001\fG>l\u0007o\u001c8f]RLE)\u0006\u0002\u0002\u0016A\u0019\u0001)a\u0006\n\u0005E\u000b\u0015\u0001D2p[B|g.\u001a8u\u0013\u0012\u0003\u0013!D2p[B|g.\u001a8u)f\u0004X-\u0006\u0002\u0002 A!\u0011\u0011EA\u0018\u001d\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012\u0011\u0006\b\u0004\u0017\u0006\u001d\u0012\"A\u0016\n\u0005%R\u0013bAA\u0017Q\u0005\u00012IQ'D_6\u0004xN\\3oiRK\b/Z\u0005\u0005\u0003c\t\u0019D\u0001\u0003UsB,'bAA\u0017Q\u0005q1m\\7q_:,g\u000e\u001e+za\u0016\u0004\u0013AC2pY\u0006#GM]3tgV\u0011\u00111\b\t\u0004e\u0005u\u0012bAA g\t\u0019\u0011J\u001c;\u0002\u001d\r|G.\u00113ee\u0016\u001c8o\u0018\u0013fcR\u0019q,!\u0012\t\u0011\u0015L\u0012\u0011!a\u0001\u0003w\t1bY8m\u0003\u0012$'/Z:tA\u0005\u00192/\u001a7fGRdun^\"pY\u0006#GM]3tgR\u0019q,!\u0014\t\u000f\u0005=3\u00041\u0001\u0002<\u00059\u0011\r\u001a3sKN\u001c\u0018\u0001F:fY\u0016\u001cG\u000fS5hQ\u000e{G.\u00113ee\u0016\u001c8\u000fF\u0002`\u0003+Bq!a\u0014\u001d\u0001\u0004\tY$\u0001\u0003sK\u0006$GCAA\u001e\u0003)YW-\u001f)sKN\u001cX\r\u001a\u000b\u0004?\u0006}\u0003bBA1=\u0001\u0007\u00111M\u0001\u0002KB!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!B3wK:$(bAA7\u0007\u0006\u0019\u0011m\u001e;\n\t\u0005E\u0014q\r\u0002\t\u0017\u0016LXI^3oi\u0006Y1.Z=SK2,\u0017m]3e)\ry\u0016q\u000f\u0005\b\u0003Cz\u0002\u0019AA2\u0003%\u0019\u0018M^3Ti\u0006$X\rF\u0002`\u0003{Bq!a !\u0001\u0004\t\t)A\u0002pkR\u0004B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f\u001b\u0015AA5p\u0013\u0011\tY)!\"\u0003%=\u0013'.Z2u\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\nY>\fGm\u0015;bi\u0016$2aXAI\u0011\u001d\t\u0019*\ta\u0001\u0003+\u000b!!\u001b8\u0011\t\u0005\r\u0015qS\u0005\u0005\u00033\u000b)IA\tPE*,7\r^%oaV$8\u000b\u001e:fC6\fA#\u00197m_^\u001c8\u000b^1uKJ+7\u000f^8sS:<\u0007")
public class BKeyboard
extends Keyboard {
    private final String componentID;
    private final Enumeration.Value componentType = CBMComponentType$.MODULE$.INPUT_DEVICE();
    private int colAddress = 0;

    public static void insertTextIntoKeyboardBuffer(String txt, CBM2MMU mem) {
        BKeyboard$.MODULE$.insertTextIntoKeyboardBuffer(txt, mem);
    }

    @Override
    public CBMComputerModel model() {
        return super.model();
    }

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public Enumeration.Value componentType() {
        return this.componentType;
    }

    private int colAddress() {
        return this.colAddress;
    }

    private void colAddress_$eq(int x$1) {
        this.colAddress = x$1;
    }

    public final void selectLowColAddress(int address) {
        this.colAddress_$eq(~address & 0xFF | this.colAddress() & 0xFF00);
    }

    public final void selectHighColAddress(int address) {
        this.colAddress_$eq((~address & 0xFF) << 8 | this.colAddress() & 0xFF);
    }

    public final int read() {
        int n = 63;
        if (this.keysPressed().size() > 0) {
            for (Enumeration.Value k : this.keysPressed()) {
                Tuple2<Object, Object> tuple2 = CKey$.MODULE$.getRowCol(k);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int r = tuple2._1$mcI$sp();
                int c = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(r, c);
                int r2 = sp2._1$mcI$sp();
                int c2 = sp2._2$mcI$sp();
                if ((this.colAddress() & 1 << c2) <= 0) continue;
                n &= ~(1 << r2);
            }
        }
        return n;
    }

    @Override
    public final void keyPressed(KeyEvent e) {
        Some some;
        Keyboard.PressedKeys pressedKeys;
        Option<Keyboard.PressedKeys> option = this.findPressedKey(e);
        if (option instanceof Some && (pressedKeys = (Keyboard.PressedKeys)(some = (Some)option).value()) != null) {
            boolean hideShift = pressedKeys.hideShift();
            List<Enumeration.Value> keys = pressedKeys.keys();
            keys.foreach((Function1 & Serializable)key -> (Set)this.keysPressed().$plus$eq(key));
            if (hideShift) {
                this.clearAllPressedShifts();
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public final void keyReleased(KeyEvent e) {
        Option<List<Enumeration.Value>> option = this.findReleasedKey(e);
        if (option instanceof Some) {
            Some some = (Some)option;
            List keys = (List)some.value();
            keys.foreach((Function1 & Serializable)key -> (Set)this.keysPressed().$minus$eq(key));
        } else if (None$.MODULE$.equals(option)) {
            this.keysPressed().clear();
        } else {
            throw new MatchError(option);
        }
        if (e.getKeyCode() == 16) {
            this.clearAllPressedShifts();
            return;
        }
    }

    @Override
    public void saveState(ObjectOutputStream out) {
    }

    @Override
    public void loadState(ObjectInputStream in) {
    }

    @Override
    public boolean allowsStateRestoring() {
        return true;
    }

    public BKeyboard(KeyboardMapper _km, CBMComputerModel model) {
        super(_km, model);
        this.componentID = "Keyboard";
    }

    private static class KeyboardThread
    extends Thread {
        private final String txt;
        private final CBM2MMU mem;

        @Override
        public void run() {
            BKeyboard$.MODULE$.ucesoft$cbm$peripheral$keyboard$BKeyboard$$keybThreadRunning_$eq(true);
            int bufferAddr = 939;
            int lenAddr = 209;
            int len = 10;
            IntRef strpos = IntRef.create((int)0);
            while (BKeyboard$.MODULE$.ucesoft$cbm$peripheral$keyboard$BKeyboard$$keybThreadRunning() && strpos.elem < this.txt.length()) {
                int size = len < this.txt.length() - strpos.elem ? len : this.txt.length() - strpos.elem;
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    int c = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper($this.txt.charAt(strpos$1.elem)));
                    $this.mem.writeBank(bufferAddr + i, c != 10 ? c : 13, 15);
                    ++strpos$1.elem;
                });
                this.mem.writeBank(lenAddr, size, 15);
                while (BKeyboard$.MODULE$.ucesoft$cbm$peripheral$keyboard$BKeyboard$$keybThreadRunning() && this.mem.readBank(lenAddr, 15) > 0) {
                    Thread.sleep(1L);
                }
            }
            BKeyboard$.MODULE$.ucesoft$cbm$peripheral$keyboard$BKeyboard$$keybThreadRunning_$eq(false);
        }

        public KeyboardThread(String txt, CBM2MMU mem) {
            this.txt = txt;
            this.mem = mem;
        }
    }
}

