/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.mos6551;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.JFrame;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import ucesoft.cbm.Log$;
import ucesoft.cbm.peripheral.mos6551.ACIA6551$;

@ScalaSignature(bytes="\u0006\u0005\tEs!B%K\u0011\u0003\u0019f!B+K\u0011\u00031\u0006\"B/\u0002\t\u0003q\u0006\"C0\u0002\u0001\u0004\u0005\r\u0011\"\u0003a\u0011-\t9.\u0001a\u0001\u0002\u0004%I!!7\t\u0015\u0005u\u0017\u00011A\u0001B\u0003&\u0011\rC\u0006\u0002`\u0006\u0001\r\u00111A\u0005\n\u0005\u0005\bbCAz\u0003\u0001\u0007\t\u0019!C\u0005\u0003kD1\"!?\u0002\u0001\u0004\u0005\t\u0015)\u0003\u0002d\"Y\u00111`\u0001A\u0002\u0003\u0007I\u0011BA\u007f\u0011-\u0011)!\u0001a\u0001\u0002\u0004%IAa\u0002\t\u0017\t-\u0011\u00011A\u0001B\u0003&\u0011q \u0005\f\u0005\u001b\t\u0001\u0019!a\u0001\n\u0013\u0011y\u0001C\u0006\u0003\u001e\u0005\u0001\r\u00111A\u0005\n\t}\u0001b\u0003B\u0012\u0003\u0001\u0007\t\u0011)Q\u0005\u0005#A\u0011B!\n\u0002\u0005\u0004%IAa\n\t\u0011\t=\u0012\u0001)A\u0005\u0005SA\u0011B!\r\u0002\u0005\u0004%IAa\r\t\u0011\tm\u0012\u0001)A\u0005\u0005kAqA!\u0010\u0002\t\u0003\u0011y\u0004C\u0004\u0003D\u0005!\tA!\u0012\t\u000f\u0005%\u0014\u0001\"\u0003\u0002:\u001a!QK\u0013\u0001c\u0011!\u0019gC!A!\u0002\u0013!\u0007\"B/\u0017\t\u0003i\u0007bB8\u0017\u0001\u0004%I\u0001\u001d\u0005\biZ\u0001\r\u0011\"\u0003v\u0011\u0019Ah\u0003)Q\u0005c\"9\u0011P\u0006a\u0001\n\u0013\u0001\bb\u0002>\u0017\u0001\u0004%Ia\u001f\u0005\u0007{Z\u0001\u000b\u0015B9\t\u000fy4\u0002\u0019!C\u0005\u007f\"I\u0011\u0011\u0001\fA\u0002\u0013%\u00111\u0001\u0005\b\u0003\u000f1\u0002\u0015)\u0003h\u0011!\tIA\u0006a\u0001\n\u0013y\b\"CA\u0006-\u0001\u0007I\u0011BA\u0007\u0011\u001d\t\tB\u0006Q!\n\u001dD\u0001\"a\u0005\u0017\u0001\u0004%Ia \u0005\n\u0003+1\u0002\u0019!C\u0005\u0003/Aq!a\u0007\u0017A\u0003&q\rC\u0005\u0002\u001eY\u0001\r\u0011\"\u0003\u0002 !I\u0011\u0011\u0007\fA\u0002\u0013%\u00111\u0007\u0005\t\u0003o1\u0002\u0015)\u0003\u0002\"!I\u0011\u0011\b\fA\u0002\u0013%\u00111\b\u0005\n\u0003\u00072\u0002\u0019!C\u0005\u0003\u000bB\u0001\"!\u0013\u0017A\u0003&\u0011Q\b\u0005\t\u0003\u00172\u0002\u0019!C\u0005\u007f\"I\u0011Q\n\fA\u0002\u0013%\u0011q\n\u0005\b\u0003'2\u0002\u0015)\u0003h\u0011!\t)F\u0006a\u0001\n\u0013y\b\"CA,-\u0001\u0007I\u0011BA-\u0011\u001d\tiF\u0006Q!\n\u001dD\u0001\"a\u0018\u0017\u0001\u0004%Ia \u0005\n\u0003C2\u0002\u0019!C\u0005\u0003GBq!a\u001a\u0017A\u0003&q\rC\u0006\u0002jY\u0001\r\u00111A\u0005\n\u0005-\u0004bCA:-\u0001\u0007\t\u0019!C\u0005\u0003kB1\"!\u001f\u0017\u0001\u0004\u0005\t\u0015)\u0003\u0002n!A\u00111\u0010\fA\u0002\u0013%q\u0010C\u0005\u0002~Y\u0001\r\u0011\"\u0003\u0002\u0000!9\u00111\u0011\f!B\u00139\u0007bBAC-\u0011\u0005\u0011q\u0011\u0005\b\u0003'3B\u0011AAK\u0011\u001d\tiJ\u0006C\u0001\u0003?Cq!!*\u0017\t\u0003\t9\u000bC\u0004\u00022Z!\t!a-\t\u000f\u0005]f\u0003\"\u0003\u0002:\"9\u00111\u0018\f\u0005\n\u0005u\u0006bBA`-\u0011%\u0011Q\u0018\u0005\b\u0003\u00034B\u0011BAb\u0011\u001d\tIM\u0006C\u0005\u0003\u0017Dq!a4\u0017\t\u0013\t\t\u000eC\u0004\u0002VZ!I!!/\u0002\u0011\u0005\u001b\u0015*\u0011\u001c6kER!a\u0013'\u0002\u000f5|7ON\u001b6c)\u0011QJT\u0001\u000ba\u0016\u0014\u0018\u000e\u001d5fe\u0006d'BA(Q\u0003\r\u0019'-\u001c\u0006\u0002#\u00069QoY3t_\u001a$8\u0001\u0001\t\u0003)\u0006i\u0011A\u0013\u0002\t\u0003\u000eK\u0015IN\u001b6cM\u0011\u0011a\u0016\t\u00031nk\u0011!\u0017\u0006\u00025\u0006)1oY1mC&\u0011A,\u0017\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0016\u0001B1dS\u0006,\u0012!\u0019\t\u0003)Z\u0019\"AF,\u0002\r%\u0014\u0018\u000fT8x!\u0011AVm\u001a6\n\u0005\u0019L&!\u0003$v]\u000e$\u0018n\u001c82!\tA\u0006.\u0003\u0002j3\n9!i\\8mK\u0006t\u0007C\u0001-l\u0013\ta\u0017L\u0001\u0003V]&$HCA1o\u0011\u0015\u0019\u0007\u00041\u0001e\u0003=\u0019w.\\7b]\u0012\u0014VmZ5ti\u0016\u0014X#A9\u0011\u0005a\u0013\u0018BA:Z\u0005\rIe\u000e^\u0001\u0014G>lW.\u00198e%\u0016<\u0017n\u001d;fe~#S-\u001d\u000b\u0003UZDqa\u001e\u000e\u0002\u0002\u0003\u0007\u0011/A\u0002yIE\n\u0001cY8n[\u0006tGMU3hSN$XM\u001d\u0011\u0002\u001f\r|g\u000e\u001e:pYJ+w-[:uKJ\f1cY8oiJ|GNU3hSN$XM]0%KF$\"A\u001b?\t\u000f]l\u0012\u0011!a\u0001c\u0006\u00012m\u001c8ue>d'+Z4jgR,'\u000fI\u0001\u0004I\u000e$W#A4\u0002\u000f\u0011\u001cGm\u0018\u0013fcR\u0019!.!\u0002\t\u000f]\u0004\u0013\u0011!a\u0001O\u0006!Am\u00193!\u0003\r!7O]\u0001\bIN\u0014x\fJ3r)\rQ\u0017q\u0002\u0005\bo\u000e\n\t\u00111\u0001h\u0003\u0011!7O\u001d\u0011\u0002\u0007%\u0014\u0018/A\u0004jeF|F%Z9\u0015\u0007)\fI\u0002C\u0004xM\u0005\u0005\t\u0019A4\u0002\t%\u0014\u0018\u000fI\u0001\fS:\u0004X\u000f^*ue\u0016\fW.\u0006\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012AA5p\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003K\u00111\"\u00138qkR\u001cFO]3b[\u0006y\u0011N\u001c9viN#(/Z1n?\u0012*\u0017\u000fF\u0002k\u0003kA\u0001b^\u0015\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\rS:\u0004X\u000f^*ue\u0016\fW\u000eI\u0001\r_V$\b/\u001e;TiJ,\u0017-\\\u000b\u0003\u0003{\u0001B!a\t\u0002@%!\u0011\u0011IA\u0013\u00051yU\u000f\u001e9viN#(/Z1n\u0003AyW\u000f\u001e9viN#(/Z1n?\u0012*\u0017\u000fF\u0002k\u0003\u000fB\u0001b\u001e\u0017\u0002\u0002\u0003\u0007\u0011QH\u0001\u000e_V$\b/\u001e;TiJ,\u0017-\u001c\u0011\u0002!%\u0014\u0018/T1ti\u0016\u0014XI\\1cY\u0016$\u0017\u0001F5sc6\u000b7\u000f^3s\u000b:\f'\r\\3e?\u0012*\u0017\u000fF\u0002k\u0003#Bqa^\u0018\u0002\u0002\u0003\u0007q-A\tjeFl\u0015m\u001d;fe\u0016s\u0017M\u00197fI\u0002\n!#\u001b:r%\u0016\u001cW-\u001b<fe\u0016s\u0017M\u00197fI\u00061\u0012N]9SK\u000e,\u0017N^3s\u000b:\f'\r\\3e?\u0012*\u0017\u000fF\u0002k\u00037Bqa\u001e\u001a\u0002\u0002\u0003\u0007q-A\njeF\u0014VmY3jm\u0016\u0014XI\\1cY\u0016$\u0007%A\u000bjeF$&/\u00198t[&$H/\u001a:F]\u0006\u0014G.\u001a3\u00023%\u0014\u0018\u000f\u0016:b]Nl\u0017\u000e\u001e;fe\u0016s\u0017M\u00197fI~#S-\u001d\u000b\u0004U\u0006\u0015\u0004bB<6\u0003\u0003\u0005\raZ\u0001\u0017SJ\fHK]1og6LG\u000f^3s\u000b:\f'\r\\3eA\u0005)2m\u001c8oK\u000e$\u0018n\u001c8E_^t\u0007*\u00198eY\u0016\u0014XCAA7!\u0011A\u0016q\u000e6\n\u0007\u0005E\u0014LA\u0005Gk:\u001cG/[8oa\u0005I2m\u001c8oK\u000e$\u0018n\u001c8E_^t\u0007*\u00198eY\u0016\u0014x\fJ3r)\rQ\u0017q\u000f\u0005\tob\n\t\u00111\u0001\u0002n\u000512m\u001c8oK\u000e$\u0018n\u001c8E_^t\u0007*\u00198eY\u0016\u0014\b%\u0001\bd_:4XM\u001d;U_V\u0003\b/\u001a:\u0002%\r|gN^3siR{W\u000b\u001d9fe~#S-\u001d\u000b\u0004U\u0006\u0005\u0005bB<<\u0003\u0003\u0005\raZ\u0001\u0010G>tg/\u001a:u)>,\u0006\u000f]3sA\u0005Q1/\u001a;TiJ,\u0017-\\:\u0015\u000f)\fI)!$\u0002\u0012\"9\u00111R\u001fA\u0002\u0005\u0005\u0012AA5o\u0011\u001d\ty)\u0010a\u0001\u0003{\t1a\\;u\u0011\u001d\tI'\u0010a\u0001\u0003[\n!bZ3u'R\u0014X-Y7t)\t\t9\nE\u0004Y\u00033\u000b\t#!\u0010\n\u0007\u0005m\u0015L\u0001\u0004UkBdWMM\u0001\u0016g\u0016$8i\u001c8wKJ$Hk\\+qa\u0016\u00148)Y:f)\rQ\u0017\u0011\u0015\u0005\u0007\u0003G{\u0004\u0019A4\u0002\u000f\r|gN^3si\u0006)qO]5uKR)!.!+\u0002.\"1\u00111\u0016!A\u0002E\f\u0001B]3hSN$XM\u001d\u0005\u0007\u0003_\u0003\u0005\u0019A9\u0002\u000bY\fG.^3\u0002\tI,\u0017\r\u001a\u000b\u0004c\u0006U\u0006BBAV\u0003\u0002\u0007\u0011/A\u0003sKN,G\u000fF\u0001k\u00039\u0019H/\u0019;vgJ+w-[:uKJ$\u0012!]\u0001\u0019e\u0016\fGMU3dK&4XM\u001d#bi\u0006\u0014VmZ5ti\u0016\u0014\u0018!G<sSR,GK]1og6LG\u000fR1uCJ+w-[:uKJ$2A[Ac\u0011\u0019\t9-\u0012a\u0001c\u0006!A-\u0019;b\u0003Q9(/\u001b;f\u0007>lW.\u00198e%\u0016<\u0017n\u001d;feR\u0019!.!4\t\r\u0005\u001dg\t1\u0001r\u0003Q9(/\u001b;f\u0007>tGO]8m%\u0016<\u0017n\u001d;feR\u0019!.a5\t\r\u0005\u001dw\t1\u0001r\u0003!\u0019\u0007.Z2l\u0013J\u000b\u0016\u0001C1dS\u0006|F%Z9\u0015\u0007)\fY\u000eC\u0004x\t\u0005\u0005\t\u0019A1\u0002\u000b\u0005\u001c\u0017.\u0019\u0011\u0002\u0019\r|gNZ5h\t&\fGn\\4\u0016\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\u0006g^Lgn\u001a\u0006\u0003\u0003[\fQA[1wCbLA!!=\u0002h\n9!\nR5bY><\u0017\u0001E2p]\u001aLw\rR5bY><w\fJ3r)\rQ\u0017q\u001f\u0005\to\u001e\t\t\u00111\u0001\u0002d\u0006i1m\u001c8gS\u001e$\u0015.\u00197pO\u0002\n1b\u001d;biV\u001cH*\u00192fYV\u0011\u0011q \t\u0005\u0003K\u0014\t!\u0003\u0003\u0003\u0004\u0005\u001d(A\u0002&MC\n,G.A\bti\u0006$Xo\u001d'bE\u0016dw\fJ3r)\rQ'\u0011\u0002\u0005\to*\t\t\u00111\u0001\u0002\u0000\u0006a1\u000f^1ukNd\u0015MY3mA\u000511o\\2lKR,\"A!\u0005\u0011\t\tM!\u0011D\u0007\u0003\u0005+QAAa\u0006\u0002*\u0005\u0019a.\u001a;\n\t\tm!Q\u0003\u0002\u0007'>\u001c7.\u001a;\u0002\u0015M|7m[3u?\u0012*\u0017\u000fF\u0002k\u0005CA\u0001b^\u0007\u0002\u0002\u0003\u0007!\u0011C\u0001\bg>\u001c7.\u001a;!\u00035\u0019wN\u001c8fGR\u0014U\u000f\u001e;p]V\u0011!\u0011\u0006\t\u0005\u0003K\u0014Y#\u0003\u0003\u0003.\u0005\u001d(a\u0002&CkR$xN\\\u0001\u000fG>tg.Z2u\u0005V$Ho\u001c8!\u0003\u001d)(\u000f\u001c+fqR,\"A!\u000e\u0011\t\u0005\u0015(qG\u0005\u0005\u0005s\t9O\u0001\u0006K)\u0016DHOR5fY\u0012\f\u0001\"\u001e:m)\u0016DH\u000fI\u0001\bg\u0016$\u0018iQ%B)\rQ'\u0011\t\u0005\u0006?N\u0001\r!Y\u0001\u0011g\"|woQ8oM&<G)[1m_\u001e$2A\u001bB$\u0011\u001d\u0011I\u0005\u0006a\u0001\u0005\u0017\na\u0001]1sK:$\b\u0003BAs\u0005\u001bJAAa\u0014\u0002h\n1!J\u0012:b[\u0016\u0004")
public class ACIA6551 {
    private final Function1<Object, BoxedUnit> irqLow;
    private int commandRegister;
    private int controlRegister;
    private boolean dcd;
    private boolean dsr;
    private boolean irq;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean irqMasterEnabled;
    private boolean irqReceiverEnabled;
    private boolean irqTransmitterEnabled;
    private Function0<BoxedUnit> connectionDownHandler;
    private boolean convertToUpper;

    public static void showConfigDialog(JFrame parent) {
        ACIA6551$.MODULE$.showConfigDialog(parent);
    }

    public static void setACIA(ACIA6551 acia) {
        ACIA6551$.MODULE$.setACIA(acia);
    }

    private int commandRegister() {
        return this.commandRegister;
    }

    private void commandRegister_$eq(int x$1) {
        this.commandRegister = x$1;
    }

    private int controlRegister() {
        return this.controlRegister;
    }

    private void controlRegister_$eq(int x$1) {
        this.controlRegister = x$1;
    }

    private boolean dcd() {
        return this.dcd;
    }

    private void dcd_$eq(boolean x$1) {
        this.dcd = x$1;
    }

    private boolean dsr() {
        return this.dsr;
    }

    private void dsr_$eq(boolean x$1) {
        this.dsr = x$1;
    }

    private boolean irq() {
        return this.irq;
    }

    private void irq_$eq(boolean x$1) {
        this.irq = x$1;
    }

    private InputStream inputStream() {
        return this.inputStream;
    }

    private void inputStream_$eq(InputStream x$1) {
        this.inputStream = x$1;
    }

    private OutputStream outputStream() {
        return this.outputStream;
    }

    private void outputStream_$eq(OutputStream x$1) {
        this.outputStream = x$1;
    }

    private boolean irqMasterEnabled() {
        return this.irqMasterEnabled;
    }

    private void irqMasterEnabled_$eq(boolean x$1) {
        this.irqMasterEnabled = x$1;
    }

    private boolean irqReceiverEnabled() {
        return this.irqReceiverEnabled;
    }

    private void irqReceiverEnabled_$eq(boolean x$1) {
        this.irqReceiverEnabled = x$1;
    }

    private boolean irqTransmitterEnabled() {
        return this.irqTransmitterEnabled;
    }

    private void irqTransmitterEnabled_$eq(boolean x$1) {
        this.irqTransmitterEnabled = x$1;
    }

    private Function0<BoxedUnit> connectionDownHandler() {
        return this.connectionDownHandler;
    }

    private void connectionDownHandler_$eq(Function0<BoxedUnit> x$1) {
        this.connectionDownHandler = x$1;
    }

    private boolean convertToUpper() {
        return this.convertToUpper;
    }

    private void convertToUpper_$eq(boolean x$1) {
        this.convertToUpper = x$1;
    }

    public void setStreams(InputStream in, OutputStream out, Function0<BoxedUnit> connectionDownHandler) {
        this.inputStream_$eq(in);
        this.outputStream_$eq(out);
        this.connectionDownHandler_$eq(connectionDownHandler);
        this.dcd_$eq(in != null);
        this.dsr_$eq(in != null);
    }

    public Tuple2<InputStream, OutputStream> getStreams() {
        return new Tuple2((Object)this.inputStream(), (Object)this.outputStream());
    }

    public void setConvertToUpperCase(boolean convert) {
        this.convertToUpper_$eq(convert);
    }

    public void write(int register, int value) {
        int n = register & 3;
        switch (n) {
            case 0: {
                this.writeTransmitDataRegister(value);
                return;
            }
            case 1: {
                this.reset();
                return;
            }
            case 2: {
                this.writeCommandRegister(value);
                return;
            }
            case 3: {
                this.writeControlRegister(value);
                return;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public int read(int register) {
        int n;
        int n2 = register & 3;
        switch (n2) {
            case 0: {
                n = this.readReceiverDataRegister();
                break;
            }
            case 1: {
                n = this.statusRegister();
                break;
            }
            case 2: {
                n = this.commandRegister();
                break;
            }
            case 3: {
                n = this.controlRegister();
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
        }
        int r = n;
        return r;
    }

    private void reset() {
        this.controlRegister_$eq(0);
        this.commandRegister_$eq(2);
        this.dcd_$eq(false);
        this.dsr_$eq(false);
        this.irq_$eq(false);
        this.irqMasterEnabled_$eq(false);
        this.irqReceiverEnabled_$eq(false);
        this.irqTransmitterEnabled_$eq(false);
    }

    private int statusRegister() {
        int st = 16;
        if (this.inputStream() != null && this.inputStream().available() > 0) {
            st |= 8;
        }
        if (!this.dcd()) {
            st |= 0x20;
        }
        if (!this.dsr()) {
            st |= 0x40;
        }
        if (this.irq()) {
            st |= 0x80;
        }
        this.irq_$eq(false);
        this.checkIRQ();
        return st;
    }

    /*
     * WARNING - void declaration
     */
    private int readReceiverDataRegister() {
        int n;
        block4: {
            try {
                void var1_1;
                int rec;
                int n2 = rec = this.inputStream() != null ? this.inputStream().read() : 0;
                if (this.inputStream() != null && this.inputStream().available() > 0 && this.irqReceiverEnabled()) {
                    this.irq_$eq(true);
                    this.checkIRQ();
                }
                if (this.convertToUpper()) {
                    n = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper((char)rec));
                    break block4;
                }
                n = var1_1;
            }
            catch (IOException io) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("ACIA connection error: ").append(io).toString());
                this.connectionDownHandler().apply$mcV$sp();
                n = 0;
            }
        }
        return n;
    }

    private void writeTransmitDataRegister(int data) {
        block3: {
            try {
                if (this.outputStream() == null) break block3;
                this.outputStream().write(data);
                this.outputStream().flush();
                if (this.irqTransmitterEnabled()) {
                    this.irq_$eq(true);
                    this.checkIRQ();
                }
            }
            catch (IOException io) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("ACIA connection error: ").append(io).toString());
                this.connectionDownHandler().apply$mcV$sp();
            }
        }
    }

    private void writeCommandRegister(int data) {
        try {
            this.commandRegister_$eq(data);
            this.irqMasterEnabled_$eq((this.commandRegister() & 1) == 1);
            this.irqReceiverEnabled_$eq((this.commandRegister() & 2) == 0);
            this.irqTransmitterEnabled_$eq((this.commandRegister() >> 2 & 1) == 1);
            if (this.irqReceiverEnabled() && this.inputStream() != null && this.inputStream().available() > 0) {
                this.irq_$eq(true);
            }
            this.checkIRQ();
        }
        catch (IOException iOException) {}
    }

    private void writeControlRegister(int data) {
        this.controlRegister_$eq(data);
    }

    private void checkIRQ() {
        this.irqLow.apply((Object)BoxesRunTime.boxToBoolean((this.irqMasterEnabled() && this.irq() ? 1 : 0) != 0));
    }

    public ACIA6551(Function1<Object, BoxedUnit> irqLow) {
        this.irqLow = irqLow;
        this.commandRegister = 0;
        this.controlRegister = 0;
        this.dcd = false;
        this.dsr = false;
        this.irq = false;
        this.inputStream = null;
        this.outputStream = null;
        this.irqMasterEnabled = false;
        this.irqReceiverEnabled = false;
        this.irqTransmitterEnabled = false;
        this.convertToUpper = false;
    }
}

