/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.rs232;

import java.io.Serializable;
import scala.Function0;
import ucesoft.cbm.Log$;
import ucesoft.cbm.peripheral.rs232.StreamRS232;

public final class ProcessRS232$
extends StreamRS232 {
    public static final ProcessRS232$ MODULE$ = new ProcessRS232$();
    private static final String componentID = "Process RS-232";
    private static Process process;
    private static String processStr;
    private static String config;

    static {
        config = "";
    }

    @Override
    public String componentID() {
        return componentID;
    }

    @Override
    public String getDescription() {
        return "Connects to an external process and uses its standard input/output as channels. Connection String syntax: external process,baud,bits,parity,stops";
    }

    @Override
    public void setConfiguration(String conf) {
        String[] parts = conf.split(",");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Bad Process RS-232 configuration string. Expected <external process>,<baud>,<bits>,<parity>,<stops>");
        }
        super.setConfiguration(conf.substring(conf.indexOf(",") + 1));
        processStr = parts[0];
        config = conf;
    }

    @Override
    public String connectionInfo() {
        return config;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean lastEnabled = this.isEnabled();
        if (enabled) {
            if (lastEnabled) {
                this.disconnect();
            }
            String[] pars = processStr.split(" ");
            ProcessBuilder pb = new ProcessBuilder(pars);
            process = pb.start();
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(8).append(processStr).append(" started").toString());
            this.setStreams(process.getInputStream(), process.getOutputStream(), processStr);
        } else {
            this.disconnect();
        }
        super.setEnabled(enabled);
    }

    @Override
    public void disconnect() {
        try {
            if (process != null) {
                process.destroy();
            }
            super.disconnect();
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Process ").append(processStr).append(" terminated").toString());
        }
        catch (Throwable throwable) {}
    }

    public String toString() {
        return new StringBuilder(0).append(this.componentID()).append((Object)(this.isEnabled() ? "(enabled)" : "")).toString();
    }

    private ProcessRS232$() {
    }
}

