/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.rs232;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.net.telnet.TelnetClient;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.Clock;
import ucesoft.cbm.Clock$;
import ucesoft.cbm.ClockEvent;
import ucesoft.cbm.ClockEvent$;
import ucesoft.cbm.Log$;
import ucesoft.cbm.peripheral.rs232.HayesResultCode$;
import ucesoft.cbm.peripheral.rs232.StreamRS232;

@ScalaSignature(bytes="\u0006\u0005=<QAE\n\t\u0002q1QAH\n\t\u0002}AQ!J\u0001\u0005\u000294AAH\n\u0001C!)Qe\u0001C\u0001M!9qe\u0001b\u0001\n\u0003A\u0003BB\u0019\u0004A\u0003%\u0011\u0006\u0003\u00043\u0007\u0001\u0006Ka\r\u0005\u0007\u0003\u000e\u0001\u000b\u0015B\u0015\t\r\t\u001b\u0001\u0015)\u0003D\u0011\u0019I5\u0001)Q\u0005S!1!j\u0001Q\u0001\n-CQaT\u0002\u0005\u0002!BQ\u0001U\u0002\u0005BECQ!Y\u0002\u0005B\tDQaY\u0002\u0005B\u0011DQA[\u0002\u0005B-DQ\u0001\\\u0002\u0005B5\f1\u0002V3m]\u0016$(k\u0015\u001a4e)\u0011A#F\u0001\u0006eN\u00144G\r\u0006\u0003-]\t!\u0002]3sSBDWM]1m\u0015\tA\u0012$A\u0002dE6T\u0011AG\u0001\bk\u000e,7o\u001c4u\u0007\u0001\u0001\"!H\u0001\u000e\u0003M\u00111\u0002V3m]\u0016$(k\u0015\u001a4eM\u0011\u0011\u0001\t\t\u0003;\r\u0019\"a\u0001\u0012\u0011\u0005u\u0019\u0013B\u0001\u0013\u0014\u0005-\u0019FO]3b[J\u001b&g\r\u001a\u0002\rqJg.\u001b;?)\u0005\u0001\u0013aC2p[B|g.\u001a8u\u0013\u0012+\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\u0006a1m\\7q_:,g\u000e^%EA\u000511\r\\5f]R\u0004\"\u0001N \u000e\u0003UR!AN\u001c\u0002\rQ,GN\\3u\u0015\tA\u0014(A\u0002oKRT!AO\u001e\u0002\u000f\r|W.\\8og*\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h\u0013\t\u0001UG\u0001\u0007UK2tW\r^\"mS\u0016tG/\u0001\u0003i_N$\u0018\u0001\u00029peR\u0004\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u00131!\u00138u\u0003\u0019\u0019wN\u001c4jO\u0006\u00191\r\\6\u0011\u00051kU\"A\f\n\u00059;\"!B\"m_\u000e\\\u0017AD4fi\u0012+7o\u0019:jaRLwN\\\u0001\u0011g\u0016$8i\u001c8gS\u001e,(/\u0019;j_:$\"AU+\u0011\u0005\u0011\u001b\u0016B\u0001+F\u0005\u0011)f.\u001b;\t\u000bYk\u0001\u0019A,\u0002\t\r|gN\u001a\t\u00031~s!!W/\u0011\u0005i+U\"A.\u000b\u0005q[\u0012A\u0002\u001fs_>$h(\u0003\u0002_\u000b\u00061\u0001K]3eK\u001aL!\u0001\r1\u000b\u0005y+\u0015AD2p]:,7\r^5p]&sgm\\\u000b\u0002/\u0006Q1/\u001a;F]\u0006\u0014G.\u001a3\u0015\u0005I+\u0007\"\u00024\u0010\u0001\u00049\u0017aB3oC\ndW\r\u001a\t\u0003\t\"L!![#\u0003\u000f\t{w\u000e\\3b]\u0006QA-[:d_:tWm\u0019;\u0015\u0003I\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002/R\tA\u0004")
public class TelnetRS232
extends StreamRS232 {
    private final String componentID;
    private TelnetClient client = new TelnetClient();
    private String host = "";
    private int port = 0;
    private String config = "";
    private final Clock clk = Clock$.MODULE$.systemClock();

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public String getDescription() {
        return "<html><b>Connects to a telnet server (like BBS)</b>.<br>Connection String syntax: <i>host:port,baud,bits,parity,stops</i> to connect or<br><i>baud,bits,parity,stops</i> to use 'at' modem commands</html>";
    }

    @Override
    public void setConfiguration(String conf) {
        String string;
        String[] parts = conf.split(",");
        int n = parts.length;
        switch (n) {
            case 4: {
                string = conf;
                break;
            }
            case 5: {
                string = conf.substring(conf.indexOf(",") + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad Telnet RS-232 configuration string. Expected [<host>:<port>,<baud>,]<bits>,<parity>,<stops>");
            }
        }
        String confString = string;
        super.setConfiguration(confString);
        if (parts.length == 5) {
            String[] pars = parts[0].split(":");
            if (pars.length != 2) {
                throw new IllegalArgumentException("Bad Telnet RS-232 configuration string. Bad host:port parameter");
            }
            this.host = pars[0];
            this.port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(pars[1]));
        } else {
            this.host = "";
        }
        this.config = conf;
    }

    @Override
    public String connectionInfo() {
        return this.config;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean lastEnabled = this.isEnabled();
        if (enabled) {
            if (lastEnabled) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Disconnecting from ").append($this.host).append("...").toString());
                try {
                    this.client.disconnect();
                }
                catch (Throwable throwable) {}
                super.setEnabled(false);
            }
            String string = this.host;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Connecting to ").append($this.host).append(":").append($this.port).append("...").toString());
                this.client = new TelnetClient();
                try {
                    this.client.connect(this.host, this.port);
                    this.modem().commandModeMessage(HayesResultCode$.MODULE$.CONNECT());
                    this.clk.schedule(new ClockEvent("RS232-waitConnect", this.clk.currentCycles() + 1000000L, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)x$1 -> this.setStreams($this.client.getInputStream(), $this.client.getOutputStream(), new StringBuilder(1).append($this.host).append(":").append($this.port).toString()), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
                }
                catch (IOException io) {
                    Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Telnet: Cannot connect to ").append($this.host).append(":").append($this.port).append(". ").append(io).toString());
                    this.disconnect();
                }
            }
        } else {
            this.disconnect();
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Disconnected from ").append($this.host).toString());
        }
        super.setEnabled(enabled);
    }

    @Override
    public void disconnect() {
        try {
            this.client.disconnect();
        }
        catch (Throwable throwable) {}
        super.disconnect();
    }

    public String toString() {
        return new StringBuilder(0).append(this.componentID()).append((Object)(this.isEnabled() ? "(enabled)" : "")).toString();
    }

    public TelnetRS232() {
        this.componentID = "Telnet (BBS) RS-232";
    }
}

