/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid;

import ucesoft.cbm.peripheral.sid.resid.ISIDDefs;
import ucesoft.cbm.peripheral.sid.resid.PointPlotter;
import ucesoft.cbm.peripheral.sid.resid.SID;

public class Filter {
    public static final boolean SPLINE_BRUTE_FORCE = false;
    protected boolean enabled;
    protected int fc = 0;
    protected int res = 0;
    protected int filt = 0;
    protected int voice3off = 0;
    protected int hp_bp_lp = 0;
    protected int vol = 0;
    protected int mixer_DC;
    protected int Vhp = 0;
    protected int Vbp = 0;
    protected int Vlp = 0;
    protected int Vnf = 0;
    int DLthreshold;
    int DLsteepness;
    int DHthreshold;
    int DHsteepness;
    int DLlp;
    int DLbp;
    int DLhp;
    int DHlp;
    int DHbp;
    int DHhp;
    protected int w0;
    protected int w0_ceil_1;
    protected int w0_ceil_dt;
    protected int _1024_div_Q;
    protected int[] f0_6581 = new int[2048];
    protected int[] f0_8580 = new int[2048];
    protected int[] f0;
    protected static int[][] f0_points_6581 = new int[][]{{0, 220}, {0, 220}, {128, 230}, {256, 250}, {384, 300}, {512, 420}, {640, 780}, {768, 1600}, {832, 2300}, {896, 3200}, {960, 4300}, {992, 5000}, {1008, 5400}, {1016, 5700}, {1023, 6000}, {1023, 6000}, {1024, 4600}, {1024, 4600}, {1032, 4800}, {1056, 5300}, {1088, 6000}, {1120, 6600}, {1152, 7200}, {1280, 9500}, {1408, 12000}, {1536, 14500}, {1664, 16000}, {1792, 17100}, {1920, 17700}, {2047, 18000}, {2047, 18000}};
    protected static int[][] f0_points_8580 = new int[][]{{0, 0}, {0, 0}, {128, 800}, {256, 1600}, {384, 2500}, {512, 3300}, {640, 4100}, {768, 4800}, {896, 5600}, {1024, 6500}, {1152, 7500}, {1280, 8400}, {1408, 9200}, {1536, 9800}, {1664, 10500}, {1792, 11000}, {1920, 11700}, {2047, 12500}, {2047, 12500}};
    protected int[][] f0_points;
    protected int f0_count;

    public void clock(int n, int n2, int n3, int n4) {
        n >>= 7;
        n2 >>= 7;
        n3 = this.voice3off != 0 && (this.filt & 4) == 0 ? 0 : (n3 >>= 7);
        n4 >>= 7;
        if (!this.enabled) {
            this.Vnf = n + n2 + n3 + n4;
            this.Vlp = 0;
            this.Vbp = 0;
            this.Vhp = 0;
            return;
        }
        this.Vnf = 0;
        int n5 = 0;
        if (SID.ANTTI_LANKILA_PATCH) {
            if ((this.filt & 1) != 0) {
                n5 += n;
            } else {
                this.Vnf += n;
            }
            if ((this.filt & 2) != 0) {
                n5 += n2;
            } else {
                this.Vnf += n2;
            }
            if ((this.filt & 4) != 0) {
                n5 += n3;
            } else {
                this.Vnf += n3;
            }
            if ((this.filt & 8) != 0) {
                n5 += n4;
            } else {
                this.Vnf += n4;
            }
        } else {
            switch (this.filt) {
                default: {
                    n5 = 0;
                    this.Vnf = n + n2 + n3 + n4;
                    break;
                }
                case 1: {
                    n5 = n;
                    this.Vnf = n2 + n3 + n4;
                    break;
                }
                case 2: {
                    n5 = n2;
                    this.Vnf = n + n3 + n4;
                    break;
                }
                case 3: {
                    n5 = n + n2;
                    this.Vnf = n3 + n4;
                    break;
                }
                case 4: {
                    n5 = n3;
                    this.Vnf = n + n2 + n4;
                    break;
                }
                case 5: {
                    n5 = n + n3;
                    this.Vnf = n2 + n4;
                    break;
                }
                case 6: {
                    n5 = n2 + n3;
                    this.Vnf = n + n4;
                    break;
                }
                case 7: {
                    n5 = n + n2 + n3;
                    this.Vnf = n4;
                    break;
                }
                case 8: {
                    n5 = n4;
                    this.Vnf = n + n2 + n3;
                    break;
                }
                case 9: {
                    n5 = n + n4;
                    this.Vnf = n2 + n3;
                    break;
                }
                case 10: {
                    n5 = n2 + n4;
                    this.Vnf = n + n3;
                    break;
                }
                case 11: {
                    n5 = n + n2 + n4;
                    this.Vnf = n3;
                    break;
                }
                case 12: {
                    n5 = n3 + n4;
                    this.Vnf = n + n2;
                    break;
                }
                case 13: {
                    n5 = n + n3 + n4;
                    this.Vnf = n2;
                    break;
                }
                case 14: {
                    n5 = n2 + n3 + n4;
                    this.Vnf = n;
                    break;
                }
                case 15: {
                    n5 = n + n2 + n3 + n4;
                    this.Vnf = 0;
                }
            }
        }
        if (SID.ANTTI_LANKILA_PATCH) {
            int n6;
            int n7 = (this.Vlp * this.DHlp + this.Vbp * this.DHbp + this.Vhp * this.DHhp >> 8) + n5;
            if (n7 < this.DHthreshold) {
                n7 = this.DHthreshold;
            }
            if ((n6 = (this.Vlp * this.DLlp + this.Vbp * this.DLbp + this.Vhp * this.DLhp >> 8) + n5) < this.DLthreshold) {
                n6 = this.DLthreshold;
            }
            int n8 = this.w0 + this.w0 * (n7 - this.DHthreshold >> 4) / this.DHsteepness;
            int n9 = this.w0 + this.w0 * (n6 - this.DLthreshold >> 4) / this.DLsteepness;
            if (n8 > this.w0_ceil_1) {
                n8 = this.w0_ceil_1;
            }
            if (n9 > this.w0_ceil_1) {
                n9 = this.w0_ceil_1;
            }
            this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - n5;
            this.Vlp -= n9 * this.Vbp >> 20;
            this.Vbp -= n8 * this.Vhp >> 20;
        } else {
            int n10 = this.w0_ceil_1 * this.Vhp >> 20;
            int n11 = this.w0_ceil_1 * this.Vbp >> 20;
            this.Vbp -= n10;
            this.Vlp -= n11;
            this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - n5;
        }
    }

    public void clock(int n, int n2, int n3, int n4, int n5) {
        n2 >>= 7;
        n3 >>= 7;
        n4 = this.voice3off != 0 && (this.filt & 4) == 0 ? 0 : (n4 >>= 7);
        n5 >>= 7;
        if (!this.enabled) {
            this.Vnf = n2 + n3 + n4 + n5;
            this.Vlp = 0;
            this.Vbp = 0;
            this.Vhp = 0;
            return;
        }
        this.Vnf = 0;
        int n6 = 0;
        if (!SID.ANTTI_LANKILA_PATCH) {
            switch (this.filt) {
                default: {
                    n6 = 0;
                    this.Vnf = n2 + n3 + n4 + n5;
                    break;
                }
                case 1: {
                    n6 = n2;
                    this.Vnf = n3 + n4 + n5;
                    break;
                }
                case 2: {
                    n6 = n3;
                    this.Vnf = n2 + n4 + n5;
                    break;
                }
                case 3: {
                    n6 = n2 + n3;
                    this.Vnf = n4 + n5;
                    break;
                }
                case 4: {
                    n6 = n4;
                    this.Vnf = n2 + n3 + n5;
                    break;
                }
                case 5: {
                    n6 = n2 + n4;
                    this.Vnf = n3 + n5;
                    break;
                }
                case 6: {
                    n6 = n3 + n4;
                    this.Vnf = n2 + n5;
                    break;
                }
                case 7: {
                    n6 = n2 + n3 + n4;
                    this.Vnf = n5;
                    break;
                }
                case 8: {
                    n6 = n5;
                    this.Vnf = n2 + n3 + n4;
                    break;
                }
                case 9: {
                    n6 = n2 + n5;
                    this.Vnf = n3 + n4;
                    break;
                }
                case 10: {
                    n6 = n3 + n5;
                    this.Vnf = n2 + n4;
                    break;
                }
                case 11: {
                    n6 = n2 + n3 + n5;
                    this.Vnf = n4;
                    break;
                }
                case 12: {
                    n6 = n4 + n5;
                    this.Vnf = n2 + n3;
                    break;
                }
                case 13: {
                    n6 = n2 + n4 + n5;
                    this.Vnf = n3;
                    break;
                }
                case 14: {
                    n6 = n3 + n4 + n5;
                    this.Vnf = n2;
                    break;
                }
                case 15: {
                    n6 = n2 + n3 + n4 + n5;
                    this.Vnf = 0;
                    break;
                }
            }
        } else {
            if ((this.filt & 1) != 0) {
                n6 += n2;
            } else {
                this.Vnf += n2;
            }
            if ((this.filt & 2) != 0) {
                n6 += n3;
            } else {
                this.Vnf += n3;
            }
            if ((this.filt & 4) != 0) {
                n6 += n4;
            } else {
                this.Vnf += n4;
            }
            if ((this.filt & 8) != 0) {
                n6 += n5;
            } else {
                this.Vnf += n5;
            }
        }
        int n7 = 8;
        while (n != 0) {
            if (n < n7) {
                n7 = n;
            }
            int n8 = this.w0_ceil_dt * n7 >> 6;
            int n9 = n8 * this.Vhp >> 14;
            int n10 = n8 * this.Vbp >> 14;
            this.Vbp -= n9;
            this.Vlp -= n10;
            this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - n6;
            n -= n7;
        }
    }

    public int output() {
        if (!this.enabled) {
            return (this.Vnf + this.mixer_DC) * this.vol;
        }
        if (!SID.ANTTI_LANKILA_PATCH) {
            int n;
            switch (this.hp_bp_lp) {
                default: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = this.Vlp;
                    break;
                }
                case 2: {
                    n = this.Vbp;
                    break;
                }
                case 3: {
                    n = this.Vlp + this.Vbp;
                    break;
                }
                case 4: {
                    n = this.Vhp;
                    break;
                }
                case 5: {
                    n = this.Vlp + this.Vhp;
                    break;
                }
                case 6: {
                    n = this.Vbp + this.Vhp;
                    break;
                }
                case 7: {
                    n = this.Vlp + this.Vbp + this.Vhp;
                }
            }
            return (this.Vnf + n + this.mixer_DC) * this.vol;
        }
        int n = 0;
        if ((this.hp_bp_lp & 1) != 0) {
            n += this.Vlp;
        }
        if ((this.hp_bp_lp & 2) != 0) {
            n += this.Vbp;
        }
        if ((this.hp_bp_lp & 4) != 0) {
            n += this.Vhp;
        }
        return (this.Vnf + n + this.mixer_DC) * this.vol;
    }

    public Filter() {
        this.enable_filter(true);
        this.interpolate(f0_points_6581, 0, f0_points_6581.length - 1, new PointPlotter(this.f0_6581), 1.0);
        this.interpolate(f0_points_8580, 0, f0_points_8580.length - 1, new PointPlotter(this.f0_8580), 1.0);
        this.set_chip_model(ISIDDefs.chip_model.MOS6581);
        this.set_distortion_properties(999999, 999999, 0, 0, 0, 999999, 999999, 0, 0, 0);
    }

    public void enable_filter(boolean bl) {
        this.enabled = bl;
    }

    public void set_chip_model(ISIDDefs.chip_model chip_model2) {
        if (chip_model2 == ISIDDefs.chip_model.MOS6581) {
            this.mixer_DC = -454;
            this.f0 = this.f0_6581;
            this.f0_points = f0_points_6581;
            this.f0_count = f0_points_6581.length;
        } else {
            this.mixer_DC = 0;
            this.f0 = this.f0_8580;
            this.f0_points = f0_points_8580;
            this.f0_count = f0_points_8580.length;
        }
        this.set_w0();
        this.set_Q();
    }

    void set_distortion_properties(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.DLthreshold = n;
        if (n2 < 16) {
            n2 = 16;
        }
        this.DLsteepness = n2 >> 4;
        this.DLlp = n3;
        this.DLbp = n4;
        this.DLhp = n5;
        this.DHthreshold = n6;
        if (n7 < 16) {
            n7 = 16;
        }
        this.DHsteepness = n7 >> 4;
        this.DHlp = n8;
        this.DHbp = n9;
        this.DHhp = n10;
    }

    public void reset() {
        this.fc = 0;
        this.res = 0;
        this.filt = 0;
        this.voice3off = 0;
        this.hp_bp_lp = 0;
        this.vol = 0;
        this.Vhp = 0;
        this.Vbp = 0;
        this.Vlp = 0;
        this.Vnf = 0;
        this.set_w0();
        this.set_Q();
    }

    public void writeFC_LO(int n) {
        this.fc = this.fc & 0x7F8 | n & 7;
        this.set_w0();
    }

    public void writeFC_HI(int n) {
        this.fc = n << 3 & 0x7F8 | this.fc & 7;
        this.set_w0();
    }

    public void writeRES_FILT(int n) {
        this.res = n >> 4 & 0xF;
        this.set_Q();
        this.filt = n & 0xF;
    }

    public void writeMODE_VOL(int n) {
        this.voice3off = n & 0x80;
        this.hp_bp_lp = n >> 4 & 7;
        this.vol = n & 0xF;
    }

    protected void set_w0() {
        this.w0 = (int)(Math.PI * 2 * (double)this.f0[this.fc] * 1.048576);
        this.w0_ceil_1 = SID.ANTTI_LANKILA_PATCH ? 118591 : (this.w0 <= 105414 ? this.w0 : 105414);
        this.w0_ceil_dt = this.w0 <= 26353 ? this.w0 : 26353;
    }

    protected void set_Q() {
        this._1024_div_Q = (int)(1024.0 / (0.707 + 1.0 * (double)this.res / 15.0));
    }

    public void fc_default(SID.FCPoints fCPoints) {
        fCPoints.points = this.f0_points;
        fCPoints.count = this.f0_count;
    }

    public PointPlotter fc_plotter() {
        return new PointPlotter(this.f0);
    }

    protected void cubic_coefficients(double d, double d2, double d3, double d4, double d5, double d6, Coefficients coefficients) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        coefficients.a = (d5 + d6 - 2.0 * d8 / d7) / (d7 * d7);
        coefficients.b = ((d6 - d5) / d7 - 3.0 * (d + d3) * coefficients.a) / 2.0;
        coefficients.c = d5 - (3.0 * d * coefficients.a + 2.0 * coefficients.b) * d;
        coefficients.d = d2 - ((d * coefficients.a + coefficients.b) * d + coefficients.c) * d;
    }

    protected void interpolate_brute_force(double d, double d2, double d3, double d4, double d5, double d6, PointPlotter pointPlotter, double d7) {
        Coefficients coefficients = new Coefficients();
        this.cubic_coefficients(d, d2, d3, d4, d5, d6, coefficients);
        for (double d8 = d; d8 <= d3; d8 += d7) {
            double d9 = ((coefficients.a * d8 + coefficients.b) * d8 + coefficients.c) * d8 + coefficients.d;
            pointPlotter.plot(d8, d9);
        }
    }

    protected void interpolate_forward_difference(double d, double d2, double d3, double d4, double d5, double d6, PointPlotter pointPlotter, double d7) {
        Coefficients coefficients = new Coefficients();
        this.cubic_coefficients(d, d2, d3, d4, d5, d6, coefficients);
        double d8 = ((coefficients.a * d + coefficients.b) * d + coefficients.c) * d + coefficients.d;
        double d9 = (3.0 * coefficients.a * (d + d7) + 2.0 * coefficients.b) * d * d7 + ((coefficients.a * d7 + coefficients.b) * d7 + coefficients.c) * d7;
        double d10 = (6.0 * coefficients.a * (d + d7) + 2.0 * coefficients.b) * d7 * d7;
        double d11 = 6.0 * coefficients.a * d7 * d7 * d7;
        for (double d12 = d; d12 <= d3; d12 += d7) {
            pointPlotter.plot(d12, d8);
            d8 += d9;
            d9 += d10;
            d10 += d11;
        }
    }

    protected double x(int[][] nArray, int n) {
        return nArray[n][0];
    }

    protected double y(int[][] nArray, int n) {
        return nArray[n][1];
    }

    public void interpolate(int[][] nArray, int n, int n2, PointPlotter pointPlotter, double d) {
        int n3 = n;
        int n4 = ++n3;
        int n5 = ++n4;
        ++n5;
        while (n4 != n2) {
            if (this.x(nArray, n3) != this.x(nArray, n4)) {
                double d2;
                double d3;
                if (this.x(nArray, n) == this.x(nArray, n3) && this.x(nArray, n4) == this.x(nArray, n5)) {
                    d2 = d3 = (this.y(nArray, n4) - this.y(nArray, n3)) / (this.x(nArray, n4) - this.x(nArray, n3));
                } else if (this.x(nArray, n) == this.x(nArray, n3)) {
                    d3 = (this.y(nArray, n5) - this.y(nArray, n3)) / (this.x(nArray, n5) - this.x(nArray, n3));
                    d2 = (3.0 * (this.y(nArray, n4) - this.y(nArray, n3)) / (this.x(nArray, n4) - this.x(nArray, n3)) - d3) / 2.0;
                } else if (this.x(nArray, n4) == this.x(nArray, n5)) {
                    d2 = (this.y(nArray, n4) - this.y(nArray, n)) / (this.x(nArray, n4) - this.x(nArray, n));
                    d3 = (3.0 * (this.y(nArray, n4) - this.y(nArray, n3)) / (this.x(nArray, n4) - this.x(nArray, n3)) - d2) / 2.0;
                } else {
                    d2 = (this.y(nArray, n4) - this.y(nArray, n)) / (this.x(nArray, n4) - this.x(nArray, n));
                    d3 = (this.y(nArray, n5) - this.y(nArray, n3)) / (this.x(nArray, n5) - this.x(nArray, n3));
                }
                this.interpolate_forward_difference(this.x(nArray, n3), this.y(nArray, n3), this.x(nArray, n4), this.y(nArray, n4), d2, d3, pointPlotter, d);
            }
            ++n;
            ++n3;
            ++n4;
            ++n5;
        }
    }

    public class Coefficients {
        public double a;
        public double b;
        public double c;
        public double d;
    }
}

