/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

import java.io.IOException;
import java.io.InputStream;
import ucesoft.cbm.peripheral.sid.resid4.DAC;

class SIDModel {
    final int id;
    final int wave_zero;
    final int voice_DC;
    public final int[][] waveforms = new int[8][4096];
    final int[] model_dacW;
    final int[] model_dacE;

    private static int[] getResourceAsInt(String string) {
        byte[] byArray;
        InputStream inputStream = SIDModel.class.getClassLoader().getResourceAsStream("resources/" + string);
        try {
            byArray = inputStream.readAllBytes();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't find resource " + string);
        }
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    SIDModel(String string, double d, int n, int n2, boolean bl, int n3) {
        this.id = n3;
        this.wave_zero = n;
        this.voice_DC = n2;
        this.model_dacW = DAC.build_dac_table(12, d, bl);
        this.model_dacE = DAC.build_dac_table(8, d, bl);
        this.waveforms[3] = SIDModel.getResourceAsInt("sid/wave" + string + "__ST.dat");
        this.waveforms[5] = SIDModel.getResourceAsInt("sid/wave" + string + "_P_T.dat");
        this.waveforms[6] = SIDModel.getResourceAsInt("sid/wave" + string + "_PS_.dat");
        this.waveforms[7] = SIDModel.getResourceAsInt("sid/wave" + string + "_PST.dat");
        int n4 = 0;
        int n5 = 0;
        while (n5 < 4096) {
            this.waveforms[0][n5] = 4095;
            this.waveforms[1][n5] = ((n4 & 0x800000) == 0x800000 ? ~n4 : n4) >> 11 & 0xFFE;
            this.waveforms[2][n5] = n4 >> 12;
            int[] nArray = this.waveforms[3];
            int n6 = n5;
            nArray[n6] = nArray[n6] << 4;
            this.waveforms[4][n5] = 4095;
            int[] nArray2 = this.waveforms[5];
            int n7 = n5;
            nArray2[n7] = nArray2[n7] << 4;
            int[] nArray3 = this.waveforms[6];
            int n8 = n5;
            nArray3[n8] = nArray3[n8] << 4;
            int[] nArray4 = this.waveforms[7];
            int n9 = n5++;
            nArray4[n9] = nArray4[n9] << 4;
            n4 += 4096;
        }
    }
}

