/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.vic.renderer;

import java.awt.Point;
import java.util.Arrays;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import ucesoft.cbm.Clock;
import ucesoft.cbm.Clock$;
import ucesoft.cbm.misc.VolumeSettingsPanel;
import ucesoft.cbm.peripheral.bus.IECBus;
import ucesoft.cbm.peripheral.sid.DefaultAudioDriver;
import ucesoft.cbm.peripheral.sid.DefaultAudioDriver$;
import ucesoft.cbm.peripheral.vic.Display;
import ucesoft.cbm.peripheral.vic.ExternalRenderer;
import ucesoft.cbm.peripheral.vic.Palette$;
import ucesoft.cbm.peripheral.vic.VIC_I_Audio$;

@ScalaSignature(bytes="\u0006\u0005\t\u001df\u0001\u0002/^\u0001!D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\rs\u0002!\t\u0011!B\u0003\u0002\u0003\u0006IA\u001f\u0005\t{\u0002\u0011\t\u0011)A\u0005}\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001\"CA\u0011\u0001\t\u0007IQBA\u0012\u0011!\tI\u0003\u0001Q\u0001\u000e\u0005\u0015\u0002BDA\u0016\u0001\u0011\u0005\tQ!AC\u0002\u00135\u0011Q\u0006\u0005\f\u0003w\u0001!\u0011!A!\u0002\u001b\ty\u0003\u0003\b\u0002>\u0001!\t\u0011!B\u0001\u0002\u0004%I!a\u0010\t\u001d\u0005\u0005\u0003\u0001\"A\u0001\u0006\u0003\u0005\r\u0011\"\u0003\u0002D!Y\u0011q\n\u0001\u0003\u0002\u0003\u0005\u000b\u0015BA\u001b\u0011%\t\t\u0006\u0001b\u0001\n\u001b\ty\u0004\u0003\u0005\u0002T\u0001\u0001\u000bQBA\u001b\u0011%\t)\u0006\u0001b\u0001\n\u001b\ty\u0004\u0003\u0005\u0002X\u0001\u0001\u000bQBA\u001b\u00119\tI\u0006\u0001C\u0001\u0002\u000b\u0005)\u0019!C\u0007\u00037B1\"!\u001a\u0001\u0005\u0003\u0005\t\u0015!\u0004\u0002^!I\u0011q\r\u0001A\u0002\u0013%\u0011\u0011\u000e\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003gB\u0001\"a\u001e\u0001A\u0003&\u00111\u000e\u0005\n\u0003s\u0002!\u0019!C\u0005\u0003wB\u0001\"!'\u0001A\u0003%\u0011Q\u0010\u0005\n\u00037\u0003\u0001\u0019!C\u0005\u0003\u007fA\u0011\"!(\u0001\u0001\u0004%I!a(\t\u0011\u0005\r\u0006\u0001)Q\u0005\u0003kA\u0011\"!*\u0001\u0001\u0004%I!a\u0010\t\u0013\u0005\u001d\u0006\u00011A\u0005\n\u0005%\u0006\u0002CAW\u0001\u0001\u0006K!!\u000e\t\u0013\u0005=\u0006\u00011A\u0005\n\u0005}\u0002\"CAY\u0001\u0001\u0007I\u0011BAZ\u0011!\t9\f\u0001Q!\n\u0005U\u0002\"CA]\u0001\u0001\u0007I\u0011BA \u0011%\tY\f\u0001a\u0001\n\u0013\ti\f\u0003\u0005\u0002B\u0002\u0001\u000b\u0015BA\u001b\u00119\t\u0019\r\u0001C\u0001\u0002\u000b\u0005\t\u0019!C\u0005\u0003\u007fA\u0011\"!2\u0001\u0001\u0004%I!a2\t\u0017\u0005-\u0007A!A\u0001B\u0003&\u0011Q\u0007\u0005\n\u0003\u001b\u0004\u0001\u0019!C\u0005\u0003SB\u0011\"a4\u0001\u0001\u0004%I!!5\t\u0011\u0005U\u0007\u0001)Q\u0005\u0003WBa\"a6\u0001\t\u0003\u0005)\u0011!a\u0001\n\u0013\ty\u0004\u0003\b\u0002Z\u0002!\t\u0011!B\u0001\u0002\u0004%I!a7\t\u0017\u0005}\u0007A!A\u0001B\u0003&\u0011Q\u0007\u0005\n\u0003C\u0004\u0001\u0019!C\u0005\u0003SB\u0011\"a9\u0001\u0001\u0004%I!!:\t\u0011\u0005%\b\u0001)Q\u0005\u0003WB\u0011\"a;\u0001\u0001\u0004%I!!<\t\u001d\u0005U\b\u0001\"A\u0001\u0006\u0003\u0005\r\u0011\"\u0003\u0002x\"Y\u00111 \u0001\u0003\u0002\u0003\u0005\u000b\u0015BAx\u0011%\ti\u0010\u0001a\u0001\n\u0013\ty\u0004C\u0005\u0002\u0000\u0002\u0001\r\u0011\"\u0003\u0003\u0002!A!Q\u0001\u0001!B\u0013\t)\u0004C\u0005\u0003\b\u0001\u0011\r\u0011\"\u0003\u0002@!A!\u0011\u0002\u0001!\u0002\u0013\t)D\u0002\u0004\u0003\f\u0001!!Q\u0002\u0005\b\u0003#9D\u0011\u0001B\b\u0011%\u0011)b\u000eb\u0001\n\u001b\u00119\u0002\u0003\u0005\u0003\u001e]\u0002\u000bQ\u0002B\r\u0011%\u0011yb\u000eb\u0001\n\u001b\ty\u0004\u0003\u0005\u0003\"]\u0002\u000bQBA\u001b\u0011%\u0011\u0019c\u000eb\u0001\n\u001b\ty\u0004\u0003\u0005\u0003&]\u0002\u000bQBA\u001b\u0011%\u00119c\u000eb\u0001\n\u0013\u0011I\u0003\u0003\u0005\u00038]\u0002\u000b\u0011\u0002B\u0016\u0011%\u0011Id\u000ea\u0001\n\u0013\ty\u0004C\u0005\u0003<]\u0002\r\u0011\"\u0003\u0003>!A!\u0011I\u001c!B\u0013\t)\u0004C\u0005\u0003D]\u0012\r\u0011\"\u0003\u0002.!A!QI\u001c!\u0002\u0013\ty\u0003C\u0005\u0003H]\u0002\r\u0011\"\u0003\u0002@!I!\u0011J\u001cA\u0002\u0013%!1\n\u0005\t\u0005\u001f:\u0004\u0015)\u0003\u00026!I!\u0011K\u001cC\u0002\u0013%!1\u000b\u0005\t\u0005;:\u0004\u0015!\u0003\u0003V!I!qL\u001cA\u0002\u0013%\u0011q\b\u0005\n\u0005C:\u0004\u0019!C\u0005\u0005GB\u0001Ba\u001a8A\u0003&\u0011Q\u0007\u0005\n\u0005S:\u0004\u0019!C\u0001\u0003SB\u0011Ba\u001b8\u0001\u0004%\tA!\u001c\t\u0011\tEt\u0007)Q\u0005\u0003WBqAa\u001d8\t\u0003\u0011)\bC\u0004\u0003|]\"\tA! \t\u000f\t}t\u0007\"\u0001\u0003\u0002\"9!qQ\u001c\u0005\u0002\tu\u0004\"\u0003BE\u0001\t\u0007I\u0011\u0002BF\u0011!\u0011i\t\u0001Q\u0001\n\tE\u0001b\u0002BD\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u001f\u0003A\u0011\tB?\u0011\u001d\u0011\t\n\u0001C\u0005\u0005{BqAa%\u0001\t\u0013\u0011i\bC\u0004\u0003\u001e\u0002!IAa(\u0003\u001b\u0011\u0013\u0018N^3SK:$WM]3s\u0015\tqv,\u0001\u0005sK:$WM]3s\u0015\t\u0001\u0017-A\u0002wS\u000eT!AY2\u0002\u0015A,'/\u001b9iKJ\fGN\u0003\u0002eK\u0006\u00191MY7\u000b\u0003\u0019\fq!^2fg>4Go\u0001\u0001\u0014\u0007\u0001Iw\u000e\u0005\u0002k[6\t1NC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7N\u0001\u0004B]f\u0014VM\u001a\t\u0003aFl\u0011aX\u0005\u0003e~\u0013\u0001#\u0012=uKJt\u0017\r\u001c*f]\u0012,'/\u001a:\u0002\u0007\t,8\u000f\u0005\u0002vo6\taO\u0003\u0002tC&\u0011\u0001P\u001e\u0002\u0007\u0013\u0016\u001b%)^:\u0002uU\u001cWm]8gi\u0012\u001a'-\u001c\u0013qKJL\u0007\u000f[3sC2$c/[2%e\u0016tG-\u001a:fe\u0012\"%/\u001b<f%\u0016tG-\u001a:fe\u0012\"C-[:qY\u0006L\bC\u00019|\u0013\taxLA\u0004ESN\u0004H.Y=\u0002\u001bY|G.^7f'\u0016$H/\u001b8h!\ry\u00181\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA2\u0002\t5L7oY\u0005\u0005\u0003\u0013\t\u0019!A\nW_2,X.Z*fiRLgnZ:QC:,G.\u0003\u0003\u0002\u000e\u0005=!!\u0004,pYVlWmU3ui&twM\u0003\u0003\u0002\n\u0005\r\u0011A\u0002\u001fj]&$h\b\u0006\u0005\u0002\u0016\u0005e\u00111DA\u0010!\r\t9\u0002A\u0007\u0002;\")1\u000f\u0002a\u0001i\"1\u0011Q\u0004\u0003A\u0002i\fq\u0001Z5ta2\f\u0017\u0010C\u0003~\t\u0001\u0007a0A\u0004I\u0005>\u0013F)\u0012*\u0016\u0005\u0005\u0015rBAA\u0014;\u0005\u0001\u0018\u0001\u0003%C\u001fJ#UI\u0015\u0011\u0002mU\u001cWm]8gi\u0012\u001a'-\u001c\u0013qKJL\u0007\u000f[3sC2$c/[2%e\u0016tG-\u001a:fe\u0012\"%/\u001b<f%\u0016tG-\u001a:fe\u0012\"S.Z7\u0016\u0005\u0005=\u0002#\u00026\u00022\u0005U\u0012bAA\u001aW\n)\u0011I\u001d:bsB\u0019!.a\u000e\n\u0007\u0005e2NA\u0002J]R\fq'^2fg>4G\u000fJ2c[\u0012\u0002XM]5qQ\u0016\u0014\u0018\r\u001c\u0013wS\u000e$#/\u001a8eKJ,'\u000f\n#sSZ,'+\u001a8eKJ,'\u000f\n\u0013nK6\u0004\u0013AN;dKN|g\r\u001e\u0013dE6$\u0003/\u001a:ja\",'/\u00197%m&\u001cGE]3oI\u0016\u0014XM\u001d\u0013Ee&4XMU3oI\u0016\u0014XM\u001d\u0013%a>\u001cXCAA\u001b\u0003i*8-Z:pMR$3MY7%a\u0016\u0014\u0018\u000e\u001d5fe\u0006dGE^5dII,g\u000eZ3sKJ$CI]5wKJ+g\u000eZ3sKJ$C\u0005]8t?\u0012*\u0017\u000f\u0006\u0003\u0002F\u0005-\u0003c\u00016\u0002H%\u0019\u0011\u0011J6\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u001bR\u0011\u0011!a\u0001\u0003k\t1\u0001\u001f\u00132\u0003]*8-Z:pMR$3MY7%a\u0016\u0014\u0018\u000e\u001d5fe\u0006dGE^5dII,g\u000eZ3sKJ$CI]5wKJ+g\u000eZ3sKJ$C\u0005]8tA\u0005)!\tT!D\u0017\u00061!\tT!D\u0017\u0002\nQa\u0016%J)\u0016\u000baa\u0016%J)\u0016\u0003\u0013\u0001O;dKN|g\r\u001e\u0013dE6$\u0003/\u001a:ja\",'/\u00197%m&\u001cGE]3oI\u0016\u0014XM\u001d\u0013Ee&4XMU3oI\u0016\u0014XM\u001d\u0013%G2|7m[\u000b\u0003\u0003;\u0002B!a\u0018\u0002b5\t1-C\u0002\u0002d\r\u0014Qa\u00117pG.\f\u0011(^2fg>4G\u000fJ2c[\u0012\u0002XM]5qQ\u0016\u0014\u0018\r\u001c\u0013wS\u000e$#/\u001a8eKJ,'\u000f\n#sSZ,'+\u001a8eKJ,'\u000f\n\u0013dY>\u001c7\u000eI\u0001\u0007gft7m\u0014(\u0016\u0005\u0005-\u0004c\u00016\u0002n%\u0019\u0011qN6\u0003\u000f\t{w\u000e\\3b]\u0006Q1/\u001f8d\u001f:{F%Z9\u0015\t\u0005\u0015\u0013Q\u000f\u0005\n\u0003\u001b\u001a\u0012\u0011!a\u0001\u0003W\nqa]=oG>s\u0005%\u0001\u0003dY&\u0004XCAA?!\u0015Q\u0017qPAB\u0013\r\t\ti\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f)\f))!#\u0002\n&\u0019\u0011qQ6\u0003\rQ+\b\u000f\\33!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000b1!Y<u\u0015\t\t\u0019*\u0001\u0003kCZ\f\u0017\u0002BAL\u0003\u001b\u0013Q\u0001U8j]R\fQa\u00197ja\u0002\n\u0011b]=oGN#\u0018M\u001d;\u0002\u001bMLhnY*uCJ$x\fJ3r)\u0011\t)%!)\t\u0013\u00055\u0003$!AA\u0002\u0005U\u0012AC:z]\u000e\u001cF/\u0019:uA\u0005q1-_2mKN$U\r^3di\u0016$\u0017AE2zG2,7\u000fR3uK\u000e$X\rZ0%KF$B!!\u0012\u0002,\"I\u0011QJ\u000e\u0002\u0002\u0003\u0007\u0011QG\u0001\u0010Gf\u001cG.Z:EKR,7\r^3eA\u0005I\u0001nU=oGNK'0Z\u0001\u000eQNKhnY*ju\u0016|F%Z9\u0015\t\u0005\u0015\u0013Q\u0017\u0005\n\u0003\u001br\u0012\u0011!a\u0001\u0003k\t!\u0002[*z]\u000e\u001c\u0016N_3!\u0003=\u0019H/\u00192mKNKhnY\"pk:$\u0018aE:uC\ndWmU=oG\u000e{WO\u001c;`I\u0015\fH\u0003BA#\u0003\u007fC\u0011\"!\u0014\"\u0003\u0003\u0005\r!!\u000e\u0002!M$\u0018M\u00197f'ft7mQ8v]R\u0004\u0013\u0001Q;dKN|g\r\u001e\u0013dE6$\u0003/\u001a:ja\",'/\u00197%m&\u001cGE]3oI\u0016\u0014XM\u001d\u0013Ee&4XMU3oI\u0016\u0014XM\u001d\u0013%gR\f'\r\\3Ts:\u001cWI\u001c3\u0002#M$\u0018M\u00197f'ft7-\u00128e?\u0012*\u0017\u000f\u0006\u0003\u0002F\u0005%\u0007\"CA'I\u0005\u0005\t\u0019AA\u001b\u0003\u0005+8-Z:pMR$3MY7%a\u0016\u0014\u0018\u000e\u001d5fe\u0006dGE^5dII,g\u000eZ3sKJ$CI]5wKJ+g\u000eZ3sKJ$Ce\u001d;bE2,7+\u001f8d\u000b:$\u0007%\u0001\u0007wgft7\rU3oI&tw-\u0001\twgft7\rU3oI&twm\u0018\u0013fcR!\u0011QIAj\u0011%\tieJA\u0001\u0002\u0004\tY'A\u0007wgft7\rU3oI&tw\rI\u0001Bk\u000e,7o\u001c4uI\r\u0014W\u000e\n9fe&\u0004\b.\u001a:bY\u00122\u0018n\u0019\u0013sK:$WM]3sI\u0011\u0013\u0018N^3SK:$WM]3sI\u0011\u001a8.\u001b9Ee\u0006<8)_2mKN\fQ)^2fg>4G\u000fJ2c[\u0012\u0002XM]5qQ\u0016\u0014\u0018\r\u001c\u0013wS\u000e$#/\u001a8eKJ,'\u000f\n#sSZ,'+\u001a8eKJ,'\u000f\n\u0013tW&\u0004HI]1x\u0007f\u001cG.Z:`I\u0015\fH\u0003BA#\u0003;D\u0011\"!\u0014+\u0003\u0003\u0005\r!!\u000e\u0002\u0005V\u001cWm]8gi\u0012\u001a'-\u001c\u0013qKJL\u0007\u000f[3sC2$c/[2%e\u0016tG-\u001a:fe\u0012\"%/\u001b<f%\u0016tG-\u001a:fe\u0012\"3o[5q\tJ\fwoQ=dY\u0016\u001c\b%\u0001\u0004xCJ\u0004xJ\\\u0001\u000bo\u0006\u0014\bo\u00148`I\u0015\fH\u0003BA#\u0003OD\u0011\"!\u0014.\u0003\u0003\u0005\r!a\u001b\u0002\u000f]\f'\u000f](oA\u0005qA.Y:u-NKhnY\"zG2,WCAAx!\rQ\u0017\u0011_\u0005\u0004\u0003g\\'\u0001\u0002'p]\u001e\fQ)^2fg>4G\u000fJ2c[\u0012\u0002XM]5qQ\u0016\u0014\u0018\r\u001c\u0013wS\u000e$#/\u001a8eKJ,'\u000f\n#sSZ,'+\u001a8eKJ,'\u000f\n\u0013mCN$hkU=oG\u000eK8\r\\3`I\u0015\fH\u0003BA#\u0003sD\u0011\"!\u00141\u0003\u0003\u0005\r!a<\u0002\u0005V\u001cWm]8gi\u0012\u001a'-\u001c\u0013qKJL\u0007\u000f[3sC2$c/[2%e\u0016tG-\u001a:fe\u0012\"%/\u001b<f%\u0016tG-\u001a:fe\u0012\"C.Y:u-NKhnY\"zG2,\u0007%A\bpkR|eMV*z]\u000e\u001cu.\u001e8u\u0003MyW\u000f^(g-NKhnY\"pk:$x\fJ3r)\u0011\t)Ea\u0001\t\u0013\u000553'!AA\u0002\u0005U\u0012\u0001E8vi>3gkU=oG\u000e{WO\u001c;!\u0003MyW\u000f^(g-NKhn\u0019+ie\u0016\u001c\bn\u001c7e\u0003QyW\u000f^(g-NKhn\u0019+ie\u0016\u001c\bn\u001c7eA\tQAI]5wK\u0006+H-[8\u0014\u0005]JGC\u0001B\t!\r\u0011\u0019bN\u0007\u0002\u0001\u0005Y1+Q'Q\u0019\u0016{&+\u0011+F+\t\u0011Ib\u0004\u0002\u0003\u001cu\u0019\u0001\u0001,#\u0002\u0019M\u000bU\n\u0015'F?J\u000bE+\u0012\u0011\u0002\u0011\r\u0003Vk\u0018$S\u000bF\u000b\u0011b\u0011)V?\u001a\u0013V)\u0015\u0011\u0002#\rcujQ&T?B+%kX*B\u001bBcU)\u0001\nD\u0019>\u001b5jU0Q\u000bJ{6+Q'Q\u0019\u0016\u0003\u0013A\u00023sSZ,'/\u0006\u0002\u0003,A!!Q\u0006B\u001a\u001b\t\u0011yCC\u0002\u00032\u0005\f1a]5e\u0013\u0011\u0011)Da\f\u0003%\u0011+g-Y;mi\u0006+H-[8Ee&4XM]\u0001\bIJLg/\u001a:!\u0003\r\t7mY\u0001\bC\u000e\u001cw\fJ3r)\u0011\t)Ea\u0010\t\u0013\u00055#)!AA\u0002\u0005U\u0012\u0001B1dG\u0002\nAB^8mk6,g+\u00197vKN\fQB^8mk6,g+\u00197vKN\u0004\u0013A\u0002<pYVlW-\u0001\u0006w_2,X.Z0%KF$B!!\u0012\u0003N!I\u0011QJ$\u0002\u0002\u0003\u0007\u0011QG\u0001\bm>dW/\\3!\u0003\u0015!\u0018M\u00197f+\t\u0011)\u0006E\u0003k\u0003c\u00119\u0006E\u0002k\u00053J1Aa\u0017l\u0005\u00151En\\1u\u0003\u0019!\u0018M\u00197fA\u000511\r\\8dWN\f!b\u00197pG.\u001cx\fJ3r)\u0011\t)E!\u001a\t\u0013\u00055C*!AA\u0002\u0005U\u0012aB2m_\u000e\\7\u000fI\u0001\u0005SN|e.\u0001\u0005jg>sw\fJ3r)\u0011\t)Ea\u001c\t\u0013\u00055s*!AA\u0002\u0005-\u0014!B5t\u001f:\u0004\u0013!C:fiZ{G.^7f)\u0011\t)Ea\u001e\t\u000f\te\u0014\u000b1\u0001\u00026\u0005\ta/A\u0003dY>\u001c7\u000e\u0006\u0002\u0002F\u000591o\\;oI>sG\u0003BA#\u0005\u0007CqA!\"T\u0001\u0004\tY'\u0001\u0002p]\u0006!1\u000f^8q\u0003\u0015\tW\u000fZ5p+\t\u0011\t\"\u0001\u0004bk\u0012Lw\u000eI\u0001\fe\u0016tG-\u001a:Ds\u000edW-A\u0004ts:\u001cwJ\u0012$\u0002\u000bY\u001c\u0018P\\2)\u0007i\u00139\nE\u0002k\u00053K1Aa'l\u0005\u0019Ig\u000e\\5oK\u0006!AM]1x)\u0011\t)E!)\t\u000f\t\r6\f1\u0001\u00026\u0005)1m\u001c7pe\"\u001a1La&")
public class DriveRenderer
implements ExternalRenderer {
    private final IECBus bus;
    public final Display ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$display;
    public final VolumeSettingsPanel.VolumeSetting ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$volumeSetting;
    private final int[] ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$mem;
    private int ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos;
    private final int BLACK;
    private final int WHITE;
    private final Clock ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock;
    private boolean syncON;
    private final Option<Tuple2<Point, Point>> clip;
    private int syncStart;
    private int cyclesDetected;
    private int hSyncSize;
    private int stableSyncCount;
    private int ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$stableSyncEnd;
    private boolean vsyncPending;
    private int ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles;
    private boolean warpOn;
    private long ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$lastVSyncCycle;
    private int outOfVSyncCount;
    private final int outOfVSyncThreshold;
    private final DriveAudio audio;

    private final int HBORDER() {
        return 112;
    }

    public final int[] ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$mem() {
        return this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$mem;
    }

    public int ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos() {
        return this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos;
    }

    public void ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos_$eq(int x$1) {
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos = x$1;
    }

    private final int BLACK() {
        return this.BLACK;
    }

    private final int WHITE() {
        return this.WHITE;
    }

    public final Clock ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock() {
        return this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock;
    }

    private boolean syncON() {
        return this.syncON;
    }

    private void syncON_$eq(boolean x$1) {
        this.syncON = x$1;
    }

    private Option<Tuple2<Point, Point>> clip() {
        return this.clip;
    }

    private int syncStart() {
        return this.syncStart;
    }

    private void syncStart_$eq(int x$1) {
        this.syncStart = x$1;
    }

    private int cyclesDetected() {
        return this.cyclesDetected;
    }

    private void cyclesDetected_$eq(int x$1) {
        this.cyclesDetected = x$1;
    }

    private int hSyncSize() {
        return this.hSyncSize;
    }

    private void hSyncSize_$eq(int x$1) {
        this.hSyncSize = x$1;
    }

    private int stableSyncCount() {
        return this.stableSyncCount;
    }

    private void stableSyncCount_$eq(int x$1) {
        this.stableSyncCount = x$1;
    }

    public int ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$stableSyncEnd() {
        return this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$stableSyncEnd;
    }

    private void stableSyncEnd_$eq(int x$1) {
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$stableSyncEnd = x$1;
    }

    private boolean vsyncPending() {
        return this.vsyncPending;
    }

    private void vsyncPending_$eq(boolean x$1) {
        this.vsyncPending = x$1;
    }

    public int ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles() {
        return this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles;
    }

    public void ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles_$eq(int x$1) {
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles = x$1;
    }

    private boolean warpOn() {
        return this.warpOn;
    }

    private void warpOn_$eq(boolean x$1) {
        this.warpOn = x$1;
    }

    private long lastVSyncCycle() {
        return this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$lastVSyncCycle;
    }

    public void ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$lastVSyncCycle_$eq(long x$1) {
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$lastVSyncCycle = x$1;
    }

    private int outOfVSyncCount() {
        return this.outOfVSyncCount;
    }

    private void outOfVSyncCount_$eq(int x$1) {
        this.outOfVSyncCount = x$1;
    }

    private int outOfVSyncThreshold() {
        return this.outOfVSyncThreshold;
    }

    private DriveAudio audio() {
        return this.audio;
    }

    @Override
    public void stop() {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<Point, Point>> option = this.clip();
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            throw new MatchError(option);
        }
        Point p1 = (Point)tuple2._1();
        Point p2 = (Point)tuple2._2();
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$display.setClipArea(p1.x, p1.y, p2.x, p2.y);
        this.audio().stop();
    }

    @Override
    public void renderCycle() {
        boolean warp = this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock().maximumSpeed();
        if (warp ^ this.warpOn()) {
            this.warpOn_$eq(warp);
            this.audio().soundOn(!this.warpOn());
        }
        this.audio().isOn_$eq(this.bus.freeSpinStepperOn());
        this.audio().clock();
        boolean data = this.bus.data() == 1;
        boolean clk = this.bus.clk() == 1;
        int color = this.BLACK();
        if (clk) {
            if (!this.syncON()) {
                this.syncON_$eq(true);
                this.cyclesDetected_$eq((int)(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock().currentCycles() - (long)this.syncStart()));
                this.syncStart_$eq((int)this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock().currentCycles());
                if (this.cyclesDetected() > 64) {
                    if (this.vsyncPending()) {
                        this.vsync();
                        this.vsyncPending_$eq(false);
                        this.outOfVSyncCount_$eq(0);
                    }
                } else {
                    this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles_$eq(1);
                }
            }
        } else {
            if (!data) {
                color = this.WHITE();
            }
            if (this.syncON()) {
                this.syncOFF();
            }
        }
        if (this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock().currentCycles() - this.lastVSyncCycle() > (long)this.outOfVSyncThreshold()) {
            if (this.outOfVSyncCount() > 10) {
                this.vsync();
            } else {
                this.outOfVSyncCount_$eq(this.outOfVSyncCount() + 1);
                this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$lastVSyncCycle_$eq(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock().currentCycles());
            }
        }
        this.draw(color);
    }

    private void syncOFF() {
        this.syncON_$eq(false);
        int newSize = (int)(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock().currentCycles() - (long)this.syncStart());
        if (newSize != this.hSyncSize()) {
            this.hSyncSize_$eq(newSize);
            if (this.stableSyncCount() == 5) {
                this.vsyncPending_$eq(true);
            }
            this.stableSyncCount_$eq(0);
            return;
        }
        if (this.stableSyncCount() < 5) {
            this.stableSyncCount_$eq(this.stableSyncCount() + 1);
            if (this.stableSyncCount() == 5) {
                this.stableSyncEnd_$eq(this.hSyncSize());
                return;
            }
            return;
        }
    }

    private void vsync() {
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$display.showFrame(-1, 0, 0, 0);
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos_$eq(0);
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles_$eq(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$stableSyncEnd());
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$lastVSyncCycle_$eq(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock().currentCycles());
    }

    private void draw(int color) {
        if (this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles() > 0) {
            this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles_$eq(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles() - 1);
            return;
        }
        for (int i = 0; i < 8 && this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos() < this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$mem().length; ++i) {
            this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$mem()[this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos()] = color;
            this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos_$eq(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos() + 1);
        }
    }

    public DriveRenderer(IECBus bus, Display display, VolumeSettingsPanel.VolumeSetting volumeSetting) {
        this.bus = bus;
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$display = display;
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$volumeSetting = volumeSetting;
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$mem = display.displayMem();
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$pos = 0;
        this.BLACK = Palette$.MODULE$.VIC_RGB()[0];
        this.WHITE = Palette$.MODULE$.VIC_RGB()[1];
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$clock = Clock$.MODULE$.systemClock();
        this.syncON = false;
        this.clip = display.removeClipArea();
        this.syncStart = 0;
        this.cyclesDetected = 0;
        this.hSyncSize = 0;
        this.stableSyncCount = 0;
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$stableSyncEnd = 0;
        this.vsyncPending = false;
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$skipDrawCycles = 0;
        this.warpOn = false;
        this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$lastVSyncCycle = 0L;
        this.outOfVSyncCount = 0;
        this.outOfVSyncThreshold = 19968;
        this.audio = new DriveAudio();
        Arrays.fill(this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$mem(), this.BLACK());
        this.vsync();
        display.setClipArea(0, 0, 400, 312);
    }

    private class DriveAudio {
        private final int CPU_FREQ;
        private final int CLOCKS_PER_SAMPLE;
        private final DefaultAudioDriver driver;
        private int acc;
        private final int[] volumeValues;
        private int volume;
        private final float[] table;
        private int clocks;
        private boolean isOn;

        private final int SAMPLE_RATE() {
            return 44100;
        }

        private final int CPU_FREQ() {
            return this.CPU_FREQ;
        }

        private final int CLOCKS_PER_SAMPLE() {
            return this.CLOCKS_PER_SAMPLE;
        }

        private DefaultAudioDriver driver() {
            return this.driver;
        }

        private int acc() {
            return this.acc;
        }

        private void acc_$eq(int x$1) {
            this.acc = x$1;
        }

        private int[] volumeValues() {
            return this.volumeValues;
        }

        private int volume() {
            return this.volume;
        }

        private void volume_$eq(int x$1) {
            this.volume = x$1;
        }

        private float[] table() {
            return this.table;
        }

        private int clocks() {
            return this.clocks;
        }

        private void clocks_$eq(int x$1) {
            this.clocks = x$1;
        }

        public boolean isOn() {
            return this.isOn;
        }

        public void isOn_$eq(boolean x$1) {
            this.isOn = x$1;
        }

        public void setVolume(int v) {
            this.volume_$eq(this.volumeValues()[v & 3]);
        }

        public void clock() {
            if (this.isOn()) {
                this.acc_$eq(this.acc() + this.volume());
            }
            this.clocks_$eq(this.clocks() + 1);
            if (this.clocks() == this.CLOCKS_PER_SAMPLE()) {
                int v = (int)this.table()[this.acc() / this.CLOCKS_PER_SAMPLE()];
                this.driver().addSample(v);
                this.acc_$eq(0);
                this.clocks_$eq(0);
                return;
            }
        }

        public void soundOn(boolean on) {
            this.driver().setSoundOn(on);
        }

        public void stop() {
            this.driver().discard();
            this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$DriveAudio$$$outer().ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$volumeSetting.removeDriver(this.driver());
        }

        public /* synthetic */ DriveRenderer ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$DriveAudio$$$outer() {
            return DriveRenderer.this;
        }

        public DriveAudio() {
            if (DriveRenderer.this == null) {
                throw null;
            }
            this.CPU_FREQ = (int)Clock$.MODULE$.systemClock().getClockHz();
            this.CLOCKS_PER_SAMPLE = this.CPU_FREQ() / 44100;
            this.driver = new DefaultAudioDriver(44100, 1, DefaultAudioDriver$.MODULE$.$lessinit$greater$default$3());
            this.acc = 0;
            this.volumeValues = new int[]{0, 42, 403, 420};
            this.volume = this.volumeValues()[1];
            this.table = VIC_I_Audio$.MODULE$.voltageFunction();
            this.clocks = 0;
            this.isOn = false;
            DriveRenderer.this.ucesoft$cbm$peripheral$vic$renderer$DriveRenderer$$volumeSetting.addDriver(this.driver());
        }
    }
}

