/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.cbm2;

import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import ucesoft.cbm.peripheral.Connector;
import ucesoft.cbm.peripheral.bus.IECBus;
import ucesoft.cbm.peripheral.bus.IECBusListener;
import ucesoft.cbm.peripheral.bus.IEEE488Bus;
import ucesoft.cbm.peripheral.bus.IEEE488Bus$LineType$;
import ucesoft.cbm.peripheral.bus.IEEE488Bus$LineValue$;
import ucesoft.cbm.peripheral.c2n.Datassette;
import ucesoft.cbm.peripheral.mos6525.MOS6525;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015v!\u0002\u00192\u0011\u0003Ad!\u0002\u001e2\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019e\u0001\u0002#\u0002\u0001\u0015C\u0001\u0002T\u0002\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006\u0005\u000e!\tA\u0015\u0005\b-\u000e\u0011\r\u0011\"\u0011X\u0011\u0019\u00197\u0001)A\u00051\"9Am\u0001a\u0001\n\u0013)\u0007bB5\u0004\u0001\u0004%IA\u001b\u0005\u0007a\u000e\u0001\u000b\u0015\u00024\t\u000bE\u001cA\u0011\u0001:\t\u000bU\u001cA\u0011\t<\t\u000bi\u001cA\u0011K>\u0007\ty\f\u0001a \u0005\u0007\u0005:!\t!!\u0001\t\u000fYs!\u0019!C!/\"11M\u0004Q\u0001\naCQ!\u001e\b\u0005BYDaA\u001f\b\u0005R\u0005\u0015aABA\u0005\u0003\u0001\tY\u0001\u0003\u0005M)\t\u0005\t\u0015!\u0003N\u0011%\ty\u0003\u0006B\u0001B\u0003%1\u000b\u0003\u0004C)\u0011\u0005\u0011\u0011\u0007\u0005\t\u0003s!\"\u0019!C!K\"9\u00111\b\u000b!\u0002\u00131\u0007bCA\u0012)\u0001\u0007\t\u0019!C\u0005\u0003{A1\"!\u0012\u0015\u0001\u0004\u0005\r\u0011\"\u0003\u0002H!Y\u00111\n\u000bA\u0002\u0003\u0005\u000b\u0015BA \u0011\u001d\ti\u0005\u0006C!\u0003\u001fBa!\u001e\u000b\u0005B\u0005M\u0003bBA+)\u0011\u0005\u0013q\u000b\u0004\u0007\u0003;\n\u0001!a\u0018\t\u00111\u0003#\u0011!Q\u0001\n5C!\"!\u0019!\u0005\u0003\u0005\u000b\u0011BA2\u0011\u0019\u0011\u0005\u0005\"\u0001\u0002p!1Q\u000f\tC!\u0003'Bq!!\u0016!\t\u0003\n9H\u0002\u0004\u0002|\u0005\u0001\u0011Q\u0010\u0005\u000b\u0003\u000b3#\u0011!Q\u0001\n\u0005\u001d\u0005BCAGM\t\u0005\t\u0015!\u0003\u0002\u0010\"1!I\nC\u0001\u0003+C\u0001\"!\u000f'\u0005\u0004%\t%\u001a\u0005\b\u0003w1\u0003\u0015!\u0003g\u0011!\tiJ\nb\u0001\n\u0003:\u0006bBAPM\u0001\u0006I\u0001\u0017\u0005\u0007k\u001a\"\t%a\u0015\t\u000f\u0005Uc\u0005\"\u0011\u0002\"\u0006\t\u0012*R#FiaB4i\u001c8oK\u000e$xN]:\u000b\u0005I\u001a\u0014\u0001B2c[JR!\u0001N\u001b\u0002\u0007\r\u0014WNC\u00017\u0003\u001d)8-Z:pMR\u001c\u0001\u0001\u0005\u0002:\u00035\t\u0011GA\tJ\u000b\u0016+E\u0007\u000f\u001dD_:tWm\u0019;peN\u001c\"!\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001H\u0001\u000bD\u0013\u0006KU)R#5qa\u001auN\u001c8fGR|'/Q\n\u0003\u0007\u0019\u0003\"a\u0012&\u000e\u0003!S!!S\u001a\u0002\u0015A,'/\u001b9iKJ\fG.\u0003\u0002L\u0011\nI1i\u001c8oK\u000e$xN]\u0001\u0004EV\u001c\bC\u0001(Q\u001b\u0005y%B\u0001'I\u0013\t\tvJ\u0001\u0006J\u000b\u0016+E\u0007\u000f\u001dCkN$\"aU+\u0011\u0005Q\u001bQ\"A\u0001\t\u000b1+\u0001\u0019A'\u0002\u0017\r|W\u000e]8oK:$\u0018\nR\u000b\u00021B\u0011\u0011\f\u0019\b\u00035z\u0003\"a\u0017 \u000e\u0003qS!!X\u001c\u0002\rq\u0012xn\u001c;?\u0013\tyf(\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0?\u00031\u0019w.\u001c9p]\u0016tG/\u0013#!\u00031!\u0017N]3di&|gnT;u+\u00051\u0007CA\u001fh\u0013\tAgHA\u0004C_>dW-\u00198\u0002!\u0011L'/Z2uS>tw*\u001e;`I\u0015\fHCA6o!\tiD.\u0003\u0002n}\t!QK\\5u\u0011\u001dy\u0017\"!AA\u0002\u0019\f1\u0001\u001f\u00132\u00035!\u0017N]3di&|gnT;uA\u0005a1/\u001a;ESJ,7\r^5p]R\u00111n\u001d\u0005\u0006i.\u0001\rAZ\u0001\u0004_V$\u0018\u0001\u0002:fC\u0012,\u0012a\u001e\t\u0003{aL!!\u001f \u0003\u0007%sG/\u0001\u0007qKJ4wN]7Xe&$X\r\u0006\u0002ly\")Q0\u0004a\u0001o\u0006!A-\u0019;b\u0005Q\u0019\u0015*Q%F\u000b\u0016#\u0004\bO\"p]:,7\r^8s\u0005N\u0011aB\u0012\u000b\u0003\u0003\u0007\u0001\"\u0001\u0016\b\u0015\u0007-\f9\u0001C\u0003~'\u0001\u0007qOA\tJ\u000b\u0016+E\u0007\u000f\u001dJ]R,'OZ1dK\u0006\u001bR\u0001FA\u0007\u00037\u0001B!a\u0004\u0002\u00169\u0019a*!\u0005\n\u0007\u0005Mq*\u0001\u0006J\u000b\u0016+E\u0007\u000f\u001dCkNLA!a\u0006\u0002\u001a\taA*\u001b8f\u0019&\u001cH/\u001a8fe*\u0019\u00111C(\u0011\t\u0005u\u0011\u0011\u0006\b\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005%\u0002\u000f5|7ON\u001b3k%!\u0011qEA\u0011\u0003\u001diuj\u0015\u001c6eUJA!a\u000b\u0002.\t1\u0001k\u001c:u\u0003\nSA!a\n\u0002\"\u0005a1-[1D_:tWm\u0019;peR1\u00111GA\u001b\u0003o\u0001\"\u0001\u0016\u000b\t\u000b1;\u0002\u0019A'\t\r\u0005=r\u00031\u0001T\u00031I7oQ8oiJ|G\u000e\\3s\u00035I7oQ8oiJ|G\u000e\\3sAU\u0011\u0011q\b\t\u0005\u0003?\t\t%\u0003\u0003\u0002D\u0005\u0005\"aB'P'Z*$'N\u0001\f[>\u001ch'\u000e\u001a6?\u0012*\u0017\u000fF\u0002l\u0003\u0013B\u0001b\\\u000e\u0002\u0002\u0003\u0007\u0011qH\u0001\t[>\u001ch'\u000e\u001a6A\u0005Q1/\u001a;N\u001fN3TGM\u001b\u0015\u0007-\f\t\u0006C\u0004\u0002$u\u0001\r!a\u0010\u0015\u0003]\fQa\u001e:ji\u0016$2a[A-\u0011\u0019\tYf\ba\u0001o\u0006)a/\u00197vK\n\t\u0012*R#FiaB\u0014J\u001c;fe\u001a\f7-\u001a\"\u0014\u000b\u0001\ni!a\u0007\u0002\u0015\u0011\fG/Y:tKR$X\r\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI\u0007S\u0001\u0004GJr\u0017\u0002BA7\u0003O\u0012!\u0002R1uCN\u001cX\r\u001e;f)\u0019\t\t(a\u001d\u0002vA\u0011A\u000b\t\u0005\u0006\u0019\u000e\u0002\r!\u0014\u0005\b\u0003C\u001a\u0003\u0019AA2)\rY\u0017\u0011\u0010\u0005\u0007\u00037*\u0003\u0019A<\u0003\u001b%+5)\u00138uKJ4\u0017mY3C'\u00191C(a \u0002\u001cA\u0019a*!!\n\u0007\u0005\ruJ\u0001\bJ\u000b\u000e\u0013Uo\u001d'jgR,g.\u001a:\u0002\u0007%,7\rE\u0002O\u0003\u0013K1!a#P\u0005\u0019IUi\u0011\"vg\u00069a\r\\1h\u0019><\b\u0003B\u001f\u0002\u0012.L1!a%?\u0005%1UO\\2uS>t\u0007\u0007\u0006\u0004\u0002\u0018\u0006e\u00151\u0014\t\u0003)\u001aBq!!\"*\u0001\u0004\t9\tC\u0004\u0002\u000e&\u0002\r!a$\u0002\u000b\t,8/\u001b3\u0002\r\t,8/\u001b3!)\rY\u00171\u0015\u0005\u0007\u00037z\u0003\u0019A<")
public final class IEEE488Connectors {

    public static class CIAIEEE488ConnectorA
    extends Connector {
        private final IEEE488Bus bus;
        private final String componentID;
        private boolean directionOut;

        @Override
        public String componentID() {
            return this.componentID;
        }

        private boolean directionOut() {
            return this.directionOut;
        }

        private void directionOut_$eq(boolean x$1) {
            this.directionOut = x$1;
        }

        public void setDirection(boolean out) {
            this.directionOut_$eq(out);
        }

        @Override
        public int read() {
            return this.bus.getDIO() ^ 0xFF;
        }

        @Override
        public void performWrite(int data) {
            int ieeeData = this.directionOut() ? data : 255;
            this.bus.setDIO(ieeeData);
        }

        public CIAIEEE488ConnectorA(IEEE488Bus bus) {
            this.bus = bus;
            this.componentID = "CIA1-PortA";
            this.directionOut = true;
        }
    }

    public static class CIAIEEE488ConnectorB
    extends Connector {
        private final String componentID;

        @Override
        public String componentID() {
            return this.componentID;
        }

        @Override
        public int read() {
            return 0;
        }

        @Override
        public void performWrite(int data) {
        }

        public CIAIEEE488ConnectorB() {
            this.componentID = "CIA1-PortB";
        }
    }

    public static class IECInterfaceB
    implements IECBusListener,
    MOS6525.PortAB {
        private final IECBus iec;
        private final Function0<BoxedUnit> flagLow;
        private final boolean isController;
        private final String busid;
        private int bitmap;

        @Override
        public void setMOS6525(MOS6525 MOS65252) {
            MOS6525.PortAB.setMOS6525$(this, MOS65252);
        }

        @Override
        public void atnChanged(int oldValue, int newValue) {
            IECBusListener.atnChanged$(this, oldValue, newValue);
        }

        @Override
        public void srqTriggered() {
            IECBusListener.srqTriggered$(this);
        }

        @Override
        public int bitmap() {
            return this.bitmap;
        }

        @Override
        public void bitmap_$eq(int x$1) {
            this.bitmap = x$1;
        }

        @Override
        public void ucesoft$cbm$peripheral$bus$IECBusListener$_setter_$isController_$eq(boolean x$1) {
        }

        @Override
        public boolean isController() {
            return this.isController;
        }

        @Override
        public String busid() {
            return this.busid;
        }

        @Override
        public int read() {
            return (this.iec.clk() << 7 | this.iec.data() << 5 | this.iec.atn() << 6) & 0xFF;
        }

        @Override
        public void write(int value) {
            int atn = (value & 0x40) > 0 ? 1 : 0;
            int data = (value & 0x20) == 0 ? 1 : 0;
            int clock = (value & 0x80) == 0 ? 1 : 0;
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("WRITE IEC atn=").append(atn).append(" data=").append(data).append(" clock=").append(clock).toString());
            this.iec.setLine(this, atn, data, clock);
            this.flagLow.apply$mcV$sp();
        }

        public IECInterfaceB(IECBus iec, Function0<BoxedUnit> flagLow) {
            this.iec = iec;
            this.flagLow = flagLow;
            IECBusListener.$init$(this);
            MOS6525.PortAB.$init$(this);
            this.isController = true;
            this.busid = "IECBUS-Adapter";
            iec.registerListener(this);
        }
    }

    public static class IEEE488InterfaceA
    extends IEEE488Bus.LineListener
    implements MOS6525.PortAB {
        private final IEEE488Bus bus;
        private final CIAIEEE488ConnectorA ciaConnector;
        private final boolean isController;
        private MOS6525 mos6525;

        @Override
        public boolean isController() {
            return this.isController;
        }

        private MOS6525 mos6525() {
            return this.mos6525;
        }

        private void mos6525_$eq(MOS6525 x$1) {
            this.mos6525 = x$1;
        }

        @Override
        public void setMOS6525(MOS6525 mos6525) {
            this.mos6525_$eq(mos6525);
        }

        @Override
        public int read() {
            int n = 7;
            Enumeration.Value value = this.bus.getLine(IEEE488Bus$LineType$.MODULE$.ATN());
            Enumeration.Value value2 = IEEE488Bus$LineValue$.MODULE$.RELEASED();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                n |= 8;
            }
            Enumeration.Value value3 = this.bus.getLine(IEEE488Bus$LineType$.MODULE$.DAV());
            Enumeration.Value value4 = IEEE488Bus$LineValue$.MODULE$.RELEASED();
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                n |= 0x10;
            }
            Enumeration.Value value5 = this.bus.getLine(IEEE488Bus$LineType$.MODULE$.EOI());
            Enumeration.Value value6 = IEEE488Bus$LineValue$.MODULE$.RELEASED();
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                n |= 0x20;
            }
            Enumeration.Value value7 = this.bus.getLine(IEEE488Bus$LineType$.MODULE$.NDAC());
            Enumeration.Value value8 = IEEE488Bus$LineValue$.MODULE$.RELEASED();
            if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                n |= 0x40;
            }
            Enumeration.Value value9 = this.bus.getLine(IEEE488Bus$LineType$.MODULE$.NRFD());
            Enumeration.Value value10 = IEEE488Bus$LineValue$.MODULE$.RELEASED();
            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                n |= 0x80;
            }
            n = n & ~this.mos6525().regs()[3] | this.mos6525().regs()[0] & this.mos6525().regs()[3];
            return n;
        }

        @Override
        public void write(int value) {
            int data = value ^ 0xFF;
            boolean directionOut = (value & 2) > 0;
            this.ciaConnector.setDirection(directionOut);
            if (directionOut) {
                this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.NRFD());
                this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.NDAC());
                if ((data & 8) > 0) {
                    this.bus.pullLine(this, IEEE488Bus$LineType$.MODULE$.ATN());
                } else {
                    this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.ATN());
                }
                if ((data & 0x10) > 0) {
                    this.bus.pullLine(this, IEEE488Bus$LineType$.MODULE$.DAV());
                } else {
                    this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.DAV());
                }
                if ((data & 0x20) > 0) {
                    this.bus.pullLine(this, IEEE488Bus$LineType$.MODULE$.EOI());
                    return;
                }
                this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.EOI());
                return;
            }
            if ((data & 0x80) > 0) {
                this.bus.pullLine(this, IEEE488Bus$LineType$.MODULE$.NRFD());
            } else {
                this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.NRFD());
            }
            if ((data & 0x40) > 0) {
                this.bus.pullLine(this, IEEE488Bus$LineType$.MODULE$.NDAC());
            } else {
                this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.NDAC());
            }
            this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.ATN());
            this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.DAV());
            this.bus.releaseLine(this, IEEE488Bus$LineType$.MODULE$.EOI());
        }

        public IEEE488InterfaceA(IEEE488Bus bus, CIAIEEE488ConnectorA ciaConnector) {
            this.bus = bus;
            this.ciaConnector = ciaConnector;
            MOS6525.PortAB.$init$(this);
            this.isController = true;
            bus.registerListener(this);
        }
    }

    public static class IEEE488InterfaceB
    extends IEEE488Bus.LineListener
    implements MOS6525.PortAB {
        private final Datassette datassette;

        @Override
        public void setMOS6525(MOS6525 MOS65252) {
            MOS6525.PortAB.setMOS6525$(this, MOS65252);
        }

        @Override
        public int read() {
            int n = 0x7F | (this.datassette.isPlayPressed() ? 128 : 0);
            return n;
        }

        @Override
        public void write(int value) {
            boolean datassetteMotor = (value & 0x40) > 0;
            boolean datassetteWrite = (value & 0x20) == 0;
            this.datassette.setMotor(datassetteMotor);
            this.datassette.setWriteLine(datassetteWrite);
        }

        public IEEE488InterfaceB(IEEE488Bus bus, Datassette datassette) {
            this.datassette = datassette;
            MOS6525.PortAB.$init$(this);
        }
    }
}

