/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import ucesoft.cbm.formats.D64LocalDirectory$;
import ucesoft.cbm.formats.D64_D71;
import ucesoft.cbm.formats.Diskette;
import ucesoft.cbm.formats.Diskette$FileType$;

@ScalaSignature(bytes="\u0006\u0005\u0005mq!B\u000b\u0017\u0011\u0003ib!B\u0010\u0017\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%iA\u000b\u0005\u0007[\u0005\u0001\u000bQB\u0016\t\u000b9\nA\u0011A\u0018\u0007\t}1\u0002!\r\u0005\tk\u0019\u0011)\u0019!C!m!I!I\u0002B\u0001B\u0003%qg\u0011\u0005\t\t\u001a\u0011)\u0019!C\u0001\u000b\"AaJ\u0002B\u0001B\u0003%a\tC\u0003(\r\u0011\u0005q\n\u0003\u0004S\r\u0001\u0006Ka\u0015\u0005\u0007S\u001a\u0001\u000b\u0015\u00026\t\r54\u0001\u0015)\u0003o\u0011\u0019\th\u0001\"\u0001\u0017e\")\u0001P\u0002C!s\")AP\u0002C!{\"9\u0011q\u0001\u0004\u0005B\u0005%\u0001bBA\u0006\r\u0011%\u0011\u0011\u0002\u0005\b\u0003\u001b1A\u0011BA\b\u0003E!e\u0007\u000e'pG\u0006dG)\u001b:fGR|'/\u001f\u0006\u0003/a\tqAZ8s[\u0006$8O\u0003\u0002\u001a5\u0005\u00191MY7\u000b\u0003m\tq!^2fg>4Go\u0001\u0001\u0011\u0005y\tQ\"\u0001\f\u0003#\u00113D\u0007T8dC2$\u0015N]3di>\u0014\u0018p\u0005\u0002\u0002CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000f\u0002\u001b5\u000b\u0005l\u0018$J\u0019\u0016{6+\u0013.F+\u0005Ys\"\u0001\u0017\u001e\u0007\tA\n!\u0001\bN\u0003b{f)\u0013'F?NK%,\u0012\u0011\u0002-\r\u0014X-\u0019;f\t&\u001c8N\u0012:p[2{7-\u00197ESJ$2\u0001MA\r!\tqba\u0005\u0002\u0007eA\u0011adM\u0005\u0003iY\u0011q\u0001\u0012\u001c5?\u0012;\u0014'\u0001\u0003gS2,W#A\u001c\u0011\u0005azdBA\u001d>!\tQ4%D\u0001<\u0015\taD$\u0001\u0004=e>|GOP\u0005\u0003}\r\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011ahI\u0001\u0006M&dW\rI\u0005\u0003kM\n1\u0001Z5s+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\tIwNC\u0001L\u0003\u0011Q\u0017M^1\n\u00055C%\u0001\u0002$jY\u0016\fA\u0001Z5sAQ\u0019\u0001\u0007U)\t\u000bUZ\u0001\u0019A\u001c\t\u000b\u0011[\u0001\u0019\u0001$\u0002#%t\u0017\u000e^5bY\u0012K'/\u00128ue&,7\u000fE\u0002U3rs!!V,\u000f\u0005i2\u0016\"\u0001\u0013\n\u0005a\u001b\u0013a\u00029bG.\fw-Z\u0005\u00035n\u0013A\u0001T5ti*\u0011\u0001l\t\t\u0003;\u001at!A\u00183\u000f\u0005}\u001bgB\u00011c\u001d\tQ\u0014-C\u0001\u001c\u0013\tI\"$\u0003\u0002\u00181%\u0011QMF\u0001\t\t&\u001c8.\u001a;uK&\u0011q\r\u001b\u0002\t\t&\u0014XI\u001c;ss*\u0011QMF\u0001\rI&\u001c8.T8eS\u001aLW\r\u001a\t\u0003E-L!\u0001\\\u0012\u0003\u000f\t{w\u000e\\3b]\u00069a-\u001b7f\u001b\u0006\u0004\b\u0003\u0002\u001dpo\u0019K!\u0001]!\u0003\u00075\u000b\u0007/\u0001\u0006tKR4\u0015\u000e\\3NCB$\"a\u001d<\u0011\u0005\t\"\u0018BA;$\u0005\u0011)f.\u001b;\t\u000b]|\u0001\u0019\u00018\u0002\u00075\f\u0007/\u0001\u0007xe&$XMT3yi\nKG\u000f\u0006\u0002tu\")1\u0010\u0005a\u0001U\u0006)a/\u00197vK\u0006iqO]5uK:+\u0007\u0010\u001e\"zi\u0016$\"a\u001d@\t\r}\f\u0002\u0019AA\u0001\u0003\u0005\u0011\u0007c\u0001\u0012\u0002\u0004%\u0019\u0011QA\u0012\u0003\u0007%sG/A\u0003dY>\u001cX\rF\u0001t\u0003A\u0019\u0018P\\2XSRDGj\\2bY\u0012K'/\u0001\u0006va\u0012\fG/\u001a$jY\u0016$Ra]A\t\u0003+Aa!a\u0005\u0015\u0001\u00041\u0015!\u00014\t\r\u0005]A\u00031\u0001]\u0003\u0005)\u0007\"\u0002#\u0006\u0001\u00041\u0005")
public class D64LocalDirectory
extends D64_D71 {
    private final File dir;
    private List<Diskette.DirEntry> initialDirEntries;
    private boolean diskModified;
    private Map<String, File> fileMap;

    public static D64LocalDirectory createDiskFromLocalDir(File dir) {
        return D64LocalDirectory$.MODULE$.createDiskFromLocalDir(dir);
    }

    @Override
    public String file() {
        return super.file();
    }

    public File dir() {
        return this.dir;
    }

    public void setFileMap(Map<String, File> map) {
        this.fileMap = map;
        this.initialDirEntries = this.directories();
    }

    @Override
    public void writeNextBit(boolean value) {
        super.writeNextBit(value);
        this.diskModified = true;
    }

    @Override
    public void writeNextByte(int b) {
        super.writeNextByte(b);
        this.diskModified = true;
    }

    @Override
    public void close() {
        this.flush();
        if (this.diskModified) {
            this.syncWithLocalDir();
        }
        this.disk().close();
    }

    private void syncWithLocalDir() {
        List<Diskette.DirEntry> dirEntries = this.directories();
        List toDelete = this.initialDirEntries.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)D64LocalDirectory.$anonfun$syncWithLocalDir$1(dirEntries, e)));
        List<Diskette.DirEntry> toModify = dirEntries;
        toDelete.foreach((Function1 & Serializable)e -> {
            Option option = $this.fileMap.get((Object)e.fileName());
            if (option instanceof Some) {
                Some some = (Some)option;
                File f = (File)some.value();
                return BoxesRunTime.boxToBoolean((boolean)f.delete());
            }
            if (None$.MODULE$.equals(option)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        toModify.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)D64LocalDirectory.$anonfun$syncWithLocalDir$3(f))).foreach((Function1 & Serializable)e -> {
            D64LocalDirectory.$anonfun$syncWithLocalDir$4(this, e);
            return BoxedUnit.UNIT;
        });
    }

    private void updateFile(File f, Diskette.DirEntry e) {
        int t = e.t();
        int s = e.s();
        try (FileOutputStream out = new FileOutputStream(f);){
            while (true) {
                byte[] sector = this.readBlock(t, s);
                t = sector[0];
                s = sector[1] & 0xFF;
                if (t == 0) {
                    out.write(sector, 2, s);
                } else {
                    out.write(sector, 2, sector.length - 2);
                }
                if (t != 0) {
                    continue;
                }
                break;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$syncWithLocalDir$1(List dirEntries$1, Diskette.DirEntry e) {
        return !dirEntries$1.contains((Object)e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$syncWithLocalDir$3(Diskette.DirEntry f) {
        Enumeration.Value value = f.fileType();
        Enumeration.Value value2 = Diskette$FileType$.MODULE$.PRG();
        if (value == null) {
            if (value2 == null) return true;
        } else if (value.equals(value2)) return true;
        Enumeration.Value value3 = f.fileType();
        Enumeration.Value value4 = Diskette$FileType$.MODULE$.SEQ();
        if (value3 != null) {
            if (!value3.equals(value4)) return false;
            return true;
        }
        if (value4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$syncWithLocalDir$4(D64LocalDirectory $this, Diskette.DirEntry e) {
        Option option = $this.fileMap.get((Object)e.fileName());
        if (option instanceof Some) {
            Some some = (Some)option;
            File f = (File)some.value();
            $this.updateFile(f, e);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            File newFile = new File($this.dir(), new StringBuilder(1).append(e.fileName().toLowerCase()).append(".").append(e.fileType().toString().toLowerCase()).toString());
            $this.updateFile(newFile, e);
            return;
        }
        throw new MatchError((Object)option);
    }

    public D64LocalDirectory(String file, File dir) {
        this.dir = dir;
        super(file, false);
        this.initialDirEntries = Nil$.MODULE$;
        this.diskModified = false;
        this.fileMap = Predef$.MODULE$.Map().empty();
    }
}

