/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.matching.Regex;
import ucesoft.cbm.formats.D64_D71;
import ucesoft.cbm.formats.D80;
import ucesoft.cbm.formats.D80$;
import ucesoft.cbm.formats.D81;
import ucesoft.cbm.formats.Diskette;
import ucesoft.cbm.formats.Diskette$FileMode$;
import ucesoft.cbm.formats.Diskette$FileType$;
import ucesoft.cbm.formats.G64;

public final class Diskette$ {
    public static final Diskette$ MODULE$ = new Diskette$();
    private static final Regex FILENAME_RE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(@?\\d:)?([^,]+)(,(s|seq|S|SEQ|p|prg|P|PRG|u|usr|U|USR|l|L))?(,(r|w|a|R|W|A))?"));
    private static final Regex DIRECTORY_RE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\$(\\d)?(:([^=]+)(=([s|S|r|R|p|P|u|U]))?)?"));

    private Regex FILENAME_RE() {
        return FILENAME_RE;
    }

    private Regex DIRECTORY_RE() {
        return DIRECTORY_RE;
    }

    public Option<Diskette.FileName> parseFileName(String fn) {
        Option option;
        Option option2;
        Option option3;
        String string = fn;
        if (string != null && !(option3 = this.DIRECTORY_RE().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(5) == 0) {
            String drive = (String)((LinearSeqOps)option3.get()).apply(0);
            String pattern = (String)((LinearSeqOps)option3.get()).apply(2);
            String ftype = (String)((LinearSeqOps)option3.get()).apply(4);
            return new Some((Object)new Diskette.DirectoryFileName(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)Option$.MODULE$.apply((Object)drive).getOrElse((Function0 & Serializable)() -> "0"))), (Option<String>)Option$.MODULE$.apply((Object)pattern), Diskette$FileType$.MODULE$.fromString(ftype)));
        }
        if (string != null && !(option2 = this.FILENAME_RE().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(6) == 0) {
            String ovr = (String)((LinearSeqOps)option2.get()).apply(0);
            String pattern = (String)((LinearSeqOps)option2.get()).apply(1);
            String string2 = (String)((LinearSeqOps)option2.get()).apply(3);
            String mode = (String)((LinearSeqOps)option2.get()).apply(5);
            if (string2 == null) {
                return new Some((Object)new Diskette.StandardFileName(pattern, (Option<Enumeration.Value>)new Some((Object)Diskette$FileType$.MODULE$.PRG()), Diskette$FileMode$.MODULE$.fromString(mode), ovr != null && ovr.startsWith("@")));
            }
        }
        if (string != null && !(option = this.FILENAME_RE().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(6) == 0) {
            String ovr = (String)((LinearSeqOps)option.get()).apply(0);
            String pattern = (String)((LinearSeqOps)option.get()).apply(1);
            String ftype = (String)((LinearSeqOps)option.get()).apply(3);
            String mode = (String)((LinearSeqOps)option.get()).apply(5);
            return new Some((Object)new Diskette.StandardFileName(pattern, Diskette$FileType$.MODULE$.fromString(ftype), Diskette$FileMode$.MODULE$.fromString(mode), ovr != null && ovr.startsWith("@")));
        }
        return None$.MODULE$;
    }

    public boolean fileNameMatch(String fileNameToSearch, String fileName) {
        int i = 0;
        while (i < fileNameToSearch.length()) {
            char a = fileNameToSearch.charAt(i);
            if (a == '*') {
                return true;
            }
            if (i >= fileName.length()) {
                return false;
            }
            char b = fileName.charAt(i);
            if (a == '?') {
                ++i;
                continue;
            }
            if (a == b) {
                ++i;
                continue;
            }
            return false;
        }
        return fileNameToSearch.length() == fileName.length();
    }

    public Diskette apply(String fileName, boolean load) {
        String upper = fileName.toUpperCase();
        if (upper.endsWith(".D64") || upper.endsWith(".D71")) {
            return new D64_D71(fileName, load);
        }
        if (upper.endsWith(".D81")) {
            return new D81(fileName);
        }
        if (upper.endsWith(".G64") || upper.endsWith(".G71")) {
            return new G64(fileName);
        }
        if (upper.endsWith(".D80")) {
            return new D80(fileName, D80$.MODULE$.$lessinit$greater$default$2());
        }
        throw new IllegalArgumentException("Unsupported file format");
    }

    public boolean apply$default$2() {
        return true;
    }

    public void makeEmptyDisk(String file) {
        String string;
        block8: {
            int p = file.lastIndexOf(46);
            if (p == -1) {
                throw new IllegalArgumentException("File name must have a valid extension");
            }
            String ext = file.substring(p + 1).toUpperCase();
            String string2 = ext;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 67074: {
                    if (!"D64".equals(string2)) break;
                    string = "emptyDisk.d64";
                    break block8;
                }
                case 67102: {
                    if (!"D71".equals(string2)) break;
                    string = "emptyDisk.d71";
                    break block8;
                }
                case 67133: {
                    if (!"D81".equals(string2)) break;
                    string = "emptyDisk.d81";
                    break block8;
                }
                case 69957: {
                    if (!"G64".equals(string2)) break;
                    string = "emptyDisk.g64";
                    break block8;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported disk format: ").append(ext).toString());
        }
        String diskRes = string;
        InputStream emptyDisk = this.getClass().getResourceAsStream(new StringBuilder(11).append("/resources/").append(diskRes).toString());
        if (emptyDisk == null) {
            throw new IllegalArgumentException(new StringBuilder(14).append("Cannot find '").append(diskRes).append("'").toString());
        }
        Files.copy(emptyDisk, new File(file).toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private Diskette$() {
    }
}

