/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.formats;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.formats.GCR;
import ucesoft.cbm.formats.UNGCR;

public final class GCR$ {
    public static final GCR$ MODULE$ = new GCR$();
    private static final int[] INTER_SECTOR_GAPS_PER_ZONE = new int[]{9, 12, 17, 8};
    private static final int[] EMPTY_GCR_SECTOR = (int[])Array$.MODULE$.ofDim(400, (ClassTag)ClassTag$.MODULE$.Int());

    public final int[] EMPTY_GCR_SECTOR() {
        return EMPTY_GCR_SECTOR;
    }

    private int getZoneFrom(int track) {
        if (track <= 17) {
            return 0;
        }
        if (track <= 24) {
            return 1;
        }
        if (track <= 30) {
            return 2;
        }
        return 3;
    }

    public void GCR2track(int[] gcrTrack, int _sectorSize, Function3<Object, Object, int[], BoxedUnit> writeSector) {
        UNGCR ungcr = new UNGCR();
        int i = 0;
        int readData = 0;
        int sectorsFound = 0;
        int[] dataBuffer = (int[])Array$.MODULE$.ofDim(256, (ClassTag)ClassTag$.MODULE$.Int());
        boolean sync = false;
        boolean dataFound = false;
        boolean headerFound = false;
        int dataBufferIndex = 0;
        int bits = 0;
        int track = 0;
        int sector = 0;
        int round = 0;
        int sectorSize = _sectorSize == -1 ? Integer.MAX_VALUE : _sectorSize;
        HashSet sectorsSet = new HashSet();
        boolean finished = false;
        while (sectorsFound < sectorSize && !finished) {
            int data = gcrTrack[i];
            int b = 0;
            while (b < 8) {
                readData <<= 1;
                if ((data & 0x80) == 128) {
                    readData |= 1;
                }
                if (headerFound) {
                    if (++bits == 10) {
                        dataBuffer[dataBufferIndex] = ungcr.gcr2Byte(readData &= 0x3FF);
                        bits = 0;
                        if (++dataBufferIndex == 5) {
                            headerFound = false;
                            sector = dataBuffer[1];
                            track = dataBuffer[2];
                            if (_sectorSize == -1 && !sectorsSet.add((Object)BoxesRunTime.boxToInteger((int)sector))) {
                                finished = true;
                            }
                        }
                    }
                } else if (dataFound) {
                    if (++bits == 10) {
                        dataBuffer[dataBufferIndex] = ungcr.gcr2Byte(readData &= 0x3FF);
                        bits = 0;
                        if (++dataBufferIndex == 256) {
                            writeSector.apply((Object)BoxesRunTime.boxToInteger((int)track), (Object)BoxesRunTime.boxToInteger((int)sector), (Object)dataBuffer);
                            ++sectorsFound;
                            dataFound = false;
                            dataBufferIndex = 0;
                            dataBuffer = (int[])Array$.MODULE$.ofDim(256, (ClassTag)ClassTag$.MODULE$.Int());
                            readData = 0;
                            bits = 0;
                        }
                    }
                } else if (sync) {
                    if ((readData &= 0xFFFFF) == 1047895) {
                        dataFound = true;
                        dataBufferIndex = 0;
                        bits = 0;
                        sync = false;
                    } else if (readData == 1047881) {
                        sync = false;
                        headerFound = true;
                        dataBufferIndex = 0;
                        bits = 0;
                    }
                } else if ((readData &= 0x3FF) == 1023) {
                    sync = true;
                }
                ++b;
                data <<= 1;
            }
            if (++i != gcrTrack.length) continue;
            i = 0;
            if (++round != 2) continue;
            throw new IllegalArgumentException("Cannot write changes on disk: invalid format");
        }
    }

    public int[] sector2GCR(int sector, int track, byte[] sectorData, String diskID, Option<Object> sectorError, boolean isLastSector) {
        int sectorErrorCode = BoxesRunTime.unboxToInt((Object)sectorError.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        GCR gcr = new GCR();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            int n = x$1;
            gcr.add((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255}));
        });
        int diskIDHi = sectorErrorCode == 11 ? 255 : (int)diskID.charAt(0);
        char diskIDLo = diskID.charAt(1);
        int headerChecksum = sector ^ track ^ diskIDHi ^ diskIDLo;
        if (sectorErrorCode == 9) {
            headerChecksum ^= 0xFF;
        }
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{sectorErrorCode == 2 ? 0 : 8}));
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{headerChecksum}));
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{sector}));
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{track}));
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{diskIDLo}));
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{diskIDHi}));
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15, 15}));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            int n = x$2;
            gcr.add((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{85}));
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            gcr.add((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255}));
        });
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{sectorErrorCode == 4 ? 0 : 7}));
        IntRef dataChecksum = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sectorData.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int b;
            int n = b = sectorErrorCode == 3 ? 0 : sectorData[i] & 0xFF;
            dataChecksum$1.elem = dataChecksum$1.elem == 0 ? b : (dataChecksum$1.elem ^= b);
            gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{b}));
        });
        if (sectorErrorCode == 5) {
            dataChecksum.elem ^= 0xFF;
        }
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{dataChecksum.elem}));
        gcr.addAndConvertToGCR((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0}));
        if (isLastSector) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 40).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                int n = x$4;
                gcr.add((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{85}));
            });
        } else {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), INTER_SECTOR_GAPS_PER_ZONE[this.getZoneFrom(track)]).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
                int n = x$5;
                gcr.add((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{85}));
            });
        }
        return gcr.getGCRBytes();
    }

    private GCR$() {
    }
}

