/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.misc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class FullScreenMode$ {
    public static final FullScreenMode$ MODULE$ = new FullScreenMode$();

    public void goFullScreen(JFrame frame, JComponent component, int width, int height, MouseListener mouseListener, Seq<KeyListener> keyListeners) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getScreenDevices()[0];
        GraphicsConfiguration conf = device.getDefaultConfiguration();
        if (device.isFullScreenSupported()) {
            JFrame window = new JFrame(conf);
            window.getContentPane().setLayout(null);
            window.getContentPane().add(component);
            window.getContentPane().setBackground(Color.BLACK);
            frame.setVisible(false);
            window.setUndecorated(true);
            window.setIconImage(new ImageIcon(this.getClass().getResource("/resources/commodore.png")).getImage());
            device.setFullScreenWindow(window);
            Rectangle size = conf.getBounds();
            double windowWidthFactor = (double)size.width / (double)width;
            double windowHeightFactor = (double)size.height / (double)height;
            double factor = package$.MODULE$.min(windowWidthFactor, windowHeightFactor);
            Dimension originalSize = component.getSize();
            component.setSize(new Dimension((int)((double)width * factor), (int)((double)height * factor)));
            Dimension vicSize = component.getSize();
            Dimension winSize = window.getSize();
            component.setLocation((winSize.width - vicSize.width) / 2, (winSize.height - vicSize.height) / 2);
            component.invalidate();
            window.validate();
            window.setVisible(true);
            window.toFront();
            window.addMouseListener(mouseListener);
            keyListeners.foreach((Function1 & Serializable)kl -> {
                window.addKeyListener(kl);
                return BoxedUnit.UNIT;
            });
            window.addKeyListener(new KeyAdapter(window, frame, component, originalSize){
                private final JFrame window$1;
                private final JFrame frame$1;
                private final JComponent component$1;
                private final Dimension originalSize$1;

                public void keyPressed(KeyEvent e) {
                    int n = e.getKeyCode();
                    switch (n) {
                        case 10: {
                            if (!e.isAltDown()) break;
                            this.window$1.dispose();
                            this.frame$1.setVisible(true);
                            this.component$1.setSize(this.originalSize$1);
                            this.frame$1.getContentPane().add("Center", this.component$1);
                            this.frame$1.pack();
                            return;
                        }
                    }
                }
                {
                    this.window$1 = window$1;
                    this.frame$1 = frame$1;
                    this.component$1 = component$1;
                    this.originalSize$1 = originalSize$1;
                }
            });
            return;
        }
        JOptionPane.showMessageDialog(frame, "Your display device does not support full screen mode", "Full Screen Mode", 0);
    }

    private FullScreenMode$() {
    }
}

