/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.misc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import ucesoft.cbm.misc.AnimatedGIFWriter;
import ucesoft.cbm.misc.GIFPanel$;
import ucesoft.cbm.peripheral.vic.Display;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u0015+\u0001EB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t#\u0002\u0011\t\u0011)A\u0005%\")a\f\u0001C\u0001?\"9A\r\u0001a\u0001\n\u0013)\u0007bB5\u0001\u0001\u0004%IA\u001b\u0005\u0007a\u0002\u0001\u000b\u0015\u00024\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0013\u0011\b\"C=\u0001\u0001\u0004\u0005\r\u0011\"\u0003{\u0011%a\b\u00011A\u0001B\u0003&1\u000fC\u0004~\u0001\u0001\u0007I\u0011\u0002@\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\u0005\u001d\u0001bBA\u0006\u0001\u0001\u0006Ka \u0005\n\u0003+\u0001!\u0019!C\u0005\u0003/A\u0001\"a\b\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003/A\u0001\"a\t\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OA\u0001\"a\f\u0001A\u0003%\u0011\u0011\u0006\u0005\t\u0003c\u0001\u0001\u0019!C\u0005K\"I\u00111\u0007\u0001A\u0002\u0013%\u0011Q\u0007\u0005\b\u0003s\u0001\u0001\u0015)\u0003g\u0011%\tY\u0004\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA \u0011%\t9\u0005\u0001b\u0001\n\u0013\tI\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA&\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Bq!a\u0016\u0001\t\u0013\tI\u0006C\u0005\u0002z\u0001\t\n\u0011\"\u0003\u0002|!I\u0011\u0011\u0013\u0001\u0012\u0002\u0013%\u00111\u0010\u0005\n\u0003'\u0003\u0011\u0013!C\u0005\u0003wBq!!&\u0001\t\u0013\t)\u0006C\u0004\u0002\u0018\u0002!I!!\u0016\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\"9\u00111\u0015\u0001\u0005\u0002\u0005U\u0003bBAS\u0001\u0011\u0005\u0011QK\u0004\b\u0003OS\u0003\u0012AAU\r\u0019I#\u0006#\u0001\u0002,\"1a,\nC\u0001\u0003sCq!a/&\t\u0003\ti\fC\u0005\u0002T\u0016\n\t\u0011\"\u0003\u0002V\nAq)\u0013$QC:,GN\u0003\u0002,Y\u0005!Q.[:d\u0015\tic&A\u0002dE6T\u0011aL\u0001\bk\u000e,7o\u001c4u\u0007\u0001\u00192\u0001\u0001\u001a;!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0003to&twMC\u00018\u0003\u0015Q\u0017M^1y\u0013\tIDG\u0001\u0004K!\u0006tW\r\u001c\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005!\u0011VO\u001c8bE2,\u0017a\u00023jgBd\u0017-\u001f\t\u0004\t\u001eKU\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005){U\"A&\u000b\u00051k\u0015a\u0001<jG*\u0011a\nL\u0001\u000ba\u0016\u0014\u0018\u000e\u001d5fe\u0006d\u0017B\u0001)L\u0005\u001d!\u0015n\u001d9mCf\f1\u0002Z5ta2\f\u0017PT1nKB\u0019AiR*\u0011\u0005Q[fBA+Z!\t1V)D\u0001X\u0015\tA\u0006'\u0001\u0004=e>|GOP\u0005\u00035\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!,R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\u00147\r\u0005\u0002b\u00015\t!\u0006C\u0003C\u0007\u0001\u00071\tC\u0003R\u0007\u0001\u0007!+A\u0007eK2\f\u00170\u00138NS2d\u0017n]\u000b\u0002MB\u0011AiZ\u0005\u0003Q\u0016\u00131!\u00138u\u0003E!W\r\\1z\u0013:l\u0015\u000e\u001c7jg~#S-\u001d\u000b\u0003W:\u0004\"\u0001\u00127\n\u00055,%\u0001B+oSRDqa\\\u0003\u0002\u0002\u0003\u0007a-A\u0002yIE\na\u0002Z3mCfLe.T5mY&\u001c\b%A\u0002pkR,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mz\n!![8\n\u0005a,(\u0001\u0005$jY\u0016|U\u000f\u001e9viN#(/Z1n\u0003\u001dyW\u000f^0%KF$\"a[>\t\u000f=D\u0011\u0011!a\u0001g\u0006!q.\u001e;!\u0003%\u0011XmY8sI&tw-F\u0001\u0000!\r!\u0015\u0011A\u0005\u0004\u0003\u0007)%a\u0002\"p_2,\u0017M\\\u0001\u000ee\u0016\u001cwN\u001d3j]\u001e|F%Z9\u0015\u0007-\fI\u0001C\u0004p\u0017\u0005\u0005\t\u0019A@\u0002\u0015I,7m\u001c:eS:<\u0007\u0005K\u0002\r\u0003\u001f\u00012\u0001RA\t\u0013\r\t\u0019\"\u0012\u0002\tm>d\u0017\r^5mK\u0006ia-\u001b7f)\u0016DHOR5fY\u0012,\"!!\u0007\u0011\u0007M\nY\"C\u0002\u0002\u001eQ\u0012!B\u0013+fqR4\u0015.\u001a7e\u000391\u0017\u000e\\3UKb$h)[3mI\u0002\na\u0002Z3mCf$V\r\u001f;GS\u0016dG-A\beK2\f\u0017\u0010V3yi\u001aKW\r\u001c3!\u0003=\u0019H/\u0019:u'R|\u0007OQ;ui>tWCAA\u0015!\r\u0019\u00141F\u0005\u0004\u0003[!$a\u0002&CkR$xN\\\u0001\u0011gR\f'\u000f^*u_B\u0014U\u000f\u001e;p]\u0002\nAc]3mK\u000e$X\r\u001a#jgBd\u0017-_%oI\u0016D\u0018\u0001G:fY\u0016\u001cG/\u001a3ESN\u0004H.Y=J]\u0012,\u0007p\u0018\u0013fcR\u00191.a\u000e\t\u000f=$\u0012\u0011!a\u0001M\u0006)2/\u001a7fGR,G\rR5ta2\f\u00170\u00138eKb\u0004\u0013!\u00044sC6,7\t[3dW\n|\u00070\u0006\u0002\u0002@A\u00191'!\u0011\n\u0007\u0005\rCGA\u0005K\u0007\",7m\u001b\"pq\u0006qaM]1nK\u000eCWmY6c_b\u0004\u0013A\u00054sC6,'+Z2pe\u0012,G\rT1cK2,\"!a\u0013\u0011\u0007M\ni%C\u0002\u0002PQ\u0012aA\u0013'bE\u0016d\u0017a\u00054sC6,'+Z2pe\u0012,G\rT1cK2\u0004\u0013\u0001B5oSR$\u0012a[\u0001\u0004C\u0012$G#D6\u0002\\\u0005}\u00131MA7\u0003c\n)\b\u0003\u0004\u0002^m\u0001\rAZ\u0001\u0002q\"1\u0011\u0011M\u000eA\u0002\u0019\f\u0011!\u001f\u0005\b\u0003KZ\u0002\u0019AA4\u0003\u0011\u0019w.\u001c9\u0011\u0007M\nI'C\u0002\u0002lQ\u0012!BS\"p[B|g.\u001a8u\u0011!\tyg\u0007I\u0001\u0002\u00041\u0017AB1oG\"|'\u000f\u0003\u0005\u0002tm\u0001\n\u00111\u0001g\u0003\t9w\u000f\u0003\u0005\u0002xm\u0001\n\u00111\u0001g\u0003\t9\u0007.A\u0007bI\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003{R3AZA@W\t\t\t\t\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u0013Ut7\r[3dW\u0016$'bAAF\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0015Q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!D1eI\u0012\"WMZ1vYR$S'A\u0007bI\u0012$C-\u001a4bk2$HEN\u0001\u000bG\",7m\u001b#fY\u0006L\u0018!C:uCJ$8\u000b^8q\u0003\u0019\u0011'o\\<tKV\u0011\u0011Q\u0014\t\u0005\t\u0006}5+C\u0002\u0002\"\u0016\u0013aa\u00149uS>t\u0017a\u0001:v]\u0006i1\u000f^8q%\u0016\u001cwN\u001d3j]\u001e\f\u0001bR%G!\u0006tW\r\u001c\t\u0003C\u0016\u001aR!JAW\u0003g\u00032\u0001RAX\u0013\r\t\t,\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0007Q\f),C\u0002\u00028V\u0014AbU3sS\u0006d\u0017N_1cY\u0016$\"!!+\u0002\u001d\r\u0014X-\u0019;f\u000f&3\u0005+\u00198fYRA\u0011qXAc\u0003\u001f\f\t\u000eE\u00024\u0003\u0003L1!a15\u0005\u001dQE)[1m_\u001eDq!a2(\u0001\u0004\tI-\u0001\u0004qCJ,g\u000e\u001e\t\u0004g\u0005-\u0017bAAgi\t1!J\u0012:b[\u0016DQAQ\u0014A\u0002\rCQ!U\u0014A\u0002I\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a6\u0011\u0007m\nI.C\u0002\u0002\\r\u0012aa\u00142kK\u000e$\b")
public class GIFPanel
extends JPanel
implements Runnable {
    private final Display[] display;
    private final String[] displayName;
    private int delayInMillis;
    private FileOutputStream out;
    private volatile boolean recording;
    private final JTextField fileTextField;
    private final JTextField delayTextField;
    private final JButton startStopButton;
    private int selectedDisplayIndex;
    private final JCheckBox frameCheckbox;
    private final JLabel frameRecordedLabel;

    public static JDialog createGIFPanel(JFrame parent, Display[] display, String[] displayName) {
        return GIFPanel$.MODULE$.createGIFPanel(parent, display, displayName);
    }

    private int delayInMillis() {
        return this.delayInMillis;
    }

    private void delayInMillis_$eq(int x$1) {
        this.delayInMillis = x$1;
    }

    private FileOutputStream out() {
        return this.out;
    }

    private void out_$eq(FileOutputStream x$1) {
        this.out = x$1;
    }

    private boolean recording() {
        return this.recording;
    }

    private void recording_$eq(boolean x$1) {
        this.recording = x$1;
    }

    private JTextField fileTextField() {
        return this.fileTextField;
    }

    private JTextField delayTextField() {
        return this.delayTextField;
    }

    private JButton startStopButton() {
        return this.startStopButton;
    }

    private int selectedDisplayIndex() {
        return this.selectedDisplayIndex;
    }

    private void selectedDisplayIndex_$eq(int x$1) {
        this.selectedDisplayIndex = x$1;
    }

    private JCheckBox frameCheckbox() {
        return this.frameCheckbox;
    }

    private JLabel frameRecordedLabel() {
        return this.frameRecordedLabel;
    }

    public void ucesoft$cbm$misc$GIFPanel$$init() {
        this.setLayout(new GridBagLayout());
        JComboBox<Object> displaySelector = new JComboBox<Object>((Object[])this.displayName);
        displaySelector.addActionListener(x$2 -> this.selectedDisplayIndex_$eq(displaySelector.getSelectedIndex()));
        this.add(0, 0, new JLabel("Display:"), 22, this.add$default$5(), this.add$default$6());
        this.add(1, 0, displaySelector, 21, this.add$default$5(), this.add$default$6());
        this.add(0, 1, new JLabel("GIF output file:"), 22, this.add$default$5(), this.add$default$6());
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(x$3 -> {
            Option<String> option = this.browse();
            if (option instanceof Some) {
                Some some = (Some)option;
                String file = (String)some.value();
                this.fileTextField().setText(file);
                return;
            }
        });
        this.add(1, 1, this.fileTextField(), 21, this.add$default$5(), this.add$default$6());
        this.add(2, 1, browseButton, this.add$default$4(), this.add$default$5(), this.add$default$6());
        this.add(0, 2, new JLabel("Frame delay in millis:"), 22, this.add$default$5(), this.add$default$6());
        this.add(1, 2, this.delayTextField(), 21, this.add$default$5(), this.add$default$6());
        this.add(0, 3, this.frameCheckbox(), 22, this.add$default$5(), this.add$default$6());
        this.add(1, 3, new JLabel("Frame recorded:"), 22, this.add$default$5(), this.add$default$6());
        this.add(2, 3, this.frameRecordedLabel(), 21, this.add$default$5(), this.add$default$6());
        this.startStopButton().addActionListener(x$4 -> this.startStop());
        this.add(1, 4, this.startStopButton(), this.add$default$4(), this.add$default$5(), this.add$default$6());
    }

    private void add(int x, int y, JComponent comp, int anchor, int gw, int gh) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = x;
        c.gridy = y;
        c.fill = 0;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.anchor = anchor;
        this.add((Component)comp, c);
    }

    private int add$default$4() {
        return 10;
    }

    private int add$default$5() {
        return 1;
    }

    private int add$default$6() {
        return 1;
    }

    private void checkDelay() {
        try {
            this.delayInMillis_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.delayTextField().getText())));
            if (this.delayInMillis() < 20) {
                this.delayInMillis_$eq(20);
                this.delayTextField().setText("20");
            }
        }
        catch (Exception exception) {
            this.delayTextField().setText("1000");
        }
    }

    private void startStop() {
        block3: {
            try {
                if (!this.recording()) {
                    String fileName = this.fileTextField().getText().toUpperCase().endsWith("GIF") ? this.fileTextField().getText() : new StringBuilder(4).append(this.fileTextField().getText()).append(".gif").toString();
                    this.out_$eq(new FileOutputStream(fileName));
                    Thread thread = new Thread((Runnable)this, "GIFRecorder");
                    this.recording_$eq(true);
                    this.checkDelay();
                    this.startStopButton().setText("Stop recording");
                    thread.start();
                    break block3;
                }
                this.stopRecording();
            }
            catch (Throwable throwable) {}
        }
    }

    private Option<String> browse() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose a file where to save GIF");
        fc.setFileFilter(new FileFilter(null){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith(".GIF");
            }

            public String getDescription() {
                return "GIF files";
            }
        });
        int n = fc.showSaveDialog(this);
        switch (n) {
            case 0: {
                return new Some((Object)fc.getSelectedFile().toString());
            }
        }
        return None$.MODULE$;
    }

    @Override
    public void run() {
        Rectangle rectangle;
        boolean includeFrame = this.frameCheckbox().isSelected();
        if (includeFrame) {
            JFrame frame = (JFrame)SwingUtilities.getRoot(this.display[this.selectedDisplayIndex()]);
            frame.requestFocus();
            JRootPane rootPane = frame.getRootPane();
            Point wp = frame.getLocationOnScreen();
            Point p = rootPane.getLocationOnScreen();
            int delta = p.y - wp.y - 1;
            Rectangle rec = rootPane.getBounds();
            rec.x = p.x;
            rec.y = wp.y + 1;
            rec.height += delta;
            rectangle = rec;
        } else {
            Rectangle rec = this.display[this.selectedDisplayIndex()].getBounds();
            Point p = this.display[this.selectedDisplayIndex()].getLocationOnScreen();
            rec.x = p.x;
            rec.y = p.y;
            rectangle = rec;
        }
        Rectangle region = rectangle;
        AnimatedGIFWriter writer = new AnimatedGIFWriter(true);
        writer.prepareForWrite(this.out(), -1, -1);
        IntRef frameRecorded = IntRef.create((int)0);
        Robot r = new Robot();
        while (this.recording()) {
            long ts = System.currentTimeMillis();
            SwingUtilities.invokeAndWait(() -> {
                BufferedImage image = r.createScreenCapture(region);
                writer.writeFrame(this.out(), image, this.delayInMillis());
                ++frameRecorded$1.elem;
                this.frameRecordedLabel().setText(Integer.toString(frameRecorded$1.elem));
            });
            long elapsed = System.currentTimeMillis() - ts;
            if (elapsed >= (long)this.delayInMillis()) continue;
            Thread.sleep((long)this.delayInMillis() - elapsed);
        }
        writer.finishWrite(this.out());
        this.out().close();
        this.stopRecording();
    }

    public void stopRecording() {
        this.recording_$eq(false);
        this.startStopButton().setText("Start");
    }

    public GIFPanel(Display[] display, String[] displayName) {
        this.display = display;
        this.displayName = displayName;
        this.delayInMillis = 0;
        this.recording = false;
        this.fileTextField = new JTextField(20);
        this.delayTextField = new JTextField("1000", 10);
        this.startStopButton = new JButton("Start");
        this.selectedDisplayIndex = 0;
        this.frameCheckbox = new JCheckBox("Include frame border");
        this.frameRecordedLabel = new JLabel("0");
    }
}

