/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import ucesoft.cbm.misc.KeyboardConfigEditor$;
import ucesoft.cbm.misc.KeyboardHelper$;
import ucesoft.cbm.peripheral.keyboard.KeyboardMapper;

@ScalaSignature(bytes="\u0006\u0005\u0005Ur!B\u000b\u0017\u0011\u0003ib!B\u0010\u0017\u0011\u0003\u0001\u0003\"B\u0018\u0002\t\u0003\u0001\u0004\"C\u0019\u0002\u0001\u0004\u0005\r\u0011\"\u00033\u0011-\ty!\u0001a\u0001\u0002\u0004%I!!\u0005\t\u0015\u0005]\u0011\u00011A\u0001B\u0003&1\u0007C\u0004\u0002\u001a\u0005!\t!a\u0007\t\u0013\u0005\u0015\u0012!!A\u0005\n\u0005\u001db\u0001B\u0010\u0017\u0001QB\u0001\"\u0010\u0005\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0003\"\u0011\t\u0011)A\u0005\u0005\"A!\n\u0003B\u0001B\u0003%1\n\u0003\u0005R\u0011\t\u0005\t\u0015!\u0003S\u0011\u0015y\u0003\u0002\"\u0001^\u0011\u001d\u0011\u0007B1A\u0005\n\rDa\u0001\u001d\u0005!\u0002\u0013!\u0007bB9\t\u0005\u0004%\tA\u001d\u0005\u0007m\"\u0001\u000b\u0011B:\t\u000b]DA\u0011\u0002=\t\u000bqDA\u0011B?\t\u000f\u0005\u001d\u0001\u0002\"\u0003\u0002\n\u0005!2*Z=c_\u0006\u0014HmQ8oM&<W\tZ5u_JT!a\u0006\r\u0002\t5L7o\u0019\u0006\u00033i\t1a\u00192n\u0015\u0005Y\u0012aB;dKN|g\r^\u0002\u0001!\tq\u0012!D\u0001\u0017\u0005QYU-\u001f2pCJ$7i\u001c8gS\u001e,E-\u001b;peN\u0019\u0011!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tAS&D\u0001*\u0015\tQ3&\u0001\u0002j_*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018*\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ$\u0001\u0004fI&$xN]\u000b\u0002gA\u0011a\u0004C\n\u0003\u0011U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000bM<\u0018N\\4\u000b\u0003i\nQA[1wCbL!\u0001P\u001c\u0003\r)\u0003\u0016M\\3m\u0003\u00151'/Y7f!\t1t(\u0003\u0002Ao\t1!J\u0012:b[\u0016\f\u0011b[3z\u001b\u0006\u0004\b/\u001a:\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001C6fs\n|\u0017M\u001d3\u000b\u0005\u001dC\u0012A\u00039fe&\u0004\b.\u001a:bY&\u0011\u0011\n\u0012\u0002\u000f\u0017\u0016L(m\\1sI6\u000b\u0007\u000f]3s\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011AjT\u0007\u0002\u001b*\u0011ajK\u0001\u0005kRLG.\u0003\u0002Q\u001b\nQ\u0001K]8qKJ$\u0018.Z:\u00025-,\u0017PY8be\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016sGO]=\u0011\u0005MSfB\u0001+Y!\t)6%D\u0001W\u0015\t9F$\u0001\u0004=e>|GOP\u0005\u00033\u000e\na\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011l\t\u000b\u0006gy{\u0006-\u0019\u0005\u0006{5\u0001\rA\u0010\u0005\u0006\u00036\u0001\rA\u0011\u0005\u0006\u00156\u0001\ra\u0013\u0005\u0006#6\u0001\rAU\u0001\u0007G>tg-[4\u0016\u0003\u0011\u0004\"!\u001a8\u000e\u0003\u0019T!a\u001a5\u0002\u001fI\u001c\u0018P\u001c;bqR,\u0007\u0010^1sK\u0006T!!\u001b6\u0002\u0005UL'BA6m\u0003\u00111\u0017NZ3\u000b\u00035\f1a\u001c:h\u0013\tygMA\bS'ftG/\u0019=UKb$\u0018I]3b\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001Z5bY><W#A:\u0011\u0005Y\"\u0018BA;8\u0005\u001dQE)[1m_\u001e\fq\u0001Z5bY><\u0007%\u0001\u0003j]&$H#A=\u0011\u0005\tR\u0018BA>$\u0005\u0011)f.\u001b;\u0002\u0013M,G\u000fT1z_V$HCA=\u007f\u0011\u0019y8\u00031\u0001\u0002\u0002\u00051qN\u001c$jY\u0016\u00042AIA\u0002\u0013\r\t)a\t\u0002\b\u0005>|G.Z1o\u0003)\u0019\u0018M^3BGRLwN\u001c\u000b\u0004s\u0006-\u0001bBA\u0007)\u0001\u0007\u0011\u0011A\u0001\u0007g\u00064X-Q:\u0002\u0015\u0015$\u0017\u000e^8s?\u0012*\u0017\u000fF\u0002z\u0003'A\u0001\"!\u0006\u0005\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0014aB3eSR|'\u000fI\u0001\nO\u0016$X\tZ5u_J$\u0012b]A\u000f\u0003?\t\t#a\t\t\u000bu2\u0001\u0019\u0001 \t\u000b\u00053\u0001\u0019\u0001\"\t\u000b)3\u0001\u0019A&\t\u000bE3\u0001\u0019\u0001*\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=2&\u0001\u0003mC:<\u0017\u0002BA\u001a\u0003[\u0011aa\u00142kK\u000e$\b")
public class KeyboardConfigEditor
extends JPanel {
    private final JFrame frame;
    private final KeyboardMapper keyMapper;
    private final Properties configuration;
    private final String keyboardConfigurationEntry;
    private final RSyntaxTextArea config;
    private final JDialog dialog;

    public static JDialog getEditor(JFrame frame, KeyboardMapper keyMapper, Properties configuration, String keyboardConfigurationEntry) {
        return KeyboardConfigEditor$.MODULE$.getEditor(frame, keyMapper, configuration, keyboardConfigurationEntry);
    }

    private RSyntaxTextArea config() {
        return this.config;
    }

    public JDialog dialog() {
        return this.dialog;
    }

    private void init() {
        this.config().setSyntaxEditingStyle("text/unix");
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)new RTextScrollPane((RTextArea)this.config()));
        JPanel buttons = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(x$2 -> this.dialog().dispose());
        buttons.add(close);
        if (this.keyMapper.configuration().isDefined()) {
            JButton save = new JButton("Save");
            buttons.add(save);
            save.addActionListener(x$3 -> this.saveAction(false));
        }
        JButton saveAs = new JButton("Save as");
        buttons.add(saveAs);
        saveAs.addActionListener(x$4 -> this.saveAction(true));
        JButton selectFile = new JButton("Select configuration file");
        buttons.add(selectFile);
        selectFile.addActionListener(x$5 -> this.setLayout(true));
        if (this.keyMapper.configuration().isDefined()) {
            JButton restoreLocale = new JButton("Restore local detected configuration");
            buttons.add(restoreLocale);
            restoreLocale.addActionListener(x$6 -> this.setLayout(false));
        }
        JButton helper = new JButton("Keyboard layout helper");
        buttons.add(helper);
        helper.addActionListener(x$7 -> {
            helper.setEnabled(false);
            JDialog hd = KeyboardHelper$.MODULE$.getDialog($this.frame, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> helper.setEnabled(true));
            hd.setVisible(true);
        });
        this.add("South", buttons);
        this.config().setText(this.keyMapper.content());
    }

    private void setLayout(boolean onFile) {
        boolean bl = onFile;
        if (bl) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Select keyboard configuration file");
            int n = fc.showOpenDialog(this.dialog());
            switch (n) {
                case 0: {
                    this.configuration.setProperty(this.keyboardConfigurationEntry, fc.getSelectedFile().toString());
                    JOptionPane.showMessageDialog(this.dialog(), "Reboot the emulator to activate the new keyboard", "Keyboard..", 1);
                    return;
                }
            }
            return;
        }
        if (!bl) {
            int n = JOptionPane.showConfirmDialog(this.dialog(), "Are you sure you want to restore local detected layout configuration ?", "Confirm", 0);
            switch (n) {
                case 0: {
                    this.configuration.remove(this.keyboardConfigurationEntry);
                    JOptionPane.showMessageDialog(this.dialog(), "Reboot the emulator to activate the new keyboard", "Keyboard..", 1);
                    return;
                }
            }
            return;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private void saveAction(boolean saveAs) {
        block6: {
            try {
                if (!saveAs) {
                    Files.write(new File((String)this.keyMapper.configuration().get()).toPath(), (Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.config().getText().split("\n")).toList()).asJava(), Charset.defaultCharset(), StandardOpenOption.CREATE);
                    break block6;
                }
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Save as ...");
                int n = fc.showSaveDialog(this.dialog());
                switch (n) {
                    case 0: {
                        Files.write(fc.getSelectedFile().toPath(), (Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.config().getText().split("\n")).toList()).asJava(), Charset.defaultCharset(), StandardOpenOption.CREATE);
                        break;
                    }
                }
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(this.dialog(), new StringBuilder(35).append("Error while writing configuration: ").append(io).toString(), "Write error", 0);
            }
        }
    }

    public KeyboardConfigEditor(JFrame frame, KeyboardMapper keyMapper, Properties configuration, String keyboardConfigurationEntry) {
        this.frame = frame;
        this.keyMapper = keyMapper;
        this.configuration = configuration;
        this.keyboardConfigurationEntry = keyboardConfigurationEntry;
        this.config = new RSyntaxTextArea(30, 100);
        this.init();
        JDialog d = new JDialog((Frame)frame, new StringBuilder(25).append("Keyboard configuration - ").append(keyMapper.configuration().getOrElse((Function0 & Serializable)() -> new StringBuilder(15).append("default ").append($this.keyMapper.locale().getOrElse((Function0 & Serializable)() -> "")).append(" layout").toString())).toString());
        d.getContentPane().add("Center", this);
        d.pack();
        d.setIconImage(new ImageIcon(this.getClass().getResource("/resources/commodore.png")).getImage());
        d.setLocationRelativeTo(frame);
        this.dialog = d;
    }
}

