/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.misc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.Log$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001B\u0014)\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\u0007\u007f\u0001\u0001\u000bQ\u0002!\t\r\t\u0003\u0001\u0015!\u0004D\u0011\u0019)\u0005\u0001)A\u0007\r\"1\u0001\n\u0001Q\u0001\u000e%Caa\u0013\u0001!\u0002\u001ba\u0005B\u0002(\u0001A\u00035q\n\u0003\u0004R\u0001\u0001\u0006iA\u0015\u0005\u0007)\u0002\u0001\u000bQB+\t\r]\u0003\u0001\u0015!\u0004Y\u0011\u0019Y\u0006\u0001)A\u00071\"aA\f\u0001C\u0001\u0002\u000b\u0005\t\u0011)A\u00071\"1Q\f\u0001Q\u0001\u000eaCAB\u0018\u0001\u0005\u0002\u0003\u0015\t\u0011!Q\u0001\u000eaCaa\u0018\u0001!\u0002\u0013\u0001\u0007\u0002D2\u0001\t\u0003\u0005)\u0011!A!B\u0013A\u0006B\u00023\u0001A\u0003&\u0001\f\u0003\u0004f\u0001\u0001\u0006K\u0001\u0017\u0005\u0007M\u0002\u0001\u000b\u0015B\u001c\t\r\u001d\u0004\u0001\u0015)\u00038\u0011\u0019A\u0007\u0001)Q\u00051\"1\u0011\u000e\u0001Q!\naCaA\u001b\u0001!B\u00139\u0004BB6\u0001A\u0003&\u0001\f\u0003\u0004m\u0001\u0001\u0006K\u0001\u0017\u0005\u0007[\u0002\u0001\u000b\u0015B\u001c\t\u000b9\u0004A\u0011A8\t\u000bU\u0004A\u0011\u0001<\t\u000b]\u0004A\u0011\u0001=\t\u000bm\u0004A\u0011\u0001?\t\rm\u0004A\u0011AA\b\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\u0007\u0001\t\u0003\tI\u0003C\u0004\u0002.\u0001!I!a\f\t\r\u0005E\u0002\u0001\"\u0003w\u0011\u0019\tY\u0004\u0001C\u0005m\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005#AB':g\rCdG\u0003\u0002*U\u0005!Q.[:d\u0015\tYC&A\u0002dE6T\u0011!L\u0001\bk\u000e,7o\u001c4u\u0007\u0001\u0019\"\u0001\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003\rA\u0018G\u000e\t\u0003caJ!!\u000f\u001a\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\"\u0001\u0010 \u0011\u0005u\u0002Q\"\u0001\u0015\t\u000bY\u0012\u0001\u0019A\u001c\u0002\t%#E*R\b\u0002\u0003v\t\u0001!\u0001\u0007S\u000b\u0006#u,\u0011#E%\u0016\u001b6kD\u0001E;\u0005\t\u0011\u0001\u0003*F\u0003\u0012{v*\u0016+\u0010\u0003\u001dk\u0012AA\u0001\u000f/JKE+R0P%~+%+Q*F\u001f\u0005QU$A\u0002\u0002\u001b]\u0013\u0016\nV#`\u0003\u0012#%+R*T\u001f\u0005iU$\u0001\u0003\u0002\u0015]\u0013\u0016\nV#`\t\u0006#\u0016iD\u0001Q;\u0005)\u0011!C,S\u00032{F)\u0011+B\u001f\u0005\u0019V$\u0001\u0004\u0002\u001b\u0015\u0013\u0016iU#`\u0003\u0012#%+R*T\u001f\u00051V$A\u0004\u0002!\u0005#EIU#T'~\u0013\u0015\nV0T\u0013j+\u0005CA\u0019Z\u0013\tQ&GA\u0002J]R\fQ\u0002R!U\u0003~\u0013\u0015\nV0T\u0013j+\u0015!J;dKN|g\r\u001e\u0013dE6$S.[:dI5K4g\u0011\u001d7I\u0011\nE\t\u0012*F'N{V*Q*L\u00035!\u0015\tV!`\u0005&#v,T!T\u0017\u0006\u0011SoY3t_\u001a$He\u00192nI5L7o\u0019\u0013NsM\u001a\u0005H\u000e\u0013%\t\u0006#\u0016iX'B'.\u000ba!Z3qe>l\u0007cA\u0019b1&\u0011!M\r\u0002\u0006\u0003J\u0014\u0018-_\u0001#k\u000e,7o\u001c4uI\r\u0014W\u000eJ7jg\u000e$S*O\u001aDqY\"Ce]3sS\u0006d')^:\u0002\u0007=,H/\u0001\u0002j]\u0006\u00191\r\\6\u0002\u0005\r\u001c\u0018!B:uCR,\u0017A\u00032ji\u000e{WO\u001c;fe\u0006aqO]5uK\u0016s\u0017M\u00197fI\u0006!A-\u0019;b\u0003\u001d\tG\r\u001a:fgN\f\u0011BZ5sgR\u0014V-\u00193\u0002\u000b%t\u0007/\u001e;\u0015\u0005A\u001c\bCA\u0019r\u0013\t\u0011(G\u0001\u0003V]&$\b\"\u0002;\u001d\u0001\u0004A\u0016!\u00012\u0002\r=,H\u000f];u+\u0005A\u0016AC2iSB\u001cV\r\\3diR\u0011\u0001/\u001f\u0005\u0006uz\u0001\raN\u0001\u0007g\u0016dWm\u0019;\u0002\t1|\u0017\r\u001a\u000b\u0003avDQA`\u0010A\u0002}\fAAZ5mKB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AA5p\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011AAR5mKR\u0019\u0001/!\u0005\t\u000f\u0005M\u0001\u00051\u0001\u0002\u0016\u0005\u0019q,\u001b8\u0011\t\u0005\u0005\u0011qC\u0005\u0005\u00033\t\u0019AA\u0006J]B,Ho\u0015;sK\u0006l\u0017\u0001B:bm\u0016$2\u0001]A\u0010\u0011\u001d\t\t#\ta\u0001\u0003G\tAaX8viB!\u0011\u0011AA\u0013\u0013\u0011\t9#a\u0001\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0015\u0007A\fY\u0003C\u0003\u007fE\u0001\u0007q0\u0001\u0005tKJL\u0017\r\\%o)\u0005\u0001\u0018!\u00043fG>$W-\u00113ee\u0016\u001c8\u000fK\u0002%\u0003k\u00012!MA\u001c\u0013\r\tID\r\u0002\u0007S:d\u0017N\\3\u0002\u0015\u0011,7m\u001c3f\t\u0006$\u0018\rK\u0002&\u0003k\tQa\u00197pG.$2\u0001]A\"\u0011\u00151g\u00051\u00018\u0001")
public class M93C86 {
    private final int ADDRESS_BIT_SIZE;
    private final int DATA_BIT_SIZE;
    public final int ucesoft$cbm$misc$M93C86$$ADDRESS_MASK;
    private final int DATA_BIT_MASK;
    public final int ucesoft$cbm$misc$M93C86$$DATA_MASK;
    private final int[] eeprom;
    public int ucesoft$cbm$misc$M93C86$$serialBus;
    private int out;
    private int in;
    private boolean clk;
    private boolean cs;
    private int state;
    private int bitCounter;
    private boolean writeEnabled;
    private int data;
    private int address;
    private boolean firstRead;

    public void input(int b) {
        this.in = b;
    }

    public int output() {
        return this.out;
    }

    public void chipSelect(boolean select) {
        this.cs = select;
        if (!this.cs) {
            this.firstRead = true;
            this.state = 0;
            this.bitCounter = 0;
            this.out = 1;
            return;
        }
    }

    public void load(File file) {
        try {
            DataInputStream f = new DataInputStream(new FileInputStream(file));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.eeprom.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                $this.eeprom[i] = f.readInt();
            });
            f.close();
        }
        catch (IOException io) {
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Can't load eeprom file ").append(file).append(" ").append(io).toString());
        }
    }

    public void load(InputStream _in) {
        DataInputStream in = new DataInputStream(_in);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.eeprom.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            $this.eeprom[i] = in.readInt();
        });
    }

    public void save(OutputStream _out) {
        DataOutputStream out = new DataOutputStream(_out);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(this.eeprom), (Function1)(JFunction1.mcVI.sp & Serializable)v -> out.writeInt(v));
    }

    public void save(File file) {
        try {
            DataOutputStream f = new DataOutputStream(new FileOutputStream(file));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(this.eeprom), (Function1)(JFunction1.mcVI.sp & Serializable)v -> f.writeInt(v));
            f.close();
        }
        catch (IOException io) {
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Can't load eeprom file ").append(file).append(" ").append(io).toString());
        }
    }

    private void serialIn() {
        this.ucesoft$cbm$misc$M93C86$$serialBus <<= 1;
        this.ucesoft$cbm$misc$M93C86$$serialBus |= this.in;
        ++this.bitCounter;
    }

    private int decodeAddress() {
        return this.ucesoft$cbm$misc$M93C86$$serialBus & this.ucesoft$cbm$misc$M93C86$$ADDRESS_MASK;
    }

    private int decodeData() {
        return this.ucesoft$cbm$misc$M93C86$$serialBus & this.ucesoft$cbm$misc$M93C86$$DATA_MASK;
    }

    public void clock(boolean clk) {
        boolean oldClk = this.clk;
        this.clk = clk;
        if (this.cs && !oldClk && clk) {
            int n = this.state;
            switch (n) {
                case 0: {
                    this.serialIn();
                    if (this.bitCounter == 1) {
                        this.out = 1;
                        return;
                    }
                    if (this.bitCounter == 3) {
                        this.bitCounter = 0;
                        int n2 = this.ucesoft$cbm$misc$M93C86$$serialBus & 7;
                        switch (n2) {
                            case 6: {
                                this.state = 1;
                                return;
                            }
                            case 4: {
                                this.state = 3;
                                return;
                            }
                            case 5: {
                                this.state = 4;
                                return;
                            }
                            case 7: {
                                this.state = 7;
                                return;
                            }
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                    }
                    return;
                }
                case 7: {
                    this.serialIn();
                    if (this.bitCounter == this.ADDRESS_BIT_SIZE) {
                        this.state = 0;
                        this.bitCounter = 0;
                        this.address = this.decodeAddress();
                        if (this.writeEnabled) {
                            this.eeprom[this.address] = this.ucesoft$cbm$misc$M93C86$$DATA_MASK;
                            return;
                        }
                        return;
                    }
                    return;
                }
                case 6: {
                    this.serialIn();
                    if (this.bitCounter == this.DATA_BIT_SIZE - 1) {
                        this.out = 0;
                        return;
                    }
                    if (this.bitCounter == this.DATA_BIT_SIZE) {
                        this.data = this.decodeData();
                        if (this.writeEnabled) {
                            Arrays.fill(this.eeprom, this.data);
                        }
                        this.out = 1;
                        return;
                    }
                    return;
                }
                case 5: {
                    this.serialIn();
                    if (this.bitCounter == this.DATA_BIT_SIZE - 1) {
                        this.out = 0;
                        return;
                    }
                    if (this.bitCounter == this.DATA_BIT_SIZE) {
                        this.data = this.decodeData();
                        if (this.writeEnabled) {
                            this.eeprom[this.address] = this.data;
                        }
                        this.out = 1;
                        return;
                    }
                    return;
                }
                case 4: {
                    this.serialIn();
                    if (this.bitCounter == this.ADDRESS_BIT_SIZE) {
                        this.state = 5;
                        this.bitCounter = 0;
                        this.address = this.decodeAddress();
                        return;
                    }
                    return;
                }
                case 3: {
                    this.serialIn();
                    if (this.bitCounter == this.ADDRESS_BIT_SIZE) {
                        int adr;
                        int n3 = adr = this.ucesoft$cbm$misc$M93C86$$serialBus >> 8 & 3;
                        switch (n3) {
                            case 3: {
                                this.writeEnabled = true;
                                this.state = 0;
                                break;
                            }
                            case 0: {
                                this.writeEnabled = false;
                                this.state = 0;
                                break;
                            }
                            case 2: {
                                if (this.writeEnabled) {
                                    Arrays.fill(this.eeprom, this.ucesoft$cbm$misc$M93C86$$DATA_MASK);
                                }
                                this.out = 1;
                                this.state = 0;
                                break;
                            }
                            case 1: {
                                this.state = 6;
                                break;
                            }
                            default: {
                                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n3));
                            }
                        }
                        this.bitCounter = 0;
                        return;
                    }
                    return;
                }
                case 1: {
                    this.serialIn();
                    if (this.bitCounter == this.ADDRESS_BIT_SIZE) {
                        this.state = 2;
                        this.bitCounter = 0;
                        this.address = this.decodeAddress();
                        this.data = this.eeprom[this.address];
                        return;
                    }
                    return;
                }
                case 2: {
                    this.data <<= 1;
                    this.out = (this.data & this.DATA_BIT_MASK) == 0 ? 0 : 1;
                    ++this.bitCounter;
                    int bitsOut = this.DATA_BIT_SIZE;
                    if (this.bitCounter == bitsOut) {
                        this.bitCounter = 0;
                        this.firstRead = false;
                        this.address = this.address + 1 & this.ucesoft$cbm$misc$M93C86$$ADDRESS_MASK;
                        this.data = this.eeprom[this.address];
                        return;
                    }
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
    }

    public M93C86(boolean x16) {
        this.ADDRESS_BIT_SIZE = x16 ? 10 : 11;
        this.DATA_BIT_SIZE = x16 ? 16 : 8;
        this.ucesoft$cbm$misc$M93C86$$ADDRESS_MASK = x16 ? 1023 : 2047;
        this.DATA_BIT_MASK = x16 ? 65536 : 256;
        this.ucesoft$cbm$misc$M93C86$$DATA_MASK = x16 ? 65535 : 255;
        this.eeprom = (int[])Array$.MODULE$.ofDim(x16 ? 1024 : 2048, (ClassTag)ClassTag$.MODULE$.Int());
        this.ucesoft$cbm$misc$M93C86$$serialBus = 0;
        this.out = 0;
        this.in = 0;
        this.clk = false;
        this.cs = false;
        this.state = 0;
        this.bitCounter = 0;
        this.writeEnabled = false;
        this.data = 0;
        this.address = 0;
        this.firstRead = true;
    }
}

