/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.bus;

import java.io.Serializable;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.peripheral.bus.BusDataIterator;
import ucesoft.cbm.peripheral.bus.IECBus;
import ucesoft.cbm.peripheral.bus.IECBusDevice$;
import ucesoft.cbm.peripheral.bus.IECBusDevice$Command$;
import ucesoft.cbm.peripheral.bus.IECBusDevice$Mode$;
import ucesoft.cbm.peripheral.bus.IECBusDevice$ReadMode$;
import ucesoft.cbm.peripheral.bus.IECBusDevice$Role$;
import ucesoft.cbm.peripheral.bus.IECBusDevice$WriteMode$;
import ucesoft.cbm.peripheral.bus.IECBusLine$;
import ucesoft.cbm.peripheral.bus.IECBusListener;

@ScalaSignature(bytes="\u0006\u0005\u0011Mq\u0001CA\u001f\u0003\u007fA\t!!\u0015\u0007\u0011\u0005U\u0013q\bE\u0001\u0003/Bq!!\u001a\u0002\t\u0003\t9\u0007C\u0005\u0002j\u0005\u0011\r\u0011\"\u0003\u0002l!A\u00111O\u0001!\u0002\u0013\ti\u0007C\u0005\u0002v\u0005\u0011\r\u0011\"\u0003\u0002l!A\u0011qO\u0001!\u0002\u0013\ti\u0007C\u0005\u0002z\u0005\u0011\r\u0011\"\u0003\u0002l!A\u00111P\u0001!\u0002\u0013\ti\u0007C\u0005\u0002~\u0005\u0011\r\u0011\"\u0003\u0002l!A\u0011qP\u0001!\u0002\u0013\ti\u0007C\u0005\u0002\u0002\u0006\u0011\r\u0011\"\u0003\u0002\u0004\"A\u00111R\u0001!\u0002\u0013\t)iB\u0004\u0002\u000e\u0006A\t!a$\u0007\u000f\u0005M\u0015\u0001#\u0001\u0002\u0016\"9\u0011Q\r\b\u0005\u0002\u0005u\u0005\"CAP\u001d\t\u0007I\u0011AAQ\u0011!\tYK\u0004Q\u0001\n\u0005\r\u0006\"CAW\u001d\t\u0007I\u0011AAQ\u0011!\tyK\u0004Q\u0001\n\u0005\r\u0006\"CAY\u001d\t\u0007I\u0011AAQ\u0011!\t\u0019L\u0004Q\u0001\n\u0005\r\u0006\"CA[\u001d\t\u0007I\u0011AAQ\u0011!\t9L\u0004Q\u0001\n\u0005\r\u0006\"CA]\u001d\t\u0007I\u0011AAQ\u0011!\tYL\u0004Q\u0001\n\u0005\r\u0006\"CA_\u001d\t\u0007I\u0011AAQ\u0011!\tyL\u0004Q\u0001\n\u0005\r\u0006\"CAa\u001d\u0005\u0005I\u0011BAb\u000f\u001d\t).\u0001E\u0005\u0003/4q!!7\u0002\u0011\u0013\tY\u000eC\u0004\u0002fy!\t!!8\t\u0013\u0005}gD1A\u0005\u0002\u0005\u0005\b\u0002CAt=\u0001\u0006I!a9\t\u0013\u0005%hD1A\u0005\u0002\u0005\u0005\b\u0002CAv=\u0001\u0006I!a9\t\u0013\u00055hD1A\u0005\u0002\u0005\u0005\b\u0002CAx=\u0001\u0006I!a9\t\u0013\u0005EhD1A\u0005\u0002\u0005\u0005\b\u0002CAz=\u0001\u0006I!a9\t\u0013\u0005UhD1A\u0005\u0002\u0005\u0005\b\u0002CA|=\u0001\u0006I!a9\t\u0013\u0005ehD1A\u0005\u0002\u0005\u0005\b\u0002CA~=\u0001\u0006I!a9\t\u0013\u0005\u0005g$!A\u0005\n\u0005\rwaBA\u007f\u0003!%\u0011q \u0004\b\u0005\u0003\t\u0001\u0012\u0002B\u0002\u0011\u001d\t)G\fC\u0001\u0005\u000bA\u0011Ba\u0002/\u0005\u0004%\tA!\u0003\t\u0011\t=a\u0006)A\u0005\u0005\u0017A\u0011B!\u0005/\u0005\u0004%\tA!\u0003\t\u0011\tMa\u0006)A\u0005\u0005\u0017A\u0011\"!1/\u0003\u0003%I!a1\b\u000f\tU\u0011\u0001#\u0001\u0003\u0018\u00199!\u0011D\u0001\t\u0002\tm\u0001bBA3m\u0011\u0005!Q\u0004\u0005\n\u0005?1$\u0019!C\u0001\u0005CA\u0001Ba\n7A\u0003%!1\u0005\u0005\n\u0005S1$\u0019!C\u0001\u0005CA\u0001Ba\u000b7A\u0003%!1\u0005\u0005\n\u0005[1$\u0019!C\u0001\u0005CA\u0001Ba\f7A\u0003%!1\u0005\u0005\n\u0005c1$\u0019!C\u0001\u0005CA\u0001Ba\r7A\u0003%!1\u0005\u0005\n\u0003\u00034\u0014\u0011!C\u0005\u0003\u0007<qA!\u000e\u0002\u0011\u0003\u00119DB\u0004\u0003:\u0005A\tAa\u000f\t\u000f\u0005\u0015$\t\"\u0001\u0003>!I!q\b\"C\u0002\u0013\u0005!\u0011\t\u0005\t\u0005\u000f\u0012\u0005\u0015!\u0003\u0003D!I!\u0011\n\"C\u0002\u0013\u0005!\u0011\t\u0005\t\u0005\u0017\u0012\u0005\u0015!\u0003\u0003D!I!Q\n\"C\u0002\u0013\u0005!\u0011\t\u0005\t\u0005\u001f\u0012\u0005\u0015!\u0003\u0003D!I!\u0011\u000b\"C\u0002\u0013\u0005!\u0011\t\u0005\t\u0005'\u0012\u0005\u0015!\u0003\u0003D!I!Q\u000b\"C\u0002\u0013\u0005!\u0011\t\u0005\t\u0005/\u0012\u0005\u0015!\u0003\u0003D!I!\u0011\f\"C\u0002\u0013\u0005!\u0011\t\u0005\t\u00057\u0012\u0005\u0015!\u0003\u0003D!I!Q\f\"C\u0002\u0013\u0005!\u0011\t\u0005\t\u0005?\u0012\u0005\u0015!\u0003\u0003D!I\u0011\u0011\u0019\"\u0002\u0002\u0013%\u00111\u0019\u0004\u0007\u0005C\n\u0001Ba\u0019\t\u000f\u0005\u00154\u000b\"\u0001\u0003f!I!\u0011N*A\u0002\u0013\u0005!1\u000e\u0005\n\u0005s\u001a\u0006\u0019!C\u0001\u0005wB\u0001Ba\"TA\u0003&!Q\u000e\u0005\n\u0005\u0013\u001b\u0006\u0019!C\u0001\u0003\u0007C\u0011Ba#T\u0001\u0004%\tA!$\t\u0011\tE5\u000b)Q\u0005\u0003\u000bC\u0011Ba%T\u0005\u0004%IA!&\t\u0011\t\u001d6\u000b)A\u0005\u0005/C\u0011B!+T\u0005\u0004%\tAa+\t\u0011\tM6\u000b)A\u0005\u0005[C\u0011B!.T\u0001\u0004%I!a!\t\u0013\t]6\u000b1A\u0005\n\te\u0006\u0002\u0003B_'\u0002\u0006K!!\"\t\u000f\t}6\u000b\"\u0001\u0003B\"9!1Y*\u0005\u0002\u0005\r\u0005b\u0002Bc'\u0012\u0005!\u0011\u0019\u0005\b\u0005\u000f\u001cF\u0011\u0001Ba\u0011\u001d\u0011Im\u0015C\u0001\u0005\u0017DqA!5T\t\u0003\u0011)\nC\u0004\u0003TN#\tA!6\t\u0013\t5\u0018!%A\u0005\u0002\t=h\u0001CA+\u0003\u007f\t\ta!\u0002\t\u0015\u0005\u0005#N!A!\u0002\u0013\u0019i\u0001\u0003\u0006\u0004\u0014)\u0014\t\u0011)A\u0005\u0003[Bq!!\u001ak\t\u0003\u0019)\u0002C\u0005\u0004\u001e)\u0014\r\u0011\"\u0005\u0004 !A11\u00066!\u0002\u0013\u0019\t\u0003\u0003\u0005\u0004.)\u0004\u000b\u0015BB\u0018\u0011!\u0019\u0019D\u001bQ!\n\u0005\u0015\u0005\u0002CB\u001bU\u0002\u0006K!!\u001c\t\u0011\r]\"\u000e)Q\u0005\u0003[B\u0001b!\u000fkA\u0003&\u0011Q\u0011\u0005\t\u0007wQ\u0007\u0015)\u0003\u0002\u0006\"A1Q\b6!B\u0013\u0019y\u0004\u0003\u0005\u0004D)\u0004\u000b\u0015BB#\u0011!\u0019YE\u001bQ!\n\u0005\u0015\u0005\"CB'U\u0002\u0007K\u0011CB(\u0011%\u0019)F\u001ba!\n#\u00199\u0006\u0003\u0005\u0004\\)\u0004\u000b\u0015BB)\u0011%\u0019iF\u001ba!\n#\tY\u0007C\u0005\u0004`)\u0004\r\u0015\"\u0005\u0004b!A1Q\r6!B\u0013\ti\u0007\u0003\u0005\u0004h)\u0004\u000b\u0015BB5\u0011!\u0019iG\u001bQ!\n\u00055\u0004\u0002CB8U\u0002\u0006K!!\u001c\t\u0011\rE$\u000e)Q\u0005\u0003\u000bC\u0001ba\u001dkA\u0003&1Q\t\u0005\t\u0007kR\u0007\u0015)\u0003\u0002\u0006\"91q\u000f6\u0005\u0012\re\u0004bBB@U\u0012E1\u0011\u0011\u0005\b\u0007\u000fSg\u0011CAB\u0011\u001d\u0019II\u001bD\t\u0007\u0017Cqaa$k\t#\u0019\t\nC\u0004\u0004\u001c*$\tb!(\t\u000f\r\u0005&\u000e\"\u0005\u0003B\"911\u00156\u0005\u0012\t\u0005\u0007bBBSU\u0012E!\u0011\u0019\u0005\b\u0007OSG\u0011\u0003Ba\u0011\u001d\u0011)M\u001bC\t\u0005\u0003Dqa!+k\t#\u0011\t\rC\u0004\u0004,*$\tB!1\t\u000f\r5&\u000e\"\u0005\u0003B\"9!q\u00196\u0005\u0012\t\u0005\u0007bBBXU\u0012E1\u0011\u0017\u0005\b\u0007\u007fSGQABa\u0011\u001d\u0019)M\u001bC\u0005\u0007\u000fDqa!8k\t#\u0011\t\rC\u0004\u0004`*$Ia!9\t\u000f\r%(\u000e\"\u0003\u0004l\"91\u0011 6\u0005\n\rm\bb\u0002C\u0001U\u0012%A1\u0001\u0005\b\t\u000fQG\u0011\u0002C\u0005\u0011\u001d!iA\u001bC\t\t\u001f\tA\"S#D\u0005V\u001cH)\u001a<jG\u0016TA!!\u0011\u0002D\u0005\u0019!-^:\u000b\t\u0005\u0015\u0013qI\u0001\u000ba\u0016\u0014\u0018\u000e\u001d5fe\u0006d'\u0002BA%\u0003\u0017\n1a\u00192n\u0015\t\ti%A\u0004vG\u0016\u001cxN\u001a;\u0004\u0001A\u0019\u00111K\u0001\u000e\u0005\u0005}\"\u0001D%F\u0007\n+8\u000fR3wS\u000e,7cA\u0001\u0002ZA!\u00111LA1\u001b\t\tiF\u0003\u0002\u0002`\u0005)1oY1mC&!\u00111MA/\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\"!!\u0015\u0002!]\u000b\u0015\nV0C\u0013R{F+S'F\u001fV#VCAA7!\u0011\tY&a\u001c\n\t\u0005E\u0014Q\f\u0002\u0004\u0013:$\u0018!E,B\u0013R{&)\u0013+`)&kUiT+UA\u0005YQiT%`)&kUiT+U\u00031)u*S0U\u00136+u*\u0016+!\u0003I9\u0016)\u0013+`\u0005\u0016#v+R#O?\nKF+R*\u0002']\u000b\u0015\nV0C\u000bR;V)\u0012(`\u0005f#Vi\u0015\u0011\u0002-]\u0013\u0016\nV#`\u0017\u0016+\u0005k\u0018\"J)~#\u0016*T#P+R\u000bqc\u0016*J)\u0016{6*R#Q?\nKEk\u0018+J\u001b\u0016{U\u000b\u0016\u0011\u0002\u000b\u0011+%)V$\u0016\u0005\u0005\u0015\u0005\u0003BA.\u0003\u000fKA!!#\u0002^\t9!i\\8mK\u0006t\u0017A\u0002#F\u0005V;\u0005%\u0001\u0003N_\u0012,\u0007cAAI\u001d5\t\u0011A\u0001\u0003N_\u0012,7c\u0001\b\u0002\u0018B!\u00111LAM\u0013\u0011\tY*!\u0018\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u000b\u0003\u0003\u001f\u000bA!\u0013#M\u000bV\u0011\u00111\u0015\t\u0005\u0003K\u000b9KD\u0002\u0002\u00126IA!!+\u0002\u001a\n)a+\u00197vK\u0006)\u0011\n\u0012'FA\u0005A\u0011\t\u0016(`'\u0016+e*A\u0005B):{6+R#OA\u0005!!+R!E\u0003\u0015\u0011V)\u0011#!\u0003\u00159&+\u0013+F\u0003\u00199&+\u0013+FA\u0005QA+\u0016*O\u0003J{UK\u0014#\u0002\u0017Q+&KT!S\u001fVsE\tI\u0001\u000b\u0013:KEkX,S\u0013R+\u0015aC%O\u0013R{vKU%U\u000b\u0002\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!2\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006!A.\u00198h\u0015\t\ty-\u0001\u0003kCZ\f\u0017\u0002BAj\u0003\u0013\u0014aa\u00142kK\u000e$\u0018!C,sSR,Wj\u001c3f!\r\t\tJ\b\u0002\n/JLG/Z'pI\u0016\u001c2AHAL)\t\t9.A\nX\u0003&#v\fT%T)\u0016sUIU0S\u000b\u0006#\u0015,\u0006\u0002\u0002dB!\u0011Q]AT\u001d\r\t\t*H\u0001\u0015/\u0006KEk\u0018'J'R+e*\u0012*`%\u0016\u000bE)\u0017\u0011\u00027]\u000b\u0015\nV0M\u0013N#VIT#S?\u0016{\u0015j\u0018%B\u001d\u0012\u001b\u0006*Q&F\u0003q9\u0016)\u0013+`\u0019&\u001bF+\u0012(F%~+u*S0I\u0003:#5\u000bS!L\u000b\u0002\nab\u0016*J)\u0016{&)\u0013+`\u00072[\u0015'A\bX%&#Vi\u0018\"J)~\u001bEjS\u0019!\u000399&+\u0013+F?\nKEkX\"M\u0017J\nqb\u0016*J)\u0016{&)\u0013+`\u00072[%\u0007I\u0001\u000f/JKE+R0M\u0003N#vLQ%U\u0003=9&+\u0013+F?2\u000b5\u000bV0C\u0013R\u0003\u0013!C,S\u0013R+u,\u0012(E\u0003)9&+\u0013+F?\u0016sE\tI\u0001\t%\u0016\fG-T8eKB\u0019\u0011\u0011\u0013\u0018\u0003\u0011I+\u0017\rZ'pI\u0016\u001c2ALAL)\t\ty0\u0001\u0005X\u0003&#vLQ%U+\t\u0011Y\u0001\u0005\u0003\u0003\u000e\u0005\u001dfbAAI[\u0005Iq+Q%U?\nKE\u000bI\u0001\t%\u0016\u000bEi\u0018\"J)\u0006I!+R!E?\nKE\u000bI\u0001\u0005%>dW\rE\u0002\u0002\u0012Z\u0012AAU8mKN\u0019a'a&\u0015\u0005\t]\u0011\u0001\u0002(P\u001d\u0016+\"Aa\t\u0011\t\t\u0015\u0012q\u0015\b\u0004\u0003#+\u0014!\u0002(P\u001d\u0016\u0003\u0013A\u0005*F\u0003\u0012Kv\fV(`\u0005\u0016{F+\u0011'L\u000bJ\u000b1CU#B\tf{FkT0C\u000b~#\u0016\tT&F%\u0002\na\u0001V!M\u0017\u0016\u0013\u0016a\u0002+B\u0019.+%\u000bI\u0001\t\u0019&\u001bF+\u0012(F%\u0006IA*S*U\u000b:+%\u000bI\u0001\b\u0007>lW.\u00198e!\r\t\tJ\u0011\u0002\b\u0007>lW.\u00198e'\r\u0011\u0015q\u0013\u000b\u0003\u0005o\tA\u0001V!M\u0017V\u0011!1\t\t\u0005\u0005\u000b\n9KD\u0002\u0002\u0012\u0006\u000bQ\u0001V!M\u0017\u0002\na\u0001T%T)\u0016s\u0015a\u0002'J'R+e\nI\u0001\u0007+:#\u0016\tT&\u0002\u000fUsE+\u0011'LA\u0005AQK\u0014'J'R+e*A\u0005V\u001d2K5\u000bV#OA\u0005aq\nU#O?\u000eC\u0015I\u0014(F\u0019\u0006iq\nU#O?\u000eC\u0015I\u0014(F\u0019\u0002\nQa\u0011'P'\u0016\u000baa\u0011'P'\u0016\u0003\u0013\u0001B(Q\u000b:\u000bQa\u0014)F\u001d\u0002\u0012qa\u00115b]:,GnE\u0002T\u00033\"\"Aa\u001a\u0011\u0007\u0005E5+\u0001\u0006eCR\fGk\\*f]\u0012,\"A!\u001c\u0011\r\u0005m#q\u000eB:\u0013\u0011\u0011\t(!\u0018\u0003\r=\u0003H/[8o!\u0011\t\u0019F!\u001e\n\t\t]\u0014q\b\u0002\u0010\u0005V\u001cH)\u0019;b\u0013R,'/\u0019;pe\u0006qA-\u0019;b)>\u001cVM\u001c3`I\u0015\fH\u0003\u0002B?\u0005\u0007\u0003B!a\u0017\u0003\u0000%!!\u0011QA/\u0005\u0011)f.\u001b;\t\u0013\t\u0015e+!AA\u0002\t5\u0014a\u0001=%c\u0005YA-\u0019;b)>\u001cVM\u001c3!\u00035\u0011X-\u00193ESJ,7\r^5p]\u0006\t\"/Z1e\t&\u0014Xm\u0019;j_:|F%Z9\u0015\t\tu$q\u0012\u0005\n\u0005\u000bK\u0016\u0011!a\u0001\u0003\u000b\u000baB]3bI\u0012K'/Z2uS>t\u0007%A\u0004`EV4g-\u001a:\u0016\u0005\t]\u0005C\u0002BM\u0005G\u000bi'\u0004\u0002\u0003\u001c*!!Q\u0014BP\u0003\u001diW\u000f^1cY\u0016TAA!)\u0002^\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0015&1\u0014\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\u0018\u0001C0ck\u001a4WM\u001d\u0011\u0002\u0011\u0019LG.\u001a(b[\u0016,\"A!,\u0011\t\te%qV\u0005\u0005\u0005c\u0013YJA\u0007TiJLgn\u001a\"vS2$WM]\u0001\nM&dWMT1nK\u0002\naa\u001c9f]\u0016$\u0017AC8qK:,Gm\u0018\u0013fcR!!Q\u0010B^\u0011%\u0011)\tYA\u0001\u0002\u0004\t))A\u0004pa\u0016tW\r\u001a\u0011\u0002\u000b\rdW-\u0019:\u0015\u0005\tu\u0014\u0001C5t\u001fB,g.\u001a3\u0002\t=\u0004XM\\\u0001\u0006G2|7/Z\u0001\fC\u0012$Gk\u001c\"vM\u001a,'\u000f\u0006\u0003\u0003~\t5\u0007b\u0002BhM\u0002\u0007\u0011QN\u0001\u0006m\u0006dW/Z\u0001\u0007EV4g-\u001a:\u0002\u001d\t,hMZ3s)>\u001cFO]5oOV\u0011!q\u001b\t\u0005\u00053\u00149O\u0004\u0003\u0003\\\n\r\b\u0003\u0002Bo\u0003;j!Aa8\u000b\t\t\u0005\u0018qJ\u0001\u0007yI|w\u000e\u001e \n\t\t\u0015\u0018QL\u0001\u0007!J,G-\u001a4\n\t\t%(1\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\t\t\u0015\u0018QL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tE(\u0006BA7\u0005g\\#A!>\u0011\t\t]8\u0011A\u0007\u0003\u0005sTAAa?\u0003~\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005\u007f\fi&\u0001\u0006b]:|G/\u0019;j_:LAaa\u0001\u0003z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0014\u000b)\fIfa\u0002\u0011\t\u0005M3\u0011B\u0005\u0005\u0007\u0017\tyD\u0001\bJ\u000b\u000e\u0013Uo\u001d'jgR,g.\u001a:\u0011\t\u0005M3qB\u0005\u0005\u0007#\tyD\u0001\u0004J\u000b\u000e\u0013Uo]\u0001\u0007I\u00164\u0018nY3\u0015\r\r]1\u0011DB\u000e!\r\t\u0019F\u001b\u0005\b\u0003\u0003j\u0007\u0019AB\u0007\u0011%\u0019\u0019\"\u001cI\u0001\u0002\u0004\ti'\u0001\u0005dQ\u0006tg.\u001a7t+\t\u0019\t\u0003\u0005\u0004\u0002\\\r\r2qE\u0005\u0005\u0007K\tiFA\u0003BeJ\f\u0017\u0010E\u0002\u0004*Ms1!a\u0015\u0001\u0003%\u0019\u0007.\u00198oK2\u001c\b%\u0001\u0003n_\u0012,\u0007\u0003BB\u0019\u0003Os1a!\u000b\u000e\u0003\u001da\u0017m\u001d;Bi:\f\u0001BY=uKJ+\u0017\rZ\u0001\u000eEf$XMU3bI\u000e{WO\u001c;\u0002!\tLH/\u001a*fC\u0012d\u0015m\u001d;DQ\u0006\u0014\u0018a\u0002:fC\u0012,u*S\u0001\te\u0016\fG-T8eKB!1\u0011IAT\u001d\r\u0019I#L\u0001\fo\u0006LG\u000fV5nK>,H\u000f\u0005\u0003\u0002\\\r\u001d\u0013\u0002BB%\u0003;\u0012A\u0001T8oO\u0006\t\u0012n\u001d*fC\u0012Lgn\u001a$jY\u0016t\u0015-\\3\u0002\tI|G.Z\u000b\u0003\u0007#\u0002Baa\u0015\u0002(:\u00191\u0011F\u001b\u0002\u0011I|G.Z0%KF$BA! \u0004Z!I!Q\u0011>\u0002\u0002\u0003\u00071\u0011K\u0001\u0006e>dW\rI\u0001\bG\"\fgN\\3m\u0003-\u0019\u0007.\u00198oK2|F%Z9\u0015\t\tu41\r\u0005\n\u0005\u000bk\u0018\u0011!a\u0001\u0003[\n\u0001b\u00195b]:,G\u000eI\u0001\noJLG/Z'pI\u0016\u0004Baa\u001b\u0002(:\u00191\u0011F\u000f\u0002\u0015\tLH/\u001a+p'\u0016tG-\u0001\neCR\fGk\\*f]\u0012\u0014\u0015\u000e^%oI\u0016D\u0018\u0001C<sSR,WiT%\u0002\u001f]\u0014\u0018\u000e^3Ds\u000edWm],bSR\fA\"\u001b8ji:+\u0007\u0010\u001e\"zi\u0016\fqa]3u\u001b>$W\r\u0006\u0003\u0003~\rm\u0004\u0002CB?\u0003\u0017\u0001\raa\f\u0002\u000f9,w/T8eK\u000691\r\\8dW\u0016$G\u0003\u0002B?\u0007\u0007C\u0001b!\"\u0002\u000e\u0001\u00071QI\u0001\u0007Gf\u001cG.Z:\u0002\u001b%\u001cH)\u001a<jG\u0016\u0014V-\u00193z\u0003!aw.\u00193ECR\fG\u0003\u0002B7\u0007\u001bC\u0001B!+\u0002\u0012\u0001\u0007!q[\u0001\rEf$XMS;tiJ+\u0017\r\u001a\u000b\u0007\u0005{\u001a\u0019ja&\t\u0011\rU\u00151\u0003a\u0001\u0003[\nAAY=uK\"A1\u0011TA\n\u0001\u0004\t))\u0001\u0004jg2\u000b7\u000f^\u0001\u0010Ef$XMS;ti^\u0013\u0018\u000e\u001e;f]R!!QPBP\u0011!\u0019I*!\u0006A\u0002\u0005\u0015\u0015\u0001\u00054jY\u0016t\u0015-\\3SK\u000e,\u0017N^3e\u00031!\u0017\r^1O_R4u.\u001e8e\u0003\u0019a\u0017n\u001d;f]\u0006AQO\u001c7jgR,g.\u0001\u0007pa\u0016twl\u00195b]:,G.\u0001\u0003uC2\\\u0017AB;oi\u0006d7.A\u0005p]\u000e{W.\\1oIR1!QPBZ\u0007wC\u0001b!.\u0002*\u0001\u00071qW\u0001\u0004G6$\u0007\u0003BB]\u0003Os1a!\u000bB\u0011!\u0019i,!\u000bA\u0002\u00055\u0014\u0001E:fG>tG-\u0019:z\u0003\u0012$'/Z:t\u0003\u0015\u0019Gn\\2l)\u0011\u0011iha1\t\u0011\r\u0015\u00151\u0006a\u0001\u0007\u000b\n1a]3u)\u0019\u0011ih!3\u0004\\\"A11ZA\u0017\u0001\u0004\u0019i-\u0001\u0003mS:,\u0007\u0003BBh\u0007+tA!a\u0015\u0004R&!11[A \u0003)IUi\u0011\"vg2Kg.Z\u0005\u0005\u0007/\u001cIN\u0001\u0003MS:,'\u0002BBj\u0003\u007fA\u0001Ba4\u0002.\u0001\u0007\u0011QN\u0001\re\u0016\u001cX\r^*jO:\fGn]\u0001\u0011I\u0016\u001cw\u000eZ3B):\u001bu.\\7b]\u0012$bA! \u0004d\u000e\u0015\b\u0002CBC\u0003c\u0001\ra!\u0012\t\u0011\r\u001d\u0018\u0011\u0007a\u0001\u0003[\nA\u0001Z1uC\u0006A!/Z1e\u0005f$X\r\u0006\u0005\u0004n\u000e=8\u0011_B{!\u0019\tYFa\u001c\u0002n!A1QQA\u001a\u0001\u0004\u0019)\u0005\u0003\u0005\u0004t\u0006M\u0002\u0019AAC\u0003\u001d\u0011Xm\u001d;beRD\u0001ba>\u00024\u0001\u0007\u0011QQ\u0001\bi&lWm\\;u\u0003%9(/\u001b;f\u0005f$X\r\u0006\u0004\u0002\u0006\u000eu8q \u0005\t\u0007\u000b\u000b)\u00041\u0001\u0004F!A1q_A\u001b\u0001\u0004\t))\u0001\u0005m_\u0006$')\u001f;f)\u0011\u0011i\b\"\u0002\t\u0011\r\u0015\u0015q\u0007a\u0001\u0007\u000b\nq\"\u001b8ji\nKH/\u001a+p/JLG/\u001a\u000b\u0005\u0005{\"Y\u0001\u0003\u0005\u0004\u0006\u0006e\u0002\u0019AB#\u0003\u0011aw.\u00193\u0015\t\tuD\u0011\u0003\u0005\t\u0005S\u000bY\u00041\u0001\u0003X\u0002")
public abstract class IECBusDevice
implements IECBusListener {
    private final IECBus bus;
    private final int device;
    private final Channel[] channels;
    private Enumeration.Value mode;
    private boolean lastAtn;
    private int byteRead;
    private int byteReadCount;
    private boolean byteReadLastChar;
    private boolean readEOI;
    private Enumeration.Value readMode;
    private long waitTimeout;
    private boolean isReadingFileName;
    private Enumeration.Value role;
    private int channel;
    private Enumeration.Value writeMode;
    private int byteToSend;
    private int dataToSendBitIndex;
    private boolean writeEOI;
    private long writeCyclesWait;
    private boolean initNextByte;
    private boolean isController;
    private int bitmap;

    public static int $lessinit$greater$default$2() {
        return IECBusDevice$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void atnChanged(int oldValue, int newValue) {
        IECBusListener.atnChanged$(this, oldValue, newValue);
    }

    @Override
    public void srqTriggered() {
        IECBusListener.srqTriggered$(this);
    }

    @Override
    public boolean isController() {
        return this.isController;
    }

    @Override
    public int bitmap() {
        return this.bitmap;
    }

    @Override
    public void bitmap_$eq(int x$1) {
        this.bitmap = x$1;
    }

    @Override
    public void ucesoft$cbm$peripheral$bus$IECBusListener$_setter_$isController_$eq(boolean x$1) {
        this.isController = x$1;
    }

    public Channel[] channels() {
        return this.channels;
    }

    public Enumeration.Value role() {
        return this.role;
    }

    public void role_$eq(Enumeration.Value x$1) {
        this.role = x$1;
    }

    public int channel() {
        return this.channel;
    }

    public void channel_$eq(int x$1) {
        this.channel = x$1;
    }

    public void setMode(Enumeration.Value newMode) {
        if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
            Predef$.MODULE$.println((Object)new StringBuilder(9).append(this.busid()).append(" - ").append(newMode).append(" FROM ").append(this.mode).toString());
        }
        this.mode = newMode;
    }

    public void clocked(long cycles) {
    }

    public abstract boolean isDeviceReady();

    public abstract Option<BusDataIterator> loadData(String var1);

    public void byteJustRead(int n, boolean isLast) {
    }

    public void byteJustWritten(boolean isLast) {
    }

    public void fileNameReceived() {
    }

    public void dataNotFound() {
    }

    public void listen() {
    }

    public void unlisten() {
    }

    public void open() {
    }

    public void open_channel() {
    }

    public void talk() {
    }

    public void untalk() {
    }

    public void close() {
    }

    public void onCommand(Enumeration.Value cmd, int secondaryAddress) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void clock(long cycles) {
        boolean atn = this.bus.atn() == 1;
        boolean clk = this.bus.clk() == 1;
        boolean data = this.bus.data() == 1;
        boolean timeout = this.waitTimeout > 0L && this.waitTimeout < cycles;
        this.clocked(cycles);
        Enumeration.Value value = this.mode;
        Enumeration.Value value2 = IECBusDevice$Mode$.MODULE$.TURNAROUND();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (!clk) {
                this.set(IECBusLine$.MODULE$.DATA(), 0);
                this.set(IECBusLine$.MODULE$.CLK(), 1);
                this.setMode(IECBusDevice$Mode$.MODULE$.WRITE());
            }
        } else {
            Enumeration.Value value4 = IECBusDevice$Mode$.MODULE$.INIT_WRITE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                this.setMode(IECBusDevice$Mode$.MODULE$.WRITE());
                this.initByteToWrite(cycles);
            } else {
                Enumeration.Value value6 = IECBusDevice$Mode$.MODULE$.IDLE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    if (atn && clk && this.isDeviceReady()) {
                        this.set(IECBusLine$.MODULE$.CLK(), 0);
                        this.set(IECBusLine$.MODULE$.DATA(), 1);
                        this.setMode(IECBusDevice$Mode$.MODULE$.ATN_SEEN());
                    } else if (!atn) {
                        Enumeration.Value value8 = this.role();
                        Enumeration.Value value9 = IECBusDevice$Role$.MODULE$.LISTENER();
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null) && !clk) {
                            this.setMode(IECBusDevice$Mode$.MODULE$.READ());
                            this.readByte(cycles, true, false);
                        }
                    }
                } else {
                    Enumeration.Value value10 = IECBusDevice$Mode$.MODULE$.ATN_SEEN();
                    Enumeration.Value value11 = value;
                    if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                        if (atn && !clk) {
                            this.set(IECBusLine$.MODULE$.DATA(), 0);
                            this.setMode(IECBusDevice$Mode$.MODULE$.READ());
                            this.readByte(cycles, true, timeout);
                        } else if (!atn) {
                            Enumeration.Value value12 = this.role();
                            Enumeration.Value value13 = IECBusDevice$Role$.MODULE$.LISTENER();
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                this.setMode(IECBusDevice$Mode$.MODULE$.IDLE());
                            } else {
                                this.resetSignals();
                            }
                        }
                    } else {
                        Enumeration.Value value14 = IECBusDevice$Mode$.MODULE$.READ();
                        Enumeration.Value value15 = value;
                        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                            if (atn && !this.lastAtn) {
                                this.setMode(IECBusDevice$Mode$.MODULE$.IDLE());
                            } else {
                                Option<Object> option = this.readByte(cycles, false, timeout);
                                if (None$.MODULE$.equals(option)) {
                                } else {
                                    if (!(option instanceof Some)) throw new MatchError(option);
                                    Some some = (Some)option;
                                    int r = BoxesRunTime.unboxToInt((Object)some.value());
                                    this.setMode(IECBusDevice$Mode$.MODULE$.IDLE());
                                    if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                                        Predef$.MODULE$.println((Object)new StringBuilder(9).append("RECEIVED ").append(Integer.toHexString(r)).toString());
                                    }
                                    if (atn) {
                                        this.decodeATNCommand(cycles, r);
                                    } else if (this.isReadingFileName) {
                                        this.channels()[this.channel()].fileName().append((char)r);
                                        if (this.byteReadLastChar) {
                                            if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                                                Predef$.MODULE$.println((Object)new StringBuilder(13).append("File name is ").append((CharSequence)this.channels()[this.channel()].fileName()).toString());
                                            }
                                            this.fileNameReceived();
                                        }
                                    } else {
                                        Enumeration.Value value16 = this.role();
                                        Enumeration.Value value17 = IECBusDevice$Role$.MODULE$.LISTENER();
                                        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                            this.channels()[this.channel()].addToBuffer(r);
                                            this.byteJustRead(r, this.byteReadLastChar);
                                        }
                                    }
                                }
                            }
                        } else {
                            Enumeration.Value value18 = IECBusDevice$Mode$.MODULE$.WRITE();
                            Enumeration.Value value19 = value;
                            if (value18 != null ? !value18.equals(value19) : value19 != null) throw new MatchError((Object)value);
                            if (atn && !this.lastAtn) {
                                this.setMode(IECBusDevice$Mode$.MODULE$.IDLE());
                                this.initNextByte = true;
                            } else {
                                if (this.initNextByte) {
                                    this.initByteToWrite(cycles);
                                }
                                if (this.writeByte(cycles, timeout)) {
                                    this.resetSignals();
                                }
                            }
                        }
                    }
                }
            }
        }
        this.lastAtn = atn;
    }

    private void set(Enumeration.Value line, int value) {
        this.bus.setLine(this, line, value);
    }

    public void resetSignals() {
        if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
            Predef$.MODULE$.println((Object)"resetting...");
        }
        this.initNextByte = true;
        this.setMode(IECBusDevice$Mode$.MODULE$.IDLE());
        this.role_$eq(IECBusDevice$Role$.MODULE$.NONE());
        this.readMode = IECBusDevice$ReadMode$.MODULE$.WAIT_BIT();
        this.set(IECBusLine$.MODULE$.CLK(), 0);
        this.set(IECBusLine$.MODULE$.DATA(), 0);
    }

    private void decodeATNCommand(long cycles, int data) {
        Tuple2.mcII.sp sp2;
        if (data < IECBusDevice$Command$.MODULE$.LISTEN().id() + 31) {
            sp2 = new Tuple2.mcII.sp(IECBusDevice$Command$.MODULE$.LISTEN().id(), data - IECBusDevice$Command$.MODULE$.LISTEN().id());
        } else if (data == IECBusDevice$Command$.MODULE$.UNLISTEN().id()) {
            sp2 = new Tuple2.mcII.sp(data, 0);
        } else if (data < IECBusDevice$Command$.MODULE$.TALK().id() + 31) {
            sp2 = new Tuple2.mcII.sp(IECBusDevice$Command$.MODULE$.TALK().id(), data - IECBusDevice$Command$.MODULE$.TALK().id());
        } else if (data == IECBusDevice$Command$.MODULE$.UNTALK().id()) {
            sp2 = new Tuple2.mcII.sp(data, 0);
        } else if (data < IECBusDevice$Command$.MODULE$.OPEN_CHANNEL().id() + 16) {
            sp2 = new Tuple2.mcII.sp(IECBusDevice$Command$.MODULE$.OPEN_CHANNEL().id(), data - IECBusDevice$Command$.MODULE$.OPEN_CHANNEL().id());
        } else if (data < IECBusDevice$Command$.MODULE$.CLOSE().id() + 16) {
            sp2 = new Tuple2.mcII.sp(IECBusDevice$Command$.MODULE$.CLOSE().id(), data - IECBusDevice$Command$.MODULE$.CLOSE().id());
        } else if (data < IECBusDevice$Command$.MODULE$.OPEN().id() + 16) {
            sp2 = new Tuple2.mcII.sp(IECBusDevice$Command$.MODULE$.OPEN().id(), data - IECBusDevice$Command$.MODULE$.OPEN().id());
        } else {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown ATN command: ").append(data).toString());
        }
        Tuple2.mcII.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int cmd = sp3._1$mcI$sp();
        int devOrSecAddr = sp3._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(cmd, devOrSecAddr);
        int cmd2 = sp4._1$mcI$sp();
        int devOrSecAddr2 = sp4._2$mcI$sp();
        Enumeration.Value CMD = IECBusDevice$Command$.MODULE$.apply(cmd2);
        if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("Dev/SecA=").append(devOrSecAddr2).append(" cmd=").append(CMD).toString());
        }
        this.onCommand(CMD, devOrSecAddr2);
        Enumeration.Value value = CMD;
        Enumeration.Value value2 = IECBusDevice$Command$.MODULE$.LISTEN();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (devOrSecAddr2 == this.device) {
                this.role_$eq(IECBusDevice$Role$.MODULE$.LISTENER());
            } else {
                this.resetSignals();
            }
            this.listen();
            return;
        }
        Enumeration.Value value4 = IECBusDevice$Command$.MODULE$.UNLISTEN();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            this.set(IECBusLine$.MODULE$.DATA(), 0);
            this.set(IECBusLine$.MODULE$.CLK(), 0);
            this.role_$eq(IECBusDevice$Role$.MODULE$.NONE());
            this.unlisten();
            return;
        }
        Enumeration.Value value6 = IECBusDevice$Command$.MODULE$.OPEN();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            Enumeration.Value value8 = this.role();
            Enumeration.Value value9 = IECBusDevice$Role$.MODULE$.LISTENER();
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                this.channel_$eq(devOrSecAddr2);
                this.channels()[this.channel()].fileName().clear();
                this.isReadingFileName = true;
                this.open();
                return;
            }
            this.resetSignals();
            return;
        }
        Enumeration.Value value10 = IECBusDevice$Command$.MODULE$.OPEN_CHANNEL();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            this.channel_$eq(devOrSecAddr2);
            this.isReadingFileName = false;
            Enumeration.Value value12 = this.role();
            Enumeration.Value value13 = IECBusDevice$Role$.MODULE$.READY_TO_BE_TALKER();
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                this.role_$eq(IECBusDevice$Role$.MODULE$.TALKER());
                this.setMode(IECBusDevice$Mode$.MODULE$.TURNAROUND());
                this.open_channel();
            }
            Enumeration.Value value14 = this.role();
            Enumeration.Value value15 = IECBusDevice$Role$.MODULE$.LISTENER();
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                this.open_channel();
                return;
            }
            return;
        }
        Enumeration.Value value16 = IECBusDevice$Command$.MODULE$.TALK();
        Enumeration.Value value17 = value;
        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
            if (devOrSecAddr2 == this.device) {
                this.role_$eq(IECBusDevice$Role$.MODULE$.READY_TO_BE_TALKER());
            }
            this.talk();
            return;
        }
        Enumeration.Value value18 = IECBusDevice$Command$.MODULE$.UNTALK();
        Enumeration.Value value19 = value;
        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
            this.role_$eq(IECBusDevice$Role$.MODULE$.NONE());
            this.untalk();
            return;
        }
        Enumeration.Value value20 = IECBusDevice$Command$.MODULE$.CLOSE();
        Enumeration.Value value21 = value;
        if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
            this.channel_$eq(devOrSecAddr2);
            Enumeration.Value value22 = this.role();
            Enumeration.Value value23 = IECBusDevice$Role$.MODULE$.NONE();
            if (value22 == null ? value23 != null : !value22.equals(value23)) {
                this.close();
                this.channels()[this.channel()].close();
                this.resetSignals();
                return;
            }
            return;
        }
        throw new MatchError((Object)value);
    }

    private Option<Object> readByte(long cycles, boolean restart, boolean timeout) {
        boolean atn;
        boolean data = this.bus.data() == 1;
        boolean clk = this.bus.clk() == 1;
        boolean bl = atn = this.bus.atn() == 1;
        if (restart) {
            if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                Predef$.MODULE$.println((Object)"Start reading byte...");
            }
            this.byteReadCount = 0;
            this.readMode = IECBusDevice$ReadMode$.MODULE$.WAIT_BIT();
            this.byteRead = 0;
            this.byteReadLastChar = false;
            this.readEOI = false;
            this.set(IECBusLine$.MODULE$.DATA(), 0);
            this.waitTimeout = cycles + (long)IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$WAIT_BIT_TIMEOUT();
            return None$.MODULE$;
        }
        if (!atn && timeout) {
            if (!this.readEOI) {
                this.set(IECBusLine$.MODULE$.DATA(), 1);
                this.waitTimeout = cycles + (long)IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$EOI_TIMEOUT();
                this.readEOI = true;
            } else {
                this.set(IECBusLine$.MODULE$.DATA(), 0);
                this.waitTimeout = 0L;
                this.byteReadLastChar = true;
            }
        }
        Enumeration.Value value = this.readMode;
        Enumeration.Value value2 = IECBusDevice$ReadMode$.MODULE$.WAIT_BIT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (clk && this.byteReadCount == 8) {
                ++this.byteReadCount;
            } else if (clk) {
                this.readMode = IECBusDevice$ReadMode$.MODULE$.READ_BIT();
            }
        } else {
            Enumeration.Value value4 = IECBusDevice$ReadMode$.MODULE$.READ_BIT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                if (!clk) {
                    int bit = data ? 0 : 1 << this.byteReadCount;
                    this.byteRead |= bit;
                    this.readMode = IECBusDevice$ReadMode$.MODULE$.WAIT_BIT();
                    ++this.byteReadCount;
                    this.waitTimeout = 0L;
                }
            } else {
                throw new MatchError((Object)value);
            }
        }
        if (this.byteReadCount == 9) {
            this.set(IECBusLine$.MODULE$.DATA(), 1);
            return new Some((Object)BoxesRunTime.boxToInteger((int)this.byteRead));
        }
        return None$.MODULE$;
    }

    private boolean writeByte(long cycles, boolean timeout) {
        if (this.writeCyclesWait > cycles) {
            return false;
        }
        boolean data = this.bus.data() == 1;
        Enumeration.Value value = this.writeMode;
        Enumeration.Value value2 = IECBusDevice$WriteMode$.MODULE$.WAIT_LISTENER_READY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.set(IECBusLine$.MODULE$.CLK(), 0);
            if (!data) {
                if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                    Predef$.MODULE$.println((Object)"LISTENER READY FOR DATA");
                }
                if (!this.channels()[this.channel()].dataToSend().isDefined()) {
                    this.waitTimeout = 0L;
                    if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(36).append("FILE NOT FOUND DETECTED for channel ").append(this.channel()).toString());
                    }
                    this.channels()[this.channel()].close();
                    this.dataNotFound();
                    return true;
                }
                if (((Iterator)this.channels()[this.channel()].dataToSend().get()).hasNext()) {
                    this.loadByte(cycles);
                }
                if (!this.writeEOI) {
                    this.writeMode = IECBusDevice$WriteMode$.MODULE$.WRITE_BIT_CLK2();
                    return false;
                }
                this.writeMode = IECBusDevice$WriteMode$.MODULE$.WAIT_LISTENER_EOI_HANDSHAKE();
                return false;
            }
            return false;
        }
        Enumeration.Value value4 = IECBusDevice$WriteMode$.MODULE$.WRITE_BIT_CLK2();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            this.set(IECBusLine$.MODULE$.CLK(), 1);
            this.set(IECBusLine$.MODULE$.DATA(), 0);
            this.writeMode = IECBusDevice$WriteMode$.MODULE$.WRITE_BIT_CLK1();
            this.writeCyclesWait = cycles + (long)IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$WRITE_KEEP_BIT_TIMEOUT();
            return false;
        }
        Enumeration.Value value6 = IECBusDevice$WriteMode$.MODULE$.WRITE_BIT_CLK1();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            int bit = this.byteToSend & 1 << this.dataToSendBitIndex;
            if (bit == 0) {
                this.set(IECBusLine$.MODULE$.DATA(), 1);
            } else {
                this.set(IECBusLine$.MODULE$.DATA(), 0);
            }
            ++this.dataToSendBitIndex;
            this.set(IECBusLine$.MODULE$.CLK(), 0);
            this.writeCyclesWait = cycles + (long)IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$WRITE_KEEP_BIT_TIMEOUT();
            this.writeMode = this.dataToSendBitIndex < 8 ? IECBusDevice$WriteMode$.MODULE$.WRITE_BIT_CLK2() : IECBusDevice$WriteMode$.MODULE$.WRITE_LAST_BIT();
            return false;
        }
        Enumeration.Value value8 = IECBusDevice$WriteMode$.MODULE$.WRITE_LAST_BIT();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            this.set(IECBusLine$.MODULE$.CLK(), 1);
            this.set(IECBusLine$.MODULE$.DATA(), 0);
            this.writeMode = IECBusDevice$WriteMode$.MODULE$.WRITE_END();
            return false;
        }
        Enumeration.Value value10 = IECBusDevice$WriteMode$.MODULE$.WRITE_END();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            this.dataToSendBitIndex = 0;
            this.set(IECBusLine$.MODULE$.CLK(), 1);
            if (data) {
                boolean isLast = !((Iterator)this.channels()[this.channel()].dataToSend().get()).hasNext();
                this.byteJustWritten(isLast);
                this.writeMode = IECBusDevice$WriteMode$.MODULE$.WAIT_LISTENER_READY();
                if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                    Predef$.MODULE$.println((Object)"RECEIVED ACK");
                }
                if (isLast) {
                    if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                        Predef$.MODULE$.println((Object)"WRITE FINISHED: ");
                    }
                    return true;
                }
                this.initNextByte = true;
                return false;
            }
            return false;
        }
        Enumeration.Value value12 = IECBusDevice$WriteMode$.MODULE$.WAIT_LISTENER_EOI_HANDSHAKE();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            if (data) {
                if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                    Predef$.MODULE$.println((Object)"EOI Handshake");
                }
                this.writeEOI = false;
                this.writeMode = IECBusDevice$WriteMode$.MODULE$.WAIT_LISTENER_READY();
            }
            return false;
        }
        throw new MatchError((Object)value);
    }

    private void loadByte(long cycles) {
        Option<BusDataIterator> option = this.channels()[this.channel()].dataToSend();
        if (option instanceof Some) {
            Some some = (Some)option;
            BusDataIterator ds = (BusDataIterator)some.value();
            if (ds.isLast()) {
                if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                    Predef$.MODULE$.println((Object)"Last char, setting EOI");
                }
                this.writeCyclesWait = cycles + (long)IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$EOI_TIMEOUT();
                this.writeEOI = true;
            }
            this.byteToSend = BoxesRunTime.unboxToInt((Object)ds.next());
            if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
                Predef$.MODULE$.println((Object)new StringBuilder(21).append("Next byte to send: ").append(Integer.toHexString(this.byteToSend)).append(" ").append(ds.getPerc()).append("%").toString());
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private void initByteToWrite(long cycles) {
        this.initNextByte = false;
        this.writeEOI = false;
        this.dataToSendBitIndex = 0;
        this.writeCyclesWait = cycles + (long)IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$WAIT_BETWEEN_BYTES();
        this.writeMode = IECBusDevice$WriteMode$.MODULE$.WAIT_LISTENER_READY();
    }

    public void load(String fileName) {
        if (IECBusDevice$.MODULE$.ucesoft$cbm$peripheral$bus$IECBusDevice$$DEBUG()) {
            Predef$.MODULE$.println((Object)new StringBuilder(8).append("Loading ").append(fileName).toString());
        }
        this.channels()[this.channel()].dataToSend_$eq(this.loadData(fileName));
    }

    /*
     * WARNING - void declaration
     */
    public IECBusDevice(IECBus bus, int device) {
        void var3_3;
        this.bus = bus;
        this.device = device;
        IECBusListener.$init$(this);
        Channel[] chs = (Channel[])Array$.MODULE$.ofDim(31, ClassTag$.MODULE$.apply(Channel.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), chs.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            chs$1[i] = new Channel();
        });
        this.channels = var3_3;
        this.mode = IECBusDevice$Mode$.MODULE$.IDLE();
        this.lastAtn = false;
        this.byteRead = 0;
        this.byteReadCount = 0;
        this.byteReadLastChar = false;
        this.readEOI = false;
        this.readMode = IECBusDevice$ReadMode$.MODULE$.WAIT_BIT();
        this.waitTimeout = 0L;
        this.isReadingFileName = false;
        this.role = IECBusDevice$Role$.MODULE$.NONE();
        this.channel = 0;
        this.writeMode = IECBusDevice$WriteMode$.MODULE$.WAIT_LISTENER_READY();
        this.byteToSend = 0;
        this.dataToSendBitIndex = 0;
        this.writeEOI = false;
        this.writeCyclesWait = 0L;
        this.initNextByte = true;
        Statics.releaseFence();
    }

    public static class Channel {
        private Option<BusDataIterator> dataToSend = None$.MODULE$;
        private boolean readDirection = true;
        private final ListBuffer<Object> _buffer = new ListBuffer();
        private final scala.collection.mutable.StringBuilder fileName = new scala.collection.mutable.StringBuilder();
        private boolean opened = false;

        public Option<BusDataIterator> dataToSend() {
            return this.dataToSend;
        }

        public void dataToSend_$eq(Option<BusDataIterator> x$1) {
            this.dataToSend = x$1;
        }

        public boolean readDirection() {
            return this.readDirection;
        }

        public void readDirection_$eq(boolean x$1) {
            this.readDirection = x$1;
        }

        private ListBuffer<Object> _buffer() {
            return this._buffer;
        }

        public scala.collection.mutable.StringBuilder fileName() {
            return this.fileName;
        }

        private boolean opened() {
            return this.opened;
        }

        private void opened_$eq(boolean x$1) {
            this.opened = x$1;
        }

        public void clear() {
            this.buffer().clear();
            this.fileName().clear();
        }

        public boolean isOpened() {
            return this.opened();
        }

        public void open() {
            this.opened_$eq(true);
        }

        public void close() {
            this.opened_$eq(false);
            this.buffer().clear();
            this.fileName().clear();
        }

        public void addToBuffer(int value) {
            this._buffer().$plus$eq((Object)BoxesRunTime.boxToInteger((int)value));
        }

        public ListBuffer<Object> buffer() {
            return this._buffer();
        }

        public String bufferToString() {
            return ((IterableOnceOps)this.buffer().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)Channel.$anonfun$bufferToString$1(BoxesRunTime.unboxToInt((Object)x$1))))).mkString();
        }

        public static final /* synthetic */ char $anonfun$bufferToString$1(int x$1) {
            return (char)x$1;
        }
    }
}

