/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.c2n;

import java.awt.Frame;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import ucesoft.cbm.CBMComponent;
import ucesoft.cbm.CBMComponentType$;
import ucesoft.cbm.Clock;
import ucesoft.cbm.Clock$;
import ucesoft.cbm.ClockEvent;
import ucesoft.cbm.ClockEvent$;
import ucesoft.cbm.formats.TAP;
import ucesoft.cbm.formats.TAP$;
import ucesoft.cbm.peripheral.c2n.DatassetteListener;
import ucesoft.cbm.peripheral.c2n.DatassetteState$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001\u0002\u0016,\u0001QB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0006\r\u0002!\ta\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019)\u0006\u0001)A\u0005\u001b\"9a\u000b\u0001b\u0001\n\u00039\u0006B\u00024\u0001A\u0003%\u0001\f\u0003\u0004h\u0001\u0001\u0006i\u0001\u001b\u0005\u0007U\u0002\u0001\u000b\u0015B6\t\r9\u0004\u0001\u0015)\u0003l\u0011\u0019y\u0007\u0001)Q\u0005W\"1\u0001\u000f\u0001Q\u0001\nEDa\u0001\u001e\u0001!B\u0013)\bB\u0002@\u0001A\u0003&1\u000eC\u0004\u0000\u0001\u0001\u0006K!!\u0001\t\u000f\u0005\u001d\u0001\u0001)Q\u0005W\"A\u0011\u0011\u0002\u0001!B\u0013\tY\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0015BA\u000b\u0011!\tY\u0002\u0001Q!\n\u0005U\u0001bCA\u000f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003?Aq!!\f\u0001\t\u0003\ty\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005]\u0002\u0001\"\u0001\u00026!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u0013\u0002A\u0011AA\u001b\u0011\u001d\tY\u0005\u0001C\u0001\u0003kAq!!\u0014\u0001\t\u0003\t)\u0004C\u0004\u0002P\u0001!\t!!\u000e\t\u000f\u0005E\u0003\u0001\"\u0001\u00026!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0002bBA+\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002~\u0001!\t%a \t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAQ\u0001\u0011%\u0011Q\u0007\u0005\b\u0003G\u0003A\u0011CAS\u0011\u001d\t9\f\u0001C\t\u0003sCq!!2\u0001\t#\t9E\u0001\u0006ECR\f7o]3ui\u0016T!\u0001L\u0017\u0002\u0007\r\u0014dN\u0003\u0002/_\u0005Q\u0001/\u001a:ja\",'/\u00197\u000b\u0005A\n\u0014aA2c[*\t!'A\u0004vG\u0016\u001cxN\u001a;\u0004\u0001M\u0019\u0001!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g!\taT(D\u00010\u0013\tqtF\u0001\u0007D\u00056\u001bu.\u001c9p]\u0016tG/\u0001\u0006dS\u00064E.Y4M_^\u00042AN!D\u0013\t\u0011uGA\u0005Gk:\u001cG/[8oaA\u0011a\u0007R\u0005\u0003\u000b^\u0012A!\u00168ji\u00061A(\u001b8jiz\"\"\u0001\u0013&\u0011\u0005%\u0003Q\"A\u0016\t\u000b}\u0012\u0001\u0019\u0001!\u0002\u0017\r|W\u000e]8oK:$\u0018\nR\u000b\u0002\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005Y\u0006twMC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q{%AB*ue&tw-\u0001\u0007d_6\u0004xN\\3oi&#\u0005%A\u0007d_6\u0004xN\\3oiRK\b/Z\u000b\u00021B\u0011\u0011l\u0019\b\u00035\u0006t!a\u00171\u000f\u0005q{V\"A/\u000b\u0005y\u001b\u0014A\u0002\u001fs_>$h(C\u00013\u0013\t\u0001\u0014'\u0003\u0002c_\u0005\u00012IQ'D_6\u0004xN\\3oiRK\b/Z\u0005\u0003I\u0016\u0014A\u0001V=qK*\u0011!mL\u0001\u000fG>l\u0007o\u001c8f]R$\u0016\u0010]3!\u0003-iu\nV(S?\u0012+E*Q-\u0010\u0003%l\"! \u0001\u0002\u000f5|Go\u001c:P]B\u0011a\u0007\\\u0005\u0003[^\u0012qAQ8pY\u0016\fg.A\u0006qY\u0006L\bK]3tg\u0016$\u0017!\u0004:fG>\u0014H\r\u0015:fgN,G-A\u0002dY.\u0004\"\u0001\u0010:\n\u0005M|#!B\"m_\u000e\\\u0017a\u0001;baB\u0019aG\u001e=\n\u0005]<$AB(qi&|g\u000e\u0005\u0002zy6\t!P\u0003\u0002|_\u00059am\u001c:nCR\u001c\u0018BA?{\u0005\r!\u0016\tU\u0001\u000b[>$xN]#wK:$\u0018\u0001\u00077bgR<&/\u001b;f\u0019&tWm\u00115b]\u001e,7\t\\8dWB\u0019a'a\u0001\n\u0007\u0005\u0015qG\u0001\u0003M_:<\u0017!\u00047bgR<&/\u001b;f\u0019&tW-\u0001\u0007uCB,G*[:uK:,'\u000f\u0005\u00037m\u00065\u0001cA%\u0002\u0010%\u0019\u0011\u0011C\u0016\u0003%\u0011\u000bG/Y:tKR$X\rT5ti\u0016tWM]\u0001\bG>,h\u000e^3s!\r1\u0014qC\u0005\u0004\u000339$aA%oi\u0006i1m\\;oi\u0016\u0014xJ\u001a4tKR\f!bY8v]R,'/T1q!\u0011\t\t#a\n\u000f\u0007e\f\u0019#C\u0002\u0002&i\f1\u0001V!Q\u0013\u0011\tI#a\u000b\u0003\u001bQ\u000b\u0007oQ8v]R,'/T1q\u0015\r\t)C_\u0001\u0010g\u0016$H+\u00199f\u0019&\u001cH/\u001a8feR\u00191)!\r\t\u000f\u0005%A\u00031\u0001\u0002\u000e\u0005!\u0011N\\5u)\u0005\u0019\u0015!\u0002:fg\u0016$\u0018AB:fiR\u000b\u0005\u000bF\u0003D\u0003{\ty\u0004C\u0003u/\u0001\u0007Q\u000fC\u0004\u0002B]\u0001\r!a\u0011\u0002\u0007A|7\u000f\u0005\u00037m\u0006U\u0011!D5t!2\f\u0017\u0010\u0015:fgN,G-F\u0001l\u0003%\u0001(/Z:t!2\f\u00170\u0001\u0007qe\u0016\u001c8OR8so\u0006\u0014H-A\u0005qe\u0016\u001c8o\u0015;pa\u0006\u0011\u0002O]3tgJ+7m\u001c:e\u0003:$\u0007\u000b\\1z\u00031\u0011Xm]3u)>\u001cF/\u0019:u\u0003-\u0001(/Z:t%\u0016<\u0018N\u001c3\u0002\u0019I,7/\u001a;D_VtG/\u001a:\u0002\u0019M,Go\u0016:ji\u0016d\u0015N\\3\u0015\u0007\r\u000bY\u0006\u0003\u0004\u0002^\u0001\u0002\ra[\u0001\u0003_:\f\u0001b]3u\u001b>$xN\u001d\u000b\u0004\u0007\u0006\r\u0004BBA/C\u0001\u00071.\u0001\u000bo_RLg-_*uCR,7\t[1oO\u0016$Gk\u001c\u000b\u0004\u0007\u0006%\u0004bBA6E\u0001\u0007\u0011QN\u0001\u0006gR\fG/\u001a\t\u0005\u0003_\n)HD\u0002J\u0003cJ1!a\u001d,\u0003=!\u0015\r^1tg\u0016$H/Z*uCR,\u0017\u0002BA<\u0003s\u0012QAV1mk\u0016L1!a\u001f8\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u001b\u001d,G\u000f\u0015:pa\u0016\u0014H/[3t+\t\t\t\t\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9)U\u0001\u0005kRLG.\u0003\u0003\u0002\f\u0006\u0015%A\u0003)s_B,'\u000f^5fg\u0006I1\r\\8dWBc\u0017-\u001f\u000b\u0004\u0007\u0006E\u0005bBAJI\u0001\u0007\u0011\u0011A\u0001\u0007Gf\u001cG.Z:\u0002\u0019\rdwnY6G_J<\u0018M\u001d3\u0015\t\u0005e\u0015Q\u0014\u000b\u0004\u0007\u0006m\u0005bBAJK\u0001\u0007\u0011\u0011\u0001\u0005\u0007\u0003?+\u0003\u0019A6\u0002\u000f\u0019|'o^1sI\u00061Q\u000f\u001d3bi\u0016\f\u0011b]1wKN#\u0018\r^3\u0015\u0007\r\u000b9\u000bC\u0004\u0002*\u001e\u0002\r!a+\u0002\u0007=,H\u000f\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t,U\u0001\u0003S>LA!!.\u00020\n\u0011rJ\u00196fGR|U\u000f\u001e9viN#(/Z1n\u0003%aw.\u00193Ti\u0006$X\rF\u0002D\u0003wCq!!0)\u0001\u0004\ty,\u0001\u0002j]B!\u0011QVAa\u0013\u0011\t\u0019-a,\u0003#=\u0013'.Z2u\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\u000bbY2|wo]*uCR,'+Z:u_JLgn\u001a")
public class Datassette
implements CBMComponent {
    private final Function0<BoxedUnit> ciaFlagLow;
    private final String componentID;
    private final Enumeration.Value componentType;
    private boolean motorOn;
    private boolean playPressed;
    private boolean recordPressed;
    private final Clock clk;
    private Option<TAP> tap;
    private boolean motorEvent;
    private long lastWriteLineChangeClock;
    private boolean lastWriteLine;
    private Option<DatassetteListener> tapeListener;
    private int counter;
    private int counterOffset;
    private TAP.TapCounterMap counterMap;
    private Properties properties;
    private ListBuffer<CBMComponent> ucesoft$cbm$CBMComponent$$_components;

    @Override
    public final void add(CBMComponent c) {
        CBMComponent.add$(this, c);
    }

    @Override
    public void shutdown() {
        CBMComponent.shutdown$(this);
    }

    @Override
    public void hardReset() {
        CBMComponent.hardReset$(this);
    }

    @Override
    public final void change(CBMComponent oldComponent, CBMComponent newComponent) {
        CBMComponent.change$(this, oldComponent, newComponent);
    }

    @Override
    public final void remove(CBMComponent c) {
        CBMComponent.remove$(this, c);
    }

    @Override
    public void afterInitHook() {
        CBMComponent.afterInitHook$(this);
    }

    @Override
    public final void shutdownComponent() {
        CBMComponent.shutdownComponent$(this);
    }

    @Override
    public final void resetComponent() {
        CBMComponent.resetComponent$(this);
    }

    @Override
    public final void hardResetComponent() {
        CBMComponent.hardResetComponent$(this);
    }

    @Override
    public void initComponent() {
        CBMComponent.initComponent$(this);
    }

    @Override
    public final List<CBMComponent> components() {
        return CBMComponent.components$(this);
    }

    @Override
    public final void printComponentsTree() {
        CBMComponent.printComponentsTree$(this);
    }

    @Override
    public void save(ObjectOutputStream out) {
        CBMComponent.save$(this, out);
    }

    @Override
    public void load(ObjectInputStream in) {
        CBMComponent.load$(this, in);
    }

    @Override
    public void componentIDMismatchHandling(String id) {
        CBMComponent.componentIDMismatchHandling$(this, id);
    }

    @Override
    public final boolean allowsState() {
        return CBMComponent.allowsState$(this);
    }

    @Override
    public void saveClockEvents(ObjectOutputStream out) {
        CBMComponent.saveClockEvents$(this, out);
    }

    @Override
    public void loadClockEvents(ObjectInputStream in, Function2<Object, Object, ClockEvent> f) {
        CBMComponent.loadClockEvents$(this, in, f);
    }

    @Override
    public <T> void loadMemory(Object mem, ObjectInputStream in) {
        CBMComponent.loadMemory$(this, mem, in);
    }

    @Override
    public Option<Frame> getActiveFrame() {
        return CBMComponent.getActiveFrame$(this);
    }

    @Override
    public void showError(String title, String error) {
        CBMComponent.showError$(this, title, error);
    }

    @Override
    public boolean isHeadless() {
        return CBMComponent.isHeadless$(this);
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public ListBuffer<CBMComponent> ucesoft$cbm$CBMComponent$$_components() {
        return this.ucesoft$cbm$CBMComponent$$_components;
    }

    @Override
    public void ucesoft$cbm$CBMComponent$_setter_$properties_$eq(Properties x$1) {
        this.properties = x$1;
    }

    @Override
    public final void ucesoft$cbm$CBMComponent$_setter_$ucesoft$cbm$CBMComponent$$_components_$eq(ListBuffer<CBMComponent> x$1) {
        this.ucesoft$cbm$CBMComponent$$_components = x$1;
    }

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public Enumeration.Value componentType() {
        return this.componentType;
    }

    public void setTapeListener(DatassetteListener tapeListener) {
        this.tapeListener = new Some((Object)tapeListener);
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
        this.motorOn = false;
        this.playPressed = false;
        this.recordPressed = false;
        this.lastWriteLineChangeClock = 0L;
        this.lastWriteLine = false;
        if (this.tap.isDefined()) {
            this.pressStop();
            return;
        }
    }

    public void setTAP(Option<TAP> tap, Option<Object> pos) {
        if (this.tap.isDefined()) {
            ((TAP)this.tap.get()).close();
        }
        this.notifyStateChangedTo(DatassetteState$.MODULE$.STOPPED());
        this.tap = tap;
        this.counterMap = TAP$.MODULE$.anaylize(new File(((TAP)tap.get()).getFilename())).counterMap();
        this.resetToStart();
        Option<Object> option = pos;
        if (option instanceof Some) {
            Some some = (Some)option;
            int p = BoxesRunTime.unboxToInt((Object)some.value());
            ((TAP)tap.get()).goTo(p);
            this.counter = this.counterMap.findCounter(p);
            this.update();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public boolean isPlayPressed() {
        return this.playPressed;
    }

    public void pressPlay() {
        if (!this.playPressed) {
            this.playPressed = true;
            this.notifyStateChangedTo(DatassetteState$.MODULE$.PLAYING());
            if (this.motorOn) {
                this.clk.pause();
                this.clk.schedule(new ClockEvent(this.componentID(), this.clk.currentCycles() + 1L, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.clockPlay(cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
                this.clk.play();
                return;
            }
            return;
        }
    }

    public void pressForward() {
        this.pressStop();
        this.notifyStateChangedTo(DatassetteState$.MODULE$.FORWARD());
        this.clk.schedule(new ClockEvent(this.componentID(), this.clk.nextCycles(), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.clockForward(true, cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
    }

    public void pressStop() {
        if (this.playPressed) {
            this.playPressed = false;
        }
        this.notifyStateChangedTo(DatassetteState$.MODULE$.STOPPED());
        this.recordPressed = false;
        this.clk.cancel(this.componentID());
    }

    public void pressRecordAndPlay() {
        this.playPressed = true;
        this.notifyStateChangedTo(DatassetteState$.MODULE$.RECORDING());
        this.recordPressed = true;
    }

    public void resetToStart() {
        this.playPressed = false;
        this.recordPressed = false;
        Option<TAP> option = this.tap;
        if (None$.MODULE$.equals(option)) {
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TAP tape = (TAP)some.value();
            tape.rewind();
        } else {
            throw new MatchError(option);
        }
        this.counterOffset = 0;
        this.counter = 0;
        this.notifyStateChangedTo(DatassetteState$.MODULE$.STOPPED());
        this.update();
    }

    public void pressRewind() {
        this.pressStop();
        this.notifyStateChangedTo(DatassetteState$.MODULE$.REWIND());
        this.clk.schedule(new ClockEvent(this.componentID(), this.clk.nextCycles(), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.clockForward(false, cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
    }

    public void resetCounter() {
        this.counterOffset = this.counter;
        Option<DatassetteListener> option = this.tapeListener;
        if (option instanceof Some) {
            Some some = (Some)option;
            DatassetteListener tl = (DatassetteListener)some.value();
            tl.datassetteUpdateCounter(0);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void setWriteLine(boolean on) {
        if (this.recordPressed && this.lastWriteLine != on) {
            if (!this.lastWriteLine && on) {
                if (this.lastWriteLineChangeClock != 0L) {
                    long cycles = this.clk.currentCycles() - this.lastWriteLineChangeClock;
                    Option<TAP> option = this.tap;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        TAP t = (TAP)some.value();
                        t.write((int)cycles >> 3);
                        this.counter = this.counterMap.findCounter((int)((TAP)this.tap.get()).getOffset()) % 1000;
                        this.update();
                    } else if (None$.MODULE$.equals(option)) {
                    } else {
                        throw new MatchError(option);
                    }
                }
                this.lastWriteLineChangeClock = this.clk.currentCycles();
            }
            this.lastWriteLine = on;
            return;
        }
    }

    public void setMotor(boolean on) {
        if (!this.motorOn && on) {
            if (!this.recordPressed) {
                this.clk.schedule(new ClockEvent(new StringBuilder(6).append(this.componentID()).append("_Motor").toString(), this.clk.currentCycles() + 32000L, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.clockPlay(cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
                if (this.playPressed) {
                    this.notifyStateChangedTo(DatassetteState$.MODULE$.PLAYING());
                }
            } else {
                this.notifyStateChangedTo(DatassetteState$.MODULE$.RECORDING());
            }
            this.motorEvent = true;
        } else if (this.motorOn && !on) {
            this.clk.cancel(this.componentID());
            this.lastWriteLineChangeClock = 0L;
            this.lastWriteLine = false;
        }
        this.motorOn = on;
    }

    private void notifyStateChangedTo(Enumeration.Value state) {
        Option<DatassetteListener> option = this.tapeListener;
        if (option instanceof Some) {
            Some some = (Some)option;
            DatassetteListener tl = (DatassetteListener)some.value();
            tl.datassetteStateChanged(state);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public Properties getProperties() {
        CBMComponent.getProperties$(this);
        this.properties().setProperty("TAP file", this.tap.isDefined() ? ((TAP)this.tap.get()).getFilename() : "-");
        this.properties().setProperty("TAP version", this.tap.isDefined() ? Integer.toString(((TAP)this.tap.get()).version()) : "-");
        this.properties().setProperty("TAP length", this.tap.isDefined() ? Long.toString(((TAP)this.tap.get()).tapeLength()) : "-");
        this.properties().setProperty("Motor on", Boolean.toString(this.motorOn));
        this.properties().setProperty("Play pressed", Boolean.toString(this.playPressed));
        this.properties().setProperty("Record pressed", Boolean.toString(this.recordPressed));
        this.properties().setProperty("Offset", this.tap.isDefined() ? Long.toString(((TAP)this.tap.get()).getOffset()) : "-");
        return this.properties();
    }

    private void clockPlay(long cycles2) {
        if (this.motorOn && this.playPressed) {
            Option<TAP> option = this.tap;
            if (None$.MODULE$.equals(option)) {
                return;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                TAP tape = (TAP)some.value();
                if (this.motorEvent) {
                    this.motorEvent = false;
                } else {
                    this.ciaFlagLow.apply$mcV$sp();
                }
                if (tape.hasNext()) {
                    int gap = tape.next();
                    this.counter = this.counterMap.findCounter((int)((TAP)this.tap.get()).getOffset()) % 1000;
                    this.update();
                    this.clk.schedule(new ClockEvent(this.componentID(), cycles2 + (long)gap, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.clockPlay(cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
                    return;
                }
                this.pressStop();
                return;
            }
            throw new MatchError(option);
        }
    }

    private void clockForward(boolean forward, long cycles2) {
        Option<TAP> option = this.tap;
        if (option instanceof Some) {
            Some some = (Some)option;
            TAP tape = (TAP)some.value();
            this.counter += forward ? 1 : -1;
            int pos = BoxesRunTime.unboxToInt((Object)this.counterMap.map().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.counter), (Function0)(JFunction0.mcI.sp & Serializable)() -> (int)tape.getOffset()));
            if (this.counter <= this.counterMap.maxCounter() && tape.goTo(pos)) {
                this.update();
                if (this.counter > 0) {
                    this.clk.schedule(new ClockEvent(this.componentID(), cycles2 + TAP$.MODULE$.FAST_FORWARD_PERIOD(), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)cycles -> this.clockForward(forward, cycles), ClockEvent$.MODULE$.$lessinit$greater$default$4()));
                    return;
                }
                this.pressStop();
                return;
            }
            this.pressStop();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private void update() {
        int progressPerc = (int)((double)((TAP)this.tap.get()).getOffset() / (double)((TAP)this.tap.get()).tapeLength() * (double)100);
        Option<DatassetteListener> option = this.tapeListener;
        if (option instanceof Some) {
            Some some = (Some)option;
            DatassetteListener tl = (DatassetteListener)some.value();
            int c = this.counter - this.counterOffset;
            tl.datassetteUpdatePosition(progressPerc, c >= 0 ? c % 1000 : c + 1000);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void saveState(ObjectOutputStream out) {
    }

    @Override
    public void loadState(ObjectInputStream in) {
    }

    @Override
    public boolean allowsStateRestoring() {
        if (this.motorOn) {
            this.showError("State error", "Can't load/save state if datassette is playing or recording");
        }
        return !this.motorOn;
    }

    public Datassette(Function0<BoxedUnit> ciaFlagLow) {
        this.ciaFlagLow = ciaFlagLow;
        CBMComponent.$init$(this);
        this.componentID = "Datassette 1530";
        this.componentType = CBMComponentType$.MODULE$.TAPE();
        this.motorOn = false;
        this.playPressed = false;
        this.recordPressed = false;
        this.clk = Clock$.MODULE$.systemClock();
        this.tap = None$.MODULE$;
        this.motorEvent = false;
        this.lastWriteLineChangeClock = 0L;
        this.lastWriteLine = false;
        this.tapeListener = None$.MODULE$;
        this.counter = 0;
        this.counterOffset = 0;
        Statics.releaseFence();
    }
}

