/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.cia;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.reflect.ScalaSignature;
import ucesoft.cbm.expansion.DigiMAX$;
import ucesoft.cbm.expansion.WiC64$;
import ucesoft.cbm.peripheral.Connector;
import ucesoft.cbm.peripheral.bus.IECBus;
import ucesoft.cbm.peripheral.bus.IECBusListener;
import ucesoft.cbm.peripheral.cia.CIA2Connectors$;
import ucesoft.cbm.peripheral.drive.ParallelCable$;
import ucesoft.cbm.peripheral.rs232.RS232;
import ucesoft.cbm.peripheral.vic.VIC_II_Memory;

@ScalaSignature(bytes="\u0006\u0005\u0005Mr!\u0002\u000f\u001e\u0011\u00031c!\u0002\u0015\u001e\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007y\u0005\u0001\u000b\u0011\u0002\u001b\u0007\tu\n\u0001A\u0010\u0005\t\u0013\u0016\u0011\t\u0011)A\u0005\u0015\"Aa)\u0002B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u000b\t\u0005\t\u0015!\u0003U\u0011\u0015\u0001T\u0001\"\u0001Z\u0011\u001dyVA1A\u0005\u0002MBa\u0001Y\u0003!\u0002\u0013!\u0004bB1\u0006\u0005\u0004%\tE\u0019\u0005\u0007M\u0016\u0001\u000b\u0011B2\t\u000f\u001d,!\u0019!C\u0001Q\"11/\u0002Q\u0001\n%Da\u0001^\u0003!B\u0013)\b\"\u0002=\u0006\t\u000bI\b\"\u0002>\u0006\t+Y\bbBA\u0002\u000b\u0011E\u0013Q\u0001\u0005\b\u0003/)A\u0011KA\r\r\u0019\t)#\u0001\u0001\u0002(!A1+\u0006B\u0001B\u0003%A\u000b\u0003\u00041+\u0011\u0005\u0011\u0011\u0006\u0005\b?V\u0011\r\u0011\"\u00014\u0011\u0019\u0001W\u0003)A\u0005i!)\u00010\u0006C\u0003s\"1!0\u0006C\u000b\u0003_\tabQ%Be\r{gN\\3di>\u00148O\u0003\u0002\u001f?\u0005\u00191-[1\u000b\u0005\u0001\n\u0013A\u00039fe&\u0004\b.\u001a:bY*\u0011!eI\u0001\u0004G\nl'\"\u0001\u0013\u0002\u000fU\u001cWm]8gi\u000e\u0001\u0001CA\u0014\u0002\u001b\u0005i\"AD\"J\u0003J\u001auN\u001c8fGR|'o]\n\u0003\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001'\u0003A\u0019\u0015*\u0011\u001a`!>\u0013F+Q0C+NKE)F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003mC:<'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aa\u0015;sS:<\u0017!E\"J\u0003Jz\u0006k\u0014*U\u0003~\u0013UkU%EA\tq\u0001k\u001c:u\u0003\u000e{gN\\3di>\u00148cA\u0003@\u0007B\u0011\u0001)Q\u0007\u0002?%\u0011!i\b\u0002\n\u0007>tg.Z2u_J\u0004\"\u0001R$\u000e\u0003\u0015S!AR\u0010\u0002\u0007\t,8/\u0003\u0002I\u000b\nq\u0011*R\"CkNd\u0015n\u001d;f]\u0016\u0014\u0018aA7f[B\u00111JT\u0007\u0002\u0019*\u0011QjH\u0001\u0004m&\u001c\u0017BA(M\u000551\u0016jQ0J\u0013~kU-\\8ssB\u0011A)U\u0005\u0003%\u0016\u0013a!S#D\u0005V\u001c\u0018!\u0002:teM\u0012\u0004CA+X\u001b\u00051&BA* \u0013\tAfKA\u0003S'J\u001a$\u0007\u0006\u0003[9vs\u0006CA.\u0006\u001b\u0005\t\u0001\"B%\n\u0001\u0004Q\u0005\"\u0002$\n\u0001\u0004\u0001\u0006\"B*\n\u0001\u0004!\u0016aC2p[B|g.\u001a8u\u0013\u0012\u000bAbY8na>tWM\u001c;J\t\u0002\nA\"[:D_:$(o\u001c7mKJ,\u0012a\u0019\t\u0003W\u0011L!!\u001a\u0017\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011n]\"p]R\u0014x\u000e\u001c7fe\u0002\nQAY;tS\u0012,\u0012!\u001b\t\u0003UFt!a[8\u0011\u00051dS\"A7\u000b\u00059,\u0013A\u0002\u001fs_>$h(\u0003\u0002qY\u00051\u0001K]3eK\u001aL!a\u000f:\u000b\u0005Ad\u0013A\u00022vg&$\u0007%\u0001\u0003cC:\\\u0007CA\u0016w\u0013\t9HFA\u0002J]R\fAA]3bIV\tQ/\u0001\u0007qKJ4wN]7Xe&$X\r\u0006\u0002}\u007fB\u00111&`\u0005\u0003}2\u0012A!\u00168ji\"1\u0011\u0011\u0001\nA\u0002U\fA\u0001Z1uC\u0006I1/\u0019<f'R\fG/\u001a\u000b\u0004y\u0006\u001d\u0001bBA\u0005'\u0001\u0007\u00111B\u0001\u0004_V$\b\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001(\u0001\u0002j_&!\u0011QCA\b\u0005Iy%M[3di>+H\u000f];u'R\u0014X-Y7\u0002\u00131|\u0017\rZ*uCR,Gc\u0001?\u0002\u001c!9\u0011Q\u0004\u000bA\u0002\u0005}\u0011AA5o!\u0011\ti!!\t\n\t\u0005\r\u0012q\u0002\u0002\u0012\u001f\nTWm\u0019;J]B,Ho\u0015;sK\u0006l'A\u0004)peR\u00145i\u001c8oK\u000e$xN]\n\u0003+}\"B!a\u000b\u0002.A\u00111,\u0006\u0005\u0006'^\u0001\r\u0001\u0016\u000b\u0004y\u0006E\u0002BBA\u00017\u0001\u0007Q\u000f")
public final class CIA2Connectors {
    public static String CIA2_PORTA_BUSID() {
        return CIA2Connectors$.MODULE$.CIA2_PORTA_BUSID();
    }

    public static class PortAConnector
    extends Connector
    implements IECBusListener {
        private final VIC_II_Memory mem;
        private final IECBus bus;
        private final RS232 rs232;
        private final String componentID;
        private final boolean isController;
        private final String busid;
        private int bank;
        private int bitmap;

        @Override
        public void atnChanged(int oldValue, int newValue) {
            IECBusListener.atnChanged$(this, oldValue, newValue);
        }

        @Override
        public void srqTriggered() {
            IECBusListener.srqTriggered$(this);
        }

        @Override
        public int bitmap() {
            return this.bitmap;
        }

        @Override
        public void bitmap_$eq(int x$1) {
            this.bitmap = x$1;
        }

        @Override
        public void ucesoft$cbm$peripheral$bus$IECBusListener$_setter_$isController_$eq(boolean x$1) {
        }

        @Override
        public String componentID() {
            return this.componentID;
        }

        @Override
        public boolean isController() {
            return this.isController;
        }

        @Override
        public String busid() {
            return this.busid;
        }

        @Override
        public final int read() {
            return ~(this.bus.clk() << 6 | this.bus.data() << 7) & 0xC0 | (this.latch() | ~this.ddr()) & 0x38 | this.bank | this.rs232.getTXD() << 2;
        }

        @Override
        public final void performWrite(int data) {
            int value = data | ~this.ddr();
            this.bank = value & 3;
            this.mem.setVideoBank(this.bank);
            this.bus.setLine(this, (value & 8) > 0 ? 1 : 0, (value & 0x20) > 0 ? 1 : 0, (value & 0x10) > 0 ? 1 : 0);
            this.rs232.setTXD(value >> 2 & 1);
            if (DigiMAX$.MODULE$.isEnabledOnUserPort()) {
                int a0a1 = data >> 2 & 3;
                DigiMAX$.MODULE$.selectChannel(a0a1);
            }
            if (WiC64$.MODULE$.enabled()) {
                WiC64$.MODULE$.setMode(data & 4);
                return;
            }
        }

        @Override
        public void saveState(ObjectOutputStream out) {
            super.saveState(out);
            out.writeInt(this.bank);
        }

        @Override
        public void loadState(ObjectInputStream in) {
            super.loadState(in);
            this.bank = in.readInt();
        }

        public PortAConnector(VIC_II_Memory mem, IECBus bus, RS232 rs232) {
            this.mem = mem;
            this.bus = bus;
            this.rs232 = rs232;
            IECBusListener.$init$(this);
            this.componentID = "CIA2 Port A Connector";
            this.isController = true;
            this.busid = CIA2Connectors$.MODULE$.CIA2_PORTA_BUSID();
            this.bank = 3;
            bus.registerListener(this);
        }
    }

    public static class PortBConnector
    extends Connector {
        private final RS232 rs232;
        private final String componentID;

        @Override
        public String componentID() {
            return this.componentID;
        }

        @Override
        public final int read() {
            if (WiC64$.MODULE$.enabled()) {
                return WiC64$.MODULE$.read();
            }
            if (ParallelCable$.MODULE$.enabled()) {
                ParallelCable$.MODULE$.onPC();
                return ParallelCable$.MODULE$.read();
            }
            if (this.rs232.isEnabled()) {
                return this.rs232.getOthers();
            }
            return (this.latch() | ~this.ddr()) & 0xFF;
        }

        @Override
        public final void performWrite(int data) {
            if (WiC64$.MODULE$.enabled()) {
                WiC64$.MODULE$.write(data);
            }
            if (ParallelCable$.MODULE$.enabled()) {
                ParallelCable$.MODULE$.onPC();
                ParallelCable$.MODULE$.write(data);
            } else {
                this.rs232.setOthers(data);
            }
            if (DigiMAX$.MODULE$.isEnabledOnUserPort()) {
                DigiMAX$.MODULE$.write(data);
                return;
            }
        }

        public PortBConnector(RS232 rs232) {
            this.rs232 = rs232;
            this.componentID = "CIA2 Port B Connector";
        }
    }
}

