/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.drive;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.reflect.ScalaSignature;
import ucesoft.cbm.peripheral.drive.DriveLedListener;
import ucesoft.cbm.peripheral.drive.Floppy;
import ucesoft.cbm.peripheral.drive.RWHeadController;

@ScalaSignature(bytes="\u0006\u0005M4Aa\u0005\u000b\u0001;!A!\u0005\u0001BC\u0002\u0013\u00051\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u0003%\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000bi\u0002A\u0011A\u001e\t\u000f\u0001\u0003!\u0019!C\u0001G!1\u0011\t\u0001Q\u0001\n\u0011BaA\u0011\u0001!B\u0013\u0019\u0005BB$\u0001A\u0003&1\tC\u0003I\u0001\u0011\u0005\u0013\nC\u0003N\u0001\u0011\u0015a\nC\u0003R\u0001\u0011\u0015#\u000bC\u0003V\u0001\u0011\u0015a\u000bC\u0003[\u0001\u0011\u00151\fC\u0003_\u0001\u0011U\u0011\nC\u0003`\u0001\u0011U\u0011\nC\u0003a\u0001\u0011U\u0013\rC\u0003m\u0001\u0011USNA\nH\u0007J\u0013v\u000bS3bI\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u0016-\u0005)AM]5wK*\u0011q\u0003G\u0001\u000ba\u0016\u0014\u0018\u000e\u001d5fe\u0006d'BA\r\u001b\u0003\r\u0019'-\u001c\u0006\u00027\u00059QoY3t_\u001a$8\u0001A\n\u0003\u0001y\u0001\"a\b\u0011\u000e\u0003QI!!\t\u000b\u0003!I;\u0006*Z1e\u0007>tGO]8mY\u0016\u0014\u0018\u0001\u00028b[\u0016,\u0012\u0001\n\t\u0003K9r!A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%b\u0012A\u0002\u001fs_>$hHC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#&\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017+\u0003\u0015q\u0017-\\3!\u0003\u001dyf\r\\8qaf\u0004\"a\b\u001b\n\u0005U\"\"A\u0002$m_B\u0004\u00180A\u0006mK\u0012d\u0015n\u001d;f]\u0016\u0014\bCA\u00109\u0013\tIDC\u0001\tEe&4X\rT3e\u0019&\u001cH/\u001a8fe\u00061A(\u001b8jiz\"B\u0001P\u001f?\u007fA\u0011q\u0004\u0001\u0005\u0006E\u0015\u0001\r\u0001\n\u0005\u0006e\u0015\u0001\ra\r\u0005\u0006m\u0015\u0001\raN\u0001\fG>l\u0007o\u001c8f]RLE)\u0001\u0007d_6\u0004xN\\3oi&#\u0005%\u0001\u0006ue\u0006\u001c7n\u0015;faN\u0004\"\u0001R#\u000e\u0003)J!A\u0012\u0016\u0003\u0007%sG/\u0001\u0006mCN$\u0018\u0007\r\"jiN\fQA]3tKR$\u0012A\u0013\t\u0003\t.K!\u0001\u0014\u0016\u0003\tUs\u0017\u000e^\u0001\u000bG\"\fgnZ3TS\u0012,GC\u0001&P\u0011\u0015\u00016\u00021\u0001D\u0003\u0011\u0019\u0018\u000eZ3\u0002\u0013M,GO\u00127paBLHC\u0001&T\u0011\u0015!F\u00021\u00014\u0003%qWm\u001e$m_B\u0004\u00180\u0001\u0004jgNKhnY\u000b\u0002/B\u0011A\tW\u0005\u00033*\u0012qAQ8pY\u0016\fg.\u0001\u0005n_Z,\u0007*Z1e)\tQE\fC\u0003^\u001d\u0001\u0007q+A\u0004n_Z,w*\u001e;\u0002\u0017I,\u0017\r\u001a(fqR\u0014\u0015\u000e^\u0001\roJLG/\u001a(fqR\u0014\u0015\u000e^\u0001\ng\u00064Xm\u0015;bi\u0016$\"A\u00132\t\u000b\r\f\u0002\u0019\u00013\u0002\u0007=,H\u000f\u0005\u0002fU6\taM\u0003\u0002hQ\u0006\u0011\u0011n\u001c\u0006\u0002S\u0006!!.\u0019<b\u0013\tYgM\u0001\nPE*,7\r^(viB,Ho\u0015;sK\u0006l\u0017!\u00037pC\u0012\u001cF/\u0019;f)\tQe\u000eC\u0003p%\u0001\u0007\u0001/\u0001\u0002j]B\u0011Q-]\u0005\u0003e\u001a\u0014\u0011c\u00142kK\u000e$\u0018J\u001c9viN#(/Z1n\u0001")
public class GCRRWHeadController
extends RWHeadController {
    private final String name;
    private final String componentID;
    private int trackSteps;
    private int last10Bits;

    public String name() {
        return this.name;
    }

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public void reset() {
        super.reset();
        this.trackSteps = 2;
        this.last10Bits = 0;
    }

    @Override
    public final void changeSide(int side) {
        if (!this.floppy().singleSide()) {
            this.floppy().side_$eq(side);
            this.track_$eq(this.floppy().currentTrack());
            int oldTrackSteps = this.trackSteps;
            this.trackSteps = this.track() << 1 | oldTrackSteps & 1;
            return;
        }
    }

    @Override
    public final void setFloppy(Floppy newFloppy) {
        super.setFloppy(newFloppy);
        this.floppy().changeTrack(this.trackSteps);
    }

    @Override
    public final boolean isSync() {
        return !this.isWriting() && this.motorOn() && this.last10Bits == 1023;
    }

    @Override
    public final void moveHead(boolean moveOut) {
        boolean trackMoved = false;
        if (moveOut) {
            if (this.track() > this.floppy().minTrack()) {
                --this.trackSteps;
                trackMoved = true;
            }
        } else if (this.track() < this.floppy().maxTrack()) {
            ++this.trackSteps;
            trackMoved = true;
        }
        if (trackMoved) {
            this.floppy().changeTrack(this.trackSteps);
            this.track_$eq(this.floppy().currentTrack());
            return;
        }
    }

    @Override
    public final void readNextBit() {
        int bit = this.floppy().nextBit();
        this.last10Bits = (this.last10Bits << 1 | bit) & 0x3FF;
        if (this.last10Bits == 1023) {
            this.bitCounter_$eq(0);
            this.byteReadySignal_$eq(1);
        }
        if (this.bitCounter() == 8) {
            this.bitCounter_$eq(0);
            this.lastWrite_$eq(this.lastRead());
            this.byteReady_$eq(true);
            this.lastRead_$eq(this.last10Bits & 0xFF);
            this.byteReadySignal_$eq(0);
            return;
        }
    }

    @Override
    public final void writeNextBit() {
        this.floppy().writeNextBit((this.lastWrite() & 0x80) > 0);
        this.lastWrite_$eq(this.lastWrite() << 1);
        if (this.bitCounter() == 8) {
            this.bitCounter_$eq(0);
            this.lastWrite_$eq(this.nextWrite());
            this.byteReady_$eq(true);
            this.byteReadySignal_$eq(0);
            return;
        }
    }

    @Override
    public final void saveState(ObjectOutputStream out) {
        super.saveState(out);
        out.writeInt(this.trackSteps);
        out.writeInt(this.last10Bits);
    }

    @Override
    public final void loadState(ObjectInputStream in) {
        super.loadState(in);
        this.trackSteps = in.readInt();
        this.last10Bits = in.readInt();
    }

    public GCRRWHeadController(String name, Floppy _floppy, DriveLedListener ledListener) {
        this.name = name;
        super(_floppy, ledListener);
        this.componentID = new StringBuilder(22).append(name).append("GCR rw head controller").toString();
        this.trackSteps = this.track() << 1;
        this.last10Bits = 0;
    }
}

